/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.eunjeon.seunjeon;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.bitbucket.eunjeon.seunjeon.ConnectionCostDict;
import org.bitbucket.eunjeon.seunjeon.LexiconDict;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.io.File$;
import scala.reflect.io.Path$;

public final class DictBuilder$ {
    public static DictBuilder$ MODULE$;
    private final String workingDirectory;
    private final String MECAB_KO_DIC_PATH;
    private final String RESOURCE_PATH;
    private final String DICT_PATHNAME;
    private final String DICT_PATH;
    private final String TERM_DICT_FILENAME;
    private final String TERM_DICT;
    private final String DICT_MAPPER_FILENAME;
    private final String DICT_MAPPER;
    private final String TERM_TRIE_FILENAME;
    private final String TERM_TRIE;
    private final String CONNECTION_COST_FILENAME;
    private final String CONNECTION_COST;
    private final String UNK_DEF_FILENAME;
    private final String UNK_DEF;
    private final String CHAR_DEF_FILENAME;
    private final String LEFT_ID_DEF_FILENAME;
    private final String LEFT_ID_DEF;
    private final String RIGHT_ID_DEF_FILENAME;
    private final String RIGHT_ID_DEF;

    static {
        new DictBuilder$();
    }

    public String workingDirectory() {
        return this.workingDirectory;
    }

    public String MECAB_KO_DIC_PATH() {
        return this.MECAB_KO_DIC_PATH;
    }

    public String RESOURCE_PATH() {
        return this.RESOURCE_PATH;
    }

    public String DICT_PATHNAME() {
        return this.DICT_PATHNAME;
    }

    public String DICT_PATH() {
        return this.DICT_PATH;
    }

    public String TERM_DICT_FILENAME() {
        return this.TERM_DICT_FILENAME;
    }

    public String TERM_DICT() {
        return this.TERM_DICT;
    }

    public String DICT_MAPPER_FILENAME() {
        return this.DICT_MAPPER_FILENAME;
    }

    public String DICT_MAPPER() {
        return this.DICT_MAPPER;
    }

    public String TERM_TRIE_FILENAME() {
        return this.TERM_TRIE_FILENAME;
    }

    public String TERM_TRIE() {
        return this.TERM_TRIE;
    }

    public String CONNECTION_COST_FILENAME() {
        return this.CONNECTION_COST_FILENAME;
    }

    public String CONNECTION_COST() {
        return this.CONNECTION_COST;
    }

    public String UNK_DEF_FILENAME() {
        return this.UNK_DEF_FILENAME;
    }

    public String UNK_DEF() {
        return this.UNK_DEF;
    }

    public String CHAR_DEF_FILENAME() {
        return this.CHAR_DEF_FILENAME;
    }

    public String LEFT_ID_DEF_FILENAME() {
        return this.LEFT_ID_DEF_FILENAME;
    }

    public String LEFT_ID_DEF() {
        return this.LEFT_ID_DEF;
    }

    public String RIGHT_ID_DEF_FILENAME() {
        return this.RIGHT_ID_DEF_FILENAME;
    }

    public String RIGHT_ID_DEF() {
        return this.RIGHT_ID_DEF;
    }

    public void main(String[] args) {
        this.clear();
        this.copyUnkDef();
        this.copyLeftIdDef();
        this.copyRightIdDef();
        Predef$.MODULE$.println((Object)"compiling lexicon dictionary...");
        this.buildLexiconDict();
        Predef$.MODULE$.println((Object)"compiling connection-cost dictionary...");
        this.buildConnectionCostDict();
        Predef$.MODULE$.println((Object)"complete");
    }

    private void copyUnkDef() {
        this.copyDefFile(this.UNK_DEF_FILENAME());
    }

    private void copyLeftIdDef() {
        this.copyDefFile(this.LEFT_ID_DEF_FILENAME());
    }

    private void copyRightIdDef() {
        this.copyDefFile(this.RIGHT_ID_DEF_FILENAME());
    }

    private void copyDefFile(String defFileName) {
        Files.copy(Paths.get(this.MECAB_KO_DIC_PATH() + File$.MODULE$.separator() + defFileName, new String[0]), Paths.get(this.RESOURCE_PATH() + File$.MODULE$.separator() + this.DICT_PATHNAME() + File$.MODULE$.separator() + defFileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    private void buildConnectionCostDict() {
        ConnectionCostDict connectionCostDict = new ConnectionCostDict();
        connectionCostDict.loadFromFile(this.MECAB_KO_DIC_PATH() + File$.MODULE$.separator() + "matrix.def");
        connectionCostDict.save(this.RESOURCE_PATH() + File$.MODULE$.separator() + this.DICT_PATHNAME() + File$.MODULE$.separator() + this.CONNECTION_COST_FILENAME());
        Predef$.MODULE$.println((Object)("building connection cost dictionary OK. " + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{connectionCostDict.getDictionaryInfo()}))));
    }

    private void buildLexiconDict() {
        String dictPath = this.RESOURCE_PATH() + File$.MODULE$.separator() + this.DICT_PATHNAME();
        LexiconDict lexiconDict = new LexiconDict();
        lexiconDict.loadFromDir(this.MECAB_KO_DIC_PATH(), lexiconDict.loadFromDir$default$2());
        lexiconDict.save(dictPath + File$.MODULE$.separator() + this.TERM_DICT_FILENAME(), dictPath + File$.MODULE$.separator() + this.DICT_MAPPER_FILENAME(), dictPath + File$.MODULE$.separator() + this.TERM_TRIE_FILENAME());
        Predef$.MODULE$.println((Object)("building LexiconDict OK. " + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lexiconDict.getDictionaryInfo()}))));
    }

    private void clear() {
        String dictPath = this.RESOURCE_PATH() + File$.MODULE$.separator() + this.DICT_PATHNAME();
        Path$.MODULE$.apply(dictPath).deleteRecursively();
        new File(dictPath).mkdirs();
    }

    private DictBuilder$() {
        MODULE$ = this;
        this.workingDirectory = System.getProperty("user.dir");
        this.MECAB_KO_DIC_PATH = this.workingDirectory() + "/mecab-ko-dic";
        this.RESOURCE_PATH = this.workingDirectory() + "/src/main/resources";
        this.DICT_PATHNAME = "/dictionary";
        this.DICT_PATH = this.DICT_PATHNAME();
        this.TERM_DICT_FILENAME = "/termDict.dat";
        this.TERM_DICT = this.DICT_PATH() + this.TERM_DICT_FILENAME();
        this.DICT_MAPPER_FILENAME = "/dictMapper.dat";
        this.DICT_MAPPER = this.DICT_PATH() + this.DICT_MAPPER_FILENAME();
        this.TERM_TRIE_FILENAME = "/trie.dat";
        this.TERM_TRIE = this.DICT_PATH() + this.TERM_TRIE_FILENAME();
        this.CONNECTION_COST_FILENAME = "/connection_cost.dat";
        this.CONNECTION_COST = this.DICT_PATH() + this.CONNECTION_COST_FILENAME();
        this.UNK_DEF_FILENAME = "/unk.def";
        this.UNK_DEF = this.DICT_PATH() + this.UNK_DEF_FILENAME();
        this.CHAR_DEF_FILENAME = "/char.def";
        this.LEFT_ID_DEF_FILENAME = "/left-id.def";
        this.LEFT_ID_DEF = this.DICT_PATH() + this.LEFT_ID_DEF_FILENAME();
        this.RIGHT_ID_DEF_FILENAME = "/right-id.def";
        this.RIGHT_ID_DEF = this.DICT_PATH() + this.RIGHT_ID_DEF_FILENAME();
    }
}

