/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.johness.javacef;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class CefHelper {
    private static String[] localeFiles = new String[]{"am.pak", "ar.pak", "bg.pak", "bn.pak", "ca.pak", "cs.pak", "da.pak", "de.pak", "el.pak", "en-GB.pak", "en-US.pak", "es-419.pak", "es.pak", "et.pak", "fa.pak", "fi.pak", "fil.pak", "fr.pak", "gu.pak", "he.pak", "hi.pak", "hr.pak", "hu.pak", "id.pak", "it.pak", "ja.pak", "kn.pak", "ko.pak", "lt.pak", "lv.pak", "ml.pak", "mr.pak", "ms.pak", "nb.pak", "nl.pak", "pl.pak", "pt-BR.pak", "pt-PT.pak", "ro.pak", "ru.pak", "sk.pak", "sl.pak", "sr.pak", "sv.pak", "sw.pak", "ta.pak", "te.pak", "th.pak", "tr.pak", "uk.pak", "vi.pak", "zh-CN.pak", "zh-TW.pak"};
    private static String[] cefFiles = new String[]{"cef.pak", "cef_100_percent.pak", "cef_200_percent.pak", "cef_extensions.pak", "d3dcompiler_43.dll", "d3dcompiler_47.dll", "devtools_resources.pak", "icudtl.dat", "jcef.dll", "jcef_helper.exe", "libcef.dll", "libEGL.dll", "libGLESv2.dll", "natives_blob.bin", "snapshot_blob.bin"};

    public static void extractNativeAndResource() throws Exception {
        byte[] bytes;
        FileOutputStream fos;
        InputStream is;
        Throwable throwable;
        InputStream nfis;
        Throwable throwable2;
        FileInputStream ofis;
        File tempDir = new File(System.getProperty("java.io.tmpdir") + "org.bitbucket.johness.javacef.49.87.win32.1");
        if (!tempDir.exists() && !tempDir.mkdir()) {
            return;
        }
        File localesDir = new File(tempDir.getPath() + File.separator + "locales");
        if (!localesDir.exists() && !localesDir.mkdirs()) {
            return;
        }
        for (String cefFileName : cefFiles) {
            File cefFile = new File(tempDir.getPath() + File.separator + cefFileName);
            if (cefFile.exists()) {
                ofis = new FileInputStream(cefFile);
                throwable2 = null;
                try {
                    nfis = CefHelper.class.getResourceAsStream("/" + cefFileName);
                    throwable = null;
                    try {
                        if (CefHelper.equalMD5(ofis, nfis)) {
                            continue;
                        }
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                    finally {
                        if (nfis != null) {
                            if (throwable != null) {
                                try {
                                    nfis.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                nfis.close();
                            }
                        }
                    }
                }
                catch (Throwable x2) {
                    throwable2 = x2;
                    throw x2;
                }
                finally {
                    if (ofis != null) {
                        if (throwable2 != null) {
                            try {
                                ofis.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                        } else {
                            ofis.close();
                        }
                    }
                }
                cefFile.delete();
                cefFile.createNewFile();
            } else {
                cefFile.createNewFile();
            }
            is = CefHelper.class.getResourceAsStream("/" + cefFileName);
            throwable2 = null;
            try {
                fos = new FileOutputStream(cefFile);
                throwable = null;
                try {
                    int byteCount = 0;
                    bytes = new byte[1024];
                    while ((byteCount = is.read(bytes)) != -1) {
                        fos.write(bytes, 0, byteCount);
                    }
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (fos != null) {
                        if (throwable != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            fos.close();
                        }
                    }
                }
            }
            catch (Throwable x2) {
                throwable2 = x2;
                throw x2;
            }
            finally {
                if (is != null) {
                    if (throwable2 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            throwable2.addSuppressed(x2);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        for (String localFileName : localeFiles) {
            File localeFile = new File(localesDir.getPath() + File.separator + localFileName);
            if (localeFile.exists()) {
                ofis = new FileInputStream(localeFile);
                throwable2 = null;
                try {
                    nfis = CefHelper.class.getResourceAsStream("/locales/" + localFileName);
                    throwable = null;
                    try {
                        if (CefHelper.equalMD5(ofis, nfis)) {
                            continue;
                        }
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                    finally {
                        if (nfis != null) {
                            if (throwable != null) {
                                try {
                                    nfis.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                nfis.close();
                            }
                        }
                    }
                }
                catch (Throwable x2) {
                    throwable2 = x2;
                    throw x2;
                }
                finally {
                    if (ofis != null) {
                        if (throwable2 != null) {
                            try {
                                ofis.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                        } else {
                            ofis.close();
                        }
                    }
                }
                localeFile.delete();
                localeFile.createNewFile();
            } else {
                localeFile.createNewFile();
            }
            is = CefHelper.class.getResourceAsStream("/locales/" + localFileName);
            throwable2 = null;
            try {
                fos = new FileOutputStream(localeFile);
                throwable = null;
                try {
                    int byteCount = 0;
                    bytes = new byte[1024];
                    while ((byteCount = is.read(bytes)) != -1) {
                        fos.write(bytes, 0, byteCount);
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (fos != null) {
                        if (throwable != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            fos.close();
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
                throw throwable4;
            }
            finally {
                if (is != null) {
                    if (throwable2 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            throwable2.addSuppressed(x2);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        CefHelper.addLibraryDir(tempDir.getPath());
    }

    private static void addLibraryDir(String libraryPath) throws Exception {
        Field userPathsField = ClassLoader.class.getDeclaredField("usr_paths");
        userPathsField.setAccessible(true);
        String[] paths = (String[])userPathsField.get(null);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < paths.length; ++i) {
            if (libraryPath.equals(paths[i])) continue;
            sb.append(paths[i]).append(File.pathSeparatorChar);
        }
        sb.append(libraryPath);
        System.setProperty("java.library.path", sb.toString());
        Field sysPathsField = ClassLoader.class.getDeclaredField("sys_paths");
        sysPathsField.setAccessible(true);
        sysPathsField.set(null, null);
    }

    public static String byteArrayToHex(byte[] byteArray) {
        StringBuilder hex = new StringBuilder();
        for (int n = 0; n < byteArray.length; ++n) {
            String stmp = Integer.toHexString(byteArray[n] & 0xFF);
            if (stmp.length() == 1) {
                hex.append('0');
            }
            hex.append(stmp);
        }
        return hex.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String streamMD5(InputStream is) throws IOException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            try (DigestInputStream digestInputStream = new DigestInputStream(is, messageDigest);){
                byte[] buffer = new byte[4096];
                while (digestInputStream.read(buffer) > 0) {
                }
                messageDigest = digestInputStream.getMessageDigest();
                byte[] resultByteArray = messageDigest.digest();
                String string = CefHelper.byteArrayToHex(resultByteArray);
                return string;
            }
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static boolean equalMD5(InputStream is0, InputStream is1) {
        try {
            String md50 = CefHelper.streamMD5(is0);
            String md51 = CefHelper.streamMD5(is1);
            if (md50 == null || md51 == null) {
                return false;
            }
            return md50.equals(md51);
        }
        catch (Exception e) {
            return false;
        }
    }
}

