package org.bitbucket.joxley.wix;

import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.maven.plugin.MojoExecutionException;

import java.io.File;
import java.io.IOException;

/**
 * Goal which executes WiX candle to create a .wixobj file.
 * 
 * @goal candle
 * 
 * @phase package
 */
public class CandleMojo extends AbstractWixMojo {
	/**
	 * Location of the WiX source files.
	 * 
	 * @parameter expression="${sourceFiles}"
	 * @required
	 */
	private File[] sourceFiles;

	/**
	 * Definitions to be passed on before pre Compilation
	 * 
	 * @parameter expression="${definitions}"
	 */
	private String[] definitions;

	/**
	 * x86, intel, x64, intel64, or ia64 (default: x86)
	 * 
	 * @parameter expression="${arch}"
	 */
	private String arch;

	/**
	 * Output file
	 * 
	 * @parameter expression="${outputDirectory}"
	 */
	private File outputDirectory;

	public void execute() throws MojoExecutionException {

		try {
			CommandLine commandLine = new CommandLine("candle");
			commandLine.addArgument("-nologo");
			commandLine.addArgument("-sw");

			if (definitions.length > 0) {
				for (String def : definitions) {
					commandLine.addArgument("-d" + def);
				}
			}
			if (outputDirectory != null) {
				if (!outputDirectory.exists()) {
					outputDirectory.mkdir();
				}

				commandLine.addArgument("-out");
				commandLine.addArgument(outputDirectory.getAbsolutePath() + "\\\\");
			}
			if (arch != null) {
				commandLine.addArgument("-arch " + arch);
			}
			if (extensions != null) {
				for (String ext : extensions) {
					commandLine.addArgument("-ext");
					commandLine.addArgument(ext);
				}
			}

			if (arguments != null) {
				commandLine.addArguments(arguments, false);
			}

			for (File f : sourceFiles) {
				if (!f.exists()) {
					throw new MojoExecutionException("Source file does not exist " + f);
				} else {
					commandLine.addArgument(f.getAbsolutePath());
				}
			}

			DefaultExecutor executor = new DefaultExecutor();
			executor.setWorkingDirectory(getWorkingDirectory(workingDirectory));
			int exitValue = executor.execute(commandLine);

			if (exitValue != 0) {
				throw new MojoExecutionException("Problem executing candle, return code " + exitValue);
			}

		} catch (ExecuteException e) {
			throw new MojoExecutionException("Problem executing candle", e);
		} catch (IOException e) {
			throw new MojoExecutionException("Problem executing candle", e);
		}
	}
}