/*
 * Decompiled with CFR 0.152.
 */
package club.caliope.udc;

import club.caliope.udc.InputFormat;
import club.caliope.udc.OutputFormat;
import club.caliope.udc.Settings;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;

public class DocumentConverter {
    private Settings settings = new Settings();
    private File fromFile;
    private File toFile;
    private String fromFormat;
    private String toFormat;
    private String extraOptions;
    private File workingDirectory;

    public DocumentConverter() {
        this.settings.setPandocExec("pandoc");
        this.extraOptions = "";
    }

    public DocumentConverter(Settings settings) {
        this();
        this.settings = settings;
    }

    public DocumentConverter fromFile(File from, String format) {
        this.fromFile = from;
        this.fromFormat = format;
        return this;
    }

    public DocumentConverter fromFile(File from, InputFormat format) {
        return this.fromFile(from, format.getFormatName());
    }

    public DocumentConverter toFile(File to, String format) {
        this.toFile = to;
        this.toFormat = format;
        return this;
    }

    public DocumentConverter toFile(File to, OutputFormat format) {
        return this.toFile(to, format.getFormatName());
    }

    public DocumentConverter addOption(String option) {
        this.extraOptions = this.extraOptions + " " + option;
        return this;
    }

    public DocumentConverter workingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
        return this;
    }

    public void convert() {
        int status;
        String command = String.format("\"%s\" \"%s\" --from=%s --to=%s %s --output=\"%s\"", this.settings.getPandocExec(), this.fromFile.getAbsoluteFile(), this.fromFormat, this.toFormat, this.extraOptions, this.toFile.getAbsoluteFile());
        try {
            System.out.println("Executing: " + command);
            status = Runtime.getRuntime().exec(command, null, this.workingDirectory).waitFor();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Could not execute: " + command, ex);
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Could not execute. Maybe pandoc is not in PATH?: " + command, ex);
        }
        if (status != 0) {
            throw new RuntimeException("Conversion failed with status code: " + status + ". Command executed: " + command);
        }
    }
}

