/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.annotations.Nullable;
import com.strobel.assembler.metadata.CompoundTypeReference;
import com.strobel.assembler.metadata.ICompoundType;
import com.strobel.assembler.metadata.IMetadataResolver;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeMetadataVisitor;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.VerifyArgument;
import java.util.List;

public final class CompoundTypeDefinition
extends TypeDefinition
implements ICompoundType {
    @Nullable
    private final TypeReference _underlyingType;
    private final TypeReference _baseType;
    private final List<TypeReference> _interfaces;

    CompoundTypeDefinition(TypeReference baseType, List<TypeReference> interfaces, IMetadataResolver resolver) {
        super((IMetadataResolver)VerifyArgument.notNull((Object)resolver, (String)"resolver"));
        VerifyArgument.noNullElementsAndNotEmpty(interfaces, (String)"interfaces");
        this.setBaseType(baseType);
        this.getExplicitInterfacesInternal().addAll(interfaces);
        this._baseType = baseType;
        this._interfaces = interfaces;
        this._underlyingType = baseType != null ? baseType : interfaces.get(0);
    }

    @Override
    public final List<TypeReference> getInterfaces() {
        return this._interfaces;
    }

    @Override
    public boolean isCompoundType() {
        return true;
    }

    @Override
    public String getSimpleName() {
        return this._underlyingType.getSimpleName();
    }

    @Override
    public boolean containsGenericParameters() {
        TypeReference baseType = this.getBaseType();
        if (baseType != null && baseType.containsGenericParameters()) {
            return true;
        }
        for (TypeReference t : this._interfaces) {
            if (!t.containsGenericParameters()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this._underlyingType.getName();
    }

    @Override
    public String getFullName() {
        return this._underlyingType.getFullName();
    }

    @Override
    public String getInternalName() {
        return this._underlyingType.getInternalName();
    }

    @Override
    public TypeReference getUnderlyingType() {
        return this._underlyingType;
    }

    @Override
    public final <R, P> R accept(TypeMetadataVisitor<P, R> visitor, P parameter) {
        return visitor.visitCompoundType(this, parameter);
    }

    @Override
    public StringBuilder appendBriefDescription(StringBuilder sb) {
        return CompoundTypeReference.append0(this, sb, " & ", TypeReference.TypeFunctions.APPEND_BRIEF_DESCRIPTION);
    }

    @Override
    public StringBuilder appendSimpleDescription(StringBuilder sb) {
        return CompoundTypeReference.append0(this, sb, " & ", TypeReference.TypeFunctions.APPEND_SIMPLE_DESCRIPTION);
    }

    @Override
    public StringBuilder appendErasedDescription(StringBuilder sb) {
        return CompoundTypeReference.append0(this, sb, " & ", TypeReference.TypeFunctions.APPEND_ERASED_DESCRIPTION);
    }

    @Override
    public StringBuilder appendDescription(StringBuilder sb) {
        return CompoundTypeReference.append0(this, sb, " & ", TypeReference.TypeFunctions.APPEND_DESCRIPTION);
    }

    @Override
    public StringBuilder appendSignature(StringBuilder sb) {
        int position = sb.length();
        StringBuilder s = CompoundTypeReference.append0(this, sb, ":", TypeReference.TypeFunctions.APPEND_SIGNATURE);
        if (this._baseType == null) {
            s.insert(position, ':');
        }
        return s;
    }

    @Override
    public StringBuilder appendErasedSignature(StringBuilder sb) {
        return this._underlyingType.appendErasedSignature(sb);
    }

    @Override
    protected StringBuilder appendErasedClassSignature(StringBuilder sb) {
        return this._underlyingType.appendErasedClassSignature(sb);
    }
}

