/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.Collection;
import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.CompilerTarget;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.ParameterDefinitionCollection;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.core.VerifyArgument;

class RecordTypeDefinition
extends TypeDefinition {
    static final TypeDefinition INSTANCE = new RecordTypeDefinition();

    private RecordTypeDefinition() {
        this.setBaseType(BuiltinTypes.Object);
        this.setCompilerVersion(CompilerTarget.JDK15.majorVersion, CompilerTarget.JDK15.minorVersion);
        this.setFlags(1025L);
        this.setName("Record");
        this.setPackageName("java.lang");
        this.setSimpleName("Record");
        Collection<MethodDefinition> methodDefinitions = this.getDeclaredMethodsInternal();
        for (MethodDefinition baseMethod : BuiltinTypes.Object.getDeclaredMethods()) {
            methodDefinitions.add(new RecordMethod(this, baseMethod));
        }
        this.setResolver(MetadataSystem.instance());
    }

    private static final class RecordMethod
    extends MethodDefinition {
        RecordMethod(RecordTypeDefinition declaringType, MethodDefinition baseMethod) {
            VerifyArgument.notNull((Object)declaringType, (String)"declaringType");
            VerifyArgument.notNull((Object)baseMethod, (String)"baseMethod");
            this.setName(baseMethod.getName());
            this.setReturnType(baseMethod.getReturnType());
            this.setDeclaringType(declaringType);
            this.setFlags(0xD3FL & (baseMethod.getFlags() | 0x400L));
            if (baseMethod.isConstructor()) {
                this.setFlags(this.getFlags() & 0xFFFFFFFFFFFFFFFEL | 4L);
            }
            ParameterDefinitionCollection ps = this.getParametersInternal();
            for (ParameterDefinition bp : baseMethod.getParameters()) {
                ps.add(new ParameterDefinition(bp.getSlot(), bp.getName(), bp.getParameterType()));
            }
        }
    }
}

