/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.ast;

import com.strobel.annotations.NotNull;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.MutableInteger;
import com.strobel.core.Predicate;
import com.strobel.core.StrongBox;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.ast.AstCode;
import com.strobel.decompiler.ast.AstOptimizer;
import com.strobel.decompiler.ast.BasicBlock;
import com.strobel.decompiler.ast.Block;
import com.strobel.decompiler.ast.CatchBlock;
import com.strobel.decompiler.ast.Condition;
import com.strobel.decompiler.ast.DefaultMap;
import com.strobel.decompiler.ast.Expression;
import com.strobel.decompiler.ast.Loop;
import com.strobel.decompiler.ast.Node;
import com.strobel.decompiler.ast.PatternMatching;
import com.strobel.decompiler.ast.Variable;
import com.strobel.functions.Consumer;
import com.strobel.util.ContractUtils;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

final class Inlining {
    private final DecompilerContext _context;
    private final Block _method;
    private final boolean _aggressive;
    final Map<Variable, MutableInteger> loadCounts;
    final Map<Variable, MutableInteger> storeCounts;
    final Map<Variable, List<Expression>> loads;
    final StrongBox<Variable> _tempVariable = new StrongBox();
    final StrongBox<Expression> _tempExpression = new StrongBox();
    private static final Predicate<Variable> IS_FLOAT_VARIABLE = new Predicate<Variable>(){

        public boolean test(Variable variable) {
            return variable.getType().getSimpleType().isFloating();
        }
    };

    public Inlining(DecompilerContext context, Block method) {
        this(context, method, false);
    }

    public Inlining(DecompilerContext context, Block method, boolean aggressive) {
        this._context = context;
        this._method = method;
        this._aggressive = aggressive;
        this.loadCounts = new DefaultMap<Variable, MutableInteger>(MutableInteger.SUPPLIER);
        this.storeCounts = new DefaultMap<Variable, MutableInteger>(MutableInteger.SUPPLIER);
        this.loads = new DefaultMap<Variable, List<Expression>>(CollectionUtilities.listFactory());
        this.analyzeMethod();
    }

    final void analyzeMethod() {
        this.loadCounts.clear();
        this.storeCounts.clear();
        this.analyzeNode(this._method);
    }

    final void analyzeNode(Node node) {
        if (node instanceof Expression) {
            Expression e = (Expression)node;
            if (PatternMatching.matchLoadOrRet(e, this._tempVariable)) {
                Inlining.increment(this.loadCounts, (Variable)this._tempVariable.get());
                this.loads.get(this._tempVariable.get()).add(e);
            } else if (PatternMatching.matchStore((Node)e, this._tempVariable, this._tempExpression)) {
                Inlining.increment(this.storeCounts, (Variable)this._tempVariable.get());
            } else if (PatternMatching.matchVariableIncDec(e, this._tempVariable)) {
                Inlining.increment(this.loadCounts, (Variable)this._tempVariable.get());
                Inlining.increment(this.storeCounts, (Variable)this._tempVariable.get());
                this.loads.get(this._tempVariable.get()).add(e);
            } else if (e.getOperand() instanceof Variable) {
                throw new IllegalStateException(String.format("Unexpected instruction <%s> with variable operand at offset %d in %s:%s", e, e.getOffset(), this._context.getCurrentMethod().getFullName(), this._context.getCurrentMethod().getErasedSignature()));
            }
            for (Expression argument : e.getArguments()) {
                this.analyzeNode(argument);
            }
        } else {
            CatchBlock catchBlock;
            Variable exceptionVariable;
            if (node instanceof CatchBlock && (exceptionVariable = (catchBlock = (CatchBlock)node).getExceptionVariable()) != null) {
                Inlining.increment(this.storeCounts, exceptionVariable);
            }
            for (Node child : node.getChildren()) {
                this.analyzeNode(child);
            }
        }
    }

    final boolean inlineAllVariables() {
        boolean modified = false;
        for (Block block : this._method.getSelfAndChildrenRecursive(Block.class)) {
            modified |= this.inlineAllInBlock(block);
        }
        return modified;
    }

    final boolean inlineAllInBlock(Block block) {
        CatchBlock catchBlock;
        Variable v;
        boolean modified = false;
        List<Node> body = block.getBody();
        StrongBox tempVariable = new StrongBox();
        StrongBox tempExpression = new StrongBox();
        if (block instanceof CatchBlock && !body.isEmpty() && (v = (catchBlock = (CatchBlock)block).getExceptionVariable()) != null && v.isGenerated() && Inlining.count(this.storeCounts, v) == 1 && Inlining.count(this.loadCounts, v) <= 1 && PatternMatching.matchGetArgument(body.get(0), AstCode.Store, tempVariable, (StrongBox<Expression>)tempExpression) && PatternMatching.matchLoad((Node)tempExpression.get(), v)) {
            body.remove(0);
            catchBlock.setExceptionVariable((Variable)tempVariable.get());
            modified = true;
        }
        int i = 0;
        while (i < body.size() - 1) {
            Node node = body.get(i);
            if (PatternMatching.matchGetArgument(node, AstCode.Store, tempVariable, (StrongBox<Expression>)tempExpression) && this.inlineOneIfPossible(block.getBody(), i, this._aggressive)) {
                modified = true;
                i = 0;
                continue;
            }
            ++i;
        }
        for (Node node : body) {
            if (!(node instanceof BasicBlock)) continue;
            modified |= this.inlineAllInBasicBlock((BasicBlock)node);
        }
        return modified;
    }

    final boolean inlineAllInBasicBlock(BasicBlock basicBlock) {
        boolean modified = false;
        List<Node> body = basicBlock.getBody();
        StrongBox tempVariable = new StrongBox();
        StrongBox tempExpression = new StrongBox();
        int i = 0;
        while (i < body.size()) {
            Node node = body.get(i);
            if (PatternMatching.matchGetArgument(node, AstCode.Store, tempVariable, (StrongBox<Expression>)tempExpression) && this.inlineOneIfPossible(basicBlock.getBody(), i, this._aggressive)) {
                modified = true;
                i = Math.max(0, i - 1);
                continue;
            }
            ++i;
        }
        return modified;
    }

    final boolean inlineIfPossible(List<Node> body, MutableInteger position) {
        int currentPosition = position.getValue();
        if (this.inlineOneIfPossible(body, currentPosition, true)) {
            position.setValue(currentPosition - this.inlineInto(body, currentPosition, this._aggressive));
            return true;
        }
        return false;
    }

    final int inlineInto(List<Node> body, int position, boolean aggressive) {
        Expression e;
        Node node;
        if (position >= body.size()) {
            return 0;
        }
        int count = 0;
        int p = position;
        while (--p >= 0 && (node = body.get(p)) instanceof Expression && (e = (Expression)node).getCode() == AstCode.Store) {
            if (!this.inlineOneIfPossible(body, p, aggressive)) continue;
            ++count;
        }
        return count;
    }

    final boolean inlineIfPossible(Variable variable, Expression inlinedExpression, Node next, boolean aggressive) {
        int storeCount = Inlining.count(this.storeCounts, variable);
        int loadCount = Inlining.count(this.loadCounts, variable);
        if (storeCount != 1 || loadCount > 1) {
            return false;
        }
        if (!this.canInline(aggressive, variable)) {
            return false;
        }
        Node n = next;
        if (n instanceof Condition) {
            n = ((Condition)n).getCondition();
        } else if (n instanceof Loop) {
            n = ((Loop)n).getCondition();
        }
        if (!(n instanceof Expression)) {
            return false;
        }
        StrongBox v = new StrongBox();
        StrongBox parent = new StrongBox();
        MutableInteger position = new MutableInteger();
        if (PatternMatching.matchStore((Node)inlinedExpression, (StrongBox<Variable>)v, (StrongBox<Expression>)parent) && PatternMatching.match((Node)parent.value, AstCode.InitArray) && (PatternMatching.match(n, AstCode.LoadElement) || PatternMatching.match(n, AstCode.StoreElement))) {
            return false;
        }
        if (this.findLoadInNext((Expression)n, variable, inlinedExpression, (StrongBox<Expression>)parent, position) == Boolean.TRUE) {
            if (!(aggressive || variable.isGenerated() || this.notFromMetadata(variable) && PatternMatching.matchReturnOrThrow(n) || this.nonAggressiveInlineInto((Expression)n, (Expression)parent.get(), inlinedExpression))) {
                return false;
            }
            List<Expression> parentArguments = ((Expression)parent.get()).getArguments();
            IdentityHashMap<Expression, Expression> parentLookup = new IdentityHashMap<Expression, Expression>();
            for (Expression node : next.getSelfAndChildrenRecursive(Expression.class)) {
                for (Expression child : node.getArguments()) {
                    parentLookup.put(child, node);
                }
            }
            List<Expression> nestedAssignments = inlinedExpression.getSelfAndChildrenRecursive(Expression.class, new Predicate<Expression>(){

                public boolean test(Expression node) {
                    return node.getCode() == AstCode.Store;
                }
            });
            for (Expression assignment : nestedAssignments) {
                Expression lastParent = parentArguments.get(position.getValue());
                for (Expression e : Inlining.getParents((Expression)n, parentLookup, parentArguments.get(position.getValue()))) {
                    if (e.getCode().isWriteOperation()) {
                        boolean lastParentFound = false;
                        for (Expression a : e.getArguments()) {
                            if (lastParentFound) {
                                if (!AstOptimizer.references(a, (Variable)assignment.getOperand())) continue;
                                return false;
                            }
                            if (a != lastParent) continue;
                            lastParentFound = true;
                        }
                    }
                    lastParent = e;
                }
            }
            inlinedExpression.getRanges().addAll(parentArguments.get(position.getValue()).getRanges());
            parentArguments.set(position.getValue(), inlinedExpression);
            return true;
        }
        return false;
    }

    private boolean notFromMetadata(Variable variable) {
        return variable.isGenerated() || !variable.isParameter() && !variable.getOriginalVariable().isFromMetadata();
    }

    private boolean nonAggressiveInlineInto(Expression next, Expression parent, Expression inlinedExpression) {
        if (inlinedExpression.getCode() == AstCode.DefaultValue) {
            return true;
        }
        switch (next.getCode()) {
            case Return: 
            case IfTrue: 
            case Switch: {
                List<Expression> arguments = next.getArguments();
                return arguments.size() == 1 && arguments.get(0) == parent;
            }
            case DefaultValue: {
                return true;
            }
        }
        return false;
    }

    final Boolean findLoadInNext(Expression expression, Variable variable, Expression expressionBeingMoved, StrongBox<Expression> parent, MutableInteger position) {
        parent.set(null);
        position.setValue(0);
        if (expression == null) {
            return Boolean.FALSE;
        }
        AstCode code = expression.getCode();
        List<Expression> arguments = expression.getArguments();
        for (int i = 0; i < arguments.size(); ++i) {
            if (i == 1 && (code == AstCode.LogicalAnd || code == AstCode.LogicalOr || code == AstCode.TernaryOp)) {
                return Boolean.FALSE;
            }
            Expression argument = arguments.get(i);
            if (argument.getCode() == AstCode.Load && argument.getOperand() == variable) {
                switch (code) {
                    case PreIncrement: 
                    case PostIncrement: {
                        if (expressionBeingMoved.getCode() == AstCode.Load) break;
                        return Boolean.FALSE;
                    }
                }
                parent.set((Object)expression);
                position.setValue(i);
                return Boolean.TRUE;
            }
            StrongBox tempOperand = new StrongBox();
            StrongBox tempExpression = new StrongBox();
            if (PatternMatching.matchGetArgument(argument, AstCode.PostIncrement, tempOperand, (StrongBox<Expression>)tempExpression) && PatternMatching.matchGetOperand((Node)tempExpression.get(), AstCode.Load, tempOperand) && tempOperand.get() == variable) {
                return Boolean.FALSE;
            }
            Boolean result = this.findLoadInNext(argument, variable, expressionBeingMoved, parent, position);
            if (!Boolean.TRUE.equals(result)) continue;
            return result;
        }
        if (Inlining.isSafeForInlineOver(expression, expressionBeingMoved)) {
            return null;
        }
        return Boolean.FALSE;
    }

    static boolean isSafeForInlineOver(Expression expression, Expression expressionBeingMoved) {
        switch (expression.getCode()) {
            case Load: {
                Variable loadedVariable = (Variable)expression.getOperand();
                for (Expression potentialStore : expressionBeingMoved.getSelfAndChildrenRecursive(Expression.class)) {
                    if (!PatternMatching.matchVariableMutation(potentialStore, loadedVariable)) continue;
                    return false;
                }
                return true;
            }
        }
        return Inlining.hasNoSideEffect(expression);
    }

    final boolean inlineOneIfPossible(List<Node> body, int position, boolean aggressive) {
        StrongBox variable = new StrongBox();
        StrongBox inlinedExpression = new StrongBox();
        Node node = body.get(position);
        if (PatternMatching.matchGetArgument(node, AstCode.Store, variable, (StrongBox<Expression>)inlinedExpression)) {
            Node next = (Node)CollectionUtilities.getOrDefault(body, (int)(position + 1));
            Variable v = (Variable)variable.get();
            Expression e = (Expression)inlinedExpression.get();
            Expression current = (Expression)node;
            if (this.inlineIfPossible(v, e, next, aggressive)) {
                e.getRanges().addAll(current.getRanges());
                body.remove(position);
                return true;
            }
            if (PatternMatching.match(e, AstCode.Store) && this.canInline(true, (Variable)variable.value) && Inlining.count(this.storeCounts, (Variable)variable.value) == 1 && Inlining.count(this.loadCounts, (Variable)variable.value) <= 1 && Inlining.count(this.loadCounts, (Variable)e.getOperand()) <= 1) {
                Variable currentVariable = (Variable)variable.value;
                Variable nestedVariable = (Variable)e.getOperand();
                if (MetadataHelper.isSameType(currentVariable.getType(), nestedVariable.getType())) {
                    List<Expression> currentLoads = this.loads.get(currentVariable);
                    List<Expression> nestedLoads = this.loads.get(nestedVariable);
                    if (nestedVariable.isGenerated()) {
                        for (Expression load : nestedLoads) {
                            load.setOperand(currentVariable);
                            currentLoads.add(load);
                            Inlining.increment(this.loadCounts, currentVariable);
                        }
                        nestedLoads.clear();
                    } else {
                        current.setOperand(nestedVariable);
                        for (Expression load : currentLoads) {
                            load.setOperand(nestedVariable);
                            nestedLoads.add(load);
                            Inlining.increment(this.loadCounts, nestedVariable);
                        }
                        currentLoads.clear();
                    }
                    Expression nestedValue = (Expression)CollectionUtilities.single(e.getArguments());
                    current.getArguments().set(0, nestedValue);
                    return true;
                }
            }
            if (PatternMatching.matchStore((Node)e, (StrongBox<Variable>)variable, (StrongBox<Expression>)inlinedExpression)) {
                Expression loadThisInstead = new Expression(AstCode.Load, (Object)v, current.getOffset(), new Expression[0]);
                if (this.inlineIfPossible((Variable)variable.get(), loadThisInstead, next, aggressive)) {
                    current.getArguments().set(0, (Expression)CollectionUtilities.single(e.getArguments()));
                    this.storeCounts.get(variable.get()).setValue(0);
                    this.loadCounts.get(variable.get()).setValue(0);
                    Inlining.increment(this.loadCounts, v);
                    return true;
                }
            }
            if (Inlining.count(this.loadCounts, v) == 0 && this.canInline(aggressive, v)) {
                if (Inlining.hasNoSideEffect(e)) {
                    body.remove(position);
                    return true;
                }
                if (Inlining.canBeExpressionStatement(e)) {
                    e.getRanges().addAll(current.getRanges());
                    body.set(position, e);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean canInline(boolean aggressive, Variable variable) {
        return aggressive ? this.notFromMetadata(variable) : variable.isGenerated();
    }

    final void copyPropagation() {
        for (Block block : this._method.getSelfAndChildrenRecursive(Block.class)) {
            List<Node> body = block.getBody();
            StrongBox variable = new StrongBox();
            StrongBox copiedExpression = new StrongBox();
            for (int i = 0; i < body.size(); ++i) {
                if (!PatternMatching.matchGetArgument(body.get(i), AstCode.Store, variable, (StrongBox<Expression>)copiedExpression) || ((Variable)variable.get()).isParameter() || Inlining.count(this.storeCounts, (Variable)variable.get()) != 1 || !this.canPerformCopyPropagation((Expression)copiedExpression.get(), (Variable)variable.get())) continue;
                List<Expression> arguments = ((Expression)copiedExpression.get()).getArguments();
                Variable[] uninlinedArgs = new Variable[arguments.size()];
                for (int j = 0; j < uninlinedArgs.length; ++j) {
                    Variable newVariable = new Variable();
                    newVariable.setGenerated(true);
                    newVariable.setName(String.format("%s_cp_%d", ((Variable)variable.get()).getName(), j));
                    uninlinedArgs[j] = newVariable;
                    body.add(i++, new Expression(AstCode.Store, (Object)uninlinedArgs[j], -34, new Expression[0]));
                }
                for (Expression expression : this._method.getSelfAndChildrenRecursive(Expression.class)) {
                    if (!expression.getCode().isLoad() || expression.getOperand() != variable.get()) continue;
                    expression.setOperand(((Expression)copiedExpression.get()).getOperand());
                    for (Variable uninlinedArg : uninlinedArgs) {
                        expression.getArguments().add(new Expression(AstCode.Load, (Object)uninlinedArg, -34, new Expression[0]));
                    }
                }
                body.remove(i);
                if (uninlinedArgs.length > 0) {
                    this.analyzeMethod();
                }
                this.inlineInto(body, i, this._aggressive);
                i -= uninlinedArgs.length + 1;
            }
        }
    }

    final boolean canPerformCopyPropagation(Expression expr, Variable copyVariable) {
        switch (expr.getCode()) {
            case Load: {
                Variable v = (Variable)expr.getOperand();
                if (v.isParameter()) {
                    return Inlining.count(this.storeCounts, v) == 0 && this.notFromMetadata(copyVariable);
                }
                return v.isGenerated() && copyVariable.isGenerated() && Inlining.count(this.storeCounts, v) == 1;
            }
        }
        return false;
    }

    static boolean hasNoSideEffect(Expression expression) {
        switch (expression.getCode()) {
            case Load: 
            case AConstNull: 
            case LdC: {
                return true;
            }
            case Add: 
            case Sub: 
            case Mul: 
            case Shl: 
            case Shr: 
            case UShr: 
            case And: 
            case Or: 
            case Xor: {
                return Inlining.hasNoSideEffect(expression.getArguments().get(0)) && Inlining.hasNoSideEffect(expression.getArguments().get(1));
            }
            case Rem: 
            case Div: {
                Expression l = expression.getArguments().get(0);
                Expression r = expression.getArguments().get(1);
                if (Inlining.hasNoSideEffect(l) && Inlining.hasNoSideEffect(r)) {
                    StrongBox c = new StrongBox();
                    if (PatternMatching.matchLoad((Node)l, (StrongBox<? super Object>)c, IS_FLOAT_VARIABLE) || PatternMatching.matchLoad((Node)r, (StrongBox<? super Object>)c, IS_FLOAT_VARIABLE)) {
                        return true;
                    }
                    if (PatternMatching.matchNumericConstant(r, (Consumer<? super Number>)c)) {
                        Number n = (Number)c.get();
                        return n instanceof Float || n instanceof Double || n.longValue() != 0L || PatternMatching.matchNumericConstant(l, (Consumer<? super Number>)c) && ((n = (Number)c.get()) instanceof Float || n instanceof Double);
                    }
                }
                return false;
            }
            case Not: 
            case Neg: {
                return Inlining.hasNoSideEffect(expression.getArguments().get(0));
            }
        }
        return false;
    }

    static boolean canBeExpressionStatement(Expression expression) {
        switch (expression.getCode()) {
            case PreIncrement: 
            case PostIncrement: 
            case PutStatic: 
            case PutField: 
            case InvokeVirtual: 
            case InvokeSpecial: 
            case InvokeStatic: 
            case InvokeInterface: 
            case InvokeDynamic: 
            case __New: 
            case Store: 
            case StoreElement: 
            case Inc: {
                return true;
            }
        }
        return false;
    }

    static int count(Map<Variable, MutableInteger> map, Variable variable) {
        MutableInteger count = map.get(variable);
        return count != null ? count.getValue() : 0;
    }

    private static void increment(Map<Variable, MutableInteger> map, Variable variable) {
        MutableInteger count = map.get(variable);
        if (count == null) {
            map.put(variable, new MutableInteger(1));
        } else {
            count.increment();
        }
    }

    private static Iterable<Expression> getParents(final Expression scope, final Map<Expression, Expression> parentLookup, final Expression node) {
        return new Iterable<Expression>(){

            @Override
            @NotNull
            public final Iterator<Expression> iterator() {
                return new Iterator<Expression>(){
                    Expression current;
                    {
                        this.current = this.updateCurrent(node);
                    }

                    private Expression updateCurrent(Expression node) {
                        if (node != null && node != Node.NULL) {
                            if (node == scope) {
                                return null;
                            }
                            node = (Expression)parentLookup.get(node);
                            return node;
                        }
                        return null;
                    }

                    @Override
                    public final boolean hasNext() {
                        return this.current != null;
                    }

                    @Override
                    public final Expression next() {
                        Expression next = this.current;
                        if (next == null) {
                            throw new NoSuchElementException();
                        }
                        this.current = this.updateCurrent(next);
                        return next;
                    }

                    @Override
                    public final void remove() {
                        throw ContractUtils.unsupported();
                    }
                };
            }
        };
    }
}

