/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java;

import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ModuleReference;
import com.strobel.assembler.metadata.PackageReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.ITextOutput;
import com.strobel.decompiler.ast.Variable;
import com.strobel.decompiler.languages.LineNumberPosition;
import com.strobel.decompiler.languages.TextLocation;
import com.strobel.decompiler.languages.java.BraceStyle;
import com.strobel.decompiler.languages.java.IOutputFormatter;
import com.strobel.decompiler.languages.java.OffsetToLineNumberConverter;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.CatchClause;
import com.strobel.decompiler.languages.java.ast.Comment;
import com.strobel.decompiler.languages.java.ast.CommentType;
import com.strobel.decompiler.languages.java.ast.EntityDeclaration;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.ImportDeclaration;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.LabelStatement;
import com.strobel.decompiler.languages.java.ast.ModuleDeclaration;
import com.strobel.decompiler.languages.java.ast.ObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.TypeParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.VariableInitializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class TextOutputFormatter
implements IOutputFormatter {
    private final ITextOutput output;
    private final Stack<AstNode> nodeStack = new Stack();
    private int braceLevelWithinType = -1;
    private boolean inDocumentationComment = false;
    private boolean firstUsingDeclaration;
    private boolean lastUsingDeclaration;
    private LineNumberMode lineNumberMode;
    private int lastObservedLineNumber = -100;
    private OffsetToLineNumberConverter offset2LineNumber = OffsetToLineNumberConverter.NOOP_CONVERTER;
    private final List<LineNumberPosition> lineNumberPositions = new ArrayList<LineNumberPosition>();
    private final Stack<TextLocation> startLocations = new Stack();

    public TextOutputFormatter(ITextOutput output, LineNumberMode lineNumberMode) {
        this.output = (ITextOutput)VerifyArgument.notNull((Object)output, (String)"output");
        this.lineNumberMode = lineNumberMode;
    }

    @Override
    public void startNode(AstNode node) {
        int lineNumber;
        if (this.nodeStack.isEmpty()) {
            if (this.isImportDeclaration(node)) {
                this.firstUsingDeclaration = !this.isImportDeclaration(node.getPreviousSibling());
                this.lastUsingDeclaration = !this.isImportDeclaration(node.getNextSibling());
            } else {
                this.firstUsingDeclaration = false;
                this.lastUsingDeclaration = false;
            }
        }
        this.nodeStack.push(node);
        int offset = -34;
        String prefix = null;
        if (node instanceof Expression) {
            offset = ((Expression)node).getOffset();
            prefix = "/*EL:";
        } else if (node instanceof Statement) {
            offset = ((Statement)node).getOffset();
            prefix = "/*SL:";
        }
        if (offset != -34 && (lineNumber = this.offset2LineNumber.getLineForOffset(offset)) > this.lastObservedLineNumber) {
            int lineOfComment = this.output.getRow();
            int columnOfComment = this.output.getColumn();
            LineNumberPosition pos = new LineNumberPosition(lineNumber, lineOfComment, columnOfComment);
            this.lineNumberPositions.add(pos);
            this.lastObservedLineNumber = lineNumber;
            if (this.lineNumberMode == LineNumberMode.WITH_DEBUG_LINE_NUMBERS) {
                String commentStr = prefix + lineNumber + "*/";
                this.output.writeComment(commentStr);
            }
        }
        this.startLocations.push(new TextLocation(this.output.getRow(), this.output.getColumn()));
        if (node instanceof EntityDeclaration && node.getUserData(Keys.MEMBER_REFERENCE) != null && node.getChildByRole(Roles.IDENTIFIER).isNull()) {
            this.output.writeDefinition("", node.getUserData(Keys.MEMBER_REFERENCE), false);
        }
    }

    @Override
    public void endNode(AstNode node) {
        if (this.nodeStack.pop() != node) {
            throw new IllegalStateException();
        }
        this.startLocations.pop();
    }

    @Override
    public void writeLabel(String label) {
        this.output.writeLabel(label);
    }

    @Override
    public void writeIdentifier(String identifier) {
        Object reference = this.getCurrentLocalReference();
        if (reference != null) {
            this.output.writeReference(identifier, reference, true);
            return;
        }
        reference = this.getCurrentMemberReference();
        if (reference != null) {
            this.output.writeReference(identifier, reference);
            return;
        }
        reference = this.getCurrentModuleReference();
        if (reference != null) {
            this.output.writeReference(identifier, reference);
            return;
        }
        reference = this.getCurrentTypeReference();
        if (reference != null) {
            this.output.writeReference(identifier, reference);
            return;
        }
        reference = this.getCurrentPackageReference();
        if (reference != null) {
            this.output.writeReference(identifier, reference);
            return;
        }
        Object definition = this.getCurrentDefinition();
        if (definition != null) {
            this.output.writeDefinition(identifier, definition, false);
            return;
        }
        definition = this.getCurrentLocalDefinition();
        if (definition != null) {
            this.output.writeDefinition(identifier, definition);
            return;
        }
        if (this.firstUsingDeclaration) {
            this.output.markFoldStart("", true);
            this.firstUsingDeclaration = false;
        }
        this.output.write(identifier);
    }

    @Override
    public void writeKeyword(String keyword) {
        this.output.writeKeyword(keyword);
    }

    @Override
    public void writeOperator(String token) {
        this.output.writeOperator(token);
    }

    @Override
    public void writeDelimiter(String token) {
        this.output.writeDelimiter(token);
    }

    @Override
    public void writeToken(String token) {
        this.output.write(token);
    }

    @Override
    public void writeLiteral(String value) {
        this.output.writeLiteral(value);
    }

    @Override
    public void writeTextLiteral(String value) {
        this.output.writeTextLiteral(value);
    }

    @Override
    public void writeTextBlock(String value) {
        int columnStart = this.output.getColumn();
        List lines = StringUtilities.split((String)value, (boolean)false, (char)'\n', (char[])new char[0]);
        boolean endsWithNewline = value.endsWith("\n");
        this.output.writeTextLiteral("\"\"\"");
        this.output.writeLine();
        int columnEnd = this.output.getColumn();
        int paddingSize = Math.max(0, columnStart - columnEnd);
        String padding = StringUtilities.repeat((char)' ', (int)paddingSize);
        int n = lines.size();
        for (int i = 0; i < n - 1; ++i) {
            String line = (String)lines.get(i);
            if (line.indexOf(13) >= 0) {
                line = line.replace("\r", "\\r");
            }
            if (line.contains("\"\"\"")) {
                line = line.replace("\"\"\"", "\\\"\"\"");
            }
            this.output.write(padding);
            this.output.writeTextLiteral(line);
            this.output.writeLine();
        }
        String lastLine = (String)lines.get(n - 1);
        this.output.write(padding);
        this.output.writeTextLiteral(lastLine);
        if (endsWithNewline && !StringUtilities.isNullOrWhitespace((String)lastLine)) {
            this.output.writeLine();
            this.output.write(padding);
        }
        this.output.writeTextLiteral("\"\"\"");
    }

    @Override
    public void space() {
        this.output.write(' ');
    }

    @Override
    public void openBrace(BraceStyle style) {
        if (this.braceLevelWithinType >= 0 || this.nodeStack.peek() instanceof TypeDeclaration) {
            ++this.braceLevelWithinType;
        }
        int blockDepth = 0;
        for (AstNode node : this.nodeStack) {
            if (!(node instanceof BlockStatement)) continue;
            ++blockDepth;
        }
        if (blockDepth <= 1) {
            this.output.markFoldStart("", this.braceLevelWithinType == 1);
        }
        switch (style) {
            case EndOfLine: 
            case EndOfLineWithoutSpace: {
                break;
            }
            case NextLine: {
                this.output.writeLine();
                break;
            }
            case NextLineShifted: {
                this.output.writeLine();
                this.output.indent();
                break;
            }
            case NextLineShifted2: {
                this.output.writeLine();
                this.output.indent();
                this.output.indent();
                break;
            }
        }
        this.output.writeDelimiter("{");
        if (style != BraceStyle.BannerStyle) {
            this.output.writeLine();
        }
        this.output.indent();
    }

    @Override
    public void closeBrace(BraceStyle style) {
        this.output.unindent();
        this.output.writeDelimiter("}");
        switch (style) {
            case NextLineShifted: {
                this.output.unindent();
                break;
            }
            case NextLineShifted2: {
                this.output.unindent();
                this.output.unindent();
            }
        }
        int blockDepth = 0;
        for (AstNode node : this.nodeStack) {
            if (!(node instanceof BlockStatement)) continue;
            ++blockDepth;
        }
        if (blockDepth <= 1) {
            this.output.markFoldEnd();
        }
        if (this.braceLevelWithinType >= 0) {
            --this.braceLevelWithinType;
        }
    }

    @Override
    public void indent() {
        this.output.indent();
    }

    @Override
    public void unindent() {
        this.output.unindent();
    }

    @Override
    public void newLine() {
        if (this.lastUsingDeclaration) {
            this.output.markFoldEnd();
            this.lastUsingDeclaration = false;
        }
        this.output.writeLine();
    }

    @Override
    public void writeComment(CommentType commentType, String content) {
        switch (commentType) {
            case SingleLine: {
                this.output.writeComment("//");
                this.output.writeComment(content);
                this.output.writeLine();
                break;
            }
            case MultiLine: {
                this.output.writeComment("/*");
                this.output.writeComment(content);
                this.output.writeComment("*/");
                break;
            }
            case Documentation: {
                boolean isLastLine;
                boolean isFirstLine = !(this.nodeStack.peek().getPreviousSibling() instanceof Comment);
                boolean bl = isLastLine = !(this.nodeStack.peek().getNextSibling() instanceof Comment);
                if (!this.inDocumentationComment && isFirstLine) {
                    this.inDocumentationComment = true;
                    String foldedContent = content.replace("\r|\n", " ").trim();
                    if (foldedContent.length() > 80) {
                        foldedContent = foldedContent.substring(0, 80) + " (...)";
                    } else if (!isLastLine) {
                        foldedContent = foldedContent + " (...)";
                    }
                    this.output.markFoldStart("/** " + foldedContent + " */", true);
                    this.output.writeComment("/**");
                    this.output.writeLine();
                }
                this.output.writeComment(" * ");
                this.output.writeComment(content);
                this.output.writeLine();
                if (!this.inDocumentationComment || !isLastLine) break;
                this.inDocumentationComment = false;
                this.output.writeComment(" */");
                this.output.markFoldEnd();
                this.output.writeLine();
                break;
            }
            default: {
                this.output.write(content);
            }
        }
    }

    private Object getCurrentDefinition() {
        Object definition;
        if (this.nodeStack.isEmpty()) {
            return null;
        }
        AstNode node = this.nodeStack.peek();
        if (TextOutputFormatter.isDefinition(node)) {
            definition = node.getUserData(Keys.TYPE_DEFINITION);
            if (definition != null) {
                return definition;
            }
            definition = node.getUserData(Keys.METHOD_DEFINITION);
            if (definition != null) {
                return definition;
            }
            definition = node.getUserData(Keys.FIELD_DEFINITION);
            if (definition != null) {
                return definition;
            }
        }
        if (node.getRole() == Roles.IDENTIFIER) {
            AstNode parent = node.getParent();
            if (parent == null) {
                return null;
            }
            if (parent instanceof VariableInitializer) {
                parent = parent.getParent();
            }
            if (parent == null) {
                return null;
            }
            definition = parent.getUserData(Keys.MODULE_REFERENCE);
            if (definition != null) {
                return definition;
            }
            definition = parent.getUserData(Keys.TYPE_DEFINITION);
            if (definition != null) {
                return definition;
            }
            definition = parent.getUserData(Keys.METHOD_DEFINITION);
            if (definition != null) {
                return definition;
            }
            definition = parent.getUserData(Keys.FIELD_DEFINITION);
            if (definition != null) {
                return definition;
            }
        }
        return null;
    }

    private MemberReference getCurrentTypeReference() {
        AstNode parent;
        AstNode node = this.nodeStack.peek();
        TypeReference typeReference = node.getUserData(Keys.TYPE_REFERENCE);
        if (typeReference != null) {
            return typeReference;
        }
        if (node instanceof Identifier && ((parent = node.getParent()) instanceof AstType || parent instanceof TypeParameterDeclaration || parent instanceof ImportDeclaration)) {
            return parent.getUserData(Keys.TYPE_REFERENCE);
        }
        return null;
    }

    private ModuleReference getCurrentModuleReference() {
        AstNode parent;
        AstNode node = this.nodeStack.peek();
        ModuleReference moduleReference = node.getUserData(Keys.MODULE_REFERENCE);
        if (moduleReference != null) {
            return moduleReference;
        }
        if (node instanceof Identifier && (parent = node.getParent()) instanceof ModuleDeclaration) {
            return parent.getUserData(Keys.MODULE_REFERENCE);
        }
        return null;
    }

    private PackageReference getCurrentPackageReference() {
        AstNode node = this.nodeStack.peek();
        PackageReference pkg = node.getUserData(Keys.PACKAGE_REFERENCE);
        if (pkg == null && node.getParent() instanceof ImportDeclaration) {
            pkg = node.getParent().getUserData(Keys.PACKAGE_REFERENCE);
        }
        return pkg;
    }

    private MemberReference getCurrentMemberReference() {
        AstNode node = this.nodeStack.peek();
        MemberReference member = node.getUserData(Keys.MEMBER_REFERENCE);
        if (member == null && node.getRole() == Roles.TARGET_EXPRESSION && (node.getParent() instanceof InvocationExpression || node.getParent() instanceof ObjectCreationExpression)) {
            member = node.getParent().getUserData(Keys.MEMBER_REFERENCE);
        }
        return member;
    }

    private Object getCurrentLocalReference() {
        AstNode node = this.nodeStack.peek();
        Variable variable = node.getUserData(Keys.VARIABLE);
        if (variable == null && node instanceof Identifier && node.getParent() != null) {
            variable = node.getParent().getUserData(Keys.VARIABLE);
        }
        if (variable != null) {
            if (variable.isParameter()) {
                return variable.getOriginalParameter();
            }
            return variable.getOriginalVariable();
        }
        return null;
    }

    private Object getCurrentLocalDefinition() {
        ParameterDefinition parameter;
        AstNode node = this.nodeStack.peek();
        if (node instanceof Identifier && node.getParent() != null) {
            node = node.getParent();
        }
        if ((parameter = node.getUserData(Keys.PARAMETER_DEFINITION)) != null) {
            return parameter;
        }
        if (node instanceof VariableInitializer || node instanceof CatchClause) {
            Variable variable = node.getUserData(Keys.VARIABLE);
            if (variable == null && node.getParent() instanceof VariableDeclarationStatement) {
                variable = node.getParent().getUserData(Keys.VARIABLE);
            }
            if (variable != null) {
                if (variable.getOriginalParameter() != null) {
                    return variable.getOriginalParameter();
                }
                return variable.getOriginalVariable();
            }
        }
        if (node instanceof LabelStatement) {
            LabelStatement label = (LabelStatement)node;
            for (int i = this.nodeStack.size() - 1; i >= 0; --i) {
                AstNode n = (AstNode)this.nodeStack.get(i);
                MemberReference methodReference = n.getUserData(Keys.MEMBER_REFERENCE);
                if (!(methodReference instanceof MethodReference)) continue;
                return methodReference + label.getLabel();
            }
        }
        return null;
    }

    private static boolean isDefinition(AstNode node) {
        return node instanceof EntityDeclaration;
    }

    private boolean isImportDeclaration(AstNode node) {
        return node instanceof ImportDeclaration;
    }

    @Override
    public void resetLineNumberOffsets(OffsetToLineNumberConverter offset2LineNumber) {
        this.lastObservedLineNumber = -100;
        this.offset2LineNumber = offset2LineNumber;
    }

    public List<LineNumberPosition> getLineNumberPositions() {
        return this.lineNumberPositions;
    }

    public static enum LineNumberMode {
        WITH_DEBUG_LINE_NUMBERS,
        WITHOUT_DEBUG_LINE_NUMBERS;

    }
}

