/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.Flags;
import com.strobel.assembler.metadata.LanguageFeature;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.CollectionUtilities;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.ast.Variable;
import com.strobel.decompiler.languages.java.analysis.Correlator;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.CastExpression;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.IfElseStatement;
import com.strobel.decompiler.languages.java.ast.InstanceOfExpression;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.NameVariables;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.VariableInitializer;
import com.strobel.decompiler.patterns.AnyNode;
import com.strobel.decompiler.patterns.BackReference;
import com.strobel.decompiler.patterns.Choice;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.NamedNode;
import com.strobel.decompiler.patterns.OptionalNode;
import com.strobel.decompiler.patterns.Repeat;
import com.strobel.decompiler.patterns.SubtreeMatch;
import java.util.List;

public class IntroducePatternMatchingTransform
extends ContextTrackingVisitor<Void> {
    private final IfElseStatement simplePattern;

    public IntroducePatternMatchingTransform(DecompilerContext context) {
        super(context);
        VariableDeclarationStatement v = new VariableDeclarationStatement(new BackReference("type").toType(), "$any$", new CastExpression(new BackReference("type").toType(), new BackReference("expression").toExpression()));
        v.setAnyModifiers(true);
        this.simplePattern = new IfElseStatement(new NamedNode("instanceOf", new InstanceOfExpression(new NamedNode("expression", new AnyNode()).toExpression(), new NamedNode("type", new AnyNode()).toType())).toExpression(), new BlockStatement(new Choice(new NamedNode("variableDeclaration", v), new SubtreeMatch(new CastExpression(new BackReference("type").toType(), new BackReference("expression").toExpression()), "usageViaCast", true)).toStatement(), new Repeat(new AnyNode()).toStatement()), new OptionalNode(new AnyNode()).toStatement());
    }

    @Override
    public void run(AstNode compilationUnit) {
        if (this.context.isSupported(LanguageFeature.PATTERN_MATCHING)) {
            super.run(compilationUnit);
        }
    }

    @Override
    public Void visitIfElseStatement(IfElseStatement node, Void data) {
        super.visitIfElseStatement(node, data);
        if (this.trySimplePatternMatch(node)) {
            return null;
        }
        return null;
    }

    private boolean trySimplePatternMatch(IfElseStatement node) {
        Identifier nameToken;
        Match m = this.simplePattern.match(node);
        if (!m.success()) {
            return false;
        }
        InstanceOfExpression io = (InstanceOfExpression)CollectionUtilities.first(m.get("instanceOf"));
        if (m.has("variableDeclaration")) {
            VariableDeclarationStatement v = (VariableDeclarationStatement)CollectionUtilities.first(m.get("variableDeclaration"));
            VariableInitializer vi = (VariableInitializer)CollectionUtilities.first(v.getVariables());
            nameToken = vi.getNameToken();
            v.remove();
            nameToken.remove();
            io.setModifiers(v.getModifiers());
            Variable variable = vi.getUserData(Keys.VARIABLE);
            if (variable != null) {
                io.putUserData(Keys.VARIABLE, variable);
            }
        } else if (m.has("usageViaCast")) {
            NameVariables nv;
            MethodDeclaration md = node.getParent(MethodDeclaration.class);
            if (md == null || (nv = md.getUserData(Keys.NAME_VARIABLES)) == null) {
                return false;
            }
            AstType astType = (AstType)CollectionUtilities.first(m.get("type"));
            TypeReference type = astType.toTypeReference();
            List casts = CollectionUtilities.toList(m.get("usageViaCast"));
            if (type == null) {
                return false;
            }
            nameToken = Identifier.create(nv.getNameForType(type));
            if (casts.size() > 1 && io.getExpression() instanceof IdentifierExpression) {
                String id = ((IdentifierExpression)io.getExpression()).getIdentifier();
                Statement parentStatement = ((CastExpression)casts.get(0)).getParent(Statement.class);
                if (parentStatement == null || parentStatement.getParent() == null) {
                    return false;
                }
                BlockStatement placeholder = new BlockStatement();
                parentStatement.replaceWith(placeholder);
                boolean correlated = Correlator.areCorrelated(new IdentifierExpression(id), node.getTrueStatement());
                placeholder.replaceWith(parentStatement);
                if (!correlated) {
                    for (int i = 1; i < casts.size(); ++i) {
                        ((CastExpression)casts.get(i)).replaceWith(new IdentifierExpression(((CastExpression)casts.get(i)).getOffset(), nameToken.clone()));
                    }
                }
            }
            ((CastExpression)casts.get(0)).replaceWith(new IdentifierExpression(((CastExpression)casts.get(0)).getOffset(), nameToken.clone()));
            io.addModifier(Flags.Flag.FINAL);
        } else {
            return false;
        }
        io.setIdentifier(nameToken);
        return true;
    }
}

