/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.core.Predicate;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.transforms.AddReferenceQualifiersTransform;
import com.strobel.decompiler.languages.java.ast.transforms.AddStandardAnnotationsTransform;
import com.strobel.decompiler.languages.java.ast.transforms.AssertStatementTransform;
import com.strobel.decompiler.languages.java.ast.transforms.BreakTargetRelocation;
import com.strobel.decompiler.languages.java.ast.transforms.CollapseImportsTransform;
import com.strobel.decompiler.languages.java.ast.transforms.ConvertLoopsTransform;
import com.strobel.decompiler.languages.java.ast.transforms.DeclareLocalClassesTransform;
import com.strobel.decompiler.languages.java.ast.transforms.DeclareVariablesTransform;
import com.strobel.decompiler.languages.java.ast.transforms.EclipseEnumSwitchRewriterTransform;
import com.strobel.decompiler.languages.java.ast.transforms.EclipseStringSwitchRewriterTransform;
import com.strobel.decompiler.languages.java.ast.transforms.EliminateSyntheticAccessorsTransform;
import com.strobel.decompiler.languages.java.ast.transforms.EnumRewriterTransform;
import com.strobel.decompiler.languages.java.ast.transforms.EnumSwitchRewriterTransform;
import com.strobel.decompiler.languages.java.ast.transforms.FlattenElseIfStatementsTransform;
import com.strobel.decompiler.languages.java.ast.transforms.FlattenSwitchBlocksTransform;
import com.strobel.decompiler.languages.java.ast.transforms.IAstTransform;
import com.strobel.decompiler.languages.java.ast.transforms.InlineEscapingAssignmentsTransform;
import com.strobel.decompiler.languages.java.ast.transforms.InsertConstantReferencesTransform;
import com.strobel.decompiler.languages.java.ast.transforms.InsertNecessaryConversionsTransform;
import com.strobel.decompiler.languages.java.ast.transforms.IntroduceInitializersTransform;
import com.strobel.decompiler.languages.java.ast.transforms.IntroduceOuterClassReferencesTransform;
import com.strobel.decompiler.languages.java.ast.transforms.IntroducePatternMatchingTransform;
import com.strobel.decompiler.languages.java.ast.transforms.IntroduceStringConcatenationTransform;
import com.strobel.decompiler.languages.java.ast.transforms.InvokeDynamicRewriter;
import com.strobel.decompiler.languages.java.ast.transforms.LabelCleanupTransform;
import com.strobel.decompiler.languages.java.ast.transforms.LambdaTransform;
import com.strobel.decompiler.languages.java.ast.transforms.MarkReferencedSyntheticsTransform;
import com.strobel.decompiler.languages.java.ast.transforms.MergeResourceTryStatementsVisitor;
import com.strobel.decompiler.languages.java.ast.transforms.MethodHandleConstantRewriter;
import com.strobel.decompiler.languages.java.ast.transforms.NewTryWithResourcesTransform;
import com.strobel.decompiler.languages.java.ast.transforms.RemoveHiddenMembersTransform;
import com.strobel.decompiler.languages.java.ast.transforms.RemoveImplicitBoxingTransform;
import com.strobel.decompiler.languages.java.ast.transforms.RemoveRedundantCastsTransform;
import com.strobel.decompiler.languages.java.ast.transforms.RemoveRedundantInitializersTransform;
import com.strobel.decompiler.languages.java.ast.transforms.RewriteBoxingCastsTransform;
import com.strobel.decompiler.languages.java.ast.transforms.RewriteInnerClassConstructorCalls;
import com.strobel.decompiler.languages.java.ast.transforms.RewriteLegacyClassConstantsTransform;
import com.strobel.decompiler.languages.java.ast.transforms.RewriteLocalClassesTransform;
import com.strobel.decompiler.languages.java.ast.transforms.RewriteNewArrayLambdas;
import com.strobel.decompiler.languages.java.ast.transforms.RewriteRecordClassesTransform;
import com.strobel.decompiler.languages.java.ast.transforms.RewriteSwitchExpressionsTransform;
import com.strobel.decompiler.languages.java.ast.transforms.SimplifyArithmeticExpressionsTransform;
import com.strobel.decompiler.languages.java.ast.transforms.SimplifyAssignmentsTransform;
import com.strobel.decompiler.languages.java.ast.transforms.StringSwitchRewriterTransform;
import com.strobel.decompiler.languages.java.ast.transforms.TryWithResourcesTransform;
import com.strobel.decompiler.languages.java.ast.transforms.VarArgsTransform;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TransformationPipeline {
    private static final Logger LOG = Logger.getLogger(TransformationPipeline.class.getSimpleName());

    public static IAstTransform[] createPipeline(DecompilerContext context) {
        return new IAstTransform[]{new RewriteLegacyClassConstantsTransform(context), new EnumRewriterTransform(context), new EnumSwitchRewriterTransform(context), new EclipseEnumSwitchRewriterTransform(context), new AssertStatementTransform(context), new RemoveImplicitBoxingTransform(context), new RemoveRedundantCastsTransform(context), new ConvertLoopsTransform(context), new BreakTargetRelocation(context), new LabelCleanupTransform(context), new TryWithResourcesTransform(context), new NewTryWithResourcesTransform(context), new DeclareVariablesTransform(context), new MergeResourceTryStatementsVisitor(context), new StringSwitchRewriterTransform(context), new EclipseStringSwitchRewriterTransform(context), new SimplifyAssignmentsTransform(context), new EliminateSyntheticAccessorsTransform(context), new LambdaTransform(context), new RewriteNewArrayLambdas(context), new RewriteRecordClassesTransform(context), new RewriteLocalClassesTransform(context), new IntroduceOuterClassReferencesTransform(context), new RewriteInnerClassConstructorCalls(context), new RemoveRedundantInitializersTransform(context), new FlattenElseIfStatementsTransform(context), new RewriteSwitchExpressionsTransform(context), new AssertStatementTransform(context), new FlattenSwitchBlocksTransform(context), new IntroduceInitializersTransform(context), new MarkReferencedSyntheticsTransform(context), new RemoveRedundantCastsTransform(context), new RewriteBoxingCastsTransform(context), new InsertNecessaryConversionsTransform(context), new MethodHandleConstantRewriter(context), new IntroduceStringConcatenationTransform(context), new InvokeDynamicRewriter(context), new SimplifyAssignmentsTransform(context), new InlineEscapingAssignmentsTransform(context), new VarArgsTransform(context), new InsertConstantReferencesTransform(context), new SimplifyArithmeticExpressionsTransform(context), new DeclareLocalClassesTransform(context), new IntroducePatternMatchingTransform(context), new AddStandardAnnotationsTransform(context), new AddReferenceQualifiersTransform(context), new RemoveHiddenMembersTransform(context), new CollapseImportsTransform(context)};
    }

    public static void runTransformationsUntil(AstNode node, Predicate<IAstTransform> abortCondition, DecompilerContext context) {
        if (node == null) {
            return;
        }
        for (IAstTransform transform : TransformationPipeline.createPipeline(context)) {
            if (abortCondition != null && abortCondition.test((Object)transform)) {
                return;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Running Java AST transform: " + transform.getClass().getSimpleName() + "...");
            }
            transform.run(node);
        }
    }
}

