/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.expressions.AssignBinaryExpression;
import com.strobel.expressions.CoalesceConversionBinaryExpression;
import com.strobel.expressions.Error;
import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionType;
import com.strobel.expressions.ExpressionVisitor;
import com.strobel.expressions.LambdaExpression;
import com.strobel.expressions.LogicalBinaryExpression;
import com.strobel.expressions.MemberExpression;
import com.strobel.expressions.MethodBinaryExpression;
import com.strobel.expressions.ParameterExpression;
import com.strobel.expressions.SimpleBinaryExpression;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.Type;
import com.strobel.util.TypeUtils;

public class BinaryExpression
extends Expression {
    private final Expression _left;
    private final Expression _right;

    BinaryExpression(Expression left, Expression right) {
        this._left = left;
        this._right = right;
    }

    public final Expression getRight() {
        return this._right;
    }

    public final Expression getLeft() {
        return this._left;
    }

    public MethodInfo getMethod() {
        return null;
    }

    public LambdaExpression<?> getConversion() {
        return null;
    }

    @Override
    public boolean canReduce() {
        return BinaryExpression.isOpAssignment(this.getNodeType());
    }

    @Override
    protected Expression accept(ExpressionVisitor visitor) {
        return visitor.visitBinary(this);
    }

    @Override
    public Expression reduce() {
        if (BinaryExpression.isOpAssignment(this.getNodeType())) {
            switch (this._left.getNodeType()) {
                case MemberAccess: {
                    return this.reduceMember();
                }
            }
            return this.reduceVariable();
        }
        return this;
    }

    static Expression create(ExpressionType nodeType, Expression left, Expression right, Type type, MethodInfo method, LambdaExpression<?> conversion) {
        if (nodeType == ExpressionType.Assign) {
            assert (method == null && TypeUtils.hasIdentityPrimitiveOrBoxingConversion((Type)type, left.getType()));
            return new AssignBinaryExpression(left, right);
        }
        if (conversion != null) {
            assert (method == null && TypeUtils.hasIdentityPrimitiveOrBoxingConversion((Type)type, right.getType()) && nodeType == ExpressionType.Coalesce);
            return new CoalesceConversionBinaryExpression(left, right, conversion);
        }
        if (method != null) {
            return new MethodBinaryExpression(nodeType, left, right, type, method);
        }
        if (TypeUtils.hasIdentityPrimitiveOrBoxingConversion((Type)type, (Type)PrimitiveTypes.Boolean)) {
            return new LogicalBinaryExpression(nodeType, left, right);
        }
        return new SimpleBinaryExpression(nodeType, left, right, type);
    }

    public BinaryExpression update(Expression left, LambdaExpression<?> conversion, Expression right) {
        if (left == this.getLeft() && right == this.getRight() && conversion == this.getConversion()) {
            return this;
        }
        if (this.isReferenceComparison()) {
            if (this.getNodeType() == ExpressionType.Equal) {
                return Expression.referenceEqual(left, right);
            }
            return Expression.referenceNotEqual(left, right);
        }
        return Expression.makeBinary(this.getNodeType(), left, right, this.getMethod(), conversion);
    }

    boolean isReferenceComparison() {
        Type<?> left = this._left.getType();
        Type<?> right = this._right.getType();
        MethodInfo method = this.getMethod();
        ExpressionType kind = this.getNodeType();
        return (kind == ExpressionType.Equal || kind == ExpressionType.NotEqual) && method == null && !left.isPrimitive() && !right.isPrimitive();
    }

    private Expression reduceVariable() {
        ExpressionType op = BinaryExpression.getBinaryOpFromAssignmentOp(this.getNodeType());
        Expression r = Expression.makeBinary(op, this._left, this._right, this.getMethod());
        LambdaExpression<?> conversion = this.getConversion();
        if (conversion != null) {
            r = Expression.invoke(conversion, r);
        }
        return Expression.assign(this._left, r);
    }

    private Expression reduceMember() {
        MemberExpression member = (MemberExpression)this._left;
        if (member.getTarget() == null) {
            return this.reduceVariable();
        }
        ParameterExpression temp1 = BinaryExpression.variable(member.getTarget().getType(), "temp1");
        BinaryExpression temp1EqualsLeft = Expression.assign(temp1, member.getTarget());
        ExpressionType op = BinaryExpression.getBinaryOpFromAssignmentOp(this.getNodeType());
        Expression temp2EqualsTemp1Member = Expression.makeBinary(op, (Expression)Expression.makeMemberAccess(temp1, member.getMember()), this._right, this.getMethod());
        LambdaExpression<?> conversion = this.getConversion();
        if (conversion != null) {
            temp2EqualsTemp1Member = Expression.invoke(conversion, temp2EqualsTemp1Member);
        }
        ParameterExpression temp2 = BinaryExpression.variable(temp2EqualsTemp1Member.getType(), "temp2");
        temp2EqualsTemp1Member = Expression.assign(temp2, temp2EqualsTemp1Member);
        BinaryExpression temp1MemberEqualsTemp2 = Expression.assign(Expression.makeMemberAccess(temp1, member.getMember()), temp2);
        return Expression.block(new ParameterExpression[]{temp1, temp2}, new Expression[]{temp1EqualsLeft, temp2EqualsTemp1Member, temp1MemberEqualsTemp2, temp2});
    }

    private static boolean isOpAssignment(ExpressionType operation) {
        switch (operation) {
            case AddAssign: 
            case SubtractAssign: 
            case MultiplyAssign: 
            case DivideAssign: 
            case ModuloAssign: 
            case AndAssign: 
            case OrAssign: 
            case RightShiftAssign: 
            case LeftShiftAssign: 
            case ExclusiveOrAssign: {
                return true;
            }
        }
        return false;
    }

    private static ExpressionType getBinaryOpFromAssignmentOp(ExpressionType operator) {
        assert (BinaryExpression.isOpAssignment(operator));
        switch (operator) {
            case AddAssign: {
                return ExpressionType.Add;
            }
            case SubtractAssign: {
                return ExpressionType.Subtract;
            }
            case MultiplyAssign: {
                return ExpressionType.Multiply;
            }
            case DivideAssign: {
                return ExpressionType.Divide;
            }
            case ModuloAssign: {
                return ExpressionType.Modulo;
            }
            case AndAssign: {
                return ExpressionType.And;
            }
            case OrAssign: {
                return ExpressionType.Or;
            }
            case RightShiftAssign: {
                return ExpressionType.RightShift;
            }
            case LeftShiftAssign: {
                return ExpressionType.LeftShift;
            }
            case ExclusiveOrAssign: {
                return ExpressionType.ExclusiveOr;
            }
        }
        throw Error.invalidOperator(operator);
    }
}

