/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.compilerservices.Closure;
import com.strobel.core.IStrongBox;
import com.strobel.core.MutableInteger;
import com.strobel.core.VerifyArgument;
import com.strobel.expressions.BlockExpression;
import com.strobel.expressions.CatchBlock;
import com.strobel.expressions.Error;
import com.strobel.expressions.ExpressionList;
import com.strobel.expressions.HoistedLocals;
import com.strobel.expressions.LambdaCompiler;
import com.strobel.expressions.LambdaExpression;
import com.strobel.expressions.ParameterExpression;
import com.strobel.expressions.ParameterExpressionList;
import com.strobel.expressions.RuntimeOperations;
import com.strobel.expressions.VariableStorageKind;
import com.strobel.reflection.ConstructorInfo;
import com.strobel.reflection.FieldInfo;
import com.strobel.reflection.Type;
import com.strobel.reflection.Types;
import com.strobel.reflection.emit.LocalBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

final class CompilerScope {
    private static final FieldInfo ClosureLocalsField = Type.of(Closure.class).getField("locals");
    private final Map<ParameterExpression, Storage> _locals = new LinkedHashMap<ParameterExpression, Storage>();
    private HoistedLocals _hoistedLocals;
    private HoistedLocals _closureHoistedLocals;
    private CompilerScope _parent;
    final Object node;
    final boolean isMethod;
    boolean needsClosure;
    final Map<ParameterExpression, VariableStorageKind> definitions;
    Map<ParameterExpression, MutableInteger> referenceCount;
    Set<Object> mergedScopes;

    CompilerScope(Object node, boolean isMethod) {
        this.node = node;
        this.isMethod = isMethod;
        ParameterExpressionList variables = CompilerScope.getVariables(node);
        this.definitions = new LinkedHashMap<ParameterExpression, VariableStorageKind>(variables.size());
        for (ParameterExpression v : variables) {
            this.definitions.put(v, VariableStorageKind.Local);
        }
    }

    CompilerScope enter(LambdaCompiler lc, CompilerScope parent) {
        this.setParent(lc, parent);
        this.allocateLocals(lc);
        if (this.isMethod && this._closureHoistedLocals != null) {
            this.emitClosureAccess(lc, this._closureHoistedLocals);
        }
        this.emitNewHoistedLocals(lc);
        if (this.isMethod) {
            this.emitCachedVariables();
        }
        return this;
    }

    CompilerScope exit() {
        if (!this.isMethod) {
            for (Storage storage : this._locals.values()) {
                storage.freeLocal();
            }
        }
        CompilerScope parent = this._parent;
        this._parent = null;
        this._hoistedLocals = null;
        this._closureHoistedLocals = null;
        this._locals.clear();
        return parent;
    }

    HoistedLocals getNearestHoistedLocals() {
        return this._hoistedLocals != null ? this._hoistedLocals : this._closureHoistedLocals;
    }

    private String getCurrentLambdaName() {
        CompilerScope s = this;
        while (s != null) {
            if (s.node instanceof LambdaExpression) {
                return ((LambdaExpression)s.node).getName();
            }
            s = s._parent;
        }
        return null;
    }

    private void emitNewHoistedLocals(LambdaCompiler lc) {
        if (this._hoistedLocals == null) {
            return;
        }
        lc.generator.emitInteger(this._hoistedLocals.variables.size());
        lc.generator.emitNewArray(Types.Object.makeArrayType());
        int i = 0;
        for (ParameterExpression v : this._hoistedLocals.variables) {
            lc.generator.dup();
            lc.generator.emitInteger(i++);
            Type<? extends IStrongBox> boxType = CompilerScope.getBoxType(v.getType());
            ConstructorInfo constructor = boxType.getConstructor(new Type[]{v.getType()});
            if (this.isMethod && lc.getParameters().contains(v)) {
                int index = lc.getParameters().indexOf(v);
                lc.generator.emitNew(boxType);
                lc.generator.dup();
                lc.emitLambdaArgument(index);
                lc.generator.call(constructor);
            } else if (v == this._hoistedLocals.getParentVariable()) {
                lc.generator.emitNew(boxType);
                lc.generator.dup();
                this.resolveVariable(v, this._closureHoistedLocals).emitLoad();
                lc.generator.call(constructor);
            } else {
                lc.generator.emitNew(boxType);
                lc.generator.dup();
                lc.generator.call(boxType.getConstructor(new Type[0]));
            }
            if (this.shouldCache(v)) {
                lc.generator.dup();
                this.cacheBoxToLocal(lc, v);
            }
            lc.generator.emitStoreElement(Types.Object);
        }
        this.emitSet(this._hoistedLocals.selfVariable);
    }

    private static Type<? extends IStrongBox> getBoxType(Type<?> type) {
        switch (((Type)VerifyArgument.notNull(type, (String)"type")).getKind()) {
            case BOOLEAN: {
                return Types.BooleanBox;
            }
            case BYTE: {
                return Types.ByteBox;
            }
            case SHORT: {
                return Types.ShortBox;
            }
            case INT: {
                return Types.IntegerBox;
            }
            case LONG: {
                return Types.LongBox;
            }
            case CHAR: {
                return Types.CharacterBox;
            }
            case FLOAT: {
                return Types.FloatBox;
            }
            case DOUBLE: {
                return Types.DoubleBox;
            }
        }
        return Types.StrongBox.makeGenericType(new Type[]{Types.Object});
    }

    private void emitCachedVariables() {
        if (this.referenceCount == null) {
            return;
        }
        for (ParameterExpression p : this.referenceCount.keySet()) {
            Storage storage;
            if (!this.shouldCache(p) || !((storage = this.resolveVariable(p)) instanceof ElementBoxStorage)) continue;
            ((ElementBoxStorage)storage).emitLoadBox();
            this.cacheBoxToLocal(storage.compiler, p);
        }
    }

    private boolean shouldCache(ParameterExpression v, int refCount) {
        return refCount > 2 && !this._locals.containsKey(v);
    }

    private boolean shouldCache(ParameterExpression v) {
        if (this.referenceCount == null) {
            return false;
        }
        MutableInteger refCount = this.referenceCount.get(v);
        return refCount != null && this.shouldCache(v, refCount.getValue());
    }

    private void cacheBoxToLocal(LambdaCompiler lc, ParameterExpression v) {
        assert (this.shouldCache(v) && !this._locals.containsKey(v)) : "shouldCache(v) && !_locals.containsKey(v)";
        LocalBoxStorage local = new LocalBoxStorage(lc, v);
        local.emitStoreBox();
        this._locals.put(v, local);
    }

    private void emitClosureAccess(LambdaCompiler lc, HoistedLocals locals) {
        if (locals == null) {
            return;
        }
        this.emitClosureToVariable(lc, locals);
        while ((locals = locals.parent) != null) {
            ParameterExpression v = locals.selfVariable;
            LocalStorage local = new LocalStorage(lc, v);
            local.emitStore(this.resolveVariable(v));
            this._locals.put(v, local);
        }
    }

    private void emitClosureToVariable(LambdaCompiler lc, HoistedLocals locals) {
        lc.emitClosureArgument();
        lc.generator.getField(ClosureLocalsField);
        this.addLocal(lc, locals.selfVariable);
        this.emitSet(locals.selfVariable);
    }

    private Storage resolveVariable(ParameterExpression variable) {
        return this.resolveVariable(variable, this.getNearestHoistedLocals());
    }

    private Storage resolveVariable(ParameterExpression variable, HoistedLocals hoistedLocals) {
        CompilerScope s = this;
        while (s != null) {
            Storage storage = s._locals.get(variable);
            if (storage != null) {
                return storage;
            }
            if (s.isMethod) break;
            s = s._parent;
        }
        HoistedLocals h = hoistedLocals;
        while (h != null) {
            Integer index = h.indexes.get(variable);
            if (index != null) {
                return new ElementBoxStorage(this.resolveVariable(h.selfVariable, hoistedLocals), index, variable);
            }
            h = h.parent;
        }
        throw Error.undefinedVariable(variable.getName(), variable.getType(), this.getCurrentLambdaName());
    }

    LocalBuilder getLocalForVariable(ParameterExpression variable) {
        Storage storage = this.resolveVariable(variable);
        if (storage instanceof LocalStorage) {
            return ((LocalStorage)storage)._local;
        }
        return null;
    }

    void emitGet(ParameterExpression variable) {
        this.resolveVariable(variable).emitLoad();
    }

    void emitSet(ParameterExpression variable) {
        this.resolveVariable(variable).emitStore();
    }

    private void setParent(LambdaCompiler lc, CompilerScope parent) {
        assert (this._parent == null && parent != this) : "_parent == null && parent != this";
        this._parent = parent;
        if (this.needsClosure && this._parent != null) {
            this._closureHoistedLocals = this._parent.getNearestHoistedLocals();
        }
        ArrayList<ParameterExpression> hoistedVariables = null;
        for (ParameterExpression p : this.getVariables()) {
            if (this.definitions.get(p) != VariableStorageKind.Hoisted) continue;
            if (hoistedVariables == null) {
                hoistedVariables = new ArrayList<ParameterExpression>();
            }
            hoistedVariables.add(p);
        }
        if (hoistedVariables != null) {
            this._hoistedLocals = new HoistedLocals(this._closureHoistedLocals, hoistedVariables.toArray(new ParameterExpression[hoistedVariables.size()]));
            this.addLocal(lc, this._hoistedLocals.selfVariable);
        }
    }

    void addLocal(LambdaCompiler lc, ParameterExpression variable) {
        this._locals.put(variable, new LocalStorage(lc, variable));
    }

    private void allocateLocals(LambdaCompiler lc) {
        for (ParameterExpression v : this.getVariables()) {
            if (this.definitions.get(v) != VariableStorageKind.Local) continue;
            Storage s = this.isMethod && lc.lambda.getParameters().contains(v) ? new ArgumentStorage(lc, v) : new LocalStorage(lc, v);
            this._locals.put(v, s);
        }
    }

    private ParameterExpressionList getVariables() {
        ExpressionList variables = CompilerScope.getVariables(this.node);
        if (this.mergedScopes == null) {
            return variables;
        }
        for (Object scope : this.mergedScopes) {
            variables = variables.addAll(variables.size(), (ExpressionList)CompilerScope.getVariables(scope));
        }
        return variables;
    }

    private static ParameterExpressionList getVariables(Object scope) {
        if (scope instanceof LambdaExpression) {
            return ((LambdaExpression)scope).getParameters();
        }
        if (scope instanceof BlockExpression) {
            return ((BlockExpression)scope).getVariables();
        }
        return new ParameterExpressionList(((CatchBlock)scope).getVariable());
    }

    void emitVariableAccess(LambdaCompiler lc, ParameterExpressionList vars) {
        if (this.getNearestHoistedLocals() != null) {
            long[] indexes = new long[vars.size()];
            int count = 0;
            for (ParameterExpression variable : vars) {
                long parents = 0L;
                HoistedLocals locals = this.getNearestHoistedLocals();
                while (!locals.indexes.containsKey(variable)) {
                    ++parents;
                    locals = locals.parent;
                    assert (locals != null);
                }
                long index = parents << 32 | (long)locals.indexes.get(variable).intValue();
                indexes[count++] = index;
            }
            if (count > 0) {
                this.emitGet(this.getNearestHoistedLocals().selfVariable);
                lc.emitConstantArray(Arrays.copyOf(indexes, count));
                lc.generator.call(Type.of(RuntimeOperations.class).getMethod("createRuntimeVariables", new Type[]{Type.of(Object[].class), Type.of(long[].class)}));
                return;
            }
        }
        lc.generator.call(Type.of(RuntimeOperations.class).getMethod("createRuntimeVariables", Type.EmptyTypes));
    }

    private final class LocalBoxStorage
    extends Storage {
        private final LocalBuilder _boxLocal;
        private final Type<?> _boxType;
        private final FieldInfo _boxValueField;

        private LocalBoxStorage(LambdaCompiler compiler, ParameterExpression variable) {
            super(compiler, variable);
            this._boxType = CompilerScope.getBoxType(variable.getType());
            this._boxValueField = this._boxType.getField("value");
            this._boxLocal = compiler.getNamedLocal(this._boxType, variable);
        }

        void emitStoreBox() {
            this.compiler.generator.emitStore(this._boxLocal);
        }

        @Override
        void emitStore(Storage value) {
            this.compiler.generator.emitLoad(this._boxLocal);
            value.emitLoad();
            this.compiler.generator.putField(this._boxValueField);
        }

        @Override
        void emitStore() {
            LocalBuilder value = this.compiler.getLocal(this.variable.getType());
            this.compiler.generator.emitStore(value);
            this.compiler.generator.emitLoad(this._boxLocal);
            this.compiler.generator.emitLoad(value);
            this.compiler.freeLocal(value);
            this.compiler.generator.putField(this._boxValueField);
        }

        @Override
        void emitLoad() {
            this.compiler.generator.emitLoad(this._boxLocal);
            this.compiler.generator.getField(this._boxValueField);
            this.compiler.generator.emitConversion(this._boxValueField.getFieldType(), this.variable.getType());
        }
    }

    private final class ElementBoxStorage
    extends Storage {
        private final int _index;
        private final Storage _array;
        private final Type<?> _boxType;
        private final FieldInfo _boxValueField;

        private ElementBoxStorage(Storage array, int index, ParameterExpression variable) {
            super(array.compiler, variable);
            this._array = array;
            this._index = index;
            this._boxType = CompilerScope.getBoxType(variable.getType());
            this._boxValueField = this._boxType.getField("value");
        }

        void emitLoadBox() {
            this._array.emitLoad();
            this.compiler.generator.emitInteger(this._index);
            this.compiler.generator.emitLoadElement(Types.Object);
            this.compiler.generator.emitConversion(Types.Object, this._boxType);
        }

        @Override
        void emitStore(Storage value) {
            this.emitLoadBox();
            value.emitLoad();
            this.compiler.generator.putField(this._boxValueField);
        }

        @Override
        void emitStore() {
            LocalBuilder value = this.compiler.getLocal(this.variable.getType());
            this.compiler.generator.emitStore(value);
            this.emitLoadBox();
            this.compiler.generator.emitLoad(value);
            this.compiler.freeLocal(value);
            this.compiler.generator.putField(this._boxValueField);
        }

        @Override
        void emitLoad() {
            this.emitLoadBox();
            this.compiler.generator.getField(this._boxValueField);
            this.compiler.generator.emitConversion(this._boxValueField.getFieldType(), this.variable.getType());
        }
    }

    private final class ArgumentStorage
    extends Storage {
        private final int _argument;

        private ArgumentStorage(LambdaCompiler compiler, ParameterExpression p) {
            super(compiler, p);
            this._argument = compiler.getLambdaArgument(compiler.lambda.getParameters().indexOf(p));
        }

        @Override
        void emitStore() {
            this.compiler.generator.emitStoreArgument(this._argument);
        }

        @Override
        void emitLoad() {
            this.compiler.generator.emitLoadArgument(this._argument);
        }
    }

    private final class LocalStorage
    extends Storage {
        private final LocalBuilder _local;
        private final boolean _named;

        private LocalStorage(LambdaCompiler compiler, ParameterExpression variable) {
            super(compiler, variable);
            this._named = variable.getName() != null;
            this._local = this._named ? compiler.getNamedLocal(variable.getType(), variable) : compiler.getLocal(variable.getType());
        }

        @Override
        void emitStore() {
            this.compiler.generator.emitStore(this._local);
        }

        @Override
        void freeLocal() {
            if (!this._named) {
                this.compiler.freeLocal(this._local);
            }
        }

        @Override
        void emitLoad() {
            this.compiler.generator.emitLoad(this._local);
            this.compiler.generator.emitConversion(this._local.getLocalType(), this.variable.getType());
        }
    }

    private static abstract class Storage {
        final LambdaCompiler compiler;
        final ParameterExpression variable;

        protected Storage(LambdaCompiler compiler, ParameterExpression variable) {
            this.compiler = compiler;
            this.variable = variable;
        }

        abstract void emitLoad();

        abstract void emitStore();

        void emitStore(Storage value) {
            value.emitLoad();
            this.emitStore();
        }

        void freeLocal() {
        }
    }
}

