/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionType;
import com.strobel.expressions.ExpressionVisitor;
import com.strobel.expressions.LabelTarget;
import com.strobel.expressions.ParameterExpression;
import com.strobel.expressions.ParameterExpressionList;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.Type;
import com.strobel.reflection.Types;

public final class ForEachExpression
extends Expression {
    private final ParameterExpression _variable;
    private final Expression _sequence;
    private final Expression _body;
    private final LabelTarget _breakTarget;
    private final LabelTarget _continueTarget;

    ForEachExpression(ParameterExpression variable, Expression sequence, Expression body, LabelTarget breakTarget, LabelTarget continueTarget) {
        this._variable = variable;
        this._sequence = sequence;
        this._body = body;
        this._breakTarget = breakTarget;
        this._continueTarget = continueTarget;
    }

    public ParameterExpression getVariable() {
        return this._variable;
    }

    public Expression getSequence() {
        return this._sequence;
    }

    public Expression getBody() {
        return this._body;
    }

    public LabelTarget getBreakTarget() {
        return this._breakTarget;
    }

    public LabelTarget getContinueTarget() {
        return this._continueTarget;
    }

    @Override
    public ExpressionType getNodeType() {
        return ExpressionType.Extension;
    }

    @Override
    public Type<?> getType() {
        if (this._breakTarget != null) {
            return this._breakTarget.getType();
        }
        return PrimitiveTypes.Void;
    }

    @Override
    public boolean canReduce() {
        return true;
    }

    public ForEachExpression update(ParameterExpression variable, Expression sequence, Expression body, LabelTarget breakTarget, LabelTarget continueTarget) {
        if (variable == this._variable && sequence == this._sequence && body == this._body && breakTarget == this._breakTarget && continueTarget == this._continueTarget) {
            return this;
        }
        return ForEachExpression.forEach(variable, sequence, body, breakTarget, continueTarget);
    }

    @Override
    protected Expression accept(ExpressionVisitor visitor) {
        return visitor.visitForEach(this);
    }

    @Override
    protected Expression visitChildren(ExpressionVisitor visitor) {
        return this.update((ParameterExpression)visitor.visit(this._variable), visitor.visit(this._sequence), visitor.visit(this._body), visitor.visitLabelTarget(this._breakTarget), visitor.visitLabelTarget(this._continueTarget));
    }

    @Override
    public Expression reduce() {
        if (this._sequence.getType().isArray()) {
            return this.reduceForArray();
        }
        return this.reduceForIterable();
    }

    private Expression reduceForArray() {
        ParameterExpression array = ForEachExpression.variable(this._sequence.getType(), "$array");
        ParameterExpression index = ForEachExpression.variable(PrimitiveTypes.Integer, "$i");
        ParameterExpression length = ForEachExpression.variable(PrimitiveTypes.Integer, "$length");
        ParameterExpressionList variables = new ParameterExpressionList(array, index, length);
        LabelTarget breakTarget = this._breakTarget != null ? this._breakTarget : ForEachExpression.label();
        LabelTarget continueTarget = this._continueTarget != null ? this._continueTarget : ForEachExpression.label("update");
        return ForEachExpression.block(variables, ForEachExpression.assign(array, this._sequence), ForEachExpression.assign(length, ForEachExpression.arrayLength(array)), ForEachExpression.assign(index, ForEachExpression.constant(0)), ForEachExpression.loop(ForEachExpression.block(new ParameterExpressionList(this._variable), ForEachExpression.ifThen(ForEachExpression.not(ForEachExpression.lessThan(index, length)), ForEachExpression.makeBreak(breakTarget)), ForEachExpression.assign(this._variable, ForEachExpression.convert(ForEachExpression.arrayIndex(array, index), this._variable.getType())), this._body, ForEachExpression.label(continueTarget), ForEachExpression.preIncrementAssign(index))), ForEachExpression.label(breakTarget));
    }

    private Expression reduceForIterable() {
        Type iteratorType;
        Type iterableType;
        Type<?> argument = this.tryGetGenericEnumerableArgument();
        if (argument == null) {
            iterableType = Types.Iterable.getErasedType();
            iteratorType = Types.Iterator.getErasedType();
        } else {
            iterableType = Types.Iterable.makeGenericType(new Type[]{argument});
            iteratorType = Types.Iterator.makeGenericType(new Type[]{argument});
        }
        ParameterExpression iterator = ForEachExpression.variable(iteratorType, "iterator");
        LabelTarget innerContinueTarget = ForEachExpression.label();
        LabelTarget innerBreakTarget = ForEachExpression.label();
        LabelTarget breakTarget = this._breakTarget != null ? this._breakTarget : ForEachExpression.label();
        LabelTarget continueTarget = this._continueTarget != null ? this._continueTarget : ForEachExpression.label("update");
        return ForEachExpression.block(new ParameterExpressionList(iterator), ForEachExpression.assign(iterator, ForEachExpression.call((Expression)ForEachExpression.convert(this._sequence, iterableType), iterableType.getMethod("iterator", new Type[0]), new Expression[0])), ForEachExpression.block(new ParameterExpressionList(this._variable), ForEachExpression.makeGoto(continueTarget), ForEachExpression.loop(ForEachExpression.block((Expression)ForEachExpression.assign(this._variable, ForEachExpression.convert(ForEachExpression.call((Expression)iterator, iteratorType.getMethod("next", new Type[0]), new Expression[0]), this._variable.getType())), this._body, (Expression)ForEachExpression.label(continueTarget), (Expression)ForEachExpression.condition(ForEachExpression.call((Expression)iterator, iteratorType.getMethod("hasNext", new Type[0]), new Expression[0]), ForEachExpression.makeContinue(innerContinueTarget), ForEachExpression.makeBreak(innerBreakTarget))), innerBreakTarget, innerContinueTarget), ForEachExpression.label(breakTarget)));
    }

    private Type<?> tryGetGenericEnumerableArgument() {
        for (Type ifType : this._sequence.getType().getInterfaces()) {
            if (!ifType.isGenericType() || ifType.getGenericTypeDefinition() != Types.Iterable) continue;
            Type typeArgument = (Type)ifType.getTypeArguments().get(0);
            if (!this._variable.getType().isAssignableFrom(typeArgument)) continue;
            return typeArgument;
        }
        return null;
    }
}

