/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.core.VerifyArgument;
import com.strobel.reflection.ICapturedType;
import com.strobel.reflection.MemberType;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeVisitor;
import com.strobel.reflection.Types;
import javax.lang.model.type.TypeKind;

final class CapturedType<T>
extends Type<T>
implements ICapturedType {
    static final String CapturedName = "<captured wildcard>";
    private final Type<?> _wildcard;
    private final Type<?> _declaringType;
    private final Type<?> _upperBound;
    private final Type<?> _lowerBound;

    CapturedType(Type<?> declaringType, Type<?> upperBound, Type<?> lowerBound, Type<?> wildcard) {
        if (!wildcard.isWildcardType()) {
            throw new IllegalArgumentException("Argument 'wildcard' must be a wildcard type.");
        }
        this._wildcard = (Type)VerifyArgument.notNull(wildcard, (String)"wildcard");
        this._upperBound = upperBound != null ? upperBound : Types.Object;
        this._lowerBound = lowerBound != null ? lowerBound : Type.Bottom;
        this._declaringType = declaringType;
    }

    @Override
    public StringBuilder appendDescription(StringBuilder sb) {
        return sb.append(CapturedName);
    }

    @Override
    public StringBuilder appendBriefDescription(StringBuilder sb) {
        return sb.append(CapturedName);
    }

    @Override
    public StringBuilder appendSimpleDescription(StringBuilder sb) {
        return sb.append(CapturedName);
    }

    @Override
    public Type<?> getExtendsBound() {
        return this._upperBound;
    }

    @Override
    public Type<?> getSuperBound() {
        return this._lowerBound;
    }

    @Override
    public Class<T> getErasedClass() {
        return this.resolveErasedClass();
    }

    @Override
    public Type<?> getWildcard() {
        return this._wildcard;
    }

    @Override
    public MemberType getMemberType() {
        return MemberType.TypeInfo;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.WILDCARD;
    }

    @Override
    public <P, R> R accept(TypeVisitor<P, R> visitor, P parameter) {
        return visitor.visitCapturedType(this, parameter);
    }

    @Override
    public boolean isWildcardType() {
        return true;
    }

    @Override
    public Type getDeclaringType() {
        return this._declaringType;
    }

    @Override
    public int getModifiers() {
        return this._wildcard.getModifiers();
    }

    private Class<?> resolveErasedClass() {
        if (this._upperBound != Types.Object) {
            return this._upperBound.getErasedClass();
        }
        return Object.class;
    }
}

