/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.core.ArrayUtilities;
import com.strobel.core.Comparer;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.ConstructorList;
import com.strobel.reflection.Error;
import com.strobel.reflection.FieldList;
import com.strobel.reflection.GenericParameter;
import com.strobel.reflection.MemberType;
import com.strobel.reflection.MethodBase;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.MethodList;
import com.strobel.reflection.ReflectedConstructor;
import com.strobel.reflection.ReflectedField;
import com.strobel.reflection.ReflectedMethod;
import com.strobel.reflection.SimpleVisitor;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeBindings;
import com.strobel.reflection.TypeList;
import com.strobel.reflection.TypeVisitor;
import com.strobel.util.ContractUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

class ReflectedType<T>
extends Type<T> {
    private static final AtomicIntegerFieldUpdater<ReflectedType> FLAGS_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ReflectedType.class, "_flags");
    private static final byte FLAG_METHODS_RESOLVED = 1;
    private static final byte FLAG_FIELDS_RESOLVED = 2;
    private static final byte FLAG_CONSTRUCTORS_RESOLVED = 4;
    private static final byte FLAG_NESTED_TYPES_RESOLVED = 8;
    private static final byte FLAG_ALL_MEMBERS_RESOLVED = 15;
    private static final byte FLAG_RESOLVING_MEMBERS = 16;
    private final String _name;
    private final String _simpleName;
    private final Class<T> _rawClass;
    private Type<? super T> _baseType;
    private TypeList _interfaces;
    private volatile int _flags;
    private boolean _completed;
    private Type<?> _declaringType;
    private MethodBase _declaringMethod;
    private List<GenericParameter<?>> _genericParameters = null;
    private List<ReflectedType<?>> _nestedTypes = null;
    private List<ReflectedMethod> _methods = null;
    private List<ReflectedField> _fields = null;
    private List<ReflectedConstructor> _constructors = null;
    private TypeBindings _typeBindings;
    private static final SimpleVisitor<java.lang.reflect.Type, GenericParameter> GenericParameterFinder = new SimpleVisitor<java.lang.reflect.Type, GenericParameter>(){

        public GenericParameter visit(TypeList types, java.lang.reflect.Type s) {
            Iterator iterator = types.iterator();
            while (iterator.hasNext()) {
                Type type = (Type)iterator.next();
                GenericParameter result = (GenericParameter)this.visit(type, s);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        public GenericParameter visitCapturedType(Type<?> t, java.lang.reflect.Type s) {
            return null;
        }

        @Override
        public GenericParameter visitClassType(Type<?> type, java.lang.reflect.Type parameter) {
            Type declaringType;
            ReflectedType reflectedType;
            GenericParameter result;
            if (type.isGenericType() && (result = this.visit(type.getGenericTypeParameters(), parameter)) != null) {
                return result;
            }
            if (type instanceof ReflectedType && (reflectedType = (ReflectedType)type)._methods != null) {
                for (Object o : reflectedType._methods) {
                    ReflectedMethod method = (ReflectedMethod)o;
                    if (!method.isGenericMethod() || (result = this.visit(method.getGenericMethodParameters(), parameter)) == null) continue;
                    return result;
                }
            }
            if ((declaringType = type.getDeclaringType()) != null && declaringType != Type.NullType) {
                return this.visitClassType(declaringType, parameter);
            }
            return null;
        }

        @Override
        public GenericParameter visitPrimitiveType(Type<?> type, java.lang.reflect.Type parameter) {
            return (GenericParameter)super.visitPrimitiveType(type, parameter);
        }

        @Override
        public GenericParameter visitTypeParameter(Type<?> type, java.lang.reflect.Type parameter) {
            if (parameter instanceof TypeVariable) {
                return this.visitTypeParameter(type, (TypeVariable)parameter);
            }
            return null;
        }

        @Override
        public GenericParameter visitTypeParameter(Type<?> type, TypeVariable typeVariable) {
            if (!(type instanceof GenericParameter)) {
                return null;
            }
            GenericParameter genericParameter = (GenericParameter)type;
            int position = ArrayUtilities.indexOf((Object[])typeVariable.getGenericDeclaration().getTypeParameters(), (Object)typeVariable);
            if (position != genericParameter.getGenericParameterPosition()) {
                return null;
            }
            Type declaringType = genericParameter.getDeclaringType();
            if (declaringType != null && declaringType.getErasedClass() == typeVariable.getGenericDeclaration()) {
                return genericParameter;
            }
            MethodInfo method = genericParameter.getDeclaringMethod();
            if (method != null && method.getRawMethod() == typeVariable.getGenericDeclaration()) {
                return genericParameter;
            }
            return null;
        }

        @Override
        public GenericParameter visitWildcardType(Type<?> type, java.lang.reflect.Type parameter) {
            return null;
        }

        @Override
        public GenericParameter visitArrayType(Type<?> type, java.lang.reflect.Type parameter) {
            return null;
        }
    };

    ReflectedType(Class<T> rawClass) {
        this._rawClass = (Class)VerifyArgument.notNull(rawClass, (String)"rawClass");
        this._name = rawClass.isLocalClass() ? rawClass.getName() : rawClass.getCanonicalName();
        this._simpleName = rawClass.getSimpleName();
    }

    @Override
    public String getFullName() {
        return this._name;
    }

    private boolean checkFlags(int flags) {
        return (this._flags & flags) == flags;
    }

    private void setFlags(int flags) {
        int oldFlags;
        while (!FLAGS_UPDATER.compareAndSet(this, oldFlags = this._flags, oldFlags | flags)) {
        }
    }

    private void clearFlags(int flags) {
        int oldFlags;
        while (!FLAGS_UPDATER.compareAndSet(this, oldFlags = this._flags, oldFlags & ~flags)) {
        }
    }

    void setBaseType(Type<?> baseType) {
        this._baseType = baseType;
    }

    void setInterfaces(TypeList interfaces) {
        this._interfaces = (TypeList)((Object)VerifyArgument.notNull((Object)((Object)interfaces), (String)"interfaces"));
    }

    List<GenericParameter<?>> getGenericParameters() {
        if (this._genericParameters == null) {
            return Collections.emptyList();
        }
        return this._genericParameters;
    }

    ReflectedField findField(Field rawField) {
        if (this._fields == null) {
            return null;
        }
        for (ReflectedField field : this._fields) {
            if (!Comparer.equals((Object)field.getRawField(), (Object)rawField)) continue;
            return field;
        }
        return null;
    }

    ReflectedMethod findMethod(Method rawMethod) {
        if (this._methods == null) {
            return null;
        }
        for (ReflectedMethod method : this._methods) {
            if (!Comparer.equals((Object)method.getRawMethod(), (Object)rawMethod)) continue;
            return method;
        }
        return null;
    }

    ReflectedConstructor findConstructor(Constructor rawConstructor) {
        if (this._constructors == null) {
            return null;
        }
        for (ReflectedConstructor constructor : this._constructors) {
            if (!Comparer.equals(constructor.getRawConstructor(), (Object)rawConstructor)) continue;
            return constructor;
        }
        return null;
    }

    ReflectedType<?> findNestedType(Class<?> rawClass) {
        if (this._nestedTypes == null) {
            return null;
        }
        for (ReflectedType<?> nestedType : this._nestedTypes) {
            if (!Comparer.equals(nestedType.getErasedClass(), rawClass)) continue;
            return nestedType;
        }
        return null;
    }

    GenericParameter findGenericParameter(TypeVariable typeVariable) {
        return (GenericParameter)GenericParameterFinder.visit(this, typeVariable);
    }

    void setDeclaringType(Type<?> declaringType) {
        this._declaringType = (Type)VerifyArgument.notNull(declaringType, (String)"declaringType");
    }

    void setDeclaringMethod(MethodBase declaringMethod) {
        this._declaringMethod = (MethodBase)VerifyArgument.notNull((Object)declaringMethod, (String)"declaringMethod");
    }

    void addGenericParameter(GenericParameter genericParameter) {
        VerifyArgument.notNull((Object)genericParameter, (String)"typeParameter");
        this._completed = false;
        if (this._genericParameters == null) {
            this._genericParameters = new ArrayList();
        }
        this._genericParameters.add(genericParameter);
    }

    void addNestedType(ReflectedType<?> nestedType) {
        VerifyArgument.notNull(nestedType, (String)"nestedType");
        if (this._nestedTypes == null) {
            this._nestedTypes = new ArrayList();
        }
        this._nestedTypes.add(nestedType);
        if (!this.checkFlags(16)) {
            this.clearFlags(8);
        }
    }

    void addMethod(ReflectedMethod method) {
        VerifyArgument.notNull((Object)method, (String)"method");
        if (this._methods == null) {
            this._methods = new ArrayList<ReflectedMethod>();
        }
        this._methods.add(method);
        if (!this.checkFlags(16)) {
            this.clearFlags(1);
        }
    }

    void addConstructor(ReflectedConstructor constructor) {
        VerifyArgument.notNull((Object)constructor, (String)"constructor");
        if (this._constructors == null) {
            this._constructors = new ArrayList<ReflectedConstructor>();
        }
        this._constructors.add(constructor);
        if (!this.checkFlags(16)) {
            this.clearFlags(4);
        }
    }

    void addField(ReflectedField field) {
        VerifyArgument.notNull((Object)field, (String)"field");
        if (this._fields == null) {
            this._fields = new ArrayList<ReflectedField>();
        }
        this._fields.add(field);
        if (!this.checkFlags(16)) {
            this.clearFlags(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeIfNecessary() {
        if (!this._completed) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (!this._completed) {
                    this.complete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureMembersResolved() {
        while (!this.checkFlags(15)) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (!this.checkFlags(15)) {
                    this.setFlags(16);
                    int oldFlags = this._flags;
                    RESOLVER.resolveMembers(this, oldFlags ^ 0xF);
                    if (this._nestedTypes != null) {
                        for (ReflectedType<?> nestedType : this._nestedTypes) {
                            nestedType.complete();
                        }
                    }
                    if (FLAGS_UPDATER.compareAndSet(this, oldFlags, 15)) {
                        return;
                    }
                }
            }
        }
        return;
    }

    @Override
    public MethodBase getDeclaringMethod() {
        return this._declaringMethod;
    }

    @Override
    protected ConstructorList getDeclaredConstructors() {
        this.ensureMembersResolved();
        if (this._constructors == null) {
            return ConstructorList.empty();
        }
        return new ConstructorList(this._constructors);
    }

    @Override
    protected MethodList getDeclaredMethods() {
        this.ensureMembersResolved();
        if (this._methods == null) {
            return MethodList.empty();
        }
        return new MethodList(this._methods);
    }

    @Override
    protected FieldList getDeclaredFields() {
        this.ensureMembersResolved();
        if (this._fields == null) {
            return FieldList.empty();
        }
        return new FieldList(this._fields);
    }

    @Override
    protected TypeList getDeclaredTypes() {
        this.ensureMembersResolved();
        if (this._nestedTypes == null) {
            return TypeList.empty();
        }
        return new TypeList(this._nestedTypes);
    }

    void complete() {
        if (this._completed) {
            return;
        }
        this._completed = true;
        this._typeBindings = this._genericParameters == null || this._genericParameters.isEmpty() ? TypeBindings.empty() : TypeBindings.createUnbound(ReflectedType.list(this._genericParameters));
    }

    @Override
    public Type<? super T> getBaseType() {
        return this._baseType;
    }

    @Override
    public TypeList getExplicitInterfaces() {
        if (this._interfaces == null) {
            return TypeList.empty();
        }
        return this._interfaces;
    }

    @Override
    protected TypeBindings getTypeBindings() {
        this.completeIfNecessary();
        return this._typeBindings;
    }

    @Override
    public Type getGenericTypeDefinition() {
        if (!this.isGenericType()) {
            throw Error.notGenericType(this);
        }
        if (!this.getTypeBindings().hasBoundParameters()) {
            return this;
        }
        throw ContractUtils.unreachable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Type makeGenericTypeCore(TypeList typeArguments) {
        Object object = CACHE_LOCK;
        synchronized (object) {
            return CACHE.getGenericType(this.getGenericTypeDefinition(), typeArguments);
        }
    }

    @Override
    public Class<T> getErasedClass() {
        this.completeIfNecessary();
        return this._rawClass;
    }

    @Override
    public MemberType getMemberType() {
        return MemberType.TypeInfo;
    }

    @Override
    public Type getDeclaringType() {
        return this._declaringType;
    }

    @Override
    public int getModifiers() {
        return this._rawClass.getModifiers();
    }

    @Override
    public <P, R> R accept(TypeVisitor<P, R> visitor, P parameter) {
        return visitor.visitClassType(this, parameter);
    }

    @Override
    protected StringBuilder _appendClassName(StringBuilder sb, boolean fullName, boolean dottedName) {
        if (!fullName) {
            return sb.append(this._simpleName);
        }
        if (dottedName) {
            return sb.append(this._name);
        }
        return super._appendClassName(sb, true, false);
    }
}

