/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.core.ArrayUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.BindingFlags;
import com.strobel.reflection.ConstructorInfo;
import com.strobel.reflection.GenericParameter;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.ParameterInfo;
import com.strobel.reflection.ParameterList;
import com.strobel.reflection.ReflectedConstructor;
import com.strobel.reflection.ReflectedField;
import com.strobel.reflection.ReflectedMethod;
import com.strobel.reflection.ReflectedType;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeBindings;
import com.strobel.reflection.Types;
import com.strobel.reflection.WildcardType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

final class Resolver {
    static final byte FLAG_RESOLVE_METHODS = 1;
    static final byte FLAG_RESOLVE_FIELDS = 2;
    static final byte FLAG_RESOLVE_CONSTRUCTORS = 4;
    static final byte FLAG_RESOLVE_NESTED_TYPES = 8;

    Resolver() {
    }

    void resolveMembers(ReflectedType<?> type, int flags) {
        Frame frame = new Frame(type, null);
        this.visit(type, frame, flags);
    }

    public Type<?> resolve(java.lang.reflect.Type type) {
        return this.resolveExisting(null, type, true);
    }

    private Type<?> visit(java.lang.reflect.Type type, Frame frame) {
        if (type instanceof ParameterizedType) {
            return this.visitParameterizedType((ParameterizedType)type, frame);
        }
        if (type instanceof java.lang.reflect.WildcardType) {
            return this.visitWildcardType((java.lang.reflect.WildcardType)type, frame);
        }
        if (type instanceof GenericArrayType) {
            return this.visitGenericArrayType((GenericArrayType)type, frame);
        }
        if (type instanceof TypeVariable) {
            return this.visitTypeVariable((TypeVariable)type, frame);
        }
        return this.visitClass((Class)type, frame);
    }

    private Type<?> visitClass(Class<?> c, Frame frame) {
        Object[] typeParameters;
        Constructor<?> declaringConstructor;
        Method declaringMethod;
        Class<?> enclosingClass = c.getEnclosingClass();
        if (enclosingClass != null) {
            if (c.isLocalClass()) {
                declaringMethod = c.getEnclosingMethod();
                declaringConstructor = c.getEnclosingConstructor();
            } else {
                if (c.isAnonymousClass()) {
                    return null;
                }
                declaringMethod = null;
                declaringConstructor = null;
            }
        } else {
            declaringMethod = null;
            declaringConstructor = null;
        }
        Frame currentFrame = new Frame(c, frame);
        ReflectedType<?> currentType = currentFrame.getCurrentClass();
        if (enclosingClass != null) {
            Iterator iterator;
            Type<?> declaringType = currentFrame.resolveType(enclosingClass);
            currentType.setDeclaringType(declaringType);
            if (declaringMethod != null) {
                iterator = declaringType.getMethods(BindingFlags.AllDeclared).iterator();
                while (iterator.hasNext()) {
                    MethodInfo method = (MethodInfo)iterator.next();
                    if (!declaringMethod.equals(method.getRawMethod())) continue;
                    currentType.setDeclaringMethod(method);
                    break;
                }
            } else if (declaringConstructor != null) {
                iterator = declaringType.getConstructors(BindingFlags.AllDeclared).iterator();
                while (iterator.hasNext()) {
                    ConstructorInfo constructor = (ConstructorInfo)iterator.next();
                    if (!declaringConstructor.equals(constructor.getRawConstructor())) continue;
                    currentType.setDeclaringMethod(constructor);
                    break;
                }
            }
            if (declaringType instanceof ReflectedType) {
                ReflectedType owner = (ReflectedType)declaringType;
                ReflectedType<?> nestedType = owner.findNestedType(c);
                if (nestedType != null) {
                    return nestedType;
                }
                if (nestedType == null) {
                    owner.addNestedType(currentType);
                }
            }
        }
        if (!ArrayUtilities.isNullOrEmpty((Object[])(typeParameters = c.getTypeParameters()))) {
            int n = typeParameters.length;
            for (int i = 0; i < n; ++i) {
                Object typeVariable = typeParameters[i];
                currentType.addGenericParameter(new GenericParameter(typeVariable.getName(), currentType, null, i));
            }
        }
        if (!c.isInterface()) {
            Class<?> baseClass = c.getGenericSuperclass();
            if (baseClass == null) {
                baseClass = c.getSuperclass();
            }
            if (baseClass != null && baseClass != c) {
                Type<?> baseType = currentFrame.resolveType(baseClass);
                if (baseType != null) {
                    currentType.setBaseType(baseType);
                } else {
                    return null;
                }
            }
        }
        ArrayList interfaceList = null;
        Object[] interfaces = c.getGenericInterfaces();
        if (ArrayUtilities.isNullOrEmpty((Object[])interfaces)) {
            interfaces = c.getInterfaces();
        }
        if (!ArrayUtilities.isNullOrEmpty((Object[])interfaces)) {
            for (Object t : interfaces) {
                Type<?> interfaceType = currentFrame.resolveType((java.lang.reflect.Type)t);
                if (interfaceType == null) {
                    return null;
                }
                if (interfaceList == null) {
                    interfaceList = new ArrayList();
                }
                interfaceList.add(interfaceType);
            }
        }
        if (interfaceList != null) {
            currentType.setInterfaces(Type.list(interfaceList));
        }
        for (GenericParameter genericParameter : currentType.getGenericParameters()) {
            Type<?> boundType;
            Object[] bounds = genericParameter.getRawTypeVariable().getBounds();
            if (ArrayUtilities.isNullOrEmpty((Object[])bounds)) continue;
            if (bounds.length == 1) {
                boundType = currentFrame.resolveType((java.lang.reflect.Type)bounds[0]);
            } else {
                Type[] resolvedBounds = new Type[bounds.length];
                int n = bounds.length;
                for (int i = 0; i < n; ++i) {
                    resolvedBounds[i] = currentFrame.resolveType((java.lang.reflect.Type)bounds[i]);
                }
                boundType = Type.makeCompoundType(Type.list(resolvedBounds));
            }
            genericParameter.setUpperBound(boundType);
        }
        currentType.complete();
        if (!Modifier.isPrivate(currentType.getModifiers())) {
            Type.CACHE.add(currentType);
        }
        return currentType;
    }

    private Type<?> visitTypeVariable(TypeVariable type, Frame frame) {
        return frame.findType(type);
    }

    private Type<?> visitGenericArrayType(GenericArrayType type, Frame frame) {
        Type<?> elementType = frame.resolveType(type.getGenericComponentType());
        if (elementType != null) {
            return elementType.makeArrayType();
        }
        return null;
    }

    private Type<?> visitWildcardType(java.lang.reflect.WildcardType w, Frame frame) {
        java.lang.reflect.Type[] upperBounds = w.getUpperBounds();
        java.lang.reflect.Type[] lowerBounds = w.getLowerBounds();
        ArrayList resolvedUpperBounds = null;
        ArrayList resolvedLowerBounds = null;
        for (java.lang.reflect.Type lowerBound : lowerBounds) {
            Type<?> resolvedLowerBound = this.visit(lowerBound, frame);
            if (resolvedLowerBound == null) continue;
            if (resolvedLowerBounds == null) {
                resolvedLowerBounds = new ArrayList();
            }
            resolvedLowerBounds.add(resolvedLowerBound);
        }
        if (resolvedLowerBounds != null && resolvedLowerBounds.size() != lowerBounds.length) {
            return null;
        }
        for (java.lang.reflect.Type upperBound : upperBounds) {
            Type<?> resolvedUpperBound = this.visit(upperBound, frame);
            if (resolvedUpperBound == null) continue;
            if (resolvedUpperBounds == null) {
                resolvedUpperBounds = new ArrayList();
            }
            resolvedUpperBounds.add(resolvedUpperBound);
        }
        if (resolvedUpperBounds != null && resolvedUpperBounds.size() != upperBounds.length) {
            return null;
        }
        Type<Object> upperBound = Types.Object;
        Type lowerBound = Type.Bottom;
        if (resolvedUpperBounds != null) {
            upperBound = resolvedUpperBounds.size() == 1 ? (Type<Object>)resolvedUpperBounds.get(0) : Type.makeCompoundType(Type.list(resolvedUpperBounds));
        }
        if (resolvedLowerBounds != null) {
            lowerBound = resolvedLowerBounds.size() == 1 ? (Type)resolvedLowerBounds.get(0) : Type.makeCompoundType(Type.list(resolvedLowerBounds));
        }
        return new WildcardType<Object>(upperBound, lowerBound);
    }

    private Type<?> visitParameterizedType(ParameterizedType type, Frame frame) {
        Type<?> rawType = frame.resolveType(type.getRawType());
        if (rawType == null) {
            return null;
        }
        java.lang.reflect.Type[] typeArguments = type.getActualTypeArguments();
        Type[] resolvedTypeArguments = new Type[typeArguments.length];
        int n = typeArguments.length;
        for (int i = 0; i < n; ++i) {
            resolvedTypeArguments[i] = frame.resolveType(typeArguments[i]);
            if (resolvedTypeArguments[i] != null) continue;
            return null;
        }
        return rawType.makeGenericType(resolvedTypeArguments);
    }

    private Type<?> resolveExisting(Frame frame, java.lang.reflect.Type type, boolean resolve) {
        Type<?> result;
        Type<?> fromCacheOrFrame = Type.tryFind(type);
        if (fromCacheOrFrame != null) {
            result = fromCacheOrFrame;
        } else {
            if (frame != null) {
                fromCacheOrFrame = frame.resolveType(type);
            }
            if (!resolve) {
                return fromCacheOrFrame;
            }
            result = fromCacheOrFrame != null ? fromCacheOrFrame : (type instanceof Class ? this.visitClass((Class)type, frame) : this.visit(type, frame));
        }
        return result;
    }

    private Type<?> visit(ReflectedType<?> type, Frame frame, int flags) {
        Class<?> erasedClass = type.getErasedClass();
        if ((flags & 8) == 8) {
            for (AnnotatedElement annotatedElement : erasedClass.getDeclaredClasses()) {
                if (type.findNestedType((Class<?>)annotatedElement) != null) continue;
                this.visit((java.lang.reflect.Type)((Object)annotatedElement), frame);
            }
        }
        if ((flags & 2) == 2) {
            for (AnnotatedElement annotatedElement : erasedClass.getDeclaredFields()) {
                if (type.findField((Field)annotatedElement) != null) continue;
                this.visitField((Field)annotatedElement, frame);
            }
        }
        if ((flags & 1) == 1) {
            for (AnnotatedElement annotatedElement : erasedClass.getDeclaredMethods()) {
                if (type.findMethod((Method)annotatedElement) != null) continue;
                this.visitMethod((Method)annotatedElement, frame);
            }
        }
        if ((flags & 4) == 4) {
            for (AnnotatedElement annotatedElement : erasedClass.getDeclaredConstructors()) {
                if (type.findConstructor((Constructor)annotatedElement) != null) continue;
                this.visitConstructor((Constructor<?>)annotatedElement, frame);
            }
        }
        return type;
    }

    public Type<?> visitField(Field field, Frame frame) {
        ReflectedType<?> declaringType = frame.getCurrentClass();
        ReflectedField reflectedField = new ReflectedField(declaringType, field, frame.resolveType(field.getType()));
        declaringType.addField(reflectedField);
        return declaringType;
    }

    private Type<?> visitMethod(Method m, Frame frame) {
        int i;
        TypeBindings genericParameters;
        java.lang.reflect.Type[] parameterTypes = m.getGenericParameterTypes();
        java.lang.reflect.Type[] thrownTypes = m.getGenericExceptionTypes();
        Class<?> returnType = m.getGenericReturnType();
        if (parameterTypes == null) {
            parameterTypes = m.getParameterTypes();
        }
        if (thrownTypes == null) {
            thrownTypes = m.getExceptionTypes();
        }
        if (returnType == null) {
            returnType = m.getReturnType();
        }
        Type[] resolvedThrownTypes = new Type[thrownTypes.length];
        ParameterInfo[] parameters = new ParameterInfo[parameterTypes.length];
        Object[] typeParameters = m.getTypeParameters();
        if (ArrayUtilities.isNullOrEmpty((Object[])typeParameters)) {
            genericParameters = TypeBindings.empty();
        } else {
            Type[] resolvedTypeParameters = new Type[typeParameters.length];
            for (int i2 = 0; i2 < typeParameters.length; ++i2) {
                GenericParameter genericParameter;
                Object typeVariable = typeParameters[i2];
                resolvedTypeParameters[i2] = genericParameter = new GenericParameter(typeVariable.getName(), (TypeVariable<?>)typeVariable, i2);
                frame.addTypeArgument(genericParameter);
            }
            genericParameters = TypeBindings.createUnbound(Type.list(resolvedTypeParameters));
        }
        for (i = 0; i < parameterTypes.length; ++i) {
            Type<?> resolvedParameterType = frame.resolveType(parameterTypes[i]);
            if (resolvedParameterType == null) {
                return null;
            }
            parameters[i] = new ParameterInfo("p" + i, i, resolvedParameterType);
        }
        for (i = 0; i < thrownTypes.length; ++i) {
            Type<?> resolvedThrownType = frame.resolveType(thrownTypes[i]);
            if (resolvedThrownType == null) {
                return null;
            }
            resolvedThrownTypes[i] = resolvedThrownType;
        }
        Type<?> resolvedReturnType = frame.resolveType(returnType);
        if (resolvedReturnType == null) {
            return null;
        }
        ReflectedType<?> declaringType = frame.getCurrentClass();
        ReflectedMethod method = new ReflectedMethod(null, declaringType, m, new ParameterList(parameters), resolvedReturnType, Type.list(resolvedThrownTypes), genericParameters);
        if (!genericParameters.isEmpty()) {
            Iterator iterator = genericParameters.getGenericParameters().iterator();
            while (iterator.hasNext()) {
                Type<?> boundType;
                Type type = (Type)iterator.next();
                GenericParameter genericParameter = (GenericParameter)type;
                genericParameter.setDeclaringMethod(method);
                Object[] bounds = genericParameter.getRawTypeVariable().getBounds();
                if (ArrayUtilities.isNullOrEmpty((Object[])bounds)) continue;
                if (bounds.length == 1) {
                    boundType = frame.resolveType((java.lang.reflect.Type)bounds[0]);
                } else {
                    Type[] resolvedBounds = new Type[bounds.length];
                    int n = bounds.length;
                    for (int i3 = 0; i3 < n; ++i3) {
                        resolvedBounds[i3] = frame.resolveType((java.lang.reflect.Type)bounds[i3]);
                    }
                    boundType = Type.makeCompoundType(Type.list(resolvedBounds));
                }
                genericParameter.setUpperBound(boundType);
            }
        }
        declaringType.addMethod(method);
        return declaringType;
    }

    private Type<?> visitConstructor(Constructor<?> c, Frame frame) {
        int i;
        java.lang.reflect.Type[] parameterTypes = c.getGenericParameterTypes();
        java.lang.reflect.Type[] thrownTypes = c.getGenericExceptionTypes();
        if (parameterTypes == null) {
            parameterTypes = c.getParameterTypes();
        }
        if (thrownTypes == null) {
            thrownTypes = c.getExceptionTypes();
        }
        Type[] resolvedThrownTypes = new Type[thrownTypes.length];
        ParameterInfo[] parameters = new ParameterInfo[parameterTypes.length];
        for (i = 0; i < parameterTypes.length; ++i) {
            Type<?> resolvedParameterType = frame.resolveType(parameterTypes[i]);
            if (resolvedParameterType == null) {
                return null;
            }
            parameters[i] = new ParameterInfo("p" + i, i, resolvedParameterType);
        }
        for (i = 0; i < thrownTypes.length; ++i) {
            Type<?> resolvedThrownType = frame.resolveType(thrownTypes[i]);
            if (resolvedThrownType == null) {
                return null;
            }
            resolvedThrownTypes[i] = resolvedThrownType;
        }
        ReflectedType<?> declaringType = frame.getCurrentClass();
        ReflectedConstructor constructor = new ReflectedConstructor(declaringType, c, new ParameterList(parameters), Type.list(resolvedThrownTypes));
        declaringType.addConstructor(constructor);
        return declaringType;
    }

    public final class Frame {
        private final ReflectedType<?> _type;
        private final java.lang.reflect.Type _typeElement;
        private final Frame _previous;
        private final Map<java.lang.reflect.Type, Type> _elementTypeMap;
        private final Stack<ReflectedMethod> _methods;
        private final ArrayList<Type<?>> _typeArguments = new ArrayList();

        public Frame(java.lang.reflect.Type typeElement, Frame previous) {
            this._typeElement = (java.lang.reflect.Type)VerifyArgument.notNull((Object)typeElement, (String)"typeElement");
            this._previous = previous;
            this._elementTypeMap = previous != null ? previous._elementTypeMap : new HashMap<java.lang.reflect.Type, Type>();
            this._methods = previous != null ? previous._methods : new Stack();
            this._type = new ReflectedType((Class)typeElement);
            this._elementTypeMap.put(typeElement, this._type);
        }

        Frame(ReflectedType<?> type, Frame previous) {
            Frame ownerFrame;
            this._type = (ReflectedType)VerifyArgument.notNull(type, (String)"type");
            this._typeElement = type;
            this._previous = previous;
            this._elementTypeMap = previous != null ? previous._elementTypeMap : new HashMap<java.lang.reflect.Type, Type>();
            this._methods = previous != null ? previous._methods : new Stack();
            this._elementTypeMap.put(this._typeElement, this._type);
            Class<?> classType = type.getErasedClass();
            Class<?> enclosingClass = classType.getEnclosingClass();
            if (enclosingClass != null && enclosingClass != classType && (ownerFrame = this.findFrame(enclosingClass)) != null && ownerFrame._type.findNestedType(this._type.getErasedClass()) == null) {
                ownerFrame._type.addNestedType(this._type);
            }
        }

        public Type<?> getResult() {
            return this._type;
        }

        void pushMethod(ReflectedMethod method) {
            this._methods.push(method);
        }

        ReflectedMethod popMethod() {
            return this._methods.pop();
        }

        ReflectedMethod currentMethod() {
            return this._methods.peek();
        }

        ReflectedType<?> getCurrentClass() {
            return this._type;
        }

        java.lang.reflect.Type getCurrentType() {
            return this._typeElement;
        }

        List<Type<?>> getTypeArguments() {
            return this._typeArguments;
        }

        Type<?> findType(java.lang.reflect.Type e) {
            Frame currentFrame = this;
            while (currentFrame != null) {
                Type result = currentFrame._elementTypeMap.get(e);
                if (result != null) {
                    return result;
                }
                if (e instanceof TypeVariable) {
                    TypeVariable typeVariable = (TypeVariable)e;
                    result = currentFrame._type.findGenericParameter(typeVariable);
                    if (result != null) {
                        return result;
                    }
                    if (!this._typeArguments.isEmpty()) {
                        for (Type<?> typeArgument : this._typeArguments) {
                            if (!(typeArgument instanceof GenericParameter) || ((GenericParameter)typeArgument).getRawTypeVariable() != typeVariable) continue;
                            return typeArgument;
                        }
                    }
                }
                currentFrame = currentFrame._previous;
            }
            return Type.tryFind(e);
        }

        Type<?> resolveType(java.lang.reflect.Type t) {
            Type<?> result = this.resolveTypeCore(t);
            if (result != null) {
                this._elementTypeMap.put(t, result);
                Type.CACHE.add(result);
            }
            return result;
        }

        private Type<?> resolveTypeCore(java.lang.reflect.Type t) {
            Type<?> fromMap = this.findType(t);
            if (fromMap != null) {
                return fromMap;
            }
            if (t instanceof Class) {
                Class classType = (Class)t;
                if (classType.isPrimitive()) {
                    return Type.of(classType);
                }
                if (classType.isArray()) {
                    Type<?> componentType = this.resolveType(classType.getComponentType());
                    if (componentType != null) {
                        return componentType.makeArrayType();
                    }
                    return null;
                }
                Type cachedType = Type.CACHE.find((Class)t);
                if (cachedType != null) {
                    return cachedType;
                }
                return Resolver.this.visit(classType, this);
            }
            if (t instanceof GenericArrayType) {
                java.lang.reflect.Type genericComponentType = ((GenericArrayType)t).getGenericComponentType();
                Type<?> componentType = this.resolveType(genericComponentType);
                if (componentType != null) {
                    return componentType.makeArrayType();
                }
                return null;
            }
            if (t instanceof java.lang.reflect.WildcardType) {
                java.lang.reflect.WildcardType w = (java.lang.reflect.WildcardType)t;
                java.lang.reflect.Type[] upperBounds = w.getUpperBounds();
                java.lang.reflect.Type[] lowerBounds = w.getLowerBounds();
                ArrayList resolvedUpperBounds = null;
                ArrayList resolvedLowerBounds = null;
                for (java.lang.reflect.Type lowerBound : lowerBounds) {
                    Type<?> resolvedLowerBound = this.resolveType(lowerBound);
                    if (resolvedLowerBound == null) continue;
                    if (resolvedLowerBounds == null) {
                        resolvedLowerBounds = new ArrayList();
                    }
                    resolvedLowerBounds.add(resolvedLowerBound);
                }
                if (resolvedLowerBounds != null && resolvedLowerBounds.size() != lowerBounds.length) {
                    return null;
                }
                for (java.lang.reflect.Type upperBound : upperBounds) {
                    Type<?> resolvedUpperBound = this.resolveType(upperBound);
                    if (resolvedUpperBound == null) continue;
                    if (resolvedUpperBounds == null) {
                        resolvedUpperBounds = new ArrayList();
                    }
                    resolvedUpperBounds.add(resolvedUpperBound);
                }
                if (resolvedUpperBounds != null && resolvedUpperBounds.size() != upperBounds.length) {
                    return null;
                }
                Type<Object> upperBound = Types.Object;
                Type lowerBound = Type.Bottom;
                if (resolvedUpperBounds != null) {
                    upperBound = resolvedUpperBounds.size() == 1 ? (Type<Object>)resolvedUpperBounds.get(0) : Type.makeCompoundType(Type.list(resolvedUpperBounds));
                }
                if (resolvedLowerBounds != null) {
                    lowerBound = resolvedLowerBounds.size() == 1 ? (Type)resolvedLowerBounds.get(0) : Type.makeCompoundType(Type.list(resolvedLowerBounds));
                }
                return new WildcardType<Object>(upperBound, lowerBound);
            }
            if (t instanceof TypeVariable) {
                TypeVariable typeVariable = (TypeVariable)t;
                Frame currentFrame = this;
                while (currentFrame != null) {
                    GenericParameter genericParameter = currentFrame._type.findGenericParameter(typeVariable);
                    if (genericParameter != null) {
                        return genericParameter;
                    }
                    currentFrame = currentFrame._previous;
                }
            }
            if (t instanceof ParameterizedType) {
                ParameterizedType type = (ParameterizedType)t;
                Type<?> rawType = this.resolveType(type.getRawType());
                Object[] typeArguments = type.getActualTypeArguments();
                if (ArrayUtilities.isNullOrEmpty((Object[])typeArguments) || !rawType.isGenericType()) {
                    return rawType;
                }
                Type[] resolvedTypeArguments = new Type[typeArguments.length];
                int n = typeArguments.length;
                for (int i = 0; i < n; ++i) {
                    Object typeArg = typeArguments[i];
                    if (typeArg instanceof TypeVariable) {
                        int position;
                        TypeVariable typeVariable = (TypeVariable)typeArg;
                        Object genericDeclaration = typeVariable.getGenericDeclaration();
                        Type<?> existingTypeArgument = this.findType(typeVariable);
                        if (existingTypeArgument != null) {
                            resolvedTypeArguments[i] = existingTypeArgument;
                            continue;
                        }
                        if (genericDeclaration instanceof Method) {
                            ReflectedType declaringType = (ReflectedType)this.resolveType(((Method)genericDeclaration).getDeclaringClass());
                            Method method = (Method)genericDeclaration;
                            position = ArrayUtilities.indexOf((Object[])method.getTypeParameters(), (Object)typeVariable);
                            ReflectedMethod declaredMethod = declaringType.findMethod(method);
                            resolvedTypeArguments[i] = (Type)declaredMethod.getTypeArguments().get(position);
                            continue;
                        }
                        Class declaringClass = (Class)genericDeclaration;
                        Type<?> declaringType = this.resolveType(declaringClass);
                        position = ArrayUtilities.indexOf((Object[])declaringClass.getTypeParameters(), (Object)typeVariable);
                        if (declaringType instanceof ReflectedType) {
                            resolvedTypeArguments[i] = ((ReflectedType)declaringType).getGenericParameters().get(position);
                            continue;
                        }
                        resolvedTypeArguments[i] = (Type)declaringType.getTypeArguments().get(position);
                        continue;
                    }
                    resolvedTypeArguments[i] = typeArg == null ? (Type)rawType.getGenericTypeParameters().get(i) : this.resolveType((java.lang.reflect.Type)typeArg);
                }
                Type fromCache = Type.CACHE.find(Type.CACHE.key(rawType, Type.list(resolvedTypeArguments)));
                if (fromCache != null) {
                    return fromCache;
                }
                for (Type resolvedTypeArgument : resolvedTypeArguments) {
                    if (resolvedTypeArgument.isGenericParameter() && resolvedTypeArgument.getDeclaringType() == rawType) continue;
                    return Type.CACHE.getGenericType(rawType, Type.list(resolvedTypeArguments));
                }
                return rawType;
            }
            return null;
        }

        Frame findFrame(java.lang.reflect.Type e) {
            Frame current = this;
            while (current != null) {
                if (current._typeElement.equals(e)) {
                    return current;
                }
                current = current._previous;
            }
            return null;
        }

        void addTypeArgument(GenericParameter genericParameter) {
            this._typeArguments.add(genericParameter);
        }
    }
}

