/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.annotations.NotNull;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.ConstructorInfo;
import com.strobel.reflection.ConstructorList;
import com.strobel.reflection.FieldInfo;
import com.strobel.reflection.FieldList;
import com.strobel.reflection.GenericParameter;
import com.strobel.reflection.MemberInfo;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.MethodList;
import com.strobel.reflection.ParameterInfo;
import com.strobel.reflection.ParameterList;
import com.strobel.reflection.ReflectedConstructor;
import com.strobel.reflection.ReflectedField;
import com.strobel.reflection.ReflectedMethod;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeBindings;
import com.strobel.reflection.TypeList;
import com.strobel.reflection.TypeMapper;
import com.strobel.reflection.Types;
import com.strobel.reflection.WildcardType;
import com.strobel.util.ContractUtils;
import com.strobel.util.TypeUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class TypeBinder
extends TypeMapper<TypeBindings> {
    static final Method GET_CLASS_METHOD;
    static final TypeBinder DEFAULT_BINDER;
    private static final ThreadLocal<Map<CacheEntry, CacheEntry>> CACHE;

    public static TypeBinder defaultBinder() {
        return DEFAULT_BINDER;
    }

    public ConstructorList visit(Type<?> declaringType, ConstructorList constructors, TypeBindings bindings) {
        VerifyArgument.notNull((Object)((Object)constructors), (String)"constructors");
        ConstructorInfo[] newConstructors = null;
        int n = constructors.size();
        for (int i = 0; i < n; ++i) {
            ConstructorInfo oldConstructor = (ConstructorInfo)constructors.get(i);
            ConstructorInfo newConstructor = this.visitConstructor(declaringType, oldConstructor, bindings);
            if (newConstructor == oldConstructor) continue;
            if (newConstructors == null) {
                newConstructors = (ConstructorInfo[])constructors.toArray();
            }
            newConstructors[i] = newConstructor;
        }
        if (newConstructors != null) {
            return new ConstructorList(newConstructors);
        }
        return constructors;
    }

    public FieldList visit(Type<?> declaringType, FieldList fields, TypeBindings bindings) {
        VerifyArgument.notNull((Object)((Object)fields), (String)"fields");
        FieldInfo[] newFields = null;
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            FieldInfo oldField = (FieldInfo)fields.get(i);
            FieldInfo newField = this.visitField(declaringType, oldField, bindings);
            if (newField == oldField) continue;
            if (newFields == null) {
                newFields = (FieldInfo[])fields.toArray();
            }
            newFields[i] = newField;
        }
        if (newFields != null) {
            return new FieldList(newFields);
        }
        return fields;
    }

    public MethodList visit(Type<?> declaringType, MethodList methods, TypeBindings bindings) {
        VerifyArgument.notNull((Object)((Object)methods), (String)"methods");
        MethodInfo[] newMethods = null;
        int n = methods.size();
        for (int i = 0; i < n; ++i) {
            MethodInfo oldMethod = (MethodInfo)methods.get(i);
            MethodInfo newMethod = this.visitMethod(declaringType, oldMethod, bindings);
            if (newMethod == oldMethod) continue;
            if (newMethods == null) {
                newMethods = (MethodInfo[])methods.toArray();
            }
            newMethods[i] = newMethod;
        }
        if (newMethods != null) {
            return new MethodList(newMethods);
        }
        return methods;
    }

    public TypeBindings visitTypeBindings(TypeBindings typeBindings, TypeBindings bindings) {
        TypeBindings newTypeBindings = typeBindings;
        Iterator iterator = typeBindings.getGenericParameters().iterator();
        while (iterator.hasNext()) {
            Type newBoundType;
            Type genericParameter = (Type)iterator.next();
            Type oldBoundType = typeBindings.getBoundType(genericParameter);
            if (oldBoundType == (newBoundType = (Type)this.visit(oldBoundType, bindings))) continue;
            newTypeBindings = newTypeBindings.withAdditionalBinding(genericParameter, newBoundType);
        }
        return newTypeBindings;
    }

    public FieldInfo visitField(Type<?> declaringType, FieldInfo field, TypeBindings bindings) {
        Type newFieldType;
        Type<?> oldFieldType = field.getFieldType();
        if (TypeUtils.areEquivalent(oldFieldType, newFieldType = (Type)this.visit(field.getFieldType(), bindings)) && TypeUtils.areEquivalent(field.getDeclaringType(), declaringType)) {
            return field;
        }
        return new ReflectedField(declaringType, field.getReflectedType(), field.getRawField(), newFieldType);
    }

    public ParameterList visitParameters(ParameterList parameters, TypeBindings bindings) {
        VerifyArgument.notNull((Object)((Object)parameters), (String)"parameters");
        ParameterInfo[] newParameters = null;
        int n = parameters.size();
        for (int i = 0; i < n; ++i) {
            ParameterInfo oldParameter = (ParameterInfo)parameters.get(i);
            Type<?> oldParameterType = oldParameter.getParameterType();
            Type newParameterType = (Type)this.visit(oldParameterType, bindings);
            if (newParameterType == oldParameterType) continue;
            if (newParameters == null) {
                newParameters = (ParameterInfo[])parameters.toArray();
            }
            newParameters[i] = new ParameterInfo(oldParameter.getName(), i, newParameterType);
        }
        if (newParameters != null) {
            return new ParameterList(newParameters);
        }
        return parameters;
    }

    public MemberInfo visitMember(Type<?> declaringType, MemberInfo member, TypeBindings bindings) {
        switch (member.getMemberType()) {
            case Constructor: {
                return this.visitConstructor(declaringType, (ConstructorInfo)member, bindings);
            }
            case Field: {
                return this.visitField(declaringType, (FieldInfo)member, bindings);
            }
            case Method: {
                return this.visitMethod(declaringType, (MethodInfo)member, bindings);
            }
            case TypeInfo: 
            case NestedType: {
                return this.visitType((Type)member, bindings);
            }
        }
        throw ContractUtils.unreachable();
    }

    public MethodInfo visitMethod(Type<?> declaringType, MethodInfo method, TypeBindings bindings) {
        if (method.isGenericMethodDefinition()) {
            TypeBindings newBindings;
            MethodInfo newDefinition;
            boolean hasChanged = false;
            if (!method.isGenericMethodDefinition()) {
                MethodInfo oldDefinition = method.getGenericMethodDefinition();
                newDefinition = this.visitMethod(declaringType, oldDefinition, bindings);
                hasChanged = newDefinition != oldDefinition;
            } else {
                newDefinition = method.getGenericMethodDefinition();
            }
            TypeBindings oldBindings = method.getTypeBindings();
            if (oldBindings.hasUnboundParameters()) {
                newBindings = this.visitTypeBindings(oldBindings, bindings.withAdditionalBindings(oldBindings));
                hasChanged |= newBindings != oldBindings;
            } else {
                newBindings = oldBindings;
            }
            if (hasChanged) {
                return this.visitMethod(declaringType, newDefinition.makeGenericMethod(newBindings.getBoundTypes()), newBindings);
            }
        }
        Type<?> oldReturnType = method.getReturnType();
        Type returnType = (Type)this.visit(oldReturnType, bindings);
        ParameterList oldParameters = method.getParameters();
        ParameterList newParameters = this.visitParameters(oldParameters, bindings);
        TypeList oldThrownTypes = method.getThrownTypes();
        Type[] newThrownTypes = new Type[oldThrownTypes.size()];
        boolean hasChanged = !oldReturnType.equals(returnType) || oldParameters != newParameters;
        boolean thrownTypesChanged = false;
        int n = newThrownTypes.length;
        for (int i = 0; i < n; ++i) {
            Type newThrownType;
            Type oldThrownType = (Type)oldThrownTypes.get(i);
            newThrownTypes[i] = newThrownType = (Type)this.visit(oldThrownType, bindings);
            if (oldThrownType.equals(newThrownType)) continue;
            thrownTypesChanged = true;
        }
        if (!(hasChanged |= thrownTypesChanged)) {
            if (!TypeUtils.areEquivalent(method.getDeclaringType(), declaringType)) {
                return MethodInfo.declaredOn(method, declaringType, method.getReflectedType());
            }
            return method;
        }
        return new ReflectedMethod(method, declaringType, method.getReflectedType(), method.getRawMethod(), newParameters, returnType, thrownTypesChanged ? new TypeList(newThrownTypes) : oldThrownTypes, method.getTypeBindings());
    }

    public ConstructorInfo visitConstructor(Type<?> declaringType, ConstructorInfo constructor, TypeBindings bindings) {
        int i;
        ParameterList parameters = constructor.getParameters();
        TypeList thrown = constructor.getThrownTypes();
        Type[] parameterTypes = new Type[parameters.size()];
        Type[] thrownTypes = new Type[thrown.size()];
        boolean hasChanged = false;
        boolean thrownTypesChanged = false;
        int n = parameterTypes.length;
        for (i = 0; i < n; ++i) {
            Type<?> oldParameterType = ((ParameterInfo)parameters.get(i)).getParameterType();
            parameterTypes[i] = (Type)this.visit(oldParameterType, bindings);
            if (oldParameterType.equals(parameterTypes[i])) continue;
            hasChanged = true;
        }
        n = thrownTypes.length;
        for (i = 0; i < n; ++i) {
            Type newThrownType;
            Type oldThrownType = (Type)thrown.get(i);
            thrownTypes[i] = newThrownType = (Type)this.visit(oldThrownType, bindings);
            if (oldThrownType.equals(newThrownType)) continue;
            thrownTypesChanged = true;
        }
        if (!(hasChanged |= thrownTypesChanged)) {
            if (!TypeUtils.areEquivalent(constructor.getDeclaringType(), declaringType)) {
                return new ReflectedConstructor(declaringType, constructor.getRawConstructor(), constructor.getParameters(), thrown);
            }
            return constructor;
        }
        ArrayList<ParameterInfo> newParameters = new ArrayList<ParameterInfo>();
        int n2 = parameterTypes.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            newParameters.add(new ParameterInfo(((ParameterInfo)parameters.get(i2)).getName(), i2, parameterTypes[i2]));
        }
        return new ReflectedConstructor(declaringType, constructor.getRawConstructor(), new ParameterList(newParameters), new TypeList(thrownTypes));
    }

    @Override
    public Type<?> visitClassType(Type<?> type, TypeBindings bindings) {
        TypeBindings newTypeBindings;
        if (bindings.containsGenericParameter(type)) {
            return bindings.getBoundType(type);
        }
        TypeBindings oldTypeBindings = type.getTypeBindings();
        if (oldTypeBindings != (newTypeBindings = this.visitTypeBindings(oldTypeBindings, bindings))) {
            return type.getGenericTypeDefinition().makeGenericType(newTypeBindings.getBoundTypes());
        }
        return type;
    }

    @Override
    public Type<?> visitTypeParameter(Type<?> type, TypeBindings bindings) {
        return this.visitTypeParameterCore(type, bindings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Type<?> visitTypeParameterCore(Type<?> type, TypeBindings bindings) {
        if (!bindings.containsGenericParameter(type) && Types.Object.equals(type.getExtendsBound())) {
            return type;
        }
        CacheEntry entry = new CacheEntry(bindings, type);
        Map<CacheEntry, CacheEntry> cache = TypeBinder.cache();
        if (cache.containsKey(entry)) {
            return type;
        }
        cache.put(entry, entry);
        try {
            if (bindings.containsGenericParameter(type)) {
                Type type2 = (Type)this.visit(bindings.getBoundType(type), bindings);
                return type2;
            }
            Type<?> upperBound = type.getExtendsBound();
            Type newUpperBound = (Type)this.visit(upperBound, bindings);
            if (newUpperBound != upperBound) {
                if (type.getDeclaringMethod() != null) {
                    GenericParameter genericParameter = new GenericParameter(type.getFullName(), (MethodInfo)type.getDeclaringMethod(), newUpperBound, type.getGenericParameterPosition());
                    return genericParameter;
                }
                GenericParameter genericParameter = new GenericParameter(type.getFullName(), type.getDeclaringType(), newUpperBound, type.getGenericParameterPosition());
                return genericParameter;
            }
            Type<?> type3 = type;
            return type3;
        }
        finally {
            cache.remove(entry);
        }
    }

    @Override
    public Type<?> visitWildcardType(Type<?> type, TypeBindings bindings) {
        Type<?> oldLower = type.getSuperBound();
        Type<?> oldUpper = type.getExtendsBound();
        Type newLower = (Type)this.visit(oldLower, bindings);
        Type newUpper = (Type)this.visit(oldUpper, bindings);
        if (newLower != oldLower || newUpper != oldUpper) {
            return new WildcardType(newUpper, newLower);
        }
        return type;
    }

    @Override
    public Type<?> visitArrayType(Type<?> type, TypeBindings bindings) {
        Type newElementType;
        Type<?> oldElementType = type.getElementType();
        if (TypeUtils.areEquivalent(oldElementType, newElementType = (Type)this.visit(oldElementType, bindings))) {
            return type;
        }
        return newElementType.makeArrayType();
    }

    private static Map<CacheEntry, CacheEntry> cache() {
        return CACHE.get();
    }

    static {
        Method getClassMethod;
        try {
            getClassMethod = Object.class.getMethod("getClass", new Class[0]);
        }
        catch (NoSuchMethodException ignored) {
            getClassMethod = null;
        }
        GET_CLASS_METHOD = getClassMethod;
        DEFAULT_BINDER = new TypeBinder();
        CACHE = new ThreadLocal<Map<CacheEntry, CacheEntry>>(){

            @Override
            protected Map<CacheEntry, CacheEntry> initialValue() {
                return new LinkedHashMap<CacheEntry, CacheEntry>();
            }
        };
    }

    private static final class CacheEntry {
        @NotNull
        final TypeBindings bindings;
        @NotNull
        final Type<?> type;

        CacheEntry(@NotNull TypeBindings bindings, @NotNull Type<?> type) {
            this.bindings = bindings;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof CacheEntry) {
                CacheEntry entry = (CacheEntry)o;
                return entry.bindings == this.bindings && entry.type == this.type;
            }
            return false;
        }

        public int hashCode() {
            int result = System.identityHashCode(this.bindings);
            result = 31 * result + System.identityHashCode(this.type);
            return result;
        }

        public String toString() {
            return "CacheEntry{bindings=" + this.bindings + ", type=" + this.type + '}';
        }
    }
}

