/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection.emit;

import com.strobel.core.HashUtilities;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.FieldInfo;
import com.strobel.reflection.MethodBase;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.Type;
import com.strobel.reflection.emit.CodeStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;

final class ConstantPool {
    private static final Writer WRITER = new Writer();
    private final ArrayList<Entry> _pool = new ArrayList();
    private final HashMap<Key, Entry> _entryMap = new HashMap();
    private final Key _lookupKey = new Key();
    private final Key _newKey = new Key();
    private int _size;
    final HashSet<Type<?>> referencedInnerTypes = new LinkedHashSet();

    ConstantPool() {
    }

    public void write(CodeStream stream) {
        stream.putShort(this._size + 1);
        for (Entry entry : this._pool) {
            if (entry == null) continue;
            entry.accept(WRITER, stream);
        }
    }

    public Entry get(int index) {
        VerifyArgument.inRange((int)0, (int)(this._size + 1), (int)index, (String)"index");
        Entry info = this._pool.get(index - 1);
        if (info == null) {
            throw new IndexOutOfBoundsException();
        }
        return info;
    }

    public Entry get(int index, Tag expectedType) {
        VerifyArgument.inRange((int)0, (int)(this._size + 1), (int)index, (String)"index");
        Entry entry = this.get(index);
        Tag actualType = entry.getTag();
        if (actualType != expectedType) {
            throw new IllegalStateException(String.format("Expected type '%s' but found type '%s'.", new Object[]{expectedType, actualType}));
        }
        return entry;
    }

    public Utf8StringConstant getUtf8StringConstant(String value) {
        this._lookupKey.set(value);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            entry = new Utf8StringConstant(this, value);
        }
        this._lookupKey.clear();
        return (Utf8StringConstant)entry;
    }

    public StringConstant getStringConstant(String value) {
        Utf8StringConstant utf8Constant = this.getUtf8StringConstant(value);
        this._lookupKey.set(Tag.StringConstant, utf8Constant.index);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            entry = new StringConstant(this, utf8Constant.index);
        }
        this._lookupKey.clear();
        return (StringConstant)entry;
    }

    public IntegerConstant getIntegerConstant(int value) {
        this._lookupKey.set(value);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            entry = new IntegerConstant(this, value);
        }
        this._lookupKey.clear();
        return (IntegerConstant)entry;
    }

    public FloatConstant getFloatConstant(float value) {
        this._lookupKey.set(value);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            entry = new FloatConstant(this, value);
        }
        this._lookupKey.clear();
        return (FloatConstant)entry;
    }

    public LongConstant getLongConstant(long value) {
        this._lookupKey.set(value);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            entry = new LongConstant(this, value);
        }
        this._lookupKey.clear();
        return (LongConstant)entry;
    }

    public DoubleConstant getDoubleConstant(double value) {
        this._lookupKey.set(value);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            entry = new DoubleConstant(this, value);
        }
        this._lookupKey.clear();
        return (DoubleConstant)entry;
    }

    public TypeInfo getTypeInfo(Type<?> type) {
        Utf8StringConstant name = this.getUtf8StringConstant(type.getInternalName());
        if (type.isNested()) {
            this.referencedInnerTypes.add(type);
            Type declaringType = type.getDeclaringType();
            MethodBase declaringMethod = type.getDeclaringMethod();
            String shortName = type.getShortName();
            if (declaringType != null) {
                this.getTypeInfo(declaringType);
            }
            if (declaringMethod != null) {
                this.getMethodReference(declaringMethod);
            }
            if (!StringUtilities.isNullOrWhitespace((String)shortName)) {
                this.getUtf8StringConstant(shortName);
            }
        }
        this._lookupKey.set(Tag.TypeInfo, name.index);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            entry = new TypeInfo(this, name.index);
        }
        this._lookupKey.clear();
        return (TypeInfo)entry;
    }

    public FieldReference getFieldReference(FieldInfo field) {
        TypeInfo typeInfo = this.getTypeInfo(field.getDeclaringType());
        NameAndTypeDescriptor nameAndDescriptor = this.getNameAndTypeDescriptor(field.getName(), field.getErasedSignature());
        this._lookupKey.set(Tag.FieldReference, typeInfo.index, nameAndDescriptor.index);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            entry = new FieldReference(this, typeInfo.index, nameAndDescriptor.index);
        }
        this._lookupKey.clear();
        return (FieldReference)entry;
    }

    public MethodReference getMethodReference(MethodBase method) {
        TypeInfo typeInfo = this.getTypeInfo(method.getDeclaringType());
        NameAndTypeDescriptor nameAndDescriptor = this.getNameAndTypeDescriptor(method.getName(), method.getErasedSignature());
        this._lookupKey.set(Tag.MethodReference, typeInfo.index, nameAndDescriptor.index);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            entry = new MethodReference(this, typeInfo.index, nameAndDescriptor.index);
        }
        this._lookupKey.clear();
        return (MethodReference)entry;
    }

    public InterfaceMethodReference getInterfaceMethodReference(MethodInfo method) {
        TypeInfo typeInfo = this.getTypeInfo(method.getDeclaringType());
        NameAndTypeDescriptor nameAndDescriptor = this.getNameAndTypeDescriptor(method.getName(), method.getErasedSignature());
        this._lookupKey.set(Tag.InterfaceMethodReference, typeInfo.index, nameAndDescriptor.index);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            entry = new InterfaceMethodReference(this, typeInfo.index, nameAndDescriptor.index);
        }
        this._lookupKey.clear();
        return (InterfaceMethodReference)entry;
    }

    NameAndTypeDescriptor getNameAndTypeDescriptor(String name, String typeDescriptor) {
        Utf8StringConstant utf8Name = this.getUtf8StringConstant(name);
        Utf8StringConstant utf8Descriptor = this.getUtf8StringConstant(typeDescriptor);
        this._lookupKey.set(Tag.NameAndTypeDescriptor, utf8Name.index, utf8Descriptor.index);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            entry = new NameAndTypeDescriptor(this, utf8Name.index, utf8Descriptor.index);
        }
        this._lookupKey.clear();
        return (NameAndTypeDescriptor)entry;
    }

    MethodHandle getMethodHandle(ReferenceKind referenceKind, int referenceIndex) {
        this._lookupKey.set(Tag.MethodHandle, referenceIndex, referenceKind);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            entry = new MethodHandle(this, referenceKind, referenceIndex);
        }
        this._lookupKey.clear();
        return (MethodHandle)entry;
    }

    MethodType getMethodType(int descriptorIndex) {
        this._lookupKey.set(Tag.MethodType, descriptorIndex);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            entry = new MethodType(this, descriptorIndex);
        }
        this._lookupKey.clear();
        return (MethodType)entry;
    }

    InvokeDynamicInfo getInvokeDynamicInfo(int bootstrapMethodAttributeIndex, int nameAndTypeDescriptorIndex) {
        this._lookupKey.set(Tag.InvokeDynamicInfo, bootstrapMethodAttributeIndex, nameAndTypeDescriptorIndex);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            entry = new InvokeDynamicInfo(this, bootstrapMethodAttributeIndex, nameAndTypeDescriptorIndex);
        }
        this._lookupKey.clear();
        return (InvokeDynamicInfo)entry;
    }

    private static final class Key {
        private Tag _tag;
        private int _intValue;
        private long _longValue;
        private String _stringValue1;
        private String _stringValue2;
        private int _refIndex1 = -1;
        private int _refIndex2 = -1;
        private int _hashCode;

        private Key() {
        }

        public void clear() {
            this._tag = null;
            this._intValue = 0;
            this._longValue = 0L;
            this._stringValue1 = null;
            this._stringValue2 = null;
            this._refIndex1 = -1;
            this._refIndex2 = -1;
        }

        public void set(int intValue) {
            this._tag = Tag.IntegerConstant;
            this._intValue = intValue;
            this._hashCode = Integer.MAX_VALUE & this._tag.value + this._intValue;
        }

        public void set(long longValue) {
            this._tag = Tag.LongConstant;
            this._longValue = longValue;
            this._hashCode = Integer.MAX_VALUE & this._tag.value + (int)longValue;
        }

        public void set(float floatValue) {
            this._tag = Tag.FloatConstant;
            this._intValue = Float.floatToRawIntBits(floatValue);
            this._hashCode = Integer.MAX_VALUE & this._tag.value + this._intValue;
        }

        public void set(double doubleValue) {
            this._tag = Tag.DoubleConstant;
            this._longValue = Double.doubleToRawLongBits(doubleValue);
            this._hashCode = Integer.MAX_VALUE & this._tag.value + (int)this._longValue;
        }

        public void set(String utf8Value) {
            this._tag = Tag.Utf8StringConstant;
            this._stringValue1 = utf8Value;
            this._hashCode = HashUtilities.combineHashCodes((Object)((Object)this._tag), (Object)utf8Value);
        }

        public void set(Tag tag, int refIndex1, ReferenceKind refKind) {
            this._tag = tag;
            this._refIndex1 = refIndex1;
            this._refIndex2 = refKind.tag;
            this._hashCode = HashUtilities.combineHashCodes((Object)((Object)tag), (Object)refIndex1);
        }

        public void set(Tag tag, int refIndex1) {
            this._tag = tag;
            this._refIndex1 = refIndex1;
            this._hashCode = HashUtilities.combineHashCodes((Object)((Object)tag), (Object)refIndex1);
        }

        public void set(Tag tag, int refIndex1, int refIndex2) {
            this._tag = tag;
            this._refIndex1 = refIndex1;
            this._refIndex2 = refIndex2;
            this._hashCode = HashUtilities.combineHashCodes((Object)((Object)tag), (Object)refIndex1, (Object)refIndex2);
        }

        public void set(Tag tag, String stringValue1) {
            this._tag = tag;
            this._stringValue1 = stringValue1;
            this._hashCode = HashUtilities.combineHashCodes((Object)((Object)tag), (Object)stringValue1);
        }

        public void set(Tag tag, String stringValue1, String stringValue2) {
            this._tag = tag;
            this._stringValue1 = stringValue1;
            this._stringValue2 = stringValue2;
            this._hashCode = HashUtilities.combineHashCodes((Object)((Object)tag), (Object)stringValue1, (Object)stringValue2);
        }

        protected Key clone() {
            Key key = new Key();
            key._tag = this._tag;
            key._hashCode = this._hashCode;
            key._intValue = this._intValue;
            key._longValue = this._longValue;
            key._stringValue1 = this._stringValue1;
            key._stringValue2 = this._stringValue2;
            key._refIndex1 = this._refIndex1;
            key._refIndex2 = this._refIndex2;
            return key;
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key key = (Key)obj;
            if (key._tag != this._tag) {
                return false;
            }
            switch (this._tag) {
                case Utf8StringConstant: {
                    return StringUtilities.equals((String)key._stringValue1, (String)this._stringValue1);
                }
                case IntegerConstant: 
                case FloatConstant: {
                    return key._intValue == this._intValue;
                }
                case LongConstant: 
                case DoubleConstant: {
                    return key._longValue == this._longValue;
                }
                case TypeInfo: 
                case StringConstant: 
                case MethodType: {
                    return key._refIndex1 == this._refIndex1;
                }
                case FieldReference: 
                case InterfaceMethodReference: 
                case NameAndTypeDescriptor: 
                case MethodReference: 
                case MethodHandle: 
                case InvokeDynamicInfo: {
                    return key._refIndex1 == this._refIndex1 && key._refIndex2 == this._refIndex2;
                }
            }
            return false;
        }
    }

    public static final class Utf8StringConstant
    extends Entry {
        public final String value;

        public Utf8StringConstant(ConstantPool owner, String value) {
            super(owner);
            this.value = value;
            owner._newKey.set(this.getTag(), value);
            owner._entryMap.put(owner._newKey.clone(), this);
            owner._newKey.clear();
        }

        @Override
        public Tag getTag() {
            return Tag.Utf8StringConstant;
        }

        @Override
        public int byteLength() {
            class SizeOutputStream
            extends OutputStream {
                private int size;

                SizeOutputStream() {
                }

                @Override
                public void write(int b) {
                    ++this.size;
                }
            }
            SizeOutputStream sizeOut = new SizeOutputStream();
            DataOutputStream out = new DataOutputStream(sizeOut);
            try {
                out.writeUTF(this.value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return 1 + sizeOut.size;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitUtf8StringConstant(this, data);
        }

        public String toString() {
            return "Utf8StringConstant[index: " + this.index + ", value: " + this.value + "]";
        }
    }

    public static final class StringConstant
    extends Entry {
        public final int stringIndex;

        public StringConstant(ConstantPool owner, int stringIndex) {
            super(owner);
            this.stringIndex = stringIndex;
            owner._newKey.set(this.getTag(), stringIndex);
            owner._entryMap.put(owner._newKey.clone(), this);
            owner._newKey.clear();
        }

        public String getValue() {
            return ((Utf8StringConstant)this.owner.get((int)this.stringIndex)).value;
        }

        @Override
        public Tag getTag() {
            return Tag.StringConstant;
        }

        @Override
        public int byteLength() {
            return 3;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitStringConstant(this, data);
        }

        public String toString() {
            return "StringConstant[index: " + this.index + ", stringIndex: " + this.stringIndex + "]";
        }
    }

    public static final class LongConstant
    extends Entry {
        public final long value;

        public LongConstant(ConstantPool owner, long value) {
            super(owner);
            this.value = value;
            owner._newKey.set(value);
            owner._entryMap.put(owner._newKey.clone(), this);
            owner._newKey.clear();
        }

        @Override
        public Tag getTag() {
            return Tag.LongConstant;
        }

        @Override
        public int byteLength() {
            return 9;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitLongConstant(this, data);
        }

        public String toString() {
            return "LongConstant[index: " + this.index + ", value: " + this.value + "]";
        }
    }

    public static final class IntegerConstant
    extends Entry {
        public final int value;

        public IntegerConstant(ConstantPool owner, int value) {
            super(owner);
            this.value = value;
            owner._newKey.set(value);
            owner._entryMap.put(owner._newKey.clone(), this);
            owner._newKey.clear();
        }

        @Override
        public Tag getTag() {
            return Tag.IntegerConstant;
        }

        @Override
        public int byteLength() {
            return 5;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitIntegerConstant(this, data);
        }

        public String toString() {
            return "IntegerConstant[index: " + this.index + ", value: " + this.value + "]";
        }
    }

    public static final class FloatConstant
    extends Entry {
        public final float value;

        public FloatConstant(ConstantPool owner, float value) {
            super(owner);
            this.value = value;
            owner._newKey.set(value);
            owner._entryMap.put(owner._newKey.clone(), this);
            owner._newKey.clear();
        }

        @Override
        public Tag getTag() {
            return Tag.FloatConstant;
        }

        @Override
        public int byteLength() {
            return 5;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitFloatConstant(this, data);
        }

        public String toString() {
            return "FloatConstant[index: " + this.index + ", value: " + this.value + "]";
        }
    }

    public static final class DoubleConstant
    extends Entry {
        public final double value;

        public DoubleConstant(ConstantPool owner, double value) {
            super(owner);
            this.value = value;
            owner._newKey.set(value);
            owner._entryMap.put(owner._newKey.clone(), this);
            owner._newKey.clear();
        }

        @Override
        public Tag getTag() {
            return Tag.DoubleConstant;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public int byteLength() {
            return 9;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitDoubleConstant(this, data);
        }

        public String toString() {
            return "DoubleConstant[index: " + this.index + ", value: " + this.value + "]";
        }
    }

    public static class InvokeDynamicInfo
    extends Entry {
        public final int bootstrapMethodAttributeIndex;
        public final int nameAndTypeDescriptorIndex;

        public InvokeDynamicInfo(ConstantPool owner, int bootstrapMethodAttributeIndex, int nameAndTypeDescriptorIndex) {
            super(owner);
            this.bootstrapMethodAttributeIndex = bootstrapMethodAttributeIndex;
            this.nameAndTypeDescriptorIndex = nameAndTypeDescriptorIndex;
            owner._newKey.set(this.getTag(), bootstrapMethodAttributeIndex, nameAndTypeDescriptorIndex);
            owner._entryMap.put(owner._newKey.clone(), this);
            owner._newKey.clear();
        }

        @Override
        public Tag getTag() {
            return Tag.InvokeDynamicInfo;
        }

        @Override
        public int byteLength() {
            return 5;
        }

        public NameAndTypeDescriptor getNameAndTypeDescriptor() {
            return (NameAndTypeDescriptor)this.owner.get(this.nameAndTypeDescriptorIndex, Tag.NameAndTypeDescriptor);
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitInvokeDynamicInfo(this, data);
        }

        public String toString() {
            return "InvokeDynamicInfo[bootstrapMethodAttributeIndex: " + this.bootstrapMethodAttributeIndex + ", nameAndTypeDescriptorIndex: " + this.nameAndTypeDescriptorIndex + "]";
        }
    }

    public static class NameAndTypeDescriptor
    extends Entry {
        public final int nameIndex;
        public final int typeDescriptorIndex;

        public NameAndTypeDescriptor(ConstantPool owner, int nameIndex, int typeDescriptorIndex) {
            super(owner);
            this.nameIndex = nameIndex;
            this.typeDescriptorIndex = typeDescriptorIndex;
            owner._newKey.set(this.getTag(), nameIndex, typeDescriptorIndex);
            owner._entryMap.put(owner._newKey.clone(), this);
            owner._newKey.clear();
        }

        @Override
        public Tag getTag() {
            return Tag.NameAndTypeDescriptor;
        }

        @Override
        public int byteLength() {
            return 5;
        }

        public String getName() {
            return ((Utf8StringConstant)this.owner.get((int)this.nameIndex, (Tag)Tag.Utf8StringConstant)).value;
        }

        public String getType() {
            return ((Utf8StringConstant)this.owner.get((int)this.typeDescriptorIndex, (Tag)Tag.Utf8StringConstant)).value;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitNameAndTypeDescriptor(this, data);
        }

        public String toString() {
            return "NameAndTypeDescriptor[index: " + this.index + ", descriptorIndex: " + this.nameIndex + ", typeDescriptorIndex: " + this.typeDescriptorIndex + "]";
        }
    }

    public static class MethodHandle
    extends Entry {
        public final ReferenceKind referenceKind;
        public final int referenceIndex;

        public MethodHandle(ConstantPool owner, ReferenceKind referenceKind, int referenceIndex) {
            super(owner);
            this.referenceKind = referenceKind;
            this.referenceIndex = referenceIndex;
            owner._newKey.set(this.getTag(), referenceIndex, referenceKind);
            owner._entryMap.put(owner._newKey.clone(), this);
            owner._newKey.clear();
        }

        public ReferenceEntry getReference() {
            Tag actual = this.owner.get(this.referenceIndex).getTag();
            Tag expected = Tag.MethodReference;
            switch (actual) {
                case FieldReference: 
                case InterfaceMethodReference: {
                    expected = actual;
                }
            }
            return (ReferenceEntry)this.owner.get(this.referenceIndex, expected);
        }

        @Override
        public Tag getTag() {
            return Tag.MethodHandle;
        }

        @Override
        public int byteLength() {
            return 4;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitMethodHandle(this, data);
        }
    }

    public static final class InterfaceMethodReference
    extends ReferenceEntry {
        public InterfaceMethodReference(ConstantPool owner, int typeIndex, int nameAndTypeDescriptorIndex) {
            super(owner, Tag.InterfaceMethodReference, typeIndex, nameAndTypeDescriptorIndex);
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitInterfaceMethodReference(this, data);
        }
    }

    public static final class MethodReference
    extends ReferenceEntry {
        public MethodReference(ConstantPool owner, int typeIndex, int nameAndTypeDescriptorIndex) {
            super(owner, Tag.MethodReference, typeIndex, nameAndTypeDescriptorIndex);
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitMethodReference(this, data);
        }
    }

    public static final class FieldReference
    extends ReferenceEntry {
        public FieldReference(ConstantPool owner, int typeIndex, int nameAndTypeDescriptorIndex) {
            super(owner, Tag.FieldReference, typeIndex, nameAndTypeDescriptorIndex);
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitFieldReference(this, data);
        }
    }

    public static abstract class ReferenceEntry
    extends Entry {
        public final Tag tag;
        public final int typeInfoIndex;
        public final int nameAndTypeDescriptorIndex;

        protected ReferenceEntry(ConstantPool cp, Tag tag, int typeInfoIndex, int nameAndTypeDescriptorIndex) {
            super(cp);
            this.tag = tag;
            this.typeInfoIndex = typeInfoIndex;
            this.nameAndTypeDescriptorIndex = nameAndTypeDescriptorIndex;
            this.owner._newKey.set(tag, typeInfoIndex, nameAndTypeDescriptorIndex);
            this.owner._entryMap.put(this.owner._newKey.clone(), this);
            this.owner._newKey.clear();
        }

        @Override
        public Tag getTag() {
            return this.tag;
        }

        @Override
        public int byteLength() {
            return 5;
        }

        public TypeInfo getClassInfo() {
            return (TypeInfo)this.owner.get(this.typeInfoIndex, Tag.TypeInfo);
        }

        public String getClassName() {
            return this.getClassInfo().getName();
        }

        public NameAndTypeDescriptor getNameAndTypeInfo() {
            return (NameAndTypeDescriptor)this.owner.get(this.nameAndTypeDescriptorIndex, Tag.NameAndTypeDescriptor);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[index: " + this.index + ", typeInfoIndex: " + this.typeInfoIndex + ", nameAndTypeDescriptorIndex: " + this.nameAndTypeDescriptorIndex + "]";
        }
    }

    public static final class MethodType
    extends Entry {
        public final int descriptorIndex;

        public MethodType(ConstantPool owner, int descriptorIndex) {
            super(owner);
            this.descriptorIndex = descriptorIndex;
            owner._newKey.set(this.getTag(), descriptorIndex);
            owner._entryMap.put(owner._newKey.clone(), this);
            owner._newKey.clear();
        }

        public String getType() {
            return ((Utf8StringConstant)this.owner.get((int)this.descriptorIndex, (Tag)Tag.Utf8StringConstant)).value;
        }

        @Override
        public Tag getTag() {
            return Tag.MethodType;
        }

        @Override
        public int byteLength() {
            return 3;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitMethodType(this, data);
        }

        public String toString() {
            return "MethodType[index: " + this.index + ", descriptorIndex: " + this.descriptorIndex + "]";
        }
    }

    public static final class TypeInfo
    extends Entry {
        public final int nameIndex;

        public TypeInfo(ConstantPool owner, int nameIndex) {
            super(owner);
            this.nameIndex = nameIndex;
            owner._newKey.set(this.getTag(), nameIndex);
            owner._entryMap.put(owner._newKey.clone(), this);
            owner._newKey.clear();
        }

        public String getName() {
            return ((Utf8StringConstant)this.owner.get((int)this.nameIndex, (Tag)Tag.Utf8StringConstant)).value;
        }

        @Override
        public Tag getTag() {
            return Tag.TypeInfo;
        }

        @Override
        public int byteLength() {
            return 3;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitTypeInfo(this, data);
        }

        public String toString() {
            return "TypeIndex[index: " + this.index + ", nameIndex: " + this.nameIndex + "]";
        }
    }

    private static final class Writer
    implements Visitor<Void, CodeStream> {
        private Writer() {
        }

        @Override
        public Void visitTypeInfo(TypeInfo info, CodeStream codeStream) {
            codeStream.putByte(info.getTag().value);
            codeStream.putShort(info.nameIndex);
            return null;
        }

        @Override
        public Void visitDoubleConstant(DoubleConstant info, CodeStream codeStream) {
            codeStream.putByte(info.getTag().value);
            codeStream.putDouble(info.value);
            return null;
        }

        @Override
        public Void visitFieldReference(FieldReference info, CodeStream codeStream) {
            codeStream.putByte(info.getTag().value);
            codeStream.putShort(info.typeInfoIndex);
            codeStream.putShort(info.nameAndTypeDescriptorIndex);
            return null;
        }

        @Override
        public Void visitFloatConstant(FloatConstant info, CodeStream codeStream) {
            codeStream.putByte(info.getTag().value);
            codeStream.putFloat(info.value);
            return null;
        }

        @Override
        public Void visitIntegerConstant(IntegerConstant info, CodeStream codeStream) {
            codeStream.putByte(info.getTag().value);
            codeStream.putInt(info.value);
            return null;
        }

        @Override
        public Void visitInterfaceMethodReference(InterfaceMethodReference info, CodeStream codeStream) {
            codeStream.putByte(info.getTag().value);
            codeStream.putShort(info.typeInfoIndex);
            codeStream.putShort(info.nameAndTypeDescriptorIndex);
            return null;
        }

        @Override
        public Void visitInvokeDynamicInfo(InvokeDynamicInfo info, CodeStream codeStream) {
            codeStream.putByte(info.getTag().value);
            codeStream.putShort(info.bootstrapMethodAttributeIndex);
            codeStream.putShort(info.nameAndTypeDescriptorIndex);
            return null;
        }

        @Override
        public Void visitLongConstant(LongConstant info, CodeStream codeStream) {
            codeStream.putByte(info.getTag().value);
            codeStream.putLong(info.value);
            return null;
        }

        @Override
        public Void visitNameAndTypeDescriptor(NameAndTypeDescriptor info, CodeStream codeStream) {
            codeStream.putByte(info.getTag().value);
            codeStream.putShort(info.nameIndex);
            codeStream.putShort(info.typeDescriptorIndex);
            return null;
        }

        @Override
        public Void visitMethodReference(MethodReference info, CodeStream codeStream) {
            codeStream.putByte(info.getTag().value);
            codeStream.putShort(info.typeInfoIndex);
            codeStream.putShort(info.nameAndTypeDescriptorIndex);
            return null;
        }

        @Override
        public Void visitMethodHandle(MethodHandle info, CodeStream codeStream) {
            codeStream.putByte(info.getTag().value);
            codeStream.putShort(info.referenceKind.ordinal());
            codeStream.putShort(info.referenceIndex);
            return null;
        }

        @Override
        public Void visitMethodType(MethodType info, CodeStream codeStream) {
            codeStream.putByte(info.getTag().value);
            codeStream.putShort(info.descriptorIndex);
            return null;
        }

        @Override
        public Void visitStringConstant(StringConstant info, CodeStream codeStream) {
            codeStream.putByte(info.getTag().value);
            codeStream.putShort(info.stringIndex);
            return null;
        }

        @Override
        public Void visitUtf8StringConstant(Utf8StringConstant info, CodeStream codeStream) {
            codeStream.putByte(info.getTag().value);
            codeStream.putUtf8(info.value);
            return null;
        }
    }

    public static interface Visitor<R, P> {
        public R visitTypeInfo(TypeInfo var1, P var2);

        public R visitDoubleConstant(DoubleConstant var1, P var2);

        public R visitFieldReference(FieldReference var1, P var2);

        public R visitFloatConstant(FloatConstant var1, P var2);

        public R visitIntegerConstant(IntegerConstant var1, P var2);

        public R visitInterfaceMethodReference(InterfaceMethodReference var1, P var2);

        public R visitInvokeDynamicInfo(InvokeDynamicInfo var1, P var2);

        public R visitLongConstant(LongConstant var1, P var2);

        public R visitNameAndTypeDescriptor(NameAndTypeDescriptor var1, P var2);

        public R visitMethodReference(MethodReference var1, P var2);

        public R visitMethodHandle(MethodHandle var1, P var2);

        public R visitMethodType(MethodType var1, P var2);

        public R visitStringConstant(StringConstant var1, P var2);

        public R visitUtf8StringConstant(Utf8StringConstant var1, P var2);
    }

    public static enum Tag {
        Utf8StringConstant(1),
        IntegerConstant(3),
        FloatConstant(4),
        LongConstant(5),
        DoubleConstant(6),
        TypeInfo(7),
        StringConstant(8),
        FieldReference(9),
        MethodReference(10),
        InterfaceMethodReference(11),
        NameAndTypeDescriptor(12),
        MethodHandle(15),
        MethodType(16),
        InvokeDynamicInfo(18);

        public final int value;

        private Tag(int value) {
            this.value = value;
        }
    }

    public static enum ReferenceKind {
        GetField(1, "getfield"),
        GetStatic(2, "getstatic"),
        PutField(3, "putfield"),
        PutStatic(4, "putstatic"),
        InvokeVirtual(5, "invokevirtual"),
        InvokeStatic(6, "invokestatic"),
        InvokeSpecial(7, "invokespecial"),
        NewInvokeSpecial(8, "newinvokespecial"),
        InvokeInterface(9, "invokeinterface");

        public final int tag;
        public final String name;

        private ReferenceKind(int tag, String name) {
            this.tag = tag;
            this.name = name;
        }

        static ReferenceKind fromTag(int tag) {
            switch (tag) {
                case 1: {
                    return GetField;
                }
                case 2: {
                    return GetStatic;
                }
                case 3: {
                    return PutField;
                }
                case 4: {
                    return PutStatic;
                }
                case 5: {
                    return InvokeVirtual;
                }
                case 6: {
                    return InvokeStatic;
                }
                case 7: {
                    return InvokeSpecial;
                }
                case 8: {
                    return NewInvokeSpecial;
                }
                case 9: {
                    return InvokeInterface;
                }
            }
            return null;
        }
    }

    public static abstract class Entry {
        protected final int index;
        protected final ConstantPool owner;

        Entry(ConstantPool owner) {
            this.owner = owner;
            this.index = owner._size + 1;
            owner._pool.add(this);
            owner._size = owner._size + this.size();
            for (int i = 1; i < this.size(); ++i) {
                owner._pool.add(null);
            }
        }

        public abstract Tag getTag();

        public int size() {
            return 1;
        }

        public abstract int byteLength();

        public abstract <R, D> R accept(Visitor<R, D> var1, D var2);
    }
}

