/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.annotations.NotNull;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.ArrayType;
import com.strobel.reflection.BindingFlags;
import com.strobel.reflection.CallingConvention;
import com.strobel.reflection.ConstructorInfo;
import com.strobel.reflection.ConstructorList;
import com.strobel.reflection.Error;
import com.strobel.reflection.FieldInfo;
import com.strobel.reflection.FieldList;
import com.strobel.reflection.MemberList;
import com.strobel.reflection.MemberType;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.MethodList;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeBindings;
import com.strobel.reflection.TypeList;
import com.strobel.reflection.TypeVisitor;
import com.strobel.util.ContractUtils;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.lang.model.type.TypeKind;

final class PrimitiveType<T>
extends Type<T> {
    private final Class<T> _class;
    private final String _signature;
    private final String _description;
    private final TypeKind _kind;

    PrimitiveType(Class<T> clazz, char signature, String description, TypeKind kind) {
        this._class = (Class)VerifyArgument.notNull(clazz, (String)"clazz");
        if (!clazz.isPrimitive()) {
            throw Error.notPrimitiveType(clazz);
        }
        this._kind = (TypeKind)((Object)VerifyArgument.notNull((Object)((Object)kind), (String)"kind"));
        this._signature = String.valueOf(signature);
        this._description = (String)VerifyArgument.notNull((Object)description, (String)"description");
    }

    @Override
    public TypeKind getKind() {
        return this._kind;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public Class<T> getErasedClass() {
        return this._class;
    }

    @Override
    protected TypeBindings getTypeBindings() {
        return TypeBindings.empty();
    }

    @Override
    public MemberList<?> getMember(String name, Set<BindingFlags> bindingFlags, Set<MemberType> memberTypes) {
        return MemberList.empty();
    }

    @Override
    public FieldInfo getField(String name, Set<BindingFlags> bindingFlags) {
        return null;
    }

    @Override
    public MethodInfo getMethod(String name, Set<BindingFlags> bindingFlags, CallingConvention callingConvention, Type<?> ... parameterTypes) {
        return null;
    }

    @Override
    public ConstructorInfo getConstructor(Set<BindingFlags> bindingFlags, CallingConvention callingConvention, Type<?> ... parameterTypes) {
        return null;
    }

    @Override
    public MemberList<?> getMembers(Set<BindingFlags> bindingFlags, Set<MemberType> memberTypes) {
        return MemberList.empty();
    }

    @Override
    public FieldList getFields(Set<BindingFlags> bindingFlags) {
        return FieldList.empty();
    }

    @Override
    public MethodList getMethods(Set<BindingFlags> bindingFlags, CallingConvention callingConvention) {
        return MethodList.empty();
    }

    @Override
    public ConstructorList getConstructors(Set<BindingFlags> bindingFlags) {
        return ConstructorList.empty();
    }

    @Override
    public TypeList getNestedTypes(Set<BindingFlags> bindingFlags) {
        return TypeList.empty();
    }

    @Override
    protected Type<T[]> createArrayType() {
        if (this.getKind() == TypeKind.VOID) {
            throw ContractUtils.unsupported();
        }
        return new ArrayType<T[]>(this);
    }

    @Override
    public MemberType getMemberType() {
        return MemberType.TypeInfo;
    }

    @Override
    public String getFullName() {
        return this._class.getName();
    }

    @Override
    public String getInternalName() {
        return this._signature;
    }

    @Override
    public Type<?> getDeclaringType() {
        return null;
    }

    @Override
    public int getModifiers() {
        return this._class.getModifiers();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this._class.isAnnotationPresent(annotationClass);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return this._class.getAnnotation(annotationClass);
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        return this._class.getAnnotations();
    }

    @Override
    @NotNull
    public Annotation[] getDeclaredAnnotations() {
        return this._class.getDeclaredAnnotations();
    }

    @Override
    public <P, R> R accept(TypeVisitor<P, R> visitor, P parameter) {
        return visitor.visitPrimitiveType(this, parameter);
    }

    @Override
    public StringBuilder appendSignature(StringBuilder sb) {
        sb.append(this._signature);
        return sb;
    }

    @Override
    public StringBuilder appendErasedSignature(StringBuilder sb) {
        sb.append(this._signature);
        return sb;
    }

    @Override
    public StringBuilder appendDescription(StringBuilder sb) {
        sb.append(this._description);
        return sb;
    }

    @Override
    public StringBuilder appendBriefDescription(StringBuilder sb) {
        sb.append(this._description);
        return sb;
    }

    @Override
    public StringBuilder appendSimpleDescription(StringBuilder sb) {
        sb.append(this._description);
        return sb;
    }
}

