/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.annotations.NotNull;
import com.strobel.core.ArrayUtilities;
import com.strobel.core.Fences;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.CallingConvention;
import com.strobel.reflection.GenericParameter;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.ParameterList;
import com.strobel.reflection.SignatureType;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeBindings;
import com.strobel.reflection.TypeList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;

class ReflectedMethod
extends MethodInfo {
    private final MethodInfo _baseMethod;
    private final Type<?> _declaringType;
    private final Method _rawMethod;
    private final ParameterList _parameters;
    private final SignatureType _signatureType;
    private final TypeBindings _bindings;
    private final TypeList _thrownTypes;
    private final Type<?> _reflectedType;

    ReflectedMethod(MethodInfo baseMethod, Type<?> declaringType, Method rawMethod, ParameterList parameters, Type<?> returnType, TypeList thrownTypes, TypeBindings bindings) {
        this(baseMethod, declaringType, declaringType, rawMethod, parameters, returnType, thrownTypes, bindings);
    }

    ReflectedMethod(MethodInfo baseMethod, Type<?> declaringType, Type<?> reflectedType, Method rawMethod, ParameterList parameters, Type<?> returnType, TypeList thrownTypes, TypeBindings bindings) {
        this._baseMethod = baseMethod;
        Type[] genericParameters = null;
        int n = bindings.size();
        for (int i = 0; i < n; ++i) {
            GenericParameter gp;
            TypeVariable<?> typeVariable;
            Type p = bindings.getGenericParameter(i);
            if (!(p instanceof GenericParameter) || (typeVariable = (gp = (GenericParameter)p).getRawTypeVariable()).getGenericDeclaration() != rawMethod) continue;
            gp.setDeclaringMethod(this);
            genericParameters = genericParameters == null ? new Type[]{gp} : (Type[])ArrayUtilities.append(genericParameters, (Object)gp);
            if (!bindings.hasBoundParameter(gp)) continue;
            throw new IllegalArgumentException("ReflectedMethod cannot be used with bound generic method parameters.  Use GenericMethod instead.");
        }
        this._declaringType = (Type)VerifyArgument.notNull(declaringType, (String)"declaringType");
        this._reflectedType = (Type)VerifyArgument.notNull(reflectedType, (String)"reflectedType");
        this._rawMethod = (Method)VerifyArgument.notNull((Object)rawMethod, (String)"rawMethod");
        this._parameters = (ParameterList)((Object)VerifyArgument.notNull((Object)((Object)parameters), (String)"parameters"));
        this._signatureType = new SignatureType((Type)VerifyArgument.notNull(returnType, (String)"returnType"), this._parameters.getParameterTypes());
        this._thrownTypes = (TypeList)((Object)VerifyArgument.notNull((Object)((Object)thrownTypes), (String)"thrownTypes"));
        this._bindings = genericParameters == null ? TypeBindings.empty() : TypeBindings.createUnbound(new TypeList(genericParameters));
    }

    @Override
    public Type<?> getReturnType() {
        return this._signatureType.getReturnType();
    }

    @Override
    public SignatureType getSignatureType() {
        return this._signatureType;
    }

    @Override
    public Method getRawMethod() {
        return this._rawMethod;
    }

    @Override
    public Type<?> getDeclaringType() {
        return this._declaringType;
    }

    @Override
    public Type<?> getReflectedType() {
        return this._reflectedType;
    }

    @Override
    public int getModifiers() {
        return this._rawMethod.getModifiers();
    }

    @Override
    public ParameterList getParameters() {
        return this._parameters;
    }

    @Override
    public TypeList getThrownTypes() {
        return this._thrownTypes;
    }

    @Override
    public CallingConvention getCallingConvention() {
        return this._rawMethod.isVarArgs() ? CallingConvention.VarArgs : CallingConvention.Standard;
    }

    @Override
    protected TypeBindings getTypeBindings() {
        return this._bindings;
    }

    @Override
    public MethodInfo getErasedMethodDefinition() {
        if (this._erasedMethodDefinition != null) {
            return this._erasedMethodDefinition;
        }
        if (this._baseMethod != null) {
            this._erasedMethodDefinition = (MethodInfo)Fences.orderWrites((Object)ReflectedMethod.reflectedOn(this._baseMethod.getErasedMethodDefinition(), this.getReflectedType()));
        }
        return super.getErasedMethodDefinition();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this._rawMethod.getAnnotation(annotationClass);
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        return this._rawMethod.getAnnotations();
    }

    @Override
    @NotNull
    public Annotation[] getDeclaredAnnotations() {
        return this._rawMethod.getDeclaredAnnotations();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this._rawMethod.isAnnotationPresent(annotationClass);
    }

    @Override
    public StringBuilder appendErasedDescription(StringBuilder sb) {
        if (this._baseMethod != null) {
            return this._baseMethod.appendErasedDescription(sb);
        }
        return super.appendErasedDescription(sb);
    }

    @Override
    public StringBuilder appendErasedSignature(StringBuilder sb) {
        if (this._baseMethod != null) {
            return this._baseMethod.appendErasedSignature(sb);
        }
        return super.appendErasedSignature(sb);
    }
}

