/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.annotations.NotNull;
import com.strobel.core.Fences;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.BindingFlags;
import com.strobel.reflection.ErasedType;
import com.strobel.reflection.MemberInfo;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.ParameterList;
import com.strobel.reflection.RuntimeTypeCache;
import com.strobel.reflection.SignatureType;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeBinder;
import com.strobel.reflection.TypeBindings;
import com.strobel.reflection.TypeList;
import com.strobel.reflection.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Set;

final class RuntimeMethodInfo
extends MethodInfo {
    private final MethodInfo _baseMethod;
    private final Method _rawMethod;
    private final Type<?> _declaringType;
    private final RuntimeTypeCache<?> _reflectedTypeCache;
    private final int _modifiers;
    private final Set<BindingFlags> _bindingFlags;
    private final ParameterList _parameters;
    private final SignatureType _signatureType;
    private final TypeList _thrownTypes;
    private final TypeBindings _typeBindings;

    RuntimeMethodInfo(MethodInfo baseMethod, Method rawMethod, Type<?> declaringType, RuntimeTypeCache<?> reflectedTypeCache, int modifiers, Set<BindingFlags> bindingFlags, ParameterList parameters, Type<?> returnType, TypeList thrownTypes, TypeBindings typeBindings) {
        this._baseMethod = baseMethod;
        this._rawMethod = (Method)VerifyArgument.notNull((Object)rawMethod, (String)"rawMethod");
        this._declaringType = (Type)VerifyArgument.notNull(declaringType, (String)"declaringType");
        this._reflectedTypeCache = (RuntimeTypeCache)VerifyArgument.notNull(reflectedTypeCache, (String)"reflectedTypeCache");
        this._bindingFlags = (Set)VerifyArgument.notNull(bindingFlags, (String)"bindingFlags");
        this._modifiers = modifiers;
        this._parameters = (ParameterList)((Object)VerifyArgument.notNull((Object)((Object)parameters), (String)"parameters"));
        Type actualReturnType = TypeBinder.GET_CLASS_METHOD.equals(rawMethod) && !(declaringType instanceof ErasedType) ? Types.Class.makeGenericType(Type.makeExtendsWildcard(reflectedTypeCache.getRuntimeType())) : (Type)VerifyArgument.notNull(returnType, (String)"returnType");
        this._signatureType = new SignatureType(actualReturnType, this._parameters.getParameterTypes());
        this._thrownTypes = (TypeList)((Object)VerifyArgument.notNull((Object)((Object)thrownTypes), (String)"thrownTypes"));
        this._typeBindings = (TypeBindings)VerifyArgument.notNull((Object)typeBindings, (String)"typeBindings");
    }

    Set<BindingFlags> getBindingFlags() {
        return this._bindingFlags;
    }

    @Override
    public ParameterList getParameters() {
        return this._parameters;
    }

    @Override
    public Type<?> getReturnType() {
        return this._signatureType.getReturnType();
    }

    @Override
    public SignatureType getSignatureType() {
        return this._signatureType;
    }

    @Override
    public Method getRawMethod() {
        return this._rawMethod;
    }

    @Override
    public String getName() {
        return this._rawMethod.getName();
    }

    @Override
    public Type<?> getDeclaringType() {
        return this._declaringType;
    }

    @Override
    public Type<?> getReflectedType() {
        return this._reflectedTypeCache.getRuntimeType();
    }

    @Override
    public TypeList getThrownTypes() {
        return this._thrownTypes;
    }

    @Override
    protected TypeBindings getTypeBindings() {
        return this._typeBindings;
    }

    @Override
    public int getModifiers() {
        return this._modifiers;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this._rawMethod.isAnnotationPresent(annotationClass);
    }

    @Override
    @NotNull
    public Annotation[] getDeclaredAnnotations() {
        return this._rawMethod.getDeclaredAnnotations();
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        return this._rawMethod.getAnnotations();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this._rawMethod.getAnnotation(annotationClass);
    }

    @Override
    public boolean isEquivalentTo(MemberInfo m) {
        if (m == this) {
            return true;
        }
        if (m instanceof RuntimeMethodInfo) {
            RuntimeMethodInfo other = (RuntimeMethodInfo)m;
            if (other._declaringType == this._declaringType && other._rawMethod == this._rawMethod) {
                return true;
            }
        }
        return super.isEquivalentTo(m);
    }

    @Override
    public MethodInfo getErasedMethodDefinition() {
        if (this._erasedMethodDefinition != null) {
            return this._erasedMethodDefinition;
        }
        if (((RuntimeMethodInfo)Fences.orderReads((Object)this))._erasedMethodDefinition != null) {
            return this._erasedMethodDefinition;
        }
        if (this._baseMethod != null) {
            this._erasedMethodDefinition = (MethodInfo)Fences.orderWrites((Object)RuntimeMethodInfo.reflectedOn(this._baseMethod.getErasedMethodDefinition(), this.getReflectedType()));
            Fences.orderAccesses((Object)this);
        }
        return super.getErasedMethodDefinition();
    }

    @Override
    public StringBuilder appendErasedDescription(StringBuilder sb) {
        if (this._baseMethod != null) {
            return this._baseMethod.appendErasedDescription(sb);
        }
        return super.appendErasedDescription(sb);
    }

    @Override
    public StringBuilder appendErasedSignature(StringBuilder sb) {
        if (this._baseMethod != null) {
            return this._baseMethod.appendErasedSignature(sb);
        }
        return super.appendErasedSignature(sb);
    }
}

