/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.collections.ImmutableList;
import com.strobel.core.Comparer;
import com.strobel.core.Fences;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.BindingFlags;
import com.strobel.reflection.ConstructorInfo;
import com.strobel.reflection.Error;
import com.strobel.reflection.FieldInfo;
import com.strobel.reflection.FieldList;
import com.strobel.reflection.Helper;
import com.strobel.reflection.MemberInfo;
import com.strobel.reflection.MemberListType;
import com.strobel.reflection.MethodBase;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.RuntimeConstructorInfo;
import com.strobel.reflection.RuntimeFieldInfo;
import com.strobel.reflection.RuntimeMethodInfo;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeList;
import com.strobel.util.ContractUtils;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.lang.model.type.TypeKind;

final class RuntimeTypeCache<T> {
    private WhatsCached _whatsCached;
    private Class<T> _erasedClass;
    private final Type<T> _runtimeType;
    private Type<?> _enclosingType;
    private final TypeKind _typeKind = TypeKind.DECLARED;
    private String _name;
    private String _fullName;
    private String _internalName;
    private String _genericSignature;
    private Package _package;
    private MemberInfoCache<RuntimeMethodInfo> _methodCache;
    private MemberInfoCache<RuntimeConstructorInfo> _constructorCache;
    private MemberInfoCache<RuntimeFieldInfo> _fieldCache;
    private MemberInfoCache<Type<?>> _interfaceCache;
    private MemberInfoCache<Type<?>> _nestedTypeCache;

    RuntimeTypeCache(Type<T> runtimeType) {
        this._runtimeType = runtimeType;
    }

    Class<T> getErasedClass() {
        if (this._erasedClass == null) {
            String fullName = this.getFullName();
            try {
                this._erasedClass = Class.forName(fullName);
            }
            catch (ClassNotFoundException e) {
                throw Error.couldNotResolveType(fullName);
            }
        }
        return this._erasedClass;
    }

    Package getPackage() {
        if (this._package == null) {
            String fullName = this._runtimeType.getClassFullName();
            int lastDotPosition = fullName.lastIndexOf(46);
            this._package = lastDotPosition < 0 ? Package.getPackage("") : Package.getPackage(fullName.substring(0, lastDotPosition));
        }
        return this._package;
    }

    TypeKind getTypeKind() {
        return this._typeKind;
    }

    String getName() {
        if (this._name == null) {
            this._name = this._runtimeType._appendClassName(new StringBuilder(), false, true).toString();
        }
        return this._name;
    }

    String getFullName() {
        if (this._fullName == null) {
            this._fullName = this._runtimeType._appendClassName(new StringBuilder(), true, true).toString();
        }
        return this._fullName;
    }

    String getInternalName() {
        if (this._internalName == null) {
            this._internalName = this._runtimeType._appendClassName(new StringBuilder(), true, false).toString();
        }
        return this._internalName;
    }

    String getGenericSignature() {
        if (this._genericSignature == null) {
            this._genericSignature = this._runtimeType.appendGenericSignature(new StringBuilder()).toString();
        }
        return this._genericSignature;
    }

    Type<T> getRuntimeType() {
        return this._runtimeType;
    }

    Type<?> getEnclosingType() {
        if (this._whatsCached != WhatsCached.EnclosingType) {
            this._enclosingType = this.getRuntimeType().getDeclaringType();
            this._whatsCached = WhatsCached.EnclosingType;
        }
        return this._enclosingType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<RuntimeMethodInfo> getMethodList(MemberListType listType, String name) {
        if (this._methodCache == null) {
            Object object = Type.CACHE_LOCK;
            synchronized (object) {
                if (this._methodCache == null) {
                    this._methodCache = (MemberInfoCache)Fences.orderWrites(new MemberInfoCache(this));
                }
            }
        }
        return this._methodCache.getMemberList(listType, name, CacheType.Method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<RuntimeConstructorInfo> getConstructorList(MemberListType listType, String name) {
        if (this._constructorCache == null) {
            Object object = Type.CACHE_LOCK;
            synchronized (object) {
                if (this._constructorCache == null) {
                    this._constructorCache = (MemberInfoCache)Fences.orderWrites(new MemberInfoCache(this));
                }
            }
        }
        return this._constructorCache.getMemberList(listType, name, CacheType.Constructor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<RuntimeFieldInfo> getFieldList(MemberListType listType, String name) {
        if (this._fieldCache == null) {
            Object object = Type.CACHE_LOCK;
            synchronized (object) {
                if (this._fieldCache == null) {
                    this._fieldCache = (MemberInfoCache)Fences.orderWrites(new MemberInfoCache(this));
                }
            }
        }
        return this._fieldCache.getMemberList(listType, name, CacheType.Field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<Type<?>> getInterfaceList(MemberListType listType, String name) {
        if (this._interfaceCache == null) {
            Object object = Type.CACHE_LOCK;
            synchronized (object) {
                if (this._interfaceCache == null) {
                    this._interfaceCache = (MemberInfoCache)Fences.orderWrites(new MemberInfoCache(this));
                }
            }
        }
        return this._interfaceCache.getMemberList(listType, name, CacheType.Interface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<Type<?>> getNestedTypeList(MemberListType listType, String name) {
        if (this._nestedTypeCache == null) {
            Object object = Type.CACHE_LOCK;
            synchronized (object) {
                if (this._nestedTypeCache == null) {
                    this._nestedTypeCache = (MemberInfoCache)Fences.orderWrites(new MemberInfoCache(this));
                }
            }
        }
        return this._nestedTypeCache.getMemberList(listType, name, CacheType.NestedType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MethodBase getMethod(Type<? super T> declaringType, MethodInfo method) {
        if (this._methodCache == null) {
            Object object = Type.CACHE_LOCK;
            synchronized (object) {
                if (this._methodCache == null) {
                    this._methodCache = (MemberInfoCache)Fences.orderWrites(new MemberInfoCache(this));
                }
            }
        }
        return this._methodCache.addMethod(declaringType, method, CacheType.Method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MethodBase getConstructor(Type<? super T> declaringType, MethodInfo constructor) {
        if (this._constructorCache == null) {
            Object object = Type.CACHE_LOCK;
            synchronized (object) {
                if (this._constructorCache == null) {
                    this._constructorCache = (MemberInfoCache)Fences.orderWrites(new MemberInfoCache(this));
                }
            }
        }
        return this._constructorCache.addMethod(declaringType, constructor, CacheType.Constructor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FieldInfo getField(FieldInfo field) {
        if (this._fieldCache == null) {
            Object object = Type.CACHE_LOCK;
            synchronized (object) {
                if (this._fieldCache == null) {
                    this._fieldCache = (MemberInfoCache)Fences.orderWrites(new MemberInfoCache(this));
                }
            }
        }
        return this._fieldCache.addField(field);
    }

    static final class MemberInfoCache<T extends MemberInfo> {
        private HashMap<String, ArrayList<T>> _caseSensitiveMembers;
        private HashMap<String, ArrayList<T>> _caseInsensitiveMembers;
        private ArrayList<T> _root;
        private boolean _cacheComplete;
        private final RuntimeTypeCache<?> _typeCache;

        private MemberInfoCache(RuntimeTypeCache<?> typeCache) {
            this._typeCache = (RuntimeTypeCache)VerifyArgument.notNull(typeCache, (String)"typeCache");
            this._cacheComplete = false;
        }

        Type<?> getReflectedType() {
            return this._typeCache.getRuntimeType();
        }

        private void mergeWithGlobalList(ArrayList<T> list) {
            int cachedCount = this._root.size();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                MemberInfo newMemberInfo = (MemberInfo)list.get(i);
                MemberInfo cachedMemberInfo = null;
                for (int j = 0; j < cachedCount; ++j) {
                    cachedMemberInfo = (MemberInfo)this._root.get(j);
                    if (!newMemberInfo.equals(cachedMemberInfo)) continue;
                    list.set(i, cachedMemberInfo);
                    break;
                }
                if (list.get(i) == cachedMemberInfo) continue;
                this._root.add(newMemberInfo);
            }
        }

        ArrayList<T> getMemberList(MemberListType listType, String name, CacheType cacheType) {
            switch (listType) {
                case CaseSensitive: {
                    if (this._caseSensitiveMembers == null) {
                        return this.populate(name, listType, cacheType);
                    }
                    ArrayList<T> list = this._caseSensitiveMembers.get(name);
                    if (list == null) {
                        return this.populate(name, listType, cacheType);
                    }
                    return list;
                }
                case All: {
                    if (this._cacheComplete) {
                        return this._root;
                    }
                    return this.populate(null, listType, cacheType);
                }
            }
            if (this._caseInsensitiveMembers == null) {
                return this.populate(name, listType, cacheType);
            }
            ArrayList<T> list = this._caseInsensitiveMembers.get(name);
            if (list == null) {
                return this.populate(name, listType, cacheType);
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ArrayList<T> insert(ArrayList<T> list, String name, MemberListType listType) {
            boolean preallocationComplete = false;
            ArrayList<T> result = list;
            MemberInfoCache memberInfoCache = this;
            synchronized (memberInfoCache) {
                try {
                    if (listType == MemberListType.CaseSensitive) {
                        if (this._caseSensitiveMembers == null) {
                            this._caseSensitiveMembers = new HashMap(1);
                        }
                    } else if (listType == MemberListType.CaseInsensitive && this._caseInsensitiveMembers == null) {
                        this._caseInsensitiveMembers = new HashMap(1);
                    }
                    if (this._root == null) {
                        this._root = new ArrayList(list.size());
                    }
                    preallocationComplete = true;
                }
                finally {
                    if (preallocationComplete) {
                        if (listType == MemberListType.CaseSensitive) {
                            ArrayList<T> cachedList = this._caseSensitiveMembers.get(name);
                            if (cachedList == null) {
                                this.mergeWithGlobalList(list);
                                this._caseSensitiveMembers.put(name, list);
                            } else {
                                result = cachedList;
                            }
                        } else if (listType == MemberListType.CaseInsensitive) {
                            ArrayList<T> cachedList = this._caseInsensitiveMembers.get(name);
                            if (cachedList == null) {
                                this.mergeWithGlobalList(list);
                                this._caseInsensitiveMembers.put(name, list);
                            } else {
                                result = cachedList;
                            }
                        } else {
                            this.mergeWithGlobalList(list);
                        }
                        if (listType == MemberListType.All) {
                            this._cacheComplete = true;
                        }
                    }
                }
            }
            return result;
        }

        MethodBase addMethod(Type<?> declaringType, MethodBase method, CacheType cacheType) {
            ArrayList<RuntimeConstructorInfo> list;
            int modifiers = ((MethodBase)VerifyArgument.notNull((Object)method, (String)"method")).getModifiers();
            boolean isPublic = Modifier.isPublic(modifiers);
            boolean isStatic = Modifier.isStatic(modifiers);
            boolean isInherited = !Comparer.equals(declaringType, this.getReflectedType());
            Set<BindingFlags> bindingFlags = Type.filterPreCalculate(isPublic, isInherited, isStatic);
            switch (cacheType) {
                case Method: {
                    ArrayList<RuntimeMethodInfo> methodList = new ArrayList<RuntimeMethodInfo>(1);
                    MethodInfo sourceMethod = (MethodInfo)method;
                    methodList.add(new RuntimeMethodInfo(sourceMethod, sourceMethod.getRawMethod(), declaringType, this._typeCache, modifiers, bindingFlags, method.getParameters(), sourceMethod.getReturnType(), method.getThrownTypes(), sourceMethod.getTypeBindings()));
                    list = methodList;
                    break;
                }
                case Constructor: {
                    ArrayList<RuntimeConstructorInfo> constructorList = new ArrayList<RuntimeConstructorInfo>(1);
                    constructorList.add(new RuntimeConstructorInfo(((ConstructorInfo)method).getRawConstructor(), this._typeCache, modifiers, bindingFlags, method.getParameters()));
                    list = constructorList;
                    break;
                }
                default: {
                    throw ContractUtils.unreachable();
                }
            }
            return (MethodBase)this.insert(list, null, MemberListType.HandleToInfo).get(0);
        }

        FieldInfo addField(FieldInfo field) {
            ArrayList<RuntimeFieldInfo> list = new ArrayList<RuntimeFieldInfo>(1);
            int modifiers = ((FieldInfo)VerifyArgument.notNull((Object)field, (String)"field")).getModifiers();
            boolean isPublic = Modifier.isPublic(modifiers);
            boolean isStatic = Modifier.isStatic(modifiers);
            Type<?> declaringType = field.getDeclaringType();
            boolean isInherited = !Comparer.equals(declaringType, this.getReflectedType());
            Set<BindingFlags> bindingFlags = Type.filterPreCalculate(isPublic, isInherited, isStatic);
            list.add(new RuntimeFieldInfo(field.getRawField(), declaringType, this._typeCache, modifiers, bindingFlags, field.getFieldType()));
            return (FieldInfo)this.insert(list, null, MemberListType.HandleToInfo).get(0);
        }

        private void populateRuntimeFields(Filter filter, FieldList declaredFields, Type<?> declaringType, ArrayList<RuntimeFieldInfo> list) {
            Type<?> reflectedType = this.getReflectedType();
            assert (declaringType != Type.nullType());
            assert (reflectedType != Type.nullType());
            boolean isInherited = !declaringType.equals(reflectedType);
            int n = declaredFields.size();
            for (int i = 0; i < n; ++i) {
                FieldInfo declaredField = (FieldInfo)declaredFields.get(i);
                if (!filter.match(declaredField.getName())) continue;
                assert (declaredField.getFieldType() != Type.nullType());
                int fieldModifiers = declaredField.getModifiers();
                if (isInherited && Modifier.isPrivate(fieldModifiers)) continue;
                boolean isPublic = Modifier.isPublic(fieldModifiers);
                boolean isStatic = Modifier.isStatic(fieldModifiers);
                Set<BindingFlags> bindingFlags = Type.filterPreCalculate(isPublic, isInherited, isStatic);
                RuntimeFieldInfo runtimeFieldInfo = new RuntimeFieldInfo(declaredField.getRawField(), declaringType, this._typeCache, fieldModifiers, bindingFlags, declaredField.getFieldType());
                list.add(runtimeFieldInfo);
            }
        }

        private ArrayList<RuntimeFieldInfo> populateFields(Filter filter) {
            Type<?> reflectedType;
            ArrayList<RuntimeFieldInfo> list = new ArrayList<RuntimeFieldInfo>();
            Type<?> declaringType = reflectedType = this.getReflectedType();
            while (declaringType.isGenericParameter()) {
                declaringType = declaringType.getExtendsBound();
            }
            while (declaringType != null && declaringType != Type.nullType()) {
                this.populateRuntimeFields(filter, declaringType.getDeclaredFields(), declaringType, list);
                declaringType = declaringType.getBaseType();
            }
            TypeList interfaces = reflectedType.isGenericParameter() ? reflectedType.getExtendsBound().getExplicitInterfaces() : reflectedType.getExplicitInterfaces();
            int n = interfaces.size();
            for (int i = 0; i < n; ++i) {
                Type interfaceType = (Type)interfaces.get(i);
                this.populateRuntimeFields(filter, interfaceType.getDeclaredFields(), interfaceType, list);
            }
            return list;
        }

        private ArrayList<RuntimeMethodInfo> populateMethods(Filter filter) {
            Type reflectedType;
            HashMap<String, ArrayList<RuntimeMethodInfo>> nameLookup = new HashMap<String, ArrayList<RuntimeMethodInfo>>();
            ArrayList<RuntimeMethodInfo> list = new ArrayList<RuntimeMethodInfo>();
            Type declaringType = reflectedType = this.getReflectedType();
            while (declaringType.isGenericParameter()) {
                declaringType = declaringType.getExtendsBound();
            }
            HashSet<String> included = new HashSet<String>();
            ArrayDeque<Type> stack = new ArrayDeque<Type>();
            stack.add(declaringType);
            while (!stack.isEmpty()) {
                Type baseType;
                declaringType = (Type)stack.removeFirst();
                boolean isInterface = declaringType.isInterface();
                Iterator iterator = declaringType.getDeclaredMethods().iterator();
                while (iterator.hasNext()) {
                    ArrayList<RuntimeMethodInfo> nameCollisions;
                    boolean isInherited;
                    MethodInfo method = (MethodInfo)iterator.next();
                    String name = method.getName();
                    if ((method.getModifiers() & 0x40) == 64 || !filter.match(name)) continue;
                    assert (method.getReturnType() != Type.nullType());
                    int methodModifiers = method.getModifiers();
                    assert (!isInterface || !Modifier.isFinal(methodModifiers));
                    boolean isVirtual = !Modifier.isFinal(methodModifiers);
                    boolean isPrivate = Modifier.isPrivate(methodModifiers);
                    boolean bl = isInherited = !declaringType.equals(reflectedType);
                    if (isInherited && isPrivate || MemberInfoCache.overrideExists(method, (ArrayList<? extends MethodInfo>)(nameCollisions = (ArrayList<RuntimeMethodInfo>)nameLookup.get(name)))) continue;
                    assert (isVirtual || !Modifier.isAbstract(methodModifiers));
                    boolean isPublic = Modifier.isPublic(methodModifiers);
                    boolean isStatic = Modifier.isStatic(methodModifiers);
                    Set<BindingFlags> bindingFlags = Type.filterPreCalculate(isPublic, isInherited, isStatic);
                    RuntimeMethodInfo runtimeMethod = new RuntimeMethodInfo(method, method.getRawMethod(), declaringType, this._typeCache, methodModifiers, bindingFlags, method.getParameters(), method.getReturnType(), method.getThrownTypes(), method.getTypeBindings());
                    if (nameCollisions == null) {
                        nameCollisions = new ArrayList<RuntimeMethodInfo>(1);
                        nameLookup.put(name, nameCollisions);
                    }
                    nameCollisions.add(runtimeMethod);
                    list.add(runtimeMethod);
                }
                if (!isInterface && (baseType = declaringType.getBaseType()) != null && baseType != Type.nullType() && included.add(baseType.getInternalName())) {
                    stack.addLast(baseType);
                }
                iterator = declaringType.getInterfaces().iterator();
                while (iterator.hasNext()) {
                    Type interfaceType = (Type)iterator.next();
                    if (!included.add(interfaceType.getInternalName())) continue;
                    stack.addLast(interfaceType);
                }
            }
            return list;
        }

        private static boolean overrideExists(MethodInfo method, ArrayList<? extends MethodInfo> methods) {
            if (methods == null) {
                return false;
            }
            int n = methods.size();
            for (int i = 0; i < n; ++i) {
                MethodInfo otherMethod = methods.get(i);
                if (otherMethod.getDeclaringType() == method.getDeclaringType() || !Helper.overrides(otherMethod, method)) continue;
                return true;
            }
            return false;
        }

        private ArrayList<RuntimeConstructorInfo> populateConstructors(Filter filter) {
            Type<?> reflectedType = this.getReflectedType();
            ArrayList<RuntimeConstructorInfo> list = new ArrayList<RuntimeConstructorInfo>();
            if (reflectedType.isGenericParameter()) {
                return list;
            }
            Iterator iterator = reflectedType.getDeclaredConstructors().iterator();
            while (iterator.hasNext()) {
                ConstructorInfo constructor = (ConstructorInfo)iterator.next();
                String name = constructor.getName();
                if (!filter.match(name)) continue;
                int modifiers = constructor.getModifiers();
                assert (constructor.getDeclaringType() != Type.nullType());
                boolean isPublic = Modifier.isPublic(modifiers);
                boolean isStatic = false;
                boolean isInherited = false;
                Set<BindingFlags> bindingFlags = Type.filterPreCalculate(isPublic, false, false);
                RuntimeConstructorInfo runtimeConstructorInfo = new RuntimeConstructorInfo(constructor.getRawConstructor(), this._typeCache, modifiers, bindingFlags, constructor.getParameters());
                list.add(runtimeConstructorInfo);
            }
            return list;
        }

        private ArrayList<Type<?>> populateInterfaces(Filter filter) {
            ArrayList list = new ArrayList();
            Type<?> reflectedType = this.getReflectedType();
            HashSet<Type> set = new HashSet<Type>();
            ImmutableList<Type<?>> interfaceList = Helper.interfaces(reflectedType);
            for (Type interfaceType : interfaceList) {
                String name = interfaceType.getFullName();
                if (!filter.match(name) || !set.add(interfaceType)) continue;
                list.add(interfaceType);
            }
            return list;
        }

        private ArrayList<Type<?>> populateNestedClasses(Filter filter) {
            ArrayList list = new ArrayList();
            Type<?> declaringType = this.getReflectedType();
            if (declaringType.isGenericParameter()) {
                while (declaringType.isGenericParameter()) {
                    declaringType = declaringType.getExtendsBound();
                }
            }
            if (declaringType == Type.nullType()) {
                return list;
            }
            TypeList declaredTypes = declaringType.getDeclaredTypes();
            int n = declaredTypes.size();
            for (int i = 0; i < n; ++i) {
                Type nestedType = (Type)declaredTypes.get(i);
                if (!filter.match(nestedType.getName())) continue;
                list.add(nestedType);
            }
            return list;
        }

        private ArrayList<T> populate(String name, MemberListType listType, CacheType cacheType) {
            ArrayList<MemberInfo> list;
            Filter filter = name == null || name.length() == 0 || cacheType == CacheType.Constructor && name.charAt(0) != '.' && name.charAt(0) != '*' ? new Filter(null, listType) : new Filter(name, listType);
            switch (cacheType) {
                case Method: {
                    list = this.populateMethods(filter);
                    break;
                }
                case Field: {
                    list = this.populateFields(filter);
                    break;
                }
                case Constructor: {
                    list = this.populateConstructors(filter);
                    break;
                }
                case NestedType: {
                    list = this.populateNestedClasses(filter);
                    break;
                }
                case Interface: {
                    list = this.populateInterfaces(filter);
                    break;
                }
                default: {
                    throw ContractUtils.unreachable();
                }
            }
            return this.insert(list, name, listType);
        }
    }

    private static final class Filter {
        private final String _name;
        private final MemberListType _listType;

        private Filter(String name, MemberListType listType) {
            this._name = name;
            this._listType = (MemberListType)((Object)VerifyArgument.notNull((Object)((Object)listType), (String)"listType"));
        }

        private boolean match(String name) {
            if (this._listType == MemberListType.CaseSensitive) {
                return this._name == null || this._name.equals(name);
            }
            return this._listType != MemberListType.CaseInsensitive || this._name == null || this._name.equalsIgnoreCase(name);
        }
    }

    private static enum CacheType {
        Method,
        Constructor,
        Field,
        Property,
        Event,
        Interface,
        NestedType;

    }

    private static enum WhatsCached {
        Nothing,
        EnclosingType;

    }
}

