/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.core.Comparer;
import com.strobel.core.HashUtilities;
import com.strobel.reflection.GenericType;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeList;
import com.strobel.reflection.emit.TypeBuilder;
import com.strobel.util.TypeUtils;
import java.util.Iterator;
import java.util.LinkedHashMap;

final class TypeCache {
    private final LinkedHashMap<Key, Type<?>> _map = new LinkedHashMap();
    private final LinkedHashMap<String, Type<?>> _definitionMap = new LinkedHashMap();
    private final LinkedHashMap<Type<?>, Type<?>> _arrayMap = new LinkedHashMap();

    TypeCache() {
    }

    public Key key(Type<?> type) {
        return this.key(type, TypeList.empty());
    }

    public Key key(Type<?> type, TypeList typeArguments) {
        return new Key(type.isGenericType() ? type.getGenericTypeDefinition() : type, typeArguments);
    }

    public Type<?> find(Key key) {
        return this._map.get(key);
    }

    public <T> Type<T[]> getArrayType(Type<T> elementType) {
        this.add(elementType);
        Type<T[]> arrayType = this._arrayMap.get(elementType);
        if (arrayType == null) {
            arrayType = elementType.createArrayType();
            this._arrayMap.put(elementType, arrayType);
        }
        return arrayType;
    }

    public <T> Type<T> getGenericType(Type<T> type, TypeList typeArguments) {
        Type<?> existing;
        Key key = this.key(type.isGenericType() ? type.getGenericTypeDefinition() : type, typeArguments);
        Type<?> genericType = this._map.get(key);
        if (genericType == null && (existing = this._map.put(key, genericType = new GenericType(type.getGenericTypeDefinition(), typeArguments))) != null) {
            return existing;
        }
        return genericType;
    }

    public <T> Type<T> find(Class<T> clazz) {
        return this._definitionMap.get(TypeUtils.getInternalName(clazz));
    }

    public int size() {
        return this._map.size();
    }

    void put(Key key, Type<?> type) {
        String descriptor = key.descriptor;
        if (!this._definitionMap.containsKey(descriptor)) {
            if (type.isGenericType() && !type.isGenericTypeDefinition()) {
                this._definitionMap.put(descriptor, type.getGenericTypeDefinition());
            } else {
                this._definitionMap.put(descriptor, type);
            }
        }
        if (type.isPrimitive() && !this._definitionMap.containsKey(type.getName())) {
            this._definitionMap.put(type.getName(), type);
        }
        this._map.put(key, type);
    }

    public void add(Type<?> type) {
        Type<?> coreType = type;
        while (coreType.isArray()) {
            coreType = coreType.getElementType();
        }
        if (coreType.isWildcardType() || coreType.isGenericParameter() || coreType instanceof TypeBuilder) {
            return;
        }
        TypeList typeArguments = coreType.isGenericType() ? coreType.getTypeBindings().getBoundTypes() : TypeList.empty();
        this.put(this.key(coreType, typeArguments), coreType);
    }

    static final class Key {
        private final String descriptor;
        private final TypeList typeArguments;
        private final int hashCode;

        public Key(Type<?> simpleType) {
            this(simpleType, null);
        }

        public Key(Type<?> type, TypeList typeArguments) {
            this.descriptor = type.getInternalName();
            this.typeArguments = typeArguments;
            int h = this.descriptor.hashCode();
            if (typeArguments != null && !typeArguments.isEmpty()) {
                Iterator iterator = typeArguments.iterator();
                while (iterator.hasNext()) {
                    Type argument = (Type)iterator.next();
                    h = HashUtilities.combineHashCodes((int)h, (int)argument.hashCode());
                }
            }
            this.hashCode = h;
        }

        public final int hashCode() {
            return this.hashCode;
        }

        public final boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            Key other = (Key)o;
            if (!this.descriptor.equals(other.descriptor)) {
                return false;
            }
            TypeList typeArguments = this.typeArguments;
            TypeList otherArguments = other.typeArguments;
            if (typeArguments == null || typeArguments.isEmpty()) {
                return otherArguments == null || otherArguments.isEmpty();
            }
            if (otherArguments == null || otherArguments.size() != typeArguments.size()) {
                return false;
            }
            int n = typeArguments.size();
            for (int i = 0; i < n; ++i) {
                Type otherArgument;
                Type argument = (Type)typeArguments.get(i);
                if (Comparer.equals((Object)argument, (Object)(otherArgument = (Type)otherArguments.get(i)))) continue;
                return false;
            }
            return true;
        }

        public final String toString() {
            return "Key{descriptor=" + this.descriptor + ", typeArguments=" + (Object)((Object)this.typeArguments) + ", hashCode=" + this.hashCode + '}';
        }
    }
}

