/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.annotations.NotNull;
import com.strobel.core.HashUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.Error;
import com.strobel.reflection.MemberInfo;
import com.strobel.reflection.MemberList;
import com.strobel.reflection.Type;
import com.strobel.util.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TypeList
extends MemberList<Type<?>> {
    private static final TypeList EMPTY = new TypeList(new Type[0]);

    public static TypeList empty() {
        return EMPTY;
    }

    public static TypeList combine(TypeList first, TypeList second) {
        return TypeList.combineCore(first, second, false);
    }

    public static TypeList of(Type ... types) {
        return new TypeList(types);
    }

    public static TypeList of(List<? extends Type<?>> types) {
        return new TypeList(types);
    }

    private static TypeList combineCore(TypeList first, TypeList second, boolean merge) {
        Type type;
        int i;
        VerifyArgument.notNull((Object)((Object)first), (String)"first");
        VerifyArgument.notNull((Object)((Object)second), (String)"second");
        if (first.isEmpty()) {
            return second;
        }
        if (second.isEmpty()) {
            return first;
        }
        ArrayList<Type> types = new ArrayList<Type>();
        int n = first.size();
        for (i = 0; i < n; ++i) {
            type = (Type)first.get(i);
            if (merge && types.contains(type)) continue;
            types.add(type);
        }
        n = second.size();
        for (i = 0; i < n; ++i) {
            type = (Type)second.get(i);
            if (merge && types.contains(type)) continue;
            types.add(type);
        }
        return new TypeList(types);
    }

    public TypeList(Type ... elements) {
        super(Type.class, (MemberInfo[])elements);
    }

    public TypeList(List<? extends Type<?>> elements) {
        super(Type.class, elements);
    }

    public TypeList(Type[] elements, int offset, int length) {
        super(Type.class, (MemberInfo[])elements, offset, length);
    }

    @Override
    @NotNull
    public TypeList subList(int fromIndex, int toIndex) {
        TypeList.subListRangeCheck((int)fromIndex, (int)toIndex, (int)this.size());
        int offset = this.getOffset() + fromIndex;
        int length = toIndex - fromIndex;
        if (length == 0) {
            return TypeList.empty();
        }
        return new TypeList((Type[])this.getElements(), offset, length);
    }

    public final boolean containsGenericParameters() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!((Type)this.get(i)).containsGenericParameters()) continue;
            return true;
        }
        return false;
    }

    public final boolean containsGenericParameter(Type<?> genericParameter) {
        if (!((Type)VerifyArgument.notNull(genericParameter, (String)"genericParameter")).isGenericParameter()) {
            throw Error.notGenericParameter(genericParameter);
        }
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!((Type)this.get(i)).containsGenericParameter(genericParameter)) continue;
            return true;
        }
        return false;
    }

    public final boolean containsSubTypeOf(Type<?> type) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!((Type)this.get(i)).isSubTypeOf(type)) continue;
            return true;
        }
        return false;
    }

    public final boolean containsSuperTypeOf(Type<?> type) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!type.isSubTypeOf((Type)this.get(i))) continue;
            return true;
        }
        return false;
    }

    public final boolean containsTypeAssignableFrom(Type<?> type) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!((Type)this.get(i)).isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public final boolean isEquivalentTo(TypeList types) {
        if (types == this) {
            return true;
        }
        if (types == null || types.size() != this.size()) {
            return false;
        }
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (TypeUtils.areEquivalent((Type)this.get(i), (Type)types.get(i))) continue;
            return false;
        }
        return true;
    }

    public final boolean isAssignableFrom(TypeList types) {
        if (types == this) {
            return true;
        }
        if (types == null || types.size() != this.size()) {
            return false;
        }
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (((Type)this.get(i)).isAssignableFrom((Type)types.get(i))) continue;
            return false;
        }
        return true;
    }

    public final TypeList getErasedTypes() {
        if (this.isEmpty()) {
            return TypeList.empty();
        }
        int size = this.size();
        Type[] erasedTypes = new Type[size];
        for (int i = 0; i < size; ++i) {
            erasedTypes[i] = ((Type)this.get(i)).getErasedType();
        }
        return new TypeList(erasedTypes);
    }

    public int hashCode() {
        int hashCode = 1642088727;
        for (Type type : (Type[])super.getElements()) {
            hashCode = HashUtilities.combineHashCodes((int)hashCode, (int)type.hashCode());
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public boolean equals(TypeList other) {
        return other == this || other != null && Arrays.equals(super.getElements(), other.getElements());
    }
}

