/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection.emit;

import com.strobel.annotations.NotNull;
import com.strobel.core.ReadOnlyList;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.FieldInfo;
import com.strobel.reflection.Type;
import com.strobel.reflection.emit.AnnotationBuilder;
import com.strobel.reflection.emit.Error;
import com.strobel.reflection.emit.TypeBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public final class FieldBuilder
extends FieldInfo {
    private final TypeBuilder<?> _typeBuilder;
    private final String _name;
    private final int _modifiers;
    private final Object _constantValue;
    private Type<?> _type;
    private ReadOnlyList<AnnotationBuilder<? extends Annotation>> _annotations;
    FieldInfo generatedField;

    FieldBuilder(TypeBuilder<?> typeBuilder, String name, Type<?> type, int modifiers, Object constantValue) {
        this._constantValue = constantValue;
        this._typeBuilder = (TypeBuilder)VerifyArgument.notNull(typeBuilder, (String)"typeBuilder");
        this._name = (String)VerifyArgument.notNull((Object)name, (String)"name");
        this._type = (Type)VerifyArgument.notNull(type, (String)"type");
        this._modifiers = modifiers;
        this._annotations = ReadOnlyList.emptyList();
    }

    FieldInfo getCreatedField() {
        this._typeBuilder.verifyCreated();
        return this.generatedField;
    }

    public <A extends Annotation> void addCustomAnnotation(AnnotationBuilder<A> annotation) {
        VerifyArgument.notNull(annotation, (String)"annotation");
        Object[] newAnnotations = new AnnotationBuilder[this._annotations.size() + 1];
        this._annotations.toArray(newAnnotations);
        newAnnotations[this._annotations.size()] = annotation;
        this._annotations = new ReadOnlyList(newAnnotations);
    }

    public ReadOnlyList<AnnotationBuilder<? extends Annotation>> getCustomAnnotations() {
        return this._annotations;
    }

    void verifyTypeNotCreated() {
        if (this._typeBuilder.isCreated() || this.generatedField != null) {
            throw Error.cannotModifyFieldAfterTypeCreated();
        }
    }

    @Override
    public Type<?> getFieldType() {
        if (this.generatedField != null) {
            return this.generatedField.getFieldType();
        }
        return this._type;
    }

    public void setFieldType(Type<?> fieldType) {
        this._type = (Type)VerifyArgument.notNull(fieldType, (String)"fieldType");
        this.invalidateCaches();
    }

    @Override
    public Field getRawField() {
        FieldInfo createdField = this.getCreatedField();
        return createdField.getRawField();
    }

    @Override
    public String getName() {
        return this._name;
    }

    public TypeBuilder<?> getDeclaringType() {
        return this._typeBuilder;
    }

    @Override
    public int getModifiers() {
        return this._modifiers;
    }

    public Object getConstantValue() {
        return this._constantValue;
    }

    @Override
    public Type<?> getReflectedType() {
        return this._typeBuilder;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        this._typeBuilder.verifyCreated();
        return this.generatedField.getAnnotation(annotationClass);
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        this._typeBuilder.verifyCreated();
        return this.generatedField.getAnnotations();
    }

    @Override
    @NotNull
    public Annotation[] getDeclaredAnnotations() {
        this._typeBuilder.verifyCreated();
        return this._typeBuilder.getDeclaredAnnotations();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        this._typeBuilder.verifyCreated();
        return this.generatedField.isAnnotationPresent(annotationClass);
    }
}

