/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection.emit;

import com.strobel.core.ArrayUtilities;
import com.strobel.core.StringUtilities;
import com.strobel.reflection.emit.Verifier;

public class VerificationException
extends IllegalStateException {
    public VerificationException() {
    }

    public VerificationException(Throwable cause) {
        super(cause);
    }

    VerificationException(Throwable cause, Verifier.VerifierFrame[] frames) {
        super(VerificationException.fixMessage("", frames), cause);
    }

    public VerificationException(String message, Throwable cause) {
        super(message, cause);
    }

    VerificationException(String message, Throwable cause, Verifier.VerifierFrame[] frames) {
        super(VerificationException.fixMessage(message, frames), cause);
    }

    public VerificationException(String s) {
        super(s);
    }

    VerificationException(String s, Verifier.VerifierFrame[] frames) {
        super(VerificationException.fixMessage(s, frames));
    }

    private static String fixMessage(String s, Verifier.VerifierFrame[] frames) {
        String message;
        String string = message = StringUtilities.isNullOrEmpty((String)s) ? "Code failed verification." : s;
        if (ArrayUtilities.isNullOrEmpty((Object[])frames)) {
            return message;
        }
        StringBuilder sb = new StringBuilder(message);
        for (int i = 0; i < frames.length; ++i) {
            Verifier.VerifierFrame frame = frames[i];
            sb.append("\n\t[").append(frames.length - i).append("] ").append(frame);
        }
        return sb.toString();
    }
}

