/*
 * Decompiled with CFR 0.152.
 */
package org.swat.excel.utils;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelUtils {
    public static Row currentRow(Sheet sheet) {
        int lastRowNum = sheet.getLastRowNum();
        Row row = sheet.getRow(lastRowNum);
        if (row == null) {
            row = sheet.createRow(lastRowNum);
        }
        return row;
    }

    public static Row newRow(Sheet sheet) {
        Row row;
        int lastRowNum = sheet.getLastRowNum();
        if (lastRowNum == 0 && (row = sheet.getRow(lastRowNum)) == null) {
            return sheet.createRow(0);
        }
        return sheet.createRow(lastRowNum + 1);
    }

    public static Cell currentCell(Row row) {
        short lastCellNum = row.getLastCellNum();
        if (lastCellNum == -1) {
            return row.createCell(0);
        }
        Cell cell = row.getCell(lastCellNum - 1);
        if (cell == null) {
            cell = row.createCell(lastCellNum - 1);
        }
        return cell;
    }

    public static Cell newCell(Row row) {
        short lastCellNum = row.getLastCellNum();
        if (lastCellNum == -1) {
            lastCellNum = 0;
        }
        return row.createCell((int)lastCellNum);
    }

    public static void autoSizeColumns(Workbook workbook) {
        int numberOfSheets = workbook.getNumberOfSheets();
        for (int i = 0; i < numberOfSheets; ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            ExcelUtils.autoSizeColumns(sheet);
        }
    }

    public static void autoSizeColumns(Sheet sheet) {
        for (int index = 0; index <= sheet.getPhysicalNumberOfRows(); ++index) {
            sheet.autoSizeColumn(index);
        }
    }
}

