/*
 * Decompiled with CFR 0.152.
 */
package org.swat.excel.utils;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.swat.core.utils.CoreRtException;
import org.swat.json.utils.JsonConstants;

public class NamedSectionSheet {
    private final Sheet sheet;
    private final boolean namedSection;
    private final List<Section> sections = new ArrayList<Section>();

    public NamedSectionSheet(Sheet sheet) {
        this(sheet, false);
    }

    public NamedSectionSheet(Sheet sheet, boolean namedSection) {
        this.sheet = sheet;
        this.namedSection = namedSection;
        this.populateSections();
    }

    private void populateSections() {
        int start = -1;
        String name = null;
        for (int index = this.sheet.getFirstRowNum(); index <= this.sheet.getLastRowNum() + 1; ++index) {
            if (start < 0 && !this.isEmptyRow(index)) {
                Row row;
                Cell cell;
                start = index;
                if (this.namedSection && (cell = (row = this.sheet.getRow(start)).getCell((int)row.getFirstCellNum())) != null && cell.getCellType() == CellType.STRING) {
                    name = cell.getStringCellValue();
                    for (Section section : this.sections) {
                        if (!StringUtils.equals((CharSequence)name, (CharSequence)section.getName())) continue;
                        throw new CoreRtException("Duplicate section name:" + name);
                    }
                    ++start;
                }
            }
            if (start < 0 || !this.isEmptyRow(index)) continue;
            this.sections.add(new Section(name, start, index - 1));
            start = -1;
        }
    }

    public Iterator<Section> iterator() {
        return new Iterator<Section>(){
            private int index = -1;

            @Override
            public boolean hasNext() {
                return this.index < NamedSectionSheet.this.sectionCount() - 1;
            }

            @Override
            public Section next() {
                if (this.hasNext()) {
                    ++this.index;
                    return NamedSectionSheet.this.sections.get(this.index);
                }
                throw new NoSuchElementException(this.index + 1 + " does not exist.");
            }
        };
    }

    public int sectionCount() {
        return this.sections.size();
    }

    public Section getSection(int index) {
        if (index >= 0 && index < this.sectionCount()) {
            return this.sections.get(index);
        }
        return null;
    }

    public Section getSection(String name) {
        if (!this.namedSection) {
            throw new CoreRtException("The sections are not named");
        }
        for (Section section : this.sections) {
            if (!StringUtils.equals((CharSequence)name, (CharSequence)section.getName())) continue;
            return section;
        }
        return null;
    }

    private boolean isEmptyRow(int index) {
        Row row = this.sheet.getRow(index);
        if (row == null) {
            return true;
        }
        return row.getFirstCellNum() == row.getLastCellNum();
    }

    public class Section {
        private final String name;
        private final int start;
        private final int end;
        private final Map<String, Integer> nameIndexMap = new LinkedHashMap<String, Integer>();

        private Section(String name, int start, int end) {
            this.name = name;
            this.start = start;
            this.end = end;
            this.readHeader();
        }

        public void addColumnIfAbsent(String name) {
            Integer index = this.nameIndexMap.get(name);
            if (index == null) {
                Row row = NamedSectionSheet.this.sheet.getRow(this.start);
                short idx = row.getLastCellNum();
                Cell cell = row.createCell((int)idx);
                cell.setCellValue(name);
                this.nameIndexMap.put(cell.getStringCellValue(), Integer.valueOf(idx));
            }
        }

        public NamedRow getRow(int index) {
            if (index < 0 || index > this.end - this.start) {
                return null;
            }
            Iterator<NamedRow> iterator = this.iterator();
            while (iterator.hasNext()) {
                NamedRow row = iterator.next();
                if (--index >= 0) continue;
                return row;
            }
            return null;
        }

        public Set<String> getHeaders() {
            return new LinkedHashSet<String>(this.nameIndexMap.keySet());
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String getName() {
            return this.name;
        }

        public Iterator<NamedRow> iterator() {
            return new Iterator<NamedRow>(){
                private int index;
                {
                    this.index = Section.this.start;
                }

                @Override
                public boolean hasNext() {
                    return this.index < Section.this.end;
                }

                @Override
                public NamedRow next() {
                    if (this.hasNext()) {
                        ++this.index;
                        return new NamedRow(NamedSectionSheet.this.sheet.getRow(this.index));
                    }
                    throw new NoSuchElementException(this.index + 1 + " does not exist.");
                }
            };
        }

        public String toString() {
            return "Section{start=" + this.start + ", end=" + this.end + "}";
        }

        private void readHeader() {
            Row row = NamedSectionSheet.this.sheet.getRow(this.start);
            this.nameIndexMap.clear();
            for (int index = row.getFirstCellNum(); index < row.getLastCellNum(); ++index) {
                Cell cell = row.getCell(index);
                if (cell == null || cell.getCellType() != CellType.STRING) continue;
                this.nameIndexMap.put(cell.getStringCellValue(), index);
            }
        }

        private int getIndex(String name) {
            Integer index = this.nameIndexMap.get(name);
            if (index == null) {
                return -1;
            }
            return index;
        }

        public class NamedRow {
            private final Row row;

            public NamedRow(Row row) {
                this.row = row;
            }

            public String asString(String name) {
                int index = Section.this.getIndex(name);
                return (String)this.getValue(name, index, "STRING");
            }

            public long asLong(String name) {
                return this.asNumber(name).longValue();
            }

            public int asInt(String name) {
                return this.asNumber(name).intValue();
            }

            public double asDouble(String name) {
                return this.asNumber(name).doubleValue();
            }

            private Number asNumber(String name) {
                return this.asNumber(name, 0);
            }

            private Number asNumber(String name, Number onError) {
                int index = Section.this.getIndex(name);
                Number value = (Number)this.getValue(name, index, "NUMBER");
                if (value == null) {
                    return onError;
                }
                return value;
            }

            public boolean asBoolean(String name) {
                String value = this.asString(name);
                if (value == null) {
                    return false;
                }
                return StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)"true") || StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)"yes");
            }

            public Object asObject(String name) {
                int index = Section.this.getIndex(name);
                if (index >= 0) {
                    Cell cell = this.row.getCell(index);
                    if (cell == null) {
                        return null;
                    }
                    CellType type = cell.getCellType();
                    try {
                        switch (type) {
                            case NUMERIC: {
                                return cell.getNumericCellValue();
                            }
                            case STRING: {
                                return cell.getStringCellValue();
                            }
                            case FORMULA: {
                                return cell.getCellFormula();
                            }
                            case BOOLEAN: {
                                return cell.getBooleanCellValue();
                            }
                        }
                    }
                    catch (Exception e) {
                        String error = String.format("Row:%d, Cell:%d, Name:%s, Type:%s - %s", this.row.getRowNum(), index, name, type, e.getMessage());
                        throw new CoreRtException(error, (Throwable)e);
                    }
                }
                return null;
            }

            public Date asDate(String name) {
                Number number = this.asNumber(name, null);
                if (number == null) {
                    return null;
                }
                return DateUtil.getJavaDate((double)number.doubleValue(), (boolean)false, (TimeZone)TimeZone.getTimeZone("UTC"));
            }

            public LocalDate asLocalDate(String name) {
                Date date = this.asDate(name);
                if (date == null) {
                    return null;
                }
                return date.toInstant().atZone(ZoneId.of("UTC")).toLocalDate();
            }

            public Cell getCell(String name) {
                return this.getCell(name, false);
            }

            public Cell getCell(String name, boolean createIfNull) {
                Integer index = Section.this.nameIndexMap.get(name);
                if (index == null) {
                    return null;
                }
                Cell cell = this.row.getCell(index.intValue());
                if (createIfNull) {
                    cell = this.row.createCell(index.intValue());
                }
                return cell;
            }

            private Object getValue(String name, int index, String type) {
                if (index < 0 || StringUtils.isBlank((CharSequence)type)) {
                    return null;
                }
                Cell cell = this.row.getCell(index);
                if (cell == null) {
                    return null;
                }
                try {
                    switch (type) {
                        case "STRING": {
                            return cell.getStringCellValue();
                        }
                        case "NUMBER": {
                            return cell.getNumericCellValue();
                        }
                    }
                    return null;
                }
                catch (Exception e) {
                    String error = String.format("Row:%d, Cell:%d, Name:%s Expected Type:%s, Actual Type:%s - %s", this.row.getRowNum(), index, name, type, cell.getCellType(), e.getMessage());
                    throw new CoreRtException(error, (Throwable)e);
                }
            }

            public Row getRow() {
                return this.row;
            }

            public Map<String, Object> toMap() {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                for (String header : Section.this.getHeaders()) {
                    map.put(header, this.asObject(header));
                }
                return map;
            }

            public String toString() {
                return this.toString(true);
            }

            public String toString(boolean pretty) {
                Map<String, Object> map = this.toMap();
                if (pretty) {
                    return JsonConstants.JSON_UTIL.pretty(map);
                }
                return JsonConstants.JSON_UTIL.toJsonString(map);
            }
        }
    }
}

