/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.tek.nik.simplifiedswagger.newmodels;

import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bitbucket.tek.nik.simplifiedswagger.BasicMappingHolder;
import org.bitbucket.tek.nik.simplifiedswagger.exception.SimplifiedSwaggerException;
import org.bitbucket.tek.nik.simplifiedswagger.newmodels.GenericArrayPropertyHandler;
import org.bitbucket.tek.nik.simplifiedswagger.newmodels.NonParameterizedPropertyHandler;
import org.bitbucket.tek.nik.simplifiedswagger.newmodels.ParameterizedPropertyHandler;
import sun.reflect.generics.reflectiveObjects.GenericArrayTypeImpl;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class NewModelCreator {
    private final Map<String, Model> definitions;
    private final ParameterizedPropertyHandler parameterizedPropertyHandler;
    private final GenericArrayPropertyHandler genericArrayPropertyHandler;
    private final NonParameterizedPropertyHandler nonParameterizedPropertyHandler;
    private int counter = 0;
    private Set<ParameterizedType> parameterizedTypes = new HashSet<ParameterizedType>();
    private Map<String, ParameterizedType> parameterizedTypesLookup = new HashMap<String, ParameterizedType>();
    private Set<WildcardType> wildcardTypes = new HashSet<WildcardType>();
    private Map<String, WildcardType> wildcardTypesLookup = new HashMap<String, WildcardType>();
    private Set<Class> nonParameterizedTypes = new HashSet<Class>();

    public void build() {
        int lastCounter = this.counter;
        for (int i = 0; lastCounter < this.counter || i == 0; ++i) {
            lastCounter = this.counter;
            this.addGenericModels(this.definitions);
            this.addWildCardModels(this.definitions);
            this.addNonGenericModels(this.definitions);
        }
    }

    public NewModelCreator(Map<String, Model> definitions) {
        this.definitions = definitions;
        this.parameterizedPropertyHandler = new ParameterizedPropertyHandler(definitions, this);
        this.nonParameterizedPropertyHandler = new NonParameterizedPropertyHandler(definitions, this);
        this.genericArrayPropertyHandler = new GenericArrayPropertyHandler(definitions, this);
    }

    private void showNewTypes() {
        System.out.println("parameterizedTypes=" + this.parameterizedTypes);
        System.out.println("wildcardTypes=" + this.wildcardTypes);
        System.out.println("nonParameterizedTypes=" + this.nonParameterizedTypes);
    }

    public void addIfParemeterizedType(Type genericType, boolean first) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type rawType = parameterizedType.getRawType();
            if (rawType instanceof Class) {
                this.prevent((Class)rawType, first);
            }
            if (this.parameterizedTypes.add((ParameterizedType)genericType)) {
                ++this.counter;
            }
        } else if (genericType instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)genericType;
            Type type = wildcardType.getUpperBounds()[0];
            if (type instanceof Class) {
                this.prevent((Class)type, first);
            }
            if (this.wildcardTypes.add(wildcardType)) {
                ++this.counter;
            }
        } else {
            if (genericType instanceof TypeVariable) {
                throw new SimplifiedSwaggerException("Resolve the typevariables. Dont send typeVariables");
            }
            if (genericType instanceof Class) {
                Class clazz = (Class)genericType;
                this.prevent(clazz, first);
                if (this.nonParameterizedTypes.add(clazz)) {
                    ++this.counter;
                }
            } else {
                throw new SimplifiedSwaggerException("got " + genericType.getClass().getName());
            }
        }
    }

    private void prevent(Class clazz, boolean first) {
        if (!first && (clazz.isArray() || List.class.isAssignableFrom(clazz) || Set.class.isAssignableFrom(clazz))) {
            throw new SimplifiedSwaggerException("Not expecting arrays/lists/sets here. Use ArrayProperty when building model fields");
        }
        if (clazz.isEnum()) {
            throw new SimplifiedSwaggerException("Not expecting enum types here. Use proper property/type when building model fields .offending type is " + clazz.getName());
        }
        if (BasicMappingHolder.INSTANCE.getMappedByType(clazz.getName()) != null) {
            throw new SimplifiedSwaggerException("Not expecting basic types here. Use proper property/type when building model fields .offending type is " + clazz.getName());
        }
        if (clazz.getName().contains("$")) {
            // empty if block
        }
    }

    private void addWildCardModels(Map<String, Model> definitions) {
        HashSet<WildcardType> hashSet = new HashSet<WildcardType>();
        hashSet.addAll(this.wildcardTypes);
        for (WildcardType wildcardType : hashSet) {
            String key = wildcardType.toString();
            if (this.wildcardTypesLookup.containsKey(key) || key.startsWith(Class.class.getName()) || key.startsWith(SoftReference.class.getName()) || key.startsWith(Constructor.class.getName()) || key.startsWith(Type.class.getName())) continue;
            key = key.replace('<', '\u00ab');
            key = key.replace('>', '\u00bb');
            this.wildcardTypesLookup.put(key, wildcardType);
            String originalKey = key;
            ModelImpl model = new ModelImpl();
            model.setTitle(originalKey);
            Type type = wildcardType.getUpperBounds()[0];
            model.setType(type == Object.class ? "object" : type.getClass().getName());
            this.addIfParemeterizedType(type, false);
            definitions.put(key, (Model)model);
        }
    }

    private void addNonGenericModels(Map<String, Model> definitions) {
        HashSet<Class> hashSet = new HashSet<Class>();
        hashSet.addAll(this.nonParameterizedTypes);
        for (Class clazz : hashSet) {
            Field[] declaredFields;
            Method[] declaredMethods;
            String key = clazz.getName();
            if (clazz.isPrimitive() || definitions.containsKey(key) || key.startsWith(Class.class.getName()) || key.startsWith(SoftReference.class.getName()) || key.startsWith(Constructor.class.getName()) || key.startsWith(Type.class.getName()) || key.startsWith(HashSet.class.getName()) || key.startsWith(LinkedHashMap.class.getName()) || key.startsWith(HashMap.class.getName())) continue;
            ModelImpl model = new ModelImpl();
            model.setTitle(key);
            model.setType("object");
            HashMap<String, Property> modelProperties = new HashMap<String, Property>();
            HashMap<String, Type> propertiesMap = new HashMap<String, Type>();
            for (Method declaredMethod : declaredMethods = clazz.getMethods()) {
                Type genericReturnType;
                String propName;
                char[] charArray;
                if (declaredMethod.getParameterTypes().length != 0 || declaredMethod.getReturnType() == Void.TYPE) continue;
                String declaredMethodName = declaredMethod.getName();
                if (declaredMethodName.startsWith("get") && declaredMethodName.length() > "get".length() && !Modifier.isStatic(declaredMethod.getModifiers())) {
                    charArray = declaredMethodName.substring("get".length()).toCharArray();
                    charArray[0] = Character.toLowerCase(charArray[0]);
                    propName = String.valueOf(charArray);
                    if (propName.equals("class") || propName.equals("type")) continue;
                    genericReturnType = declaredMethod.getGenericReturnType();
                    if (genericReturnType instanceof Class) {
                        propertiesMap.put(propName, genericReturnType);
                        continue;
                    }
                    if (genericReturnType instanceof ParameterizedType) {
                        propertiesMap.put(propName, genericReturnType);
                        continue;
                    }
                    throw new SimplifiedSwaggerException("handle " + genericReturnType.getClass().getName() + " method=" + propName + ", in " + key);
                }
                if (!declaredMethodName.startsWith("is") || declaredMethodName.length() <= "is".length() || Modifier.isStatic(declaredMethod.getModifiers())) continue;
                charArray = declaredMethodName.substring("is".length()).toCharArray();
                charArray[0] = Character.toLowerCase(charArray[0]);
                propName = String.valueOf(charArray);
                if (propName.equals("class") || propName.equals("type")) continue;
                genericReturnType = declaredMethod.getGenericReturnType();
                if (genericReturnType instanceof Class) {
                    propertiesMap.put(propName, genericReturnType);
                    continue;
                }
                if (genericReturnType instanceof ParameterizedType) {
                    propertiesMap.put(propName, genericReturnType);
                    continue;
                }
                throw new SimplifiedSwaggerException("handle " + genericReturnType.getClass().getName() + " method=" + propName + ", in " + key);
            }
            for (Field field : declaredFields = clazz.getDeclaredFields()) {
                if (field.getName().equals("class") || field.getName().equals("type") || Modifier.isStatic(field.getModifiers()) || propertiesMap.get(field.getName()) != null) continue;
                Type genericType = field.getGenericType();
                if (genericType instanceof Class) {
                    propertiesMap.put(field.getName(), field.getType());
                    continue;
                }
                if (genericType instanceof ParameterizedType) {
                    propertiesMap.put(field.getName(), genericType);
                    continue;
                }
                if (genericType instanceof GenericArrayType) {
                    propertiesMap.put(field.getName(), genericType);
                    continue;
                }
                throw new SimplifiedSwaggerException("handle " + genericType.getClass().getName() + " field=" + field.getName() + ", in " + key);
            }
            Set keySet = propertiesMap.keySet();
            for (String key2 : keySet) {
                if (key2.equals("class") || key2.equals("type")) continue;
                Type type = (Type)propertiesMap.get(key2);
                if (type == null) {
                    throw new SimplifiedSwaggerException("unexpected if for property " + key2 + " in generic model " + key + " was actual of null type");
                }
                if (type instanceof ParameterizedType) {
                    this.handleParameterizedProperty(definitions, modelProperties, key2, (ParameterizedType)type, null);
                    continue;
                }
                if (type instanceof GenericArrayType) {
                    this.handleGenericArrayProperty(definitions, modelProperties, key2, (GenericArrayType)type, null);
                    continue;
                }
                if (type instanceof WildcardType) {
                    WildcardType wildcardType = (WildcardType)type;
                    Class propertyType = (Class)wildcardType.getUpperBounds()[0];
                    Property basicProperty = BasicMappingHolder.INSTANCE.buildBasicProperty(propertyType);
                    if (basicProperty != null) {
                        basicProperty.setName(key2);
                        modelProperties.put(key2, basicProperty);
                        continue;
                    }
                    if (propertyType.isArray()) {
                        ArrayProperty arrayProperty = new ArrayProperty();
                        RefProperty refProperty = new RefProperty();
                        refProperty.set$ref("#/definitions/" + propertyType.getName());
                        refProperty.setName("items");
                        arrayProperty.setItems((Property)refProperty);
                        modelProperties.put(key2, (Property)refProperty);
                        if (definitions.get(propertyType.getName()) != null) continue;
                        this.addIfParemeterizedType(propertyType, false);
                        continue;
                    }
                    RefProperty refProperty = new RefProperty();
                    refProperty.set$ref("#/definitions/" + propertyType.getName());
                    refProperty.setName(key2);
                    modelProperties.put(key2, (Property)refProperty);
                    if (definitions.get(propertyType.getName()) != null) continue;
                    this.addIfParemeterizedType(propertyType, false);
                    continue;
                }
                if (type instanceof Class) {
                    this.handleNonParameterizedProperty(definitions, modelProperties, key2, (Class)type);
                    continue;
                }
                throw new SimplifiedSwaggerException("unexpected else for property " + key2 + " in generic model " + key + " was actual of " + type.getClass().getName());
            }
            model.setProperties(modelProperties);
            definitions.put(key, (Model)model);
        }
    }

    private void handleNonParameterizedProperty(Map<String, Model> definitions, HashMap<String, Property> modelProperties, String key2, Class propertyType) {
        this.nonParameterizedPropertyHandler.handleNonParameterizedProperty(modelProperties, key2, propertyType);
    }

    private void handleParameterizedProperty(Map<String, Model> definitions, HashMap<String, Property> modelProperties, String propertyName, ParameterizedType type, Map<String, Type> typeVariableToActualTypeMapFromParentClass) {
        this.parameterizedPropertyHandler.handleParameterizedProperty(modelProperties, propertyName, type, typeVariableToActualTypeMapFromParentClass);
    }

    private void handleGenericArrayProperty(Map<String, Model> definitions, HashMap<String, Property> modelProperties, String propertyName, GenericArrayType type, Map<String, Type> typeVariableToActualTypeMapFromParentClass) {
        this.genericArrayPropertyHandler.handleGenericArrayProperty(modelProperties, propertyName, type, typeVariableToActualTypeMapFromParentClass);
    }

    private void addGenericModels(Map<String, Model> definitions) {
        HashSet<ParameterizedType> hashSet = new HashSet<ParameterizedType>();
        hashSet.addAll(this.parameterizedTypes);
        for (ParameterizedType parameterizedType : hashSet) {
            Type[] actualTypeArguments;
            Type rawType = parameterizedType.getRawType();
            String key = parameterizedType.toString();
            if (this.parameterizedTypesLookup.containsKey(key)) continue;
            key = key.replace('<', '\u00ab');
            key = key.replace('>', '\u00bb');
            this.parameterizedTypesLookup.put(key, parameterizedType);
            String originalKey = key;
            ModelImpl model = new ModelImpl();
            model.setTitle(originalKey);
            model.setType("object");
            HashMap<String, Property> modelProperties = new HashMap<String, Property>();
            for (Type type : actualTypeArguments = parameterizedType.getActualTypeArguments()) {
            }
            if (rawType instanceof Class) {
                Field[] declaredFields;
                Method[] declaredMethods;
                Class clazz = (Class)rawType;
                TypeVariable<Class<T>>[] typeParameters = clazz.getTypeParameters();
                HashMap<String, Type> typeVariableToActualTypeMap = new HashMap<String, Type>();
                for (int i = 0; i < typeParameters.length; ++i) {
                    TypeVariable typeVariable = typeParameters[i];
                    typeVariableToActualTypeMap.put(typeVariable.getName(), actualTypeArguments[i]);
                }
                HashMap<String, Type> propertiesMap = new HashMap<String, Type>();
                for (Method declaredMethod : declaredMethods = clazz.getMethods()) {
                    Type type;
                    Type genericReturnType;
                    String propName;
                    char[] charArray;
                    if (declaredMethod.getParameterTypes().length != 0 || declaredMethod.getReturnType() == Void.TYPE) continue;
                    String declaredMethodName = declaredMethod.getName();
                    if (declaredMethodName.startsWith("get") && declaredMethodName.length() > "get".length() && !Modifier.isStatic(declaredMethod.getModifiers())) {
                        charArray = declaredMethodName.substring("get".length()).toCharArray();
                        charArray[0] = Character.toLowerCase(charArray[0]);
                        propName = String.valueOf(charArray);
                        if (propName.equals("class") || propName.equals("type")) continue;
                        genericReturnType = declaredMethod.getGenericReturnType();
                        if (genericReturnType instanceof TypeVariable) {
                            type = (Type)typeVariableToActualTypeMap.get(((TypeVariable)genericReturnType).getName());
                            propertiesMap.put(propName, type);
                            continue;
                        }
                        if (genericReturnType instanceof ParameterizedType) {
                            propertiesMap.put(propName, genericReturnType);
                            continue;
                        }
                        if (genericReturnType instanceof Class) {
                            propertiesMap.put(propName, genericReturnType);
                            continue;
                        }
                        if (genericReturnType instanceof GenericArrayType) {
                            propertiesMap.put(propName, genericReturnType);
                            continue;
                        }
                        throw new SimplifiedSwaggerException("handle " + genericReturnType.getClass().getName() + " method=" + propName + ", in " + key);
                    }
                    if (!declaredMethodName.startsWith("is") || declaredMethodName.length() <= "is".length() || Modifier.isStatic(declaredMethod.getModifiers())) continue;
                    charArray = declaredMethodName.substring("is".length()).toCharArray();
                    charArray[0] = Character.toLowerCase(charArray[0]);
                    propName = String.valueOf(charArray);
                    if (propName.equals("class") || propName.equals("type")) continue;
                    genericReturnType = declaredMethod.getGenericReturnType();
                    if (genericReturnType instanceof TypeVariable) {
                        type = (Type)typeVariableToActualTypeMap.get((TypeVariable)genericReturnType);
                        propertiesMap.put(propName, type);
                        continue;
                    }
                    if (genericReturnType instanceof ParameterizedType) {
                        propertiesMap.put(propName, genericReturnType);
                        continue;
                    }
                    if (genericReturnType instanceof Class) {
                        propertiesMap.put(propName, genericReturnType);
                        continue;
                    }
                    if (genericReturnType instanceof GenericArrayType) {
                        propertiesMap.put(propName, genericReturnType);
                        continue;
                    }
                    throw new SimplifiedSwaggerException("handle " + genericReturnType.getClass().getName() + " method=" + propName + ", in " + key);
                }
                for (Field field : declaredFields = clazz.getDeclaredFields()) {
                    if (field.getName().equals("class") || field.getName().equals("type") || Modifier.isStatic(field.getModifiers()) || propertiesMap.get(field.getName()) != null) continue;
                    Type genericType = field.getGenericType();
                    if (genericType instanceof TypeVariable) {
                        Type type = (Type)typeVariableToActualTypeMap.get((TypeVariable)genericType);
                        propertiesMap.put(field.getName(), type);
                        continue;
                    }
                    if (genericType instanceof Class) {
                        propertiesMap.put(field.getName(), field.getType());
                        continue;
                    }
                    throw new SimplifiedSwaggerException("handle " + genericType.getClass().getName() + " field=" + field.getName() + ", in " + key);
                }
                Set keySet = propertiesMap.keySet();
                for (String key2 : keySet) {
                    if (key2.equals("class") || key2.equals("type")) continue;
                    Type type = (Type)propertiesMap.get(key2);
                    if (type == null) {
                        throw new SimplifiedSwaggerException("unexpected if for property " + key2 + " in generic model " + key + " was actual of null type");
                    }
                    if (type instanceof TypeVariable) {
                        throw new SimplifiedSwaggerException("unexpected if for property " + key2 + " in generic model " + key + " was actual of TypeVariable type");
                    }
                    if (type instanceof ParameterizedType) {
                        ParameterizedType parameterizedType1 = (ParameterizedType)type;
                        parameterizedType1 = this.parametrizedTypeWithResolvedActualArguments(typeVariableToActualTypeMap, parameterizedType1);
                        this.handleParameterizedProperty(definitions, modelProperties, key2, parameterizedType1, typeVariableToActualTypeMap);
                        continue;
                    }
                    if (type instanceof WildcardType) {
                        WildcardType wildcardType = (WildcardType)type;
                        Class propertyType = (Class)wildcardType.getUpperBounds()[0];
                        Property basicProperty = BasicMappingHolder.INSTANCE.buildBasicProperty(propertyType);
                        if (basicProperty != null) {
                            basicProperty.setName(key2);
                            modelProperties.put(key2, basicProperty);
                            continue;
                        }
                        RefProperty refProperty = new RefProperty();
                        refProperty.set$ref("#/definitions/" + propertyType.getName());
                        refProperty.setName(key2);
                        modelProperties.put(key2, (Property)refProperty);
                        if (definitions.get(propertyType.getName()) != null) continue;
                        this.addIfParemeterizedType(propertyType, false);
                        continue;
                    }
                    if (type instanceof Class) {
                        this.handleNonParameterizedProperty(definitions, modelProperties, key2, (Class)type);
                        continue;
                    }
                    if (type instanceof GenericArrayType) {
                        ParameterizedType parametrizedTypeWithResolvedActualArguments;
                        ParameterizedType parameterizedType1;
                        GenericArrayType genericArrayType = (GenericArrayType)type;
                        Type genericComponentType = genericArrayType.getGenericComponentType();
                        if (genericComponentType instanceof ParameterizedType && (parameterizedType1 = (ParameterizedType)genericComponentType) != (parametrizedTypeWithResolvedActualArguments = this.parametrizedTypeWithResolvedActualArguments(typeVariableToActualTypeMap, parameterizedType1))) {
                            genericArrayType = GenericArrayTypeImpl.make(parametrizedTypeWithResolvedActualArguments);
                        }
                        this.handleGenericArrayProperty(definitions, modelProperties, key2, genericArrayType, typeVariableToActualTypeMap);
                        continue;
                    }
                    throw new SimplifiedSwaggerException("unexpected else for property " + key2 + " in generic model " + key + " was actual of " + type.getClass().getName());
                }
            } else {
                throw new SimplifiedSwaggerException("key=" + key + " did not map to a Class. check");
            }
            model.setProperties(modelProperties);
            definitions.put(originalKey, (Model)model);
        }
    }

    private ParameterizedType parametrizedTypeWithResolvedActualArguments(Map<String, Type> typeVariableToActualTypeMap, ParameterizedType parameterizedType1) {
        Type[] actualTypeArguments2 = parameterizedType1.getActualTypeArguments();
        boolean needMyImpl = false;
        if (actualTypeArguments2 != null) {
            for (Type actualTypeArgument2 : actualTypeArguments2) {
                if (!(actualTypeArgument2 instanceof TypeVariable)) continue;
                needMyImpl = true;
                break;
            }
        }
        if (needMyImpl) {
            Type[] newactualTypeArguments = new Type[actualTypeArguments2.length];
            for (int i = 0; i < actualTypeArguments2.length; ++i) {
                Type actualTypeArgument2 = actualTypeArguments2[i];
                if (actualTypeArgument2 instanceof TypeVariable) {
                    TypeVariable tv = (TypeVariable)actualTypeArgument2;
                    newactualTypeArguments[i] = typeVariableToActualTypeMap.get(tv.getName());
                    continue;
                }
                newactualTypeArguments[i] = actualTypeArguments2[i];
            }
            parameterizedType1 = ParameterizedTypeImpl.make((Class)parameterizedType1.getRawType(), newactualTypeArguments, parameterizedType1.getOwnerType());
        }
        return parameterizedType1;
    }

    public ParameterizedType getParameterizedModelType(String key) {
        return this.parameterizedTypesLookup.get(key);
    }
}

