/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.tek.nik.simplifiedswagger.newmodels;

import io.swagger.models.Model;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bitbucket.tek.nik.simplifiedswagger.BasicMappingHolder;
import org.bitbucket.tek.nik.simplifiedswagger.newmodels.Chain;
import org.bitbucket.tek.nik.simplifiedswagger.newmodels.ChainControl;
import org.bitbucket.tek.nik.simplifiedswagger.newmodels.NewModelCreator;
import org.springframework.util.MultiValueMap;

public class NonParameterizedPropertyHandler {
    private final ChainControl chainControl;

    public NonParameterizedPropertyHandler(Map<String, Model> definitions, NewModelCreator newModelCreator) {
        this.chainControl = new ChainControl(definitions, newModelCreator);
    }

    public void handleNonParameterizedProperty(HashMap<String, Property> modelProperties, String propertyName, Class type) {
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            ArrayProperty arrayProperty = new ArrayProperty();
            arrayProperty.setName(propertyName);
            modelProperties.put(propertyName, (Property)arrayProperty);
            new Chain(this.chainControl, (Property)arrayProperty, componentType).chain();
        } else if (List.class.isAssignableFrom(type) || Set.class.isAssignableFrom(type)) {
            Class<Object> componentType = Object.class;
            ArrayProperty arrayProperty = new ArrayProperty();
            arrayProperty.setName(propertyName);
            modelProperties.put(propertyName, (Property)arrayProperty);
            new Chain(this.chainControl, (Property)arrayProperty, (Type)((Object)componentType)).chain();
        } else if (Map.class.isAssignableFrom(type)) {
            Class<Object> valueType = Object.class;
            MapProperty mapProperty = new MapProperty();
            mapProperty.setName(propertyName);
            if (MultiValueMap.class.isAssignableFrom(type)) {
                mapProperty.setExample("{\r\n    \"additionalProp1\": [],\r\n    \"additionalProp2\": [],\r\n    \"additionalProp3\": []\r\n  },");
            }
            modelProperties.put(propertyName, (Property)mapProperty);
            new Chain(this.chainControl, (Property)mapProperty, (Type)((Object)valueType)).chain();
        } else {
            Property property = BasicMappingHolder.INSTANCE.buildBasicProperty(type);
            if (property == null) {
                RefProperty refProperty = new RefProperty();
                refProperty.set$ref("#/definitions/" + type.getName());
                if (this.chainControl.getDefinitions().get("#/definitions/" + type.getName()) == null) {
                    this.chainControl.getNewModelCreator().addIfParemeterizedType(type, false);
                }
                property = refProperty;
            }
            property.setName(propertyName);
            modelProperties.put(propertyName, property);
        }
    }
}

