/*
 * Decompiled with CFR 0.152.
 */
package jdd.util.jre;

import java.util.Arrays;
import java.util.Random;
import jdd.util.JDDConsole;
import jdd.util.jre.JREInfo;
import jdd.util.math.FastRandom;

public class JRETest {
    public static long mem_start;

    public static void mem_start() {
        for (int i = 0; i < 6; ++i) {
            System.gc();
        }
        mem_start = JREInfo.usedMemory();
    }

    public static long mem_end() {
        return JREInfo.usedMemory() - mem_start;
    }

    public static int rnd_size(int n) {
        if (n < 0) {
            return 0;
        }
        int n2 = 1 << n;
        return n2 + (int)(Math.random() * (double)n2);
    }

    public static void set1(int[] nArray, int n) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n;
        }
    }

    public static void set2(int[] nArray, int n) {
        Arrays.fill(nArray, n);
    }

    public static void set3(int[] nArray, int n) {
        int n2 = nArray.length / 4;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            nArray[n3] = n;
            nArray[n3 + 1] = n;
            nArray[n3 + 2] = n;
            nArray[n3 + 3] = n;
            n3 += 4;
        }
        n2 = nArray.length & 3;
        while (n2-- != 0) {
            nArray[n3++] = n;
        }
    }

    public static void copy1(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            nArray[i] = nArray2[i];
        }
    }

    public static void copy2(int[] nArray, int[] nArray2) {
        System.arraycopy(nArray2, 0, nArray, 0, nArray.length);
    }

    public static void copy3(int[] nArray, int[] nArray2) {
        int n = nArray.length / 4;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            nArray[n2] = nArray2[n2];
            nArray[n2 + 1] = nArray2[n2 + 1];
            nArray[n2 + 2] = nArray2[n2 + 2];
            nArray[n2 + 3] = nArray2[n2 + 3];
            n2 += 4;
        }
        n = nArray.length & 3;
        while (n-- != 0) {
            nArray[n2] = nArray2[n2];
            ++n2;
        }
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        JREInfo.show();
        JRETest jRETest = new JRETest();
        int n3 = 10240;
        int n4 = 10240;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        for (n2 = 0; n2 < n4; ++n2) {
            JRETest.set1(nArray, n2);
        }
        long l = System.currentTimeMillis();
        for (n2 = 0; n2 < n4; ++n2) {
            JRETest.set1(nArray, n2);
        }
        long l2 = System.currentTimeMillis() - l;
        for (n2 = 0; n2 < n4; ++n2) {
            JRETest.set2(nArray, n2);
        }
        l = System.currentTimeMillis();
        for (n2 = 0; n2 < n4; ++n2) {
            JRETest.set2(nArray, n2);
        }
        long l3 = System.currentTimeMillis() - l;
        if (l2 < l3) {
            System.out.println("SET: Java code is faster than Arrays.fill() [" + l2 + " vs " + l3 + "]");
        } else {
            System.out.println("SET: Arrays.fill() is faster than Java code [" + l3 + " vs " + l2 + "]");
        }
        for (n2 = 0; n2 < n4; ++n2) {
            JRETest.set3(nArray, n2);
        }
        l = System.currentTimeMillis();
        for (n2 = 0; n2 < n4; ++n2) {
            JRETest.set3(nArray, n2);
        }
        l2 = System.currentTimeMillis() - l;
        if (l2 < l3) {
            System.out.println("SET: unrolled java code is faster than Arrays.fill() [" + l2 + " vs " + l3 + "]");
        } else {
            System.out.println("SET: Arrays.fill() is faster than unrolled java code [" + l3 + " vs " + l2 + "]");
        }
        for (n2 = 0; n2 < n4; ++n2) {
            JRETest.copy1(nArray, nArray2);
        }
        l = System.currentTimeMillis();
        for (n2 = 0; n2 < n4; ++n2) {
            JRETest.copy1(nArray, nArray2);
        }
        l2 = System.currentTimeMillis() - l;
        for (n2 = 0; n2 < n4; ++n2) {
            JRETest.copy2(nArray, nArray2);
        }
        l = System.currentTimeMillis();
        for (n2 = 0; n2 < n4; ++n2) {
            JRETest.copy2(nArray, nArray2);
        }
        l3 = System.currentTimeMillis() - l;
        if (l2 < l3) {
            System.out.println("COPY: Java code is faster than System.arraycopy() [" + l2 + " vs " + l3 + "]");
        } else {
            System.out.println("COPY: System.arraycopy() is faster than Java code [" + l3 + " vs " + l2 + "]");
        }
        for (n2 = 0; n2 < n4; ++n2) {
            JRETest.copy3(nArray, nArray2);
        }
        l = System.currentTimeMillis();
        for (n2 = 0; n2 < n4; ++n2) {
            JRETest.copy3(nArray, nArray2);
        }
        l2 = System.currentTimeMillis() - l;
        if (l2 < l3) {
            System.out.println("COPY: unrolled loop is faster than System.arraycopy() [" + l2 + " vs " + l3 + "]");
        } else {
            System.out.println("COPY: System.arraycopy() is faster than unrolled loop [" + l3 + " vs " + l2 + "]");
        }
        JRETest.mem_start();
        Object object = new Object();
        long l4 = JRETest.mem_end();
        System.out.println("MEMORY: Object size = " + l4);
        int n5 = 10000;
        Random random = new Random();
        long l5 = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            n = FastRandom.mtrand() % n5;
            n = FastRandom.mtrand() % n5;
            n = FastRandom.mtrand() % n5;
            n = FastRandom.mtrand() % n5;
            n = FastRandom.mtrand() % n5;
            n = FastRandom.mtrand() % n5;
        }
        l5 = System.currentTimeMillis() - l5;
        long l6 = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            n = random.nextInt(n5);
            n = random.nextInt(n5);
            n = random.nextInt(n5);
            n = random.nextInt(n5);
            n = random.nextInt(n5);
            n = random.nextInt(n5);
        }
        l6 = System.currentTimeMillis() - l6;
        if (l5 < l6) {
            JDDConsole.out.println("LPRNG: FastRandom.mtrand() is " + (100L * l6 / l5 - 100L) + "% faster that Java code");
        } else {
            JDDConsole.out.println("LPRNG: Java is " + (100L * l5 / l6 - 100L) + "% faster that FastRandom.mtrand()");
        }
    }
}

