/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.commons.file;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bitcoins.commons.file.FileUtil$;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.matching.Regex;

public final class FileUtil$
implements Logging {
    public static FileUtil$ MODULE$;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new FileUtil$();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FileUtil$ fileUtil$ = this;
        synchronized (fileUtil$) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public Path zipDirectory(Path source, Path target, Vector<Regex> fileNameFilter) {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(target.toFile()));
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(fileNameFilter, target, zos, source){
            private final Vector fileNameFilter$1;
            private final Path target$1;
            private final ZipOutputStream zos$1;
            private final Path source$1;

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                FileVisitResult fileVisitResult;
                if (this.fileNameFilter$1.exists((Function1 & Serializable & scala.Serializable)reg -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$visitFile$1(file, reg)))) {
                    FileUtil$.MODULE$.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Skipping ").append(file.toAbsolutePath()).append(" for zip").toString());
                    fileVisitResult = FileVisitResult.CONTINUE;
                } else {
                    FileUtil$.MODULE$.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Zipping file=").append(file.toAbsolutePath()).append(" to ").append($this.target$1.toAbsolutePath()).toString());
                    this.zos$1.putNextEntry(new ZipEntry(((Object)this.source$1.relativize(file)).toString()));
                    Files.copy(file, this.zos$1);
                    this.zos$1.closeEntry();
                    FileUtil$.MODULE$.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Done zipping file=").append(file.toAbsolutePath()).toString());
                    fileVisitResult = FileVisitResult.CONTINUE;
                }
                return fileVisitResult;
            }

            public static final /* synthetic */ boolean $anonfun$visitFile$1(Path file$1, Regex reg) {
                return ((Object)file$1.toAbsolutePath()).toString().matches(reg.regex());
            }
            {
                this.fileNameFilter$1 = fileNameFilter$1;
                this.target$1 = target$1;
                this.zos$1 = zos$1;
                this.source$1 = source$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$visitFile$1$adapted(java.nio.file.Path scala.util.matching.Regex ), $anonfun$visitFile$2(java.nio.file.Path ), $anonfun$visitFile$3(org.bitcoins.commons.file.FileUtil$$anon$1 java.nio.file.Path ), $anonfun$visitFile$4(java.nio.file.Path )}, serializedLambda);
            }
        });
        zos.close();
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Zipping complete!");
        return target;
    }

    private FileUtil$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

