/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.commons.jsonmodels;

import java.io.Serializable;
import org.bitcoins.commons.jsonmodels.SerializedPSBT;
import org.bitcoins.commons.jsonmodels.SerializedPSBTGlobalMap;
import org.bitcoins.commons.jsonmodels.SerializedPSBTInputMap;
import org.bitcoins.commons.jsonmodels.SerializedPSBTOutputMap;
import org.bitcoins.commons.jsonmodels.SerializedTransaction;
import org.bitcoins.commons.jsonmodels.SerializedTransaction$;
import org.bitcoins.commons.jsonmodels.SerializedTransactionOutput;
import org.bitcoins.commons.jsonmodels.SerializedTransactionWitness;
import org.bitcoins.core.crypto.ExtPublicKey;
import org.bitcoins.core.number.UInt32;
import org.bitcoins.core.protocol.script.Script;
import org.bitcoins.core.protocol.transaction.Transaction;
import org.bitcoins.core.psbt.GlobalPSBTMap;
import org.bitcoins.core.psbt.GlobalPSBTRecord;
import org.bitcoins.core.psbt.InputPSBTMap;
import org.bitcoins.core.psbt.InputPSBTRecord;
import org.bitcoins.core.psbt.OutputPSBTMap;
import org.bitcoins.core.psbt.OutputPSBTRecord;
import org.bitcoins.core.psbt.PSBT;
import org.bitcoins.core.psbt.PSBTGlobalKeyId;
import org.bitcoins.core.psbt.PSBTInputKeyId;
import org.bitcoins.core.psbt.PSBTOutputKeyId;
import org.bitcoins.core.script.constant.ScriptToken;
import org.bitcoins.core.script.crypto.HashType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.TraversableLike;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scodec.bits.ByteVector;

public final class SerializedPSBT$
implements scala.Serializable {
    public static SerializedPSBT$ MODULE$;

    static {
        new SerializedPSBT$();
    }

    public SerializedPSBTGlobalMap decodeGlobalMap(GlobalPSBTMap global) {
        SerializedTransaction decodedTx = SerializedTransaction$.MODULE$.decodeRawTransaction((Transaction)global.unsignedTransaction().transaction());
        UInt32 version = global.version().version();
        Vector xpubs = (Vector)global.extendedPublicKeys().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.xpub(), Vector$.MODULE$.canBuildFrom());
        None$ xpubsOpt = xpubs.nonEmpty() ? new Some((Object)xpubs) : None$.MODULE$;
        Vector unknownRecords = global.getRecords((PSBTGlobalKeyId)PSBTGlobalKeyId.UnknownKeyId$.MODULE$);
        return new SerializedPSBTGlobalMap(decodedTx, version, (Option<Vector<ExtPublicKey>>)xpubsOpt, (Vector<GlobalPSBTRecord.Unknown>)unknownRecords);
    }

    public SerializedPSBTInputMap decodeInputMap(InputPSBTMap input, int index) {
        Option prevTxOpt = input.nonWitnessOrUnknownUTXOOpt().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.transactionSpent());
        Option nonWitnessUtxo = prevTxOpt.map((Function1 & Serializable & scala.Serializable)tx -> SerializedTransaction$.MODULE$.decodeRawTransaction((Transaction)tx));
        Option witnessUtxo = input.witnessUTXOOpt().map((Function1 & Serializable & scala.Serializable)rec -> SerializedTransaction$.MODULE$.decodeTransactionOutput(rec.witnessUTXO(), index));
        Vector sigs = input.partialSignatures();
        None$ sigsOpt = sigs.nonEmpty() ? new Some((Object)sigs) : None$.MODULE$;
        Option hashType = input.sigHashTypeOpt().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.hashType());
        Option redeemScript = input.redeemScriptOpt().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.redeemScript().asm().toVector());
        Option witScript = input.witnessScriptOpt().map((Function1 & Serializable & scala.Serializable)x$5 -> ((Script)x$5.witnessScript()).asm().toVector());
        Vector bip32Paths = input.BIP32DerivationPaths();
        None$ bip32PathsOpt = bip32Paths.nonEmpty() ? new Some((Object)bip32Paths) : None$.MODULE$;
        Option finalizedScriptSig = input.finalizedScriptSigOpt().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.scriptSig().asm().toVector());
        Option finalizedWitScript = input.finalizedScriptWitnessOpt().flatMap((Function1 & Serializable & scala.Serializable)rec -> SerializedTransaction$.MODULE$.decodeRawTransactionWitness(rec.scriptWitness()));
        Option porCommit = input.proofOfReservesCommitmentOpt().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.porCommitment());
        Vector unknowns = input.getRecords((PSBTInputKeyId)PSBTInputKeyId.UnknownKeyId$.MODULE$);
        return new SerializedPSBTInputMap((Option<SerializedTransaction>)nonWitnessUtxo, (Option<SerializedTransactionOutput>)witnessUtxo, (Option<Vector<InputPSBTRecord.PartialSignature>>)sigsOpt, (Option<HashType>)hashType, (Option<Vector<ScriptToken>>)redeemScript, (Option<Vector<ScriptToken>>)witScript, (Option<Vector<InputPSBTRecord.BIP32DerivationPath>>)bip32PathsOpt, (Option<Vector<ScriptToken>>)finalizedScriptSig, (Option<SerializedTransactionWitness>)finalizedWitScript, (Option<ByteVector>)porCommit, (Vector<InputPSBTRecord.Unknown>)unknowns);
    }

    public SerializedPSBTOutputMap decodeOutputMap(OutputPSBTMap output) {
        Option redeemScript = output.redeemScriptOpt().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.redeemScript().asm().toVector());
        Option witScript = output.witnessScriptOpt().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.witnessScript().asm().toVector());
        Vector bip32Paths = output.BIP32DerivationPaths();
        None$ bip32PathsOpt = bip32Paths.nonEmpty() ? new Some((Object)bip32Paths) : None$.MODULE$;
        Vector unknowns = output.getRecords((PSBTOutputKeyId)PSBTOutputKeyId.UnknownKeyId$.MODULE$);
        return new SerializedPSBTOutputMap((Option<Vector<ScriptToken>>)redeemScript, (Option<Vector<ScriptToken>>)witScript, (Option<Vector<OutputPSBTRecord.BIP32DerivationPath>>)bip32PathsOpt, (Vector<OutputPSBTRecord.Unknown>)unknowns);
    }

    public SerializedPSBT decodePSBT(PSBT psbt) {
        SerializedPSBTGlobalMap global = this.decodeGlobalMap(psbt.globalMap());
        Vector inputs = (Vector)((TraversableLike)psbt.inputMaps().zipWithIndex(Vector$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            InputPSBTMap input = (InputPSBTMap)tuple2._1();
            int index = tuple2._2$mcI$sp();
            SerializedPSBTInputMap serializedPSBTInputMap = MODULE$.decodeInputMap(input, index);
            return serializedPSBTInputMap;
        }, Vector$.MODULE$.canBuildFrom());
        Vector outputs = (Vector)psbt.outputMaps().map((Function1 & Serializable & scala.Serializable)output -> MODULE$.decodeOutputMap((OutputPSBTMap)output), Vector$.MODULE$.canBuildFrom());
        return new SerializedPSBT(global, (Vector<SerializedPSBTInputMap>)inputs, (Vector<SerializedPSBTOutputMap>)outputs);
    }

    public SerializedPSBT apply(SerializedPSBTGlobalMap global, Vector<SerializedPSBTInputMap> inputs, Vector<SerializedPSBTOutputMap> outputs) {
        return new SerializedPSBT(global, inputs, outputs);
    }

    public Option<Tuple3<SerializedPSBTGlobalMap, Vector<SerializedPSBTInputMap>, Vector<SerializedPSBTOutputMap>>> unapply(SerializedPSBT x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.global(), x$0.inputs(), x$0.outputs()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SerializedPSBT$() {
        MODULE$ = this;
    }
}

