/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.commons.jsonmodels;

import java.io.Serializable;
import org.bitcoins.commons.jsonmodels.SerializedTransaction;
import org.bitcoins.commons.jsonmodels.SerializedTransactionInput;
import org.bitcoins.commons.jsonmodels.SerializedTransactionOutput;
import org.bitcoins.commons.jsonmodels.SerializedTransactionWitness;
import org.bitcoins.core.number.Int32;
import org.bitcoins.core.number.UInt32;
import org.bitcoins.core.number.UInt32$;
import org.bitcoins.core.protocol.script.EmptyScriptWitness$;
import org.bitcoins.core.protocol.script.P2WPKHWitnessV0;
import org.bitcoins.core.protocol.script.P2WSHWitnessV0;
import org.bitcoins.core.protocol.script.Script;
import org.bitcoins.core.protocol.script.ScriptWitness;
import org.bitcoins.core.protocol.transaction.NonWitnessTransaction;
import org.bitcoins.core.protocol.transaction.Transaction;
import org.bitcoins.core.protocol.transaction.TransactionInput;
import org.bitcoins.core.protocol.transaction.TransactionOutput;
import org.bitcoins.core.protocol.transaction.WitnessTransaction;
import org.bitcoins.core.script.constant.ScriptConstant;
import org.bitcoins.core.script.constant.ScriptNumberOperation;
import org.bitcoins.core.script.constant.ScriptToken;
import org.bitcoins.crypto.DoubleSha256DigestBE;
import org.bitcoins.crypto.ECDigitalSignature;
import org.bitcoins.crypto.ECPublicKeyBytes;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple9;
import scala.collection.TraversableLike;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.runtime.BoxesRunTime;
import scodec.bits.ByteVector;

public final class SerializedTransaction$
implements scala.Serializable {
    public static SerializedTransaction$ MODULE$;

    static {
        new SerializedTransaction$();
    }

    public String tokenToString(ScriptToken token) {
        String string;
        ScriptToken scriptToken = token;
        if (scriptToken instanceof ScriptNumberOperation) {
            ScriptNumberOperation scriptNumberOperation = (ScriptNumberOperation)scriptToken;
            string = scriptNumberOperation.toString();
        } else if (scriptToken instanceof ScriptConstant) {
            ScriptConstant scriptConstant = (ScriptConstant)scriptToken;
            string = scriptConstant.bytes().toString();
        } else if (scriptToken != null) {
            ScriptToken scriptToken2 = scriptToken;
            string = scriptToken2.toString();
        } else {
            throw new MatchError((Object)scriptToken);
        }
        return string;
    }

    public Option<SerializedTransactionWitness> decodeRawTransactionWitness(ScriptWitness witness) {
        None$ none$;
        ScriptWitness scriptWitness = witness;
        if (EmptyScriptWitness$.MODULE$.equals(scriptWitness)) {
            none$ = None$.MODULE$;
        } else if (scriptWitness instanceof P2WPKHWitnessV0) {
            P2WPKHWitnessV0 p2WPKHWitnessV0 = (P2WPKHWitnessV0)scriptWitness;
            none$ = new Some((Object)new SerializedTransactionWitness(p2WPKHWitnessV0.hex(), (Option<String>)new Some((Object)"P2WPKH"), (Option<Vector<ScriptToken>>)None$.MODULE$, (Option<ECPublicKeyBytes>)new Some((Object)p2WPKHWitnessV0.pubKey()), (Option<ECDigitalSignature>)new Some((Object)p2WPKHWitnessV0.signature()), (Option<Vector<ByteVector>>)None$.MODULE$));
        } else if (scriptWitness instanceof P2WSHWitnessV0) {
            P2WSHWitnessV0 p2WSHWitnessV0 = (P2WSHWitnessV0)scriptWitness;
            none$ = new Some((Object)new SerializedTransactionWitness(p2WSHWitnessV0.hex(), (Option<String>)new Some((Object)"P2WSH"), (Option<Vector<ScriptToken>>)new Some((Object)((Script)p2WSHWitnessV0.redeemScript()).asm().toVector()), (Option<ECPublicKeyBytes>)None$.MODULE$, (Option<ECDigitalSignature>)None$.MODULE$, (Option<Vector<ByteVector>>)new Some((Object)p2WSHWitnessV0.stack().toVector().tail())));
        } else {
            throw new MatchError((Object)scriptWitness);
        }
        return none$;
    }

    public SerializedTransactionInput decodeTransactionInput(TransactionInput input, Option<ScriptWitness> witnessOpt) {
        Option decodedWitnessOpt = witnessOpt.flatMap((Function1 & Serializable & scala.Serializable)witness -> MODULE$.decodeRawTransactionWitness((ScriptWitness)witness));
        return new SerializedTransactionInput(input.previousOutput().txIdBE(), input.hex(), input.previousOutput().vout(), (Vector<ScriptToken>)input.scriptSignature().asm().toVector(), (Option<SerializedTransactionWitness>)decodedWitnessOpt, input.sequence());
    }

    public SerializedTransactionOutput decodeTransactionOutput(TransactionOutput output, int index) {
        return new SerializedTransactionOutput(output.value().toBigDecimal(), UInt32$.MODULE$.apply((long)index), (Vector<ScriptToken>)output.scriptPubKey().asm().toVector(), output.hex());
    }

    public SerializedTransaction decodeRawTransaction(Transaction tx) {
        None$ none$;
        Vector inputs = (Vector)((TraversableLike)tx.inputs().toVector().zipWithIndex(Vector$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            None$ none$;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            TransactionInput input = (TransactionInput)tuple2._1();
            int index = tuple2._2$mcI$sp();
            Transaction transaction = tx;
            if (transaction instanceof NonWitnessTransaction) {
                none$ = None$.MODULE$;
            } else {
                if (!(transaction instanceof WitnessTransaction)) throw new MatchError((Object)transaction);
                WitnessTransaction witnessTransaction = (WitnessTransaction)transaction;
                none$ = new Some(witnessTransaction.witness().witnesses().apply(index));
            }
            None$ witnessOpt = none$;
            return MODULE$.decodeTransactionInput(input, (Option<ScriptWitness>)witnessOpt);
        }, Vector$.MODULE$.canBuildFrom());
        Vector outputs = (Vector)((TraversableLike)tx.outputs().toVector().zipWithIndex(Vector$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TransactionOutput output = (TransactionOutput)tuple2._1();
            int index = tuple2._2$mcI$sp();
            SerializedTransactionOutput serializedTransactionOutput = MODULE$.decodeTransactionOutput(output, index);
            return serializedTransactionOutput;
        }, Vector$.MODULE$.canBuildFrom());
        Transaction transaction = tx;
        if (transaction instanceof NonWitnessTransaction) {
            none$ = None$.MODULE$;
        } else if (transaction instanceof WitnessTransaction) {
            WitnessTransaction witnessTransaction = (WitnessTransaction)transaction;
            none$ = new Some((Object)witnessTransaction.wTxIdBE());
        } else {
            throw new MatchError((Object)transaction);
        }
        None$ wtxIdOpt = none$;
        return new SerializedTransaction(tx.txIdBE(), (Option<DoubleSha256DigestBE>)wtxIdOpt, tx.version(), tx.byteSize(), tx.vsize(), tx.weight(), tx.lockTime(), (Vector<SerializedTransactionInput>)inputs, (Vector<SerializedTransactionOutput>)outputs);
    }

    public SerializedTransaction apply(DoubleSha256DigestBE txid, Option<DoubleSha256DigestBE> wtxid, Int32 version, long size, long vsize, long weight, UInt32 locktime, Vector<SerializedTransactionInput> vin, Vector<SerializedTransactionOutput> vout) {
        return new SerializedTransaction(txid, wtxid, version, size, vsize, weight, locktime, vin, vout);
    }

    public Option<Tuple9<DoubleSha256DigestBE, Option<DoubleSha256DigestBE>, Int32, Object, Object, Object, UInt32, Vector<SerializedTransactionInput>, Vector<SerializedTransactionOutput>>> unapply(SerializedTransaction x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple9((Object)x$0.txid(), x$0.wtxid(), (Object)x$0.version(), (Object)BoxesRunTime.boxToLong((long)x$0.size()), (Object)BoxesRunTime.boxToLong((long)x$0.vsize()), (Object)BoxesRunTime.boxToLong((long)x$0.weight()), (Object)x$0.locktime(), x$0.vin(), x$0.vout()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SerializedTransaction$() {
        MODULE$ = this;
    }
}

