/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.chain.blockchain;

import java.io.Serializable;
import org.bitcoins.chain.ChainVerificationLogger;
import org.bitcoins.chain.blockchain.Blockchain;
import org.bitcoins.chain.blockchain.Blockchain$;
import org.bitcoins.chain.blockchain.BlockchainUpdate;
import org.bitcoins.chain.blockchain.ConnectTipResult;
import org.bitcoins.chain.config.ChainAppConfig;
import org.bitcoins.chain.validation.TipUpdateResult;
import org.bitcoins.chain.validation.TipValidation$;
import org.bitcoins.core.api.chain.db.BlockHeaderDb;
import org.bitcoins.core.protocol.blockchain.BlockHeader;
import org.bitcoins.crypto.DoubleSha256DigestBE;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ma\u0001C\u0005\u000b!\u0003\r\tA\u0003\n\t\u000bu\u0001A\u0011A\u0010\t\u000b\r\u0002a\u0011\u0001\u0013\t\u000by\u0002A\u0011A \t\u000bY\u0003A\u0011A,\t\u000b=\u0004A\u0011\u00029\t\u000bU\u0004A\u0011\u0002<\t\r}\u0004AQAA\u0001\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001f\u0011\u0001DQ1tK\ncwnY6DQ\u0006LgnQ8na>\u0013'.Z2u\u0015\tYA\"\u0001\u0006cY>\u001c7n\u00195bS:T!!\u0004\b\u0002\u000b\rD\u0017-\u001b8\u000b\u0005=\u0001\u0012\u0001\u00032ji\u000e|\u0017N\\:\u000b\u0003E\t1a\u001c:h'\r\u00011#\u0007\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005iYR\"\u0001\u0007\n\u0005qa!aF\"iC&tg+\u001a:jM&\u001c\u0017\r^5p]2{wmZ3s\u0003\u0019!\u0013N\\5uI\r\u0001A#\u0001\u0011\u0011\u0005Q\t\u0013B\u0001\u0012\u0016\u0005\u0011)f.\u001b;\u0002\u0017\u0019\u0014x.\u001c%fC\u0012,'o\u001d\u000b\u0003K%\u0002\"AJ\u0014\u000e\u0003)I!\u0001\u000b\u0006\u0003\u0015\tcwnY6dQ\u0006Lg\u000eC\u0003+\u0005\u0001\u00071&A\u0004iK\u0006$WM]:\u0011\u00071\n4'D\u0001.\u0015\tqs&A\u0005j[6,H/\u00192mK*\u0011\u0001'F\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u001a.\u0005\r\u0019V-\u001d\t\u0003iqj\u0011!\u000e\u0006\u0003m]\n!\u0001\u001a2\u000b\u00055A$BA\u001d;\u0003\r\t\u0007/\u001b\u0006\u0003w9\tAaY8sK&\u0011Q(\u000e\u0002\u000e\u00052|7m\u001b%fC\u0012,'\u000f\u00122\u0002\u0015\r|gN\\3diRK\u0007\u000fF\u0002A\u0019V#\"!\u0011#\u0011\u0005\u0019\u0012\u0015BA\"\u000b\u0005A\u0019uN\u001c8fGR$\u0016\u000e\u001d*fgVdG\u000fC\u0003F\u0007\u0001\u000fa)\u0001\u0003d_:4\u0007CA$K\u001b\u0005A%BA%\r\u0003\u0019\u0019wN\u001c4jO&\u00111\n\u0013\u0002\u000f\u0007\"\f\u0017N\\!qa\u000e{gNZ5h\u0011\u0015i5\u00011\u0001O\u0003\u0019AW-\u00193feB\u0011qjU\u0007\u0002!*\u00111\"\u0015\u0006\u0003%j\n\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0003)B\u00131B\u00117pG.DU-\u00193fe\")1b\u0001a\u0001K\u000512m\u001c8oK\u000e$\b*Z1eKJ\u001cHk\\\"iC&t7\u000fF\u0002YU2$\"!\u00175\u0011\u0007i\u0013WM\u0004\u0002\\A:\u0011AlX\u0007\u0002;*\u0011aLH\u0001\u0007yI|w\u000e\u001e \n\u0003YI!!Y\u000b\u0002\u000fA\f7m[1hK&\u00111\r\u001a\u0002\u0007-\u0016\u001cGo\u001c:\u000b\u0005\u0005,\u0002C\u0001\u0014g\u0013\t9'B\u0001\tCY>\u001c7n\u00195bS:,\u0006\u000fZ1uK\")\u0011\u000e\u0002a\u0002\r\u0006q1\r[1j]\u0006\u0003\boQ8oM&<\u0007\"\u0002\u0016\u0005\u0001\u0004Y\u0007c\u0001.c\u001d\")Q\u000e\u0002a\u0001]\u0006Y!\r\\8dW\u000eD\u0017-\u001b8t!\rQ&-J\u0001\u0016a\u0006\u00148/Z\"p]:,7\r\u001e+jaJ+7/\u001e7u)\rI\u0016o\u001d\u0005\u0006e\u0016\u0001\r!Q\u0001\u0011G>tg.Z2u)&\u0004(+Z:vYRDQ\u0001^\u0003A\u0002\u0015\f!\u0002\\1tiV\u0003H-\u0019;f\u0003Y1\u0017N\u001c3Qe\u00164(\t\\8dW\"+\u0017\rZ3s\u0013\u0012DHcA<~}B\u0019A\u0003\u001f>\n\u0005e,\"AB(qi&|g\u000e\u0005\u0002\u0015w&\u0011A0\u0006\u0002\u0004\u0013:$\b\"B'\u0007\u0001\u0004q\u0005\"B\u0006\u0007\u0001\u0004)\u0013\u0001F2p]:,7\r^,bY.\u0014\u0015mY6xCJ$7\u000f\u0006\u0004\u0002\u0004\u0005\u0015\u0011\u0011\u0002\t\u00045\n\u001c\u0004BBA\u0004\u000f\u0001\u00071'A\u0004dkJ\u0014XM\u001c;\t\u000f\u0005-q\u00011\u0001\u0002\u0004\u0005I\u0011M\\2fgR|'o]\u0001\u0017e\u0016\u001cwN\\:ueV\u001cGO\u0012:p[\"+\u0017\rZ3sgR1\u0011\u0011CA\u000b\u00033!2A\\A\n\u0011\u0015I\u0007\u0002q\u0001G\u0011\u0019\t9\u0002\u0003a\u0001g\u0005Y1\r[5mI\"+\u0017\rZ3s\u0011\u001d\tY\u0001\u0003a\u0001\u0003\u0007\u0001")
public interface BaseBlockChainCompObject
extends ChainVerificationLogger {
    public Blockchain fromHeaders(Seq<BlockHeaderDb> var1);

    public static /* synthetic */ ConnectTipResult connectTip$(BaseBlockChainCompObject $this, BlockHeader header, Blockchain blockchain, ChainAppConfig conf) {
        return $this.connectTip(header, blockchain, conf);
    }

    default public ConnectTipResult connectTip(BlockHeader header, Blockchain blockchain, ChainAppConfig conf) {
        ConnectTipResult.BadTip badTip;
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(50).append("Attempting to add new tip=").append(header.hashBE().hex()).append(" with prevhash=").append(header.previousBlockHashBE().hex()).append(" to chain").toString());
        Option<Object> option = this.findPrevBlockHeaderIdx(header, blockchain);
        if (None$.MODULE$.equals(option)) {
            ConnectTipResult.BadTip failed;
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(125).append("No common ancestor found in the chain with tip=").append(blockchain.tip().hashBE().hex()).append(" to connect to hash=").append(header.hashBE().hex()).append(" prevHash=").append(header.previousBlockHashBE().hex()).append(". This may be because we have a competing reorg!").toString());
            TipUpdateResult.BadPreviousBlockHash err = new TipUpdateResult.BadPreviousBlockHash(header);
            badTip = failed = new ConnectTipResult.BadTip(err);
        } else if (option instanceof Some) {
            ConnectTipResult connectTipResult;
            TipUpdateResult tipResult;
            Some some = (Some)option;
            int prevHeaderIdx = BoxesRunTime.unboxToInt((Object)some.value());
            BlockHeaderDb prevBlockHeader = (BlockHeaderDb)blockchain.headers().apply(prevHeaderIdx);
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(72).append("Attempting to add new tip=").append(header.hashBE().hex()).append(" with prevhash=").append(header.previousBlockHashBE().hex()).append(" to chain of ").append(blockchain.length()).append(" headers with tip ").append(blockchain.tip().hashBE().hex()).toString());
            Blockchain chain = blockchain.fromValidHeader(prevBlockHeader);
            TipUpdateResult tipUpdateResult = tipResult = TipValidation$.MODULE$.checkNewTip(header, chain, conf);
            if (tipUpdateResult instanceof TipUpdateResult.Success) {
                ConnectTipResult connectTipResult2;
                TipUpdateResult.Success success = (TipUpdateResult.Success)tipUpdateResult;
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(43).append("Successfully verified=").append(success.header().hashBE().hex()).append(", connecting to chain").toString());
                int connectionIdx = blockchain.length() - prevHeaderIdx;
                if (connectionIdx != blockchain.length()) {
                    BlockHeaderDb blockHeaderDb = success.headerDb();
                    Blockchain newChain = new Blockchain((Vector<BlockHeaderDb>)((Vector)blockchain.headers().takeRight(connectionIdx).$plus$colon((Object)blockHeaderDb)));
                    connectTipResult2 = new ConnectTipResult.Reorg(success, newChain);
                } else {
                    Vector olderChain = blockchain.size() < 2016 ? blockchain.headers() : blockchain.headers().take(2015);
                    BlockHeaderDb blockHeaderDb = success.headerDb();
                    Blockchain newChain = new Blockchain((Vector<BlockHeaderDb>)((Vector)olderChain.$plus$colon((Object)blockHeaderDb)));
                    connectTipResult2 = new ConnectTipResult.ExtendChain(success, newChain);
                }
                connectTipResult = connectTipResult2;
            } else if (tipUpdateResult instanceof TipUpdateResult.Failure) {
                TipUpdateResult.Failure failure = (TipUpdateResult.Failure)tipUpdateResult;
                this.logger().warn((Function0 & Serializable)() -> new StringBuilder(33).append("Could not verify header=").append(header.hashBE().hex()).append(", reason=").append(failure).toString());
                connectTipResult = new ConnectTipResult.BadTip(failure);
            } else {
                throw new MatchError((Object)tipUpdateResult);
            }
            badTip = connectTipResult;
        } else {
            throw new MatchError(option);
        }
        ConnectTipResult.BadTip tipResult = badTip;
        return tipResult;
    }

    public static /* synthetic */ Vector connectHeadersToChains$(BaseBlockChainCompObject $this, Vector headers, Vector blockchains, ChainAppConfig chainAppConfig) {
        return $this.connectHeadersToChains((Vector<BlockHeader>)headers, (Vector<Blockchain>)blockchains, chainAppConfig);
    }

    default public Vector<BlockchainUpdate> connectHeadersToChains(Vector<BlockHeader> headers, Vector<Blockchain> blockchains, ChainAppConfig chainAppConfig) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(46).append("Attempting to connect ").append(headers.length()).append(" headers to ").append(blockchains.length()).append(" blockchains").toString());
        Vector initUpdates = (Vector)blockchains.map((Function1 & Serializable)blockchain -> new BlockchainUpdate.Successful((Blockchain)blockchain, (Vector<BlockHeaderDb>)package$.MODULE$.Vector().empty()));
        return (Vector)headers.foldLeft((Object)initUpdates, (Function2 & Serializable)(lastUpdates, h) -> (Vector)lastUpdates.flatMap((Function1 & Serializable)lastUpdate -> {
            ConnectTipResult connectTipResult = Blockchain$.MODULE$.connectTip((BlockHeader)h, lastUpdate.blockchain(), chainAppConfig);
            return this.parseConnectTipResult(connectTipResult, (BlockchainUpdate)lastUpdate);
        }));
    }

    private Vector<BlockchainUpdate> parseConnectTipResult(ConnectTipResult connectTipResult, BlockchainUpdate lastUpdate) {
        Vector vector;
        BlockchainUpdate blockchainUpdate = lastUpdate;
        if (blockchainUpdate instanceof BlockchainUpdate.Successful) {
            Vector vector2;
            ConnectTipResult connectTipResult2 = connectTipResult;
            if (connectTipResult2 instanceof ConnectTipResult.ExtendChain) {
                ConnectTipResult.ExtendChain extendChain = (ConnectTipResult.ExtendChain)connectTipResult2;
                TipUpdateResult.Success tipUpdateResult = extendChain.tipUpdateResult();
                Blockchain newChain = extendChain.newChain();
                BlockHeaderDb blockHeaderDb = tipUpdateResult.headerDb();
                BlockchainUpdate.Successful update = new BlockchainUpdate.Successful(newChain, (Vector<BlockHeaderDb>)((Vector)lastUpdate.successfulHeaders().$plus$colon((Object)blockHeaderDb)));
                vector2 = (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BlockchainUpdate.Successful[]{update}));
            } else if (connectTipResult2 instanceof ConnectTipResult.Reorg) {
                ConnectTipResult.Reorg reorg = (ConnectTipResult.Reorg)connectTipResult2;
                TipUpdateResult.Success tipUpdateResult = reorg.tipUpdateResult();
                Blockchain newChain = reorg.newChain();
                BlockHeaderDb blockHeaderDb = tipUpdateResult.headerDb();
                BlockchainUpdate.Successful competingUpdate = new BlockchainUpdate.Successful(newChain, (Vector<BlockHeaderDb>)((Vector)lastUpdate.successfulHeaders().$plus$colon((Object)blockHeaderDb)));
                vector2 = (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BlockchainUpdate[]{lastUpdate, competingUpdate}));
            } else if (connectTipResult2 instanceof ConnectTipResult.BadTip) {
                ConnectTipResult.BadTip badTip = (ConnectTipResult.BadTip)connectTipResult2;
                TipUpdateResult.Failure tipUpdateResult = badTip.tipUpdateResult();
                BlockchainUpdate.Failed failedUpdate = new BlockchainUpdate.Failed(lastUpdate.blockchain(), lastUpdate.successfulHeaders(), tipUpdateResult.header(), tipUpdateResult);
                vector2 = (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BlockchainUpdate.Failed[]{failedUpdate}));
            } else {
                throw new MatchError((Object)connectTipResult2);
            }
            vector = vector2;
        } else if (blockchainUpdate instanceof BlockchainUpdate.Failed) {
            BlockchainUpdate.Failed failed = (BlockchainUpdate.Failed)blockchainUpdate;
            vector = (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BlockchainUpdate.Failed[]{failed}));
        } else {
            throw new MatchError((Object)blockchainUpdate);
        }
        return vector;
    }

    private Option<Object> findPrevBlockHeaderIdx(BlockHeader header, Blockchain blockchain) {
        BlockHeaderDb latestTip = blockchain.tip();
        DoubleSha256DigestBE doubleSha256DigestBE = latestTip.hashBE();
        DoubleSha256DigestBE doubleSha256DigestBE2 = header.previousBlockHashBE();
        return !(doubleSha256DigestBE != null ? !doubleSha256DigestBE.equals(doubleSha256DigestBE2) : doubleSha256DigestBE2 != null) ? new Some((Object)BoxesRunTime.boxToInteger((int)0)) : blockchain.findHeaderIdx(header.previousBlockHashBE());
    }

    public static /* synthetic */ Vector connectWalkBackwards$(BaseBlockChainCompObject $this, BlockHeaderDb current, Vector ancestors) {
        return $this.connectWalkBackwards(current, (Vector<BlockHeaderDb>)ancestors);
    }

    default public Vector<BlockHeaderDb> connectWalkBackwards(BlockHeaderDb current, Vector<BlockHeaderDb> ancestors) {
        Map groupByHeight = ancestors.groupBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.height()));
        return this.loop$2(current, package$.MODULE$.Vector().empty(), groupByHeight);
    }

    public static /* synthetic */ Vector reconstructFromHeaders$(BaseBlockChainCompObject $this, BlockHeaderDb childHeader, Vector ancestors, ChainAppConfig chainAppConfig) {
        return $this.reconstructFromHeaders(childHeader, (Vector<BlockHeaderDb>)ancestors, chainAppConfig);
    }

    default public Vector<Blockchain> reconstructFromHeaders(BlockHeaderDb childHeader, Vector<BlockHeaderDb> ancestors, ChainAppConfig chainAppConfig) {
        Vector vector;
        Option blockchainUpdateOpt;
        None$ none$;
        Vector<BlockHeaderDb> orderedHeaders = this.connectWalkBackwards(childHeader, ancestors);
        if (orderedHeaders.isEmpty() || orderedHeaders.length() == 1) {
            none$ = None$.MODULE$;
        } else {
            Option dbOpt = ancestors.find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)BaseBlockChainCompObject.$anonfun$reconstructFromHeaders$1(orderedHeaders, x$5)));
            none$ = new Some((Object)Blockchain$.MODULE$.fromHeaders((Seq<BlockHeaderDb>)((Seq)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BlockHeaderDb[]{(BlockHeaderDb)dbOpt.get()})))));
        }
        None$ initBlockchainOpt = none$;
        Option option = blockchainUpdateOpt = initBlockchainOpt.map((Function1 & Serializable)initBlockchain -> Blockchain$.MODULE$.connectHeadersToChains((Vector<BlockHeader>)((Vector)orderedHeaders.tail().map((Function1 & Serializable)x$6 -> x$6.blockHeader())), (Vector<Blockchain>)((Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Blockchain[]{initBlockchain}))), chainAppConfig));
        if (option instanceof Some) {
            Some some = (Some)option;
            Vector v = (Vector)some.value();
            vector = (Vector)v.map((Function1 & Serializable)x$7 -> x$7.blockchain());
        } else if (None$.MODULE$.equals(option)) {
            vector = package$.MODULE$.Vector().empty();
        } else {
            throw new MatchError((Object)option);
        }
        return vector;
    }

    public static /* synthetic */ boolean $anonfun$connectWalkBackwards$3(BlockHeaderDb current$1, BlockHeaderDb x$4) {
        DoubleSha256DigestBE doubleSha256DigestBE = x$4.hashBE();
        DoubleSha256DigestBE doubleSha256DigestBE2 = current$1.previousBlockHashBE();
        return !(doubleSha256DigestBE != null ? !doubleSha256DigestBE.equals(doubleSha256DigestBE2) : doubleSha256DigestBE2 != null);
    }

    private Vector loop$2(BlockHeaderDb current, Vector accum, Map groupByHeight$1) {
        int prevHeight;
        Option possibleHeadersOpt;
        Option prevHeaderOpt;
        Option option;
        while ((option = (prevHeaderOpt = (possibleHeadersOpt = groupByHeight$1.get((Object)BoxesRunTime.boxToInteger((int)(prevHeight = current.height() - 1)))).flatMap((Function1 & Serializable)x$3 -> x$3.find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)BaseBlockChainCompObject.$anonfun$connectWalkBackwards$3(current, x$4)))))) instanceof Some) {
            Some some = (Some)option;
            BlockHeaderDb prevHeader = (BlockHeaderDb)some.value();
            BlockHeaderDb blockHeaderDb = current;
            accum = (Vector)accum.$plus$colon((Object)blockHeaderDb);
            current = prevHeader;
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError((Object)option);
        }
        BlockHeaderDb blockHeaderDb = current;
        Vector vector = (Vector)accum.$plus$colon((Object)blockHeaderDb);
        return vector;
    }

    public static /* synthetic */ boolean $anonfun$reconstructFromHeaders$1(Vector orderedHeaders$1, BlockHeaderDb x$5) {
        DoubleSha256DigestBE doubleSha256DigestBE = x$5.hashBE();
        DoubleSha256DigestBE doubleSha256DigestBE2 = ((BlockHeaderDb)orderedHeaders$1.head()).hashBE();
        return !(doubleSha256DigestBE != null ? !doubleSha256DigestBE.equals(doubleSha256DigestBE2) : doubleSha256DigestBE2 != null);
    }

    public static void $init$(BaseBlockChainCompObject $this) {
    }
}

