/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.chain.blockchain;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.bitcoins.chain.ChainCallbacks;
import org.bitcoins.chain.ChainVerificationLogger;
import org.bitcoins.chain.blockchain.BaseBlockChain;
import org.bitcoins.chain.blockchain.Blockchain;
import org.bitcoins.chain.blockchain.Blockchain$;
import org.bitcoins.chain.blockchain.BlockchainUpdate;
import org.bitcoins.chain.blockchain.ChainHandler$;
import org.bitcoins.chain.blockchain.ChainHandlerCached;
import org.bitcoins.chain.blockchain.DuplicateFilters;
import org.bitcoins.chain.blockchain.DuplicateHeaders;
import org.bitcoins.chain.blockchain.InvalidBlockHeader;
import org.bitcoins.chain.blockchain.UnknownBlockHash;
import org.bitcoins.chain.blockchain.UnknownBlockHeight;
import org.bitcoins.chain.blockchain.UnknownFilterHash;
import org.bitcoins.chain.config.ChainAppConfig;
import org.bitcoins.chain.models.BlockHeaderDAO;
import org.bitcoins.chain.models.ChainStateDescriptorDAO;
import org.bitcoins.chain.models.CompactFilterDAO;
import org.bitcoins.chain.models.CompactFilterHeaderDAO;
import org.bitcoins.chain.models.IsInitialBlockDownload;
import org.bitcoins.chain.pow.Pow$;
import org.bitcoins.core.api.chain.ChainApi;
import org.bitcoins.core.api.chain.ChainQueryApi;
import org.bitcoins.core.api.chain.FilterSyncMarker;
import org.bitcoins.core.api.chain.db.BlockHeaderDb;
import org.bitcoins.core.api.chain.db.CompactFilterDb;
import org.bitcoins.core.api.chain.db.CompactFilterDbHelper$;
import org.bitcoins.core.api.chain.db.CompactFilterHeaderDb;
import org.bitcoins.core.api.chain.db.CompactFilterHeaderDbHelper$;
import org.bitcoins.core.gcs.FilterHeader;
import org.bitcoins.core.number.Int32;
import org.bitcoins.core.number.UInt32;
import org.bitcoins.core.number.UInt32$;
import org.bitcoins.core.p2p.CompactFilterMessage;
import org.bitcoins.core.package;
import org.bitcoins.core.package$;
import org.bitcoins.core.protocol.BlockStamp;
import org.bitcoins.core.protocol.blockchain.BlockHeader;
import org.bitcoins.core.util.FutureUtil$;
import org.bitcoins.crypto.CryptoUtil$;
import org.bitcoins.crypto.DoubleSha256DigestBE;
import org.bitcoins.crypto.DoubleSha256DigestBE$;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.BigInt;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011%e\u0001\u0002)R\u0001iC\u0001B\u001c\u0001\u0003\u0006\u0004%\ta\u001c\u0005\tm\u0002\u0011\t\u0011)A\u0005a\"Aq\u000f\u0001BC\u0002\u0013\u0005\u0001\u0010\u0003\u0005}\u0001\t\u0005\t\u0015!\u0003z\u0011!i\bA!b\u0001\n\u0003q\b\"CA\u0003\u0001\t\u0005\t\u0015!\u0003\u0000\u0011)\t9\u0001\u0001BC\u0002\u0013\u0005\u0011\u0011\u0002\u0005\u000b\u0003#\u0001!\u0011!Q\u0001\n\u0005-\u0001BCA\n\u0001\t\u0015\r\u0011\"\u0001\u0002\u0016!Q\u0011\u0011\b\u0001\u0003\u0002\u0003\u0006I!a\u0006\t\u0015\u0005m\u0002A!b\u0001\n\u0007\ti\u0004\u0003\u0006\u0002L\u0001\u0011\t\u0011)A\u0005\u0003\u007fA!\"!\u0014\u0001\u0005\u0003\u0005\u000b1BA(\u0011\u001d\tY\u0006\u0001C\u0001\u0003;Bq!a\u001d\u0001\t\u0003\n)\bC\u0004\u0002\u0004\u0002!\t\"!\"\t\u000f\u0005=\u0006\u0001\"\u0011\u00022\"9\u0011Q\u0017\u0001\u0005B\u0005]\u0006bBAc\u0001\u0011\u0005\u0013q\u0019\u0005\b\u0003'\u0004A\u0011CAk\u0011\u001d\t\t\u0010\u0001C!\u0003gDq!a>\u0001\t\u0003\nI\u0010C\u0004\u0002~\u0002!\t\"a@\t\u000f\tU\u0001\u0001\"\u0011\u0003\u0018!9!Q\u0004\u0001\u0005\n\t}\u0001b\u0002B\u0015\u0001\u0011%!1\u0006\u0005\b\u0005k\u0001A\u0011\tB\u001c\u0011\u001d\u0011y\u0004\u0001C!\u0005\u0003BqA!\u0017\u0001\t\u0003\u0012Y\u0006C\u0004\u0003p\u0001!\tA!\u001d\t\u000f\t\u0015\u0005\u0001\"\u0003\u0003\b\"9!Q\u0013\u0001\u0005\n\t]\u0005b\u0002BT\u0001\u0011\u0005#\u0011\u0016\u0005\b\u0005g\u0003A\u0011\tB[\u0011\u001d\u0011i\f\u0001C!\u0005\u007fCqA!3\u0001\t\u0003\n)\bC\u0004\u0003L\u0002!\tE!4\t\u000f\tM\u0007\u0001\"\u0005\u0003V\"9!Q\u001c\u0001\u0005B\t}\u0007b\u0002Bq\u0001\u0011\u0005#1\u001d\u0005\b\u0005K\u0004A\u0011\u0002Bp\u0011\u001d\u00119\u000f\u0001C!\u0005SDqA!<\u0001\t\u0003\n)\bC\u0004\u0003p\u0002!\tE!=\t\u000f\te\b\u0001\"\u0011\u0003|\"91\u0011\u0002\u0001\u0005B\r-\u0001bBB\f\u0001\u0011\u00053\u0011\u0004\u0005\b\u0007C\u0001A\u0011IB\u0012\u0011\u001d\u00199\u0003\u0001C!\u0007SAqaa\u0016\u0001\t\u0003\u001aI\u0006C\u0004\u0004d\u0001!\ta!\u001a\t\u000f\r=\u0004\u0001\"\u0003\u0004r!91Q\u0012\u0001\u0005\n\r=\u0005bBBN\u0001\u0011%1Q\u0014\u0005\b\u0007W\u0003A\u0011BBW\u0011\u001d\u0019)\f\u0001C\u0001\u0007oCqaa/\u0001\t\u0013\u0019i\fC\u0004\u0004D\u0002!\ta!2\t\u0013\rE\u0007!%A\u0005\u0002\rM\u0007\"CBs\u0001E\u0005I\u0011ABt\u0011%\u0019Y\u000fAI\u0001\n\u0003\u0019i\u000fC\u0005\u0004r\u0002\t\n\u0011\"\u0001\u0004t\"I1q\u001f\u0001\u0012\u0002\u0013\u00051\u0011 \u0005\b\u0007{\u0004A\u0011AB\u0000\u0011\u001d!I\u0001\u0001C!\t\u0017Aq\u0001b\u0004\u0001\t\u0003\"\t\u0002C\u0004\u0005\u0014\u0001!\t\u0005\"\u0005\t\u000f\u0011U\u0001\u0001\"\u0011\u0005\u0018!9AQ\u0004\u0001\u0005B\u0011}\u0001b\u0002C\u0012\u0001\u0011%AQE\u0004\b\tS\t\u0006\u0012\u0001C\u0016\r\u0019\u0001\u0016\u000b#\u0001\u0005.!9\u00111\f%\u0005\u0002\u0011=\u0002b\u0002C\u0019\u0011\u0012\u0005A1\u0007\u0005\b\t\u0013BE\u0011\u0001C&\u0011\u001d!)\u0006\u0013C\u0001\t/Bq\u0001\"\rI\t\u0003!9\u0007C\u0004\u0005V!#\t\u0001b\u001e\t\u000f\ru\b\n\"\u0001\u0005\u0000\ta1\t[1j]\"\u000bg\u000e\u001a7fe*\u0011!kU\u0001\u000bE2|7m[2iC&t'B\u0001+V\u0003\u0015\u0019\u0007.Y5o\u0015\t1v+\u0001\u0005cSR\u001cw.\u001b8t\u0015\u0005A\u0016aA8sO\u000e\u00011\u0003\u0002\u0001\\C*\u0004\"\u0001X0\u000e\u0003uS\u0011AX\u0001\u0006g\u000e\fG.Y\u0005\u0003Av\u0013a!\u00118z%\u00164\u0007C\u00012i\u001b\u0005\u0019'B\u0001+e\u0015\t)g-A\u0002ba&T!aZ+\u0002\t\r|'/Z\u0005\u0003S\u000e\u0014\u0001b\u00115bS:\f\u0005/\u001b\t\u0003W2l\u0011aU\u0005\u0003[N\u0013qc\u00115bS:4VM]5gS\u000e\fG/[8o\u0019><w-\u001a:\u0002\u001d\tdwnY6IK\u0006$WM\u001d#B\u001fV\t\u0001\u000f\u0005\u0002ri6\t!O\u0003\u0002t'\u00061Qn\u001c3fYNL!!\u001e:\u0003\u001d\tcwnY6IK\u0006$WM\u001d#B\u001f\u0006y!\r\\8dW\"+\u0017\rZ3s\t\u0006{\u0005%A\bgS2$XM\u001d%fC\u0012,'\u000fR!P+\u0005I\bCA9{\u0013\tY(O\u0001\fD_6\u0004\u0018m\u0019;GS2$XM\u001d%fC\u0012,'\u000fR!P\u0003A1\u0017\u000e\u001c;fe\"+\u0017\rZ3s\t\u0006{\u0005%A\u0005gS2$XM\u001d#B\u001fV\tq\u0010E\u0002r\u0003\u0003I1!a\u0001s\u0005A\u0019u.\u001c9bGR4\u0015\u000e\u001c;fe\u0012\u000bu*\u0001\u0006gS2$XM\u001d#B\u001f\u0002\n\u0001b\u001d;bi\u0016$\u0015iT\u000b\u0003\u0003\u0017\u00012!]A\u0007\u0013\r\tyA\u001d\u0002\u0018\u0007\"\f\u0017N\\*uCR,G)Z:de&\u0004Ho\u001c:E\u0003>\u000b\u0011b\u001d;bi\u0016$\u0015i\u0014\u0011\u0002-\tdwnY6GS2$XM]\"iK\u000e\\\u0007o\\5oiN,\"!a\u0006\u0011\u0011\u0005e\u0011qEA\u0017\u0003[qA!a\u0007\u0002$A\u0019\u0011QD/\u000e\u0005\u0005}!bAA\u00113\u00061AH]8pizJ1!!\n^\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011FA\u0016\u0005\ri\u0015\r\u001d\u0006\u0004\u0003Ki\u0006\u0003BA\u0018\u0003ki!!!\r\u000b\u0007\u0005MR+\u0001\u0004def\u0004Ho\\\u0005\u0005\u0003o\t\tD\u0001\u000bE_V\u0014G.Z*iCJ*d\u0007R5hKN$()R\u0001\u0018E2|7m\u001b$jYR,'o\u00115fG.\u0004x.\u001b8ug\u0002\n1b\u00195bS:\u001cuN\u001c4jOV\u0011\u0011q\b\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011QI*\u0002\r\r|gNZ5h\u0013\u0011\tI%a\u0011\u0003\u001d\rC\u0017-\u001b8BaB\u001cuN\u001c4jO\u0006a1\r[1j]\u000e{gNZ5hA\u0005\u0001R\r_3dkRLwN\\\"p]R,\u0007\u0010\u001e\t\u0005\u0003#\n9&\u0004\u0002\u0002T)\u0019\u0011QK/\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002Z\u0005M#\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Qa\u0011qLA5\u0003W\ni'a\u001c\u0002rQ1\u0011\u0011MA3\u0003O\u00022!a\u0019\u0001\u001b\u0005\t\u0006bBA\u001e\u001d\u0001\u000f\u0011q\b\u0005\b\u0003\u001br\u00019AA(\u0011\u0015qg\u00021\u0001q\u0011\u00159h\u00021\u0001z\u0011\u0015ih\u00021\u0001\u0000\u0011\u001d\t9A\u0004a\u0001\u0003\u0017Aq!a\u0005\u000f\u0001\u0004\t9\"A\u0007hKR\u0014En\\2l\u0007>,h\u000e\u001e\u000b\u0003\u0003o\u0002b!!\u0015\u0002z\u0005u\u0014\u0002BA>\u0003'\u0012aAR;ukJ,\u0007c\u0001/\u0002\u0000%\u0019\u0011\u0011Q/\u0003\u0007%sG/\u0001\rhKR\u0014Um\u001d;CY>\u001c7\u000eS3bI\u0016\u0014\b*\u001a7qKJ$B!a\"\u0002\u0014B!\u0011\u0011RAH\u001b\t\tYIC\u0002\u0002\u000e\u000e\f!\u0001\u001a2\n\t\u0005E\u00151\u0012\u0002\u000e\u00052|7m\u001b%fC\u0012,'\u000f\u00122\t\u000f\u0005U\u0005\u00031\u0001\u0002\u0018\u000611\r[1j]N\u0004b!!'\u0002$\u0006%f\u0002BAN\u0003?sA!!\b\u0002\u001e&\ta,C\u0002\u0002\"v\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002&\u0006\u001d&A\u0002,fGR|'OC\u0002\u0002\"v\u0003B!a\u0019\u0002,&\u0019\u0011QV)\u0003\u0015\tcwnY6dQ\u0006Lg.\u0001\nhKR\u0014Um\u001d;CY>\u001c7\u000eS3bI\u0016\u0014HCAAZ!\u0019\t\t&!\u001f\u0002\b\u0006Iq-\u001a;IK\u0006$WM\u001d\u000b\u0005\u0003s\u000b\t\r\u0005\u0004\u0002R\u0005e\u00141\u0018\t\u00069\u0006u\u0016qQ\u0005\u0004\u0003\u007fk&AB(qi&|g\u000eC\u0004\u0002DJ\u0001\r!!\f\u0002\t!\f7\u000f[\u0001\u000bO\u0016$\b*Z1eKJ\u001cH\u0003BAe\u0003\u001b\u0004b!!\u0015\u0002z\u0005-\u0007CBAM\u0003G\u000bY\fC\u0004\u0002PN\u0001\r!!5\u0002\r!\f7\u000f[3t!\u0019\tI*a)\u0002.\u0005A\u0002O]8dKN\u001c\b*Z1eKJ\u001cx+\u001b;i\u0007\"\f\u0017N\\:\u0015\r\u0005]\u0017\u0011\\Aw!\u0015\t\t&!\u001fb\u0011\u001d\tY\u000e\u0006a\u0001\u0003;\fq\u0001[3bI\u0016\u00148\u000f\u0005\u0004\u0002\u001a\u0006\r\u0016q\u001c\t\u0005\u0003C\fI/\u0004\u0002\u0002d*\u0019!+!:\u000b\u0007\u0005\u001dh-\u0001\u0005qe>$xnY8m\u0013\u0011\tY/a9\u0003\u0017\tcwnY6IK\u0006$WM\u001d\u0005\b\u0003_$\u0002\u0019AAL\u0003-\u0011Gn\\2lG\"\f\u0017N\\:\u0002\u001dA\u0014xnY3tg\"+\u0017\rZ3sgR!\u0011q[A{\u0011\u001d\tY.\u0006a\u0001\u0003;\f\u0001cZ3u\u0005\u0016\u001cHO\u00117pG.D\u0015m\u001d5\u0015\u0005\u0005m\bCBA)\u0003s\ni#A\u0012oKb$(\t\\8dW\"+\u0017\rZ3s\u0005\u0006$8\r\u001b*b]\u001e,w+\u001b;i\u0007\"\f\u0017N\\:\u0015\u0011\t\u0005!1\u0002B\b\u0005'\u0001b!!\u0015\u0002z\t\r\u0001#\u0002/\u0002>\n\u0015\u0001c\u00012\u0003\b%\u0019!\u0011B2\u0003!\u0019KG\u000e^3s'ft7-T1sW\u0016\u0014\bb\u0002B\u0007/\u0001\u0007\u0011QF\u0001\raJ,go\u0015;pa\"\u000b7\u000f\u001b\u0005\b\u0005#9\u0002\u0019AA?\u0003%\u0011\u0017\r^2i'&TX\rC\u0004\u0002p^\u0001\r!a&\u000239,\u0007\u0010\u001e\"m_\u000e\\\u0007*Z1eKJ\u0014\u0015\r^2i%\u0006tw-\u001a\u000b\u0007\u0005\u0003\u0011IBa\u0007\t\u000f\t5\u0001\u00041\u0001\u0002.!9!\u0011\u0003\rA\u0002\u0005u\u0014A\u00044j]\u0012tU\r\u001f;IK\u0006$WM\u001d\u000b\t\u0005\u0003\u0011\tC!\n\u0003(!9!1E\rA\u0002\u0005m\u0016A\u00059sKZ\u0014En\\2l\u0011\u0016\fG-\u001a:PaRDqA!\u0005\u001a\u0001\u0004\ti\bC\u0004\u0002pf\u0001\r!a&\u0002)\u001d,GOQ3ti\u000eC\u0017-\u001b8Bi\"+\u0017n\u001a5u)!\u0011\u0019A!\f\u00032\tM\u0002b\u0002B\u00185\u0001\u0007\u0011QP\u0001\fgR\f'\u000f\u001e%fS\u001eDG\u000fC\u0004\u0003\u0012i\u0001\r!! \t\u000f\u0005=(\u00041\u0001\u0002\u0018\u0006Qb.\u001a=u\r&dG/\u001a:IK\u0006$WM\u001d\"bi\u000eD'+\u00198hKR1!\u0011\u0001B\u001d\u0005{AqAa\u000f\u001c\u0001\u0004\ti(\u0001\u0007gS2$XM\u001d%fS\u001eDG\u000fC\u0004\u0003\u0012m\u0001\r!! \u0002)A\u0014xnY3tg\u001aKG\u000e^3s\u0011\u0016\fG-\u001a:t)\u0019\t9Na\u0011\u0003V!9!Q\t\u000fA\u0002\t\u001d\u0013!\u00044jYR,'\u000fS3bI\u0016\u00148\u000f\u0005\u0004\u0002\u001a\u0006\r&\u0011\n\t\u0005\u0005\u0017\u0012\t&\u0004\u0002\u0003N)\u0019!q\n4\u0002\u0007\u001d\u001c7/\u0003\u0003\u0003T\t5#\u0001\u0004$jYR,'\u000fS3bI\u0016\u0014\bb\u0002B,9\u0001\u0007\u0011QF\u0001\tgR|\u0007\u000fS1tQ\u0006q\u0001O]8dKN\u001ch)\u001b7uKJ\u001cH\u0003BAl\u0005;BqAa\u0018\u001e\u0001\u0004\u0011\t'\u0001\u0005nKN\u001c\u0018mZ3t!\u0019\tI*a)\u0003dA!!Q\rB6\u001b\t\u00119GC\u0002\u0003j\u0019\f1\u0001\u001d\u001aq\u0013\u0011\u0011iGa\u001a\u0003)\r{W\u000e]1di\u001aKG\u000e^3s\u001b\u0016\u001c8/Y4f\u0003M1XM]5gs\u001aKG\u000e^3s\u0011\u0016\fG-\u001a:t)\u0011\u0011\u0019Ha\u001f\u0011\r\u0005E\u0013\u0011\u0010B;!\ra&qO\u0005\u0004\u0005sj&\u0001B+oSRDqA!\u0012\u001f\u0001\u0004\u0011i\b\u0005\u0004\u0002\u001a\u0006\r&q\u0010\t\u0005\u0003\u0013\u0013\t)\u0003\u0003\u0003\u0004\u0006-%!F\"p[B\f7\r\u001e$jYR,'\u000fS3bI\u0016\u0014HIY\u0001\u0012G\",7m\u001b$jYR,'\u000fS3bI\u0016\u0014H\u0003\u0002BE\u0005\u001f#BAa\u001d\u0003\f\"9!QR\u0010A\u0002\t}\u0014\u0001\u00044jYR,'\u000fS3bI\u0016\u0014\bb\u0002BI?\u0001\u0007!1S\u0001\u000eM&dG/\u001a:t\u0005fD\u0015m\u001d5\u0011\u0011\u0005e\u0011qEA\u0017\u0005\u007f\nqCZ5oI\u001aKG\u000e^3s\t\n4%o\\7NKN\u001c\u0018mZ3\u0015\r\te%q\u0014BQ!\u0011\tIIa'\n\t\tu\u00151\u0012\u0002\u0010\u0007>l\u0007/Y2u\r&dG/\u001a:EE\"9!Q\u0012\u0011A\u0002\t}\u0004b\u0002BRA\u0001\u0007!QU\u0001\u0014[\u0016\u001c8/Y4fg\nK(\t\\8dW\"\u000b7\u000f\u001b\t\t\u00033\t9#!\f\u0003d\u0005\u0011\u0002O]8dKN\u001c8\t[3dWB|\u0017N\u001c;t)\u0019\t9Na+\u00030\"9!QV\u0011A\u0002\u0005E\u0017aC2iK\u000e\\\u0007o\\5oiNDqA!-\"\u0001\u0004\ti#A\u0005cY>\u001c7\u000eS1tQ\u0006Iq-\u001a;GS2$XM\u001d\u000b\u0005\u0005o\u0013Y\f\u0005\u0004\u0002R\u0005e$\u0011\u0018\t\u00069\u0006u&\u0011\u0014\u0005\b\u0005c\u0013\u0003\u0019AA\u0017\u0003I9W\r\u001e%fC\u0012,'o]!u\u0011\u0016Lw\r\u001b;\u0015\t\t\u0005'Q\u0019\t\u0007\u0003#\nIHa1\u0011\r\u0005e\u00151UAD\u0011\u001d\u00119m\ta\u0001\u0003{\na\u0001[3jO\"$\u0018\u0001F4fi\u001aKG\u000e^3s\u0011\u0016\fG-\u001a:D_VtG/\u0001\rhKR4\u0015\u000e\u001c;fe\"+\u0017\rZ3sg\u0006#\b*Z5hQR$BAa4\u0003RB1\u0011\u0011KA=\u0005{BqAa2&\u0001\u0004\ti(A\u000fhKR\u0014Um\u001d;GS2$XM\u001d%fC\u0012,'oV5uQ\u000eC\u0017-\u001b8t)\u0011\u00119Na7\u0011\r\u0005E\u0013\u0011\u0010Bm!\u0015a\u0016Q\u0018B@\u0011\u001d\tyO\na\u0001\u0003/\u000b1cZ3u\u0005\u0016\u001cHOR5mi\u0016\u0014\b*Z1eKJ$\"Aa6\u0002\u001b\u001d,GOQ3ti\u001aKG\u000e^3s)\t\u00119,\u0001\fcKN$h)\u001b7uKJDU-\u00193feN+\u0017M]2i\u0003=9W\r\u001e$jYR,'\u000fS3bI\u0016\u0014H\u0003\u0002Bl\u0005WDqA!-+\u0001\u0004\ti#\u0001\bhKR4\u0015\u000e\u001c;fe\u000e{WO\u001c;\u0002%\u001d,GOR5mi\u0016\u00148/\u0011;IK&<\u0007\u000e\u001e\u000b\u0005\u0005g\u00149\u0010\u0005\u0004\u0002R\u0005e$Q\u001f\t\u0007\u00033\u000b\u0019K!'\t\u000f\t\u001dG\u00061\u0001\u0002~\u0005)r-\u001a;IK&<\u0007\u000e\u001e\"z\u00052|7m[*uC6\u0004H\u0003BA<\u0005{DqAa@.\u0001\u0004\u0019\t!\u0001\u0006cY>\u001c7n\u0015;b[B\u0004Baa\u0001\u0004\u00065\u0011\u0011Q]\u0005\u0005\u0007\u000f\t)O\u0001\u0006CY>\u001c7n\u0015;b[B\f\u0001$\u001a9pG\"\u001cVmY8oIR{'\t\\8dW\"+\u0017n\u001a5u)\u0011\t9h!\u0004\t\u000f\r=a\u00061\u0001\u0004\u0012\u0005!A/[7f!\ra61C\u0005\u0004\u0007+i&\u0001\u0002'p]\u001e\fabZ3u\u00052|7m\u001b%fS\u001eDG\u000f\u0006\u0003\u0004\u001c\r}\u0001CBA)\u0003s\u001ai\u0002E\u0003]\u0003{\u000bi\bC\u0004\u00032>\u0002\r!!\f\u00021\u001d,GOT;nE\u0016\u0014xJZ\"p]\u001aL'/\\1uS>t7\u000f\u0006\u0003\u0004\u001c\r\u0015\u0002b\u0002BYa\u0001\u0007\u0011QF\u0001\u0019O\u0016$h)\u001b7uKJ\u001c()\u001a;xK\u0016t\u0007*Z5hQR\u001cHCBB\u0016\u0007#\u001a\u0019\u0006\u0005\u0004\u0002R\u0005e4Q\u0006\t\u0007\u00033\u000b\u0019ka\f\u0011\t\rE21\n\b\u0005\u0007g\u00199E\u0004\u0003\u00046\r\u0015c\u0002BB\u001c\u0007\u0007rAa!\u000f\u0004B9!11HB \u001d\u0011\tib!\u0010\n\u0003aK!AV,\n\u0005\u001d,\u0016BA3g\u0013\t!F-C\u0002\u0004J\r\fQb\u00115bS:\fV/\u001a:z\u0003BL\u0017\u0002BB'\u0007\u001f\u0012aBR5mi\u0016\u0014(+Z:q_:\u001cXMC\u0002\u0004J\rDqAa\f2\u0001\u0004\ti\bC\u0004\u0004VE\u0002\r!! \u0002\u0013\u0015tG\rS3jO\"$\u0018!E4fi\"+\u0017\rZ3sg\n+Go^3f]R1!\u0011YB.\u0007?Bqa!\u00183\u0001\u0004\t9)\u0001\u0003ge>l\u0007bBB1e\u0001\u0007\u0011qQ\u0001\u0003i>\f!#[:NSN\u001c\u0018N\\4DQ\u0006LgnV8sWV\u00111q\r\t\u0007\u0003#\nIh!\u001b\u0011\u0007q\u001bY'C\u0002\u0004nu\u0013qAQ8pY\u0016\fg.A\u0007dC2\u001c7\t[1j]^{'o\u001b\u000b\t\u0005\u0007\u001c\u0019ha\u001e\u0004|!91Q\u000f\u001bA\u0002\t\r\u0017\u0001\u0005:f[\u0006Lg.\u001b8h\u0011\u0016\fG-\u001a:t\u0011\u001d\u0019I\b\u000ea\u0001\u0005\u0007\fQ!Y2dk6Dqa! 5\u0001\u0004\t9)\u0001\fmCN$\b*Z1eKJ<\u0016\u000e\u001e5X_J\\\u0017J\u001c#cQ\r!4\u0011\u0011\t\u0005\u0007\u0007\u001bI)\u0004\u0002\u0004\u0006*\u00191qQ/\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004\f\u000e\u0015%a\u0002;bS2\u0014XmY\u0001\u0012O\u0016$()\u0019;dQ\u001a{'OU3dC2\u001cG\u0003CBI\u0007'\u001b)j!'\u0011\r\u0005E\u0013\u0011PAL\u0011\u001d\u0011y#\u000ea\u0001\u0003{Bqaa&6\u0001\u0004\ti(A\u0005nCbDU-[4ii\"9!\u0011C\u001bA\u0002\u0005u\u0014A\u00062bi\u000eD\u0017I\u001c3HKR\u0014En\\2lG\"\f\u0017N\\:\u0015\u0015\rE5qTBQ\u0007K\u001b9\u000bC\u0004\u0003\u0012Y\u0002\r!! \t\u000f\r\rf\u00071\u0001\u0002~\u0005\u0001\"-\u0019;dQN#\u0018M\u001d;IK&<\u0007\u000e\u001e\u0005\b\u0007/3\u0004\u0019AA?\u0011\u001d\u0019IK\u000ea\u0001\u0003{\n!B\\;n\u0005\u0006$8\r[3t\u0003]\u0011XO\u001c*fG\u0006d7-\u001e7bi\u0016\u001c\u0005.Y5o/>\u00148\u000e\u0006\u0004\u0003B\u000e=6\u0011\u0017\u0005\b\u0007/;\u0004\u0019AA?\u0011\u001d\u0019\u0019l\u000ea\u0001\u0003\u000f\u000b!\u0002\\1ti\"+\u0017\rZ3s\u0003Q\u0011XmY1mGVd\u0017\r^3DQ\u0006LgnV8sWV\u00111\u0011\u0018\t\u0007\u0003#\nI(!\u0019\u0002=\r\fGnY;mCR,7\t[1j]^{'o[$f]\u0016\u001c\u0018n\u001d\"m_\u000e\\G\u0003BAZ\u0007\u007fCqa!1:\u0001\u0004\t9)A\u0007hK:,7/[:IK\u0006$WM]\u0001\tG>\u0004\u0018pV5uQRa\u0011\u0011MBd\u0007\u0013\u001cYm!4\u0004P\"9aN\u000fI\u0001\u0002\u0004\u0001\bbB<;!\u0003\u0005\r!\u001f\u0005\b{j\u0002\n\u00111\u0001\u0000\u0011%\t9A\u000fI\u0001\u0002\u0004\tY\u0001C\u0005\u0002\u0014i\u0002\n\u00111\u0001\u0002\u0018\u0005\u00112m\u001c9z/&$\b\u000e\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019)NK\u0002q\u0007/\\#a!7\u0011\t\rm7\u0011]\u0007\u0003\u0007;TAaa8\u0004\u0006\u0006IQO\\2iK\u000e\\W\rZ\u0005\u0005\u0007G\u001ciNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!cY8qs^KG\u000f\u001b\u0013eK\u001a\fW\u000f\u001c;%eU\u00111\u0011\u001e\u0016\u0004s\u000e]\u0017AE2paf<\u0016\u000e\u001e5%I\u00164\u0017-\u001e7uIM*\"aa<+\u0007}\u001c9.\u0001\nd_BLx+\u001b;iI\u0011,g-Y;mi\u0012\"TCAB{U\u0011\tYaa6\u0002%\r|\u0007/_,ji\"$C-\u001a4bk2$H%N\u000b\u0003\u0007wTC!a\u0006\u0004X\u0006!Bo\\\"iC&t\u0007*\u00198eY\u0016\u00148)Y2iK\u0012,\"\u0001\"\u0001\u0011\r\u0005E\u0013\u0011\u0010C\u0002!\u0011\t\u0019\u0007\"\u0002\n\u0007\u0011\u001d\u0011K\u0001\nDQ\u0006Lg\u000eS1oI2,'oQ1dQ\u0016$\u0017!E4fi6+G-[1o)&lW\rU1tiR\u0011AQ\u0002\t\u0007\u0003#\nIh!\u0005\u0002\u0013%\u001c8+\u001f8dS:<GCAB4\u0003\u0015I7/\u0013\"E\u0003)\u0019X\r^*z]\u000eLgn\u001a\u000b\u0005\u0003/$I\u0002C\u0004\u0005\u001c\u0011\u0003\ra!\u001b\u0002\u000bY\fG.^3\u0002\rM,G/\u0013\"E)\u0011\t9\u000e\"\t\t\u000f\u0011mQ\t1\u0001\u0004j\u0005yR\u000f\u001d3bi\u0016\u001c\u0016P\\2j]\u001e\fe\u000eZ#yK\u000e,H/Z\"bY2\u0014\u0017mY6\u0015\t\tMDq\u0005\u0005\b\t71\u0005\u0019AB5\u00031\u0019\u0005.Y5o\u0011\u0006tG\r\\3s!\r\t\u0019\u0007S\n\u0003\u0011n#\"\u0001b\u000b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0019\u0011UBq\bC!\t\u0007\")\u0005b\u0012\u0015\r\u0005\u0005Dq\u0007C\u001e\u0011\u001d!ID\u0013a\u0002\u0003\u001f\n!!Z2\t\u000f\u0011u\"\nq\u0001\u0002@\u0005q1\r[1j]\u0006\u0003\boQ8oM&<\u0007\"\u00028K\u0001\u0004\u0001\b\"B<K\u0001\u0004I\b\"B?K\u0001\u0004y\bbBA\u0004\u0015\u0002\u0007\u00111\u0002\u0005\b\u0003'Q\u0005\u0019AA\f\u0003Y1'o\\7DQ\u0006Lg\u000eS1oI2,'oQ1dQ\u0016$G\u0003\u0002C'\t#\"B!!\u0019\u0005P!9A\u0011H&A\u0004\u0005=\u0003b\u0002C*\u0017\u0002\u0007A1A\u0001\u0007G\u0006\u001c\u0007.\u001a3\u0002\u0019\u0019\u0014x.\u001c#bi\u0006\u0014\u0017m]3\u0015\u0015\u0011eCq\fC1\tG\")\u0007\u0006\u0004\u0002b\u0011mCQ\f\u0005\b\tsa\u00059AA(\u0011\u001d\tY\u0004\u0014a\u0002\u0003\u007fAQA\u001c'A\u0002ADQa\u001e'A\u0002eDQ! 'A\u0002}Dq!a\u0002M\u0001\u0004\tY\u0001\u0006\u0006\u0005j\u0011=D\u0011\u000fC:\tk\"b!!\u0019\u0005l\u00115\u0004b\u0002C\u001d\u001b\u0002\u000f\u0011q\n\u0005\b\u0003wi\u00059AA \u0011\u0015qW\n1\u0001q\u0011\u00159X\n1\u0001z\u0011\u0015iX\n1\u0001\u0000\u0011\u001d\t9!\u0014a\u0001\u0003\u0017!\"\u0001\"\u001f\u0015\r\u0005\u0005D1\u0010C?\u0011\u001d!ID\u0014a\u0002\u0003\u001fBq!a\u000fO\u0001\b\ty\u0004\u0006\u0003\u0005\u0002\u0012\u0015E\u0003\u0002C\u0001\t\u0007Cq\u0001\"\u000fP\u0001\b\ty\u0005C\u0004\u0005\b>\u0003\r!!\u0019\u0002\u0019\rD\u0017-\u001b8IC:$G.\u001a:")
public class ChainHandler
implements ChainApi,
ChainVerificationLogger {
    private final BlockHeaderDAO blockHeaderDAO;
    private final CompactFilterHeaderDAO filterHeaderDAO;
    private final CompactFilterDAO filterDAO;
    private final ChainStateDescriptorDAO stateDAO;
    private final Map<DoubleSha256DigestBE, DoubleSha256DigestBE> blockFilterCheckpoints;
    private final ChainAppConfig chainConfig;
    private final ExecutionContext executionContext;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static ChainHandler fromDatabase(ExecutionContext ec, ChainAppConfig chainConfig) {
        return ChainHandler$.MODULE$.fromDatabase(ec, chainConfig);
    }

    public static ChainHandler apply(BlockHeaderDAO blockHeaderDAO, CompactFilterHeaderDAO filterHeaderDAO, CompactFilterDAO filterDAO, ChainStateDescriptorDAO stateDAO, ExecutionContext ec, ChainAppConfig chainConfig) {
        return ChainHandler$.MODULE$.apply(blockHeaderDAO, filterHeaderDAO, filterDAO, stateDAO, ec, chainConfig);
    }

    public static ChainHandler fromDatabase(BlockHeaderDAO blockHeaderDAO, CompactFilterHeaderDAO filterHeaderDAO, CompactFilterDAO filterDAO, ChainStateDescriptorDAO stateDAO, ExecutionContext ec, ChainAppConfig chainConfig) {
        return ChainHandler$.MODULE$.fromDatabase(blockHeaderDAO, filterHeaderDAO, filterDAO, stateDAO, ec, chainConfig);
    }

    public static ChainHandler fromChainHandlerCached(ChainHandlerCached cached, ExecutionContext ec) {
        return ChainHandler$.MODULE$.fromChainHandlerCached(cached, ec);
    }

    public static ChainHandler apply(BlockHeaderDAO blockHeaderDAO, CompactFilterHeaderDAO filterHeaderDAO, CompactFilterDAO filterDAO, ChainStateDescriptorDAO stateDAO, Map<DoubleSha256DigestBE, DoubleSha256DigestBE> blockFilterCheckpoints, ExecutionContext ec, ChainAppConfig chainAppConfig) {
        return ChainHandler$.MODULE$.apply(blockHeaderDAO, filterHeaderDAO, filterDAO, stateDAO, blockFilterCheckpoints, ec, chainAppConfig);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public Future<ChainApi> processHeader(BlockHeader header) {
        return ChainApi.processHeader$((ChainApi)this, (BlockHeader)header);
    }

    public Future<ChainApi> processFilterHeader(FilterHeader filterHeader, DoubleSha256DigestBE blockHash) {
        return ChainApi.processFilterHeader$((ChainApi)this, (FilterHeader)filterHeader, (DoubleSha256DigestBE)blockHash);
    }

    public Future<ChainApi> processFilter(CompactFilterMessage message) {
        return ChainApi.processFilter$((ChainApi)this, (CompactFilterMessage)message);
    }

    public Future<ChainApi> processCheckpoint(DoubleSha256DigestBE filterHeaderHash, DoubleSha256DigestBE blockHash) {
        return ChainApi.processCheckpoint$((ChainApi)this, (DoubleSha256DigestBE)filterHeaderHash, (DoubleSha256DigestBE)blockHash);
    }

    public Future<Object> getBestHashBlockHeight(ExecutionContext ec) {
        return ChainQueryApi.getBestHashBlockHeight$((ChainQueryApi)this, (ExecutionContext)ec);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ChainHandler chainHandler = this;
        synchronized (chainHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public BlockHeaderDAO blockHeaderDAO() {
        return this.blockHeaderDAO;
    }

    public CompactFilterHeaderDAO filterHeaderDAO() {
        return this.filterHeaderDAO;
    }

    public CompactFilterDAO filterDAO() {
        return this.filterDAO;
    }

    public ChainStateDescriptorDAO stateDAO() {
        return this.stateDAO;
    }

    public Map<DoubleSha256DigestBE, DoubleSha256DigestBE> blockFilterCheckpoints() {
        return this.blockFilterCheckpoints;
    }

    public ChainAppConfig chainConfig() {
        return this.chainConfig;
    }

    public Future<Object> getBlockCount() {
        this.logger().debug((Function0 & Serializable)() -> "Querying for block count");
        return this.blockHeaderDAO().bestHeight().map((Function1)(JFunction1.mcII.sp & Serializable)height -> {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(28).append("getBlockCount result: count=").append(height).toString());
            return height;
        }, this.executionContext);
    }

    public BlockHeaderDb getBestBlockHeaderHelper(Vector<Blockchain> chains) {
        BlockHeaderDb blockHeaderDb;
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(45).append("Finding best block hash out of chains.length=").append(chains.length()).toString());
        Map groupedChains = chains.groupBy((Function1 & Serializable)x$1 -> x$1.tip().chainWork());
        BigInt maxWork = (BigInt)groupedChains.keys().max((Ordering)Ordering.BigInt$.MODULE$);
        Vector chainsByWork = (Vector)groupedChains.apply((Object)maxWork);
        if (chainsByWork.isEmpty()) {
            String errMsg = new StringBuilder(34).append("Did not find blockchain with work ").append(maxWork).toString();
            this.logger().error((Function0 & Serializable)() -> errMsg);
            throw new RuntimeException(errMsg);
        }
        if (chainsByWork.length() == 1) {
            blockHeaderDb = ((BaseBlockChain)chainsByWork.head()).tip();
        } else {
            String tips = ((IterableOnceOps)chainsByWork.map((Function1 & Serializable)x$2 -> x$2.tip().hashBE().hex())).mkString(", ");
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(74).append("We have multiple competing blockchains with same work, selecting by time: ").append(tips).toString());
            blockHeaderDb = ((BaseBlockChain)chainsByWork.minBy((Function1 & Serializable)x$3 -> x$3.tip().time(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).tip();
        }
        BlockHeaderDb bestHeader = blockHeaderDb;
        return bestHeader;
    }

    public Future<BlockHeaderDb> getBestBlockHeader() {
        Future<Vector<BlockHeaderDb>> tipsF = this.blockHeaderDAO().getBestChainTips();
        return tipsF.map((Function1 & Serializable)tips -> {
            Vector chains = (Vector)tips.map((Function1 & Serializable)t -> Blockchain$.MODULE$.fromHeaders((Seq<BlockHeaderDb>)((Seq)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BlockHeaderDb[]{t})))));
            return new Tuple2(tips, (Object)chains);
        }, this.executionContext).map((Function1 & Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector chains = (Vector)tuple2._2();
            BlockHeaderDb blockHeaderDb = this.getBestBlockHeaderHelper((Vector<Blockchain>)chains);
            return blockHeaderDb;
        }, this.executionContext);
    }

    public Future<Option<BlockHeaderDb>> getHeader(DoubleSha256DigestBE hash) {
        return this.getHeaders((Vector<DoubleSha256DigestBE>)((Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DoubleSha256DigestBE[]{hash})))).map((Function1 & Serializable)x$5 -> (Option)x$5.head(), this.executionContext);
    }

    public Future<Vector<Option<BlockHeaderDb>>> getHeaders(Vector<DoubleSha256DigestBE> hashes) {
        return this.blockHeaderDAO().findByHashes(hashes);
    }

    public Future<ChainApi> processHeadersWithChains(Vector<BlockHeader> headers2, Vector<Blockchain> blockchains) {
        Future future;
        if (headers2.isEmpty()) {
            future = Future$.MODULE$.successful((Object)this);
        } else {
            Vector headersWeAlreadyHave = (Vector)blockchains.flatMap((Function1 & Serializable)x$6 -> x$6.headers());
            Vector filteredHeaders = (Vector)headers2.filterNot((Function1 & Serializable)h -> BoxesRunTime.boxToBoolean((boolean)headersWeAlreadyHave.exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ChainHandler.$anonfun$processHeadersWithChains$3(h, x$7)))));
            if (filteredHeaders.isEmpty()) {
                return Future$.MODULE$.failed((Throwable)new DuplicateHeaders("Received duplicate headers."));
            }
            Vector<BlockchainUpdate> blockchainUpdates = Blockchain$.MODULE$.connectHeadersToChains((Vector<BlockHeader>)filteredHeaders, blockchains, this.chainConfig());
            Vector successfullyValidatedHeaders = (Vector)blockchainUpdates.flatMap((Function1 & Serializable)x$8 -> x$8.successfulHeaders());
            Vector headersToBeCreated = (Vector)successfullyValidatedHeaders.distinct();
            if (headersToBeCreated.isEmpty()) {
                future = Future$.MODULE$.failed((Throwable)new InvalidBlockHeader(new StringBuilder(68).append("Failed to connect any headers to our internal chain state, failures=").append(blockchainUpdates).toString()));
            } else {
                Vector chains = (Vector)blockchainUpdates.map((Function1 & Serializable)x$9 -> x$9.blockchain());
                Future<Vector<BlockHeaderDb>> createdF = this.blockHeaderDAO().createAll((Vector<BlockHeaderDb>)headersToBeCreated);
                ChainHandler newChainHandler = ChainHandler$.MODULE$.apply(this.blockHeaderDAO(), this.filterHeaderDAO(), this.filterDAO(), this.stateDAO(), this.blockFilterCheckpoints(), this.executionContext, this.chainConfig());
                future = createdF.map((Function1 & Serializable)headers -> {
                    Future<BoxedUnit> future;
                    if (((ChainCallbacks)this.chainConfig().callBacks()).onBlockHeaderConnected().nonEmpty()) {
                        Vector headersWithHeight = headersToBeCreated.reverseIterator().map((Function1 & Serializable)h -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)h.height()), (Object)h.blockHeader())).toVector();
                        future = ((ChainCallbacks)this.chainConfig().callBacks()).executeOnBlockHeaderConnectedCallbacks((Vector<Tuple2<Object, BlockHeader>>)headersWithHeight, $this.executionContext);
                    } else {
                        future = BoxedUnit.UNIT;
                    }
                    chains.foreach((Function1 & Serializable)c -> {
                        ChainHandler.$anonfun$processHeadersWithChains$8(this, headers, c);
                        return BoxedUnit.UNIT;
                    });
                    return newChainHandler;
                }, this.executionContext);
            }
        }
        return future;
    }

    /*
     * WARNING - void declaration
     */
    public Future<ChainApi> processHeaders(Vector<BlockHeader> headers) {
        void var3_3;
        Future<Vector<Blockchain>> blockchainsF = this.blockHeaderDAO().getBlockchains(this.executionContext);
        Future resultF = blockchainsF.flatMap((Function1 & Serializable)blockchains -> this.processHeadersWithChains(headers, (Vector<Blockchain>)blockchains).map((Function1 & Serializable)newChainApi -> newChainApi, $this.executionContext), this.executionContext);
        return var3_3;
    }

    public Future<DoubleSha256DigestBE> getBestBlockHash() {
        return this.getBestBlockHeader().map((Function1 & Serializable)x$10 -> x$10.hashBE(), this.executionContext);
    }

    public Future<Option<FilterSyncMarker>> nextBlockHeaderBatchRangeWithChains(DoubleSha256DigestBE prevStopHash, int batchSize, Vector<Blockchain> blockchains) {
        return this.getHeader(prevStopHash).flatMap((Function1 & Serializable)prevBlockHeaderOpt -> {
            Future<Option<FilterSyncMarker>> future;
            if (prevBlockHeaderOpt.isDefined()) {
                future = this.findNextHeader((Option<BlockHeaderDb>)prevBlockHeaderOpt, batchSize, blockchains);
            } else {
                DoubleSha256DigestBE doubleSha256DigestBE = prevStopHash;
                DoubleSha256DigestBE doubleSha256DigestBE2 = DoubleSha256DigestBE$.MODULE$.empty();
                future = !(doubleSha256DigestBE != null ? !doubleSha256DigestBE.equals(doubleSha256DigestBE2) : doubleSha256DigestBE2 != null) ? this.findNextHeader((Option<BlockHeaderDb>)None$.MODULE$, batchSize, blockchains) : Future$.MODULE$.successful((Object)None$.MODULE$);
            }
            return future.map((Function1 & Serializable)headerOpt -> headerOpt, $this.executionContext);
        }, this.executionContext);
    }

    public Future<Option<FilterSyncMarker>> nextBlockHeaderBatchRange(DoubleSha256DigestBE prevStopHash, int batchSize) {
        return this.blockHeaderDAO().getBlockchains(this.executionContext).flatMap((Function1 & Serializable)blockchains -> this.nextBlockHeaderBatchRangeWithChains(prevStopHash, batchSize, (Vector<Blockchain>)blockchains).map((Function1 & Serializable)syncMarkerOpt -> syncMarkerOpt, $this.executionContext), this.executionContext);
    }

    private Future<Option<FilterSyncMarker>> findNextHeader(Option<BlockHeaderDb> prevBlockHeaderOpt, int batchSize, Vector<Blockchain> blockchains) {
        int n;
        Future<Vector<Blockchain>> future;
        Option<BlockHeaderDb> option = prevBlockHeaderOpt;
        if (None$.MODULE$.equals(option)) {
            future = this.blockHeaderDAO().getBlockchainsBetweenHeights(0, batchSize - 1, this.executionContext);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            BlockHeaderDb prevBlockHeader = (BlockHeaderDb)some.value();
            Vector inMemoryBlockchains = (Vector)blockchains.filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.exists((Function1<BlockHeaderDb, Object>)(Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ChainHandler.$anonfun$findNextHeader$2(prevBlockHeader$1, x$12)))));
            future = inMemoryBlockchains.nonEmpty() ? Future$.MODULE$.successful((Object)inMemoryBlockchains) : this.blockHeaderDAO().getBlockchainsBetweenHeights(prevBlockHeader.height(), prevBlockHeader.height() + batchSize, this.executionContext);
        } else {
            throw new MatchError(option);
        }
        Future<Vector<Blockchain>> chainsF = future;
        Option<BlockHeaderDb> option2 = prevBlockHeaderOpt;
        if (None$.MODULE$.equals(option2)) {
            n = 0;
        } else if (option2 instanceof Some) {
            Some some = (Some)option2;
            BlockHeaderDb prevBlockHeader = (BlockHeaderDb)some.value();
            n = prevBlockHeader.height() + 1;
        } else {
            throw new MatchError(option2);
        }
        int startHeight = n;
        return chainsF.map(arg_0 -> ChainHandler.$anonfun$findNextHeader$3(this, startHeight, batchSize, prevBlockHeaderOpt, arg_0), this.executionContext);
    }

    private Option<FilterSyncMarker> getBestChainAtHeight(int startHeight, int batchSize, Vector<Blockchain> blockchains) {
        int targetHeight = startHeight + batchSize - 1;
        Option mostWorkChainOpt = package.seqUtil$.MODULE$.maxByOption$extension(package$.MODULE$.seqUtil(blockchains), (Function1 & Serializable)x$13 -> x$13.tip().chainWork(), (Ordering)Ordering.BigInt$.MODULE$);
        Option hashHeightOpt = mostWorkChainOpt.flatMap((Function1 & Serializable)mostWorkChain -> {
            Option option;
            int maxHeight = mostWorkChain.tip().height();
            if (targetHeight >= maxHeight) {
                FilterSyncMarker marker = new FilterSyncMarker(startHeight, mostWorkChain.tip().hash());
                option = new Some((Object)marker);
            } else {
                option = mostWorkChain.find((Function1<BlockHeaderDb, Object>)(Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ChainHandler.$anonfun$getBestChainAtHeight$3(targetHeight, x$14))).map((Function1 & Serializable)h -> new FilterSyncMarker(startHeight, h.hash()));
            }
            return option;
        });
        return hashHeightOpt;
    }

    public Future<Option<FilterSyncMarker>> nextFilterHeaderBatchRange(int filterHeight, int batchSize) {
        int startHeight = filterHeight <= 0 ? 0 : filterHeight + 1;
        int stopHeight = startHeight - 1 + batchSize;
        Future stopBlockF = this.getFilterHeadersAtHeight(stopHeight).map((Function1 & Serializable)x$15 -> x$15.headOption(), this.executionContext).flatMap((Function1 & Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                CompactFilterHeaderDb stopBlock = (CompactFilterHeaderDb)some.value();
                future = Future$.MODULE$.successful((Object)stopBlock);
            } else if (None$.MODULE$.equals(option)) {
                future = this.getBestFilterHeader().map((Function1 & Serializable)x$16 -> (CompactFilterHeaderDb)x$16.getOrElse((Function0 & Serializable)() -> {
                    throw new UnknownBlockHeight(new StringBuilder(29).append("Unknown filter header height ").append(stopHeight).toString());
                }), $this.executionContext);
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, this.executionContext);
        return stopBlockF.map((Function1 & Serializable)stopBlock -> startHeight > stopBlock.height() ? None$.MODULE$ : new Some((Object)new FilterSyncMarker(startHeight, stopBlock.blockHashBE().flip())), this.executionContext);
    }

    public Future<ChainApi> processFilterHeaders(Vector<FilterHeader> filterHeaders, DoubleSha256DigestBE stopHash) {
        Future filterHeadersToCreateF = this.blockHeaderDAO().getNAncestors(stopHash, filterHeaders.size() - 1).map((Function1 & Serializable)x$17 -> (Vector)x$17.sortBy((Function1 & Serializable)x$18 -> BoxesRunTime.boxToInteger((int)x$18.height()), (Ordering)Ordering.Int$.MODULE$), this.executionContext).map((Function1 & Serializable)blockHeaders -> {
            if (blockHeaders.size() != filterHeaders.size()) {
                throw new UnknownBlockHash(new StringBuilder(68).append("Filter header batch size does not match block header batch size ").append(filterHeaders.size()).append(" != ").append(blockHeaders.size()).toString());
            }
            return (Vector)blockHeaders.indices().toVector().map((Function1 & Serializable)i -> ChainHandler.$anonfun$processFilterHeaders$4(blockHeaders, filterHeaders, BoxesRunTime.unboxToInt((Object)i)));
        }, this.executionContext);
        return filterHeadersToCreateF.flatMap((Function1 & Serializable)filterHeadersToCreate -> this.verifyFilterHeaders((Vector<CompactFilterHeaderDb>)filterHeadersToCreate).flatMap((Function1 & Serializable)x$23 -> {
            BoxedUnit boxedUnit = x$23;
            Future future = this.filterHeaderDAO().createAll((Vector<CompactFilterHeaderDb>)filterHeadersToCreate).flatMap((Function1 & Serializable)x$22 -> {
                Vector vector = x$22;
                Future future = ((ChainCallbacks)this.chainConfig().callBacks()).executeOnCompactFilterHeaderConnectedCallbacks((Vector<CompactFilterHeaderDb>)filterHeadersToCreate, $this.executionContext).map(arg_0 -> ChainHandler.$anonfun$processFilterHeaders$8(this, filterHeadersToCreate, arg_0), $this.executionContext);
                return future;
            }, $this.executionContext);
            return future;
        }, $this.executionContext), this.executionContext);
    }

    public Future<ChainApi> processFilters(Vector<CompactFilterMessage> messages) {
        Future future;
        Object object = new Object();
        try {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(25).append("processFilters: messages=").append(messages).toString());
            Future filterHeadersF = this.filterHeaderDAO().findAllByBlockHashes((Vector<DoubleSha256DigestBE>)((Vector)messages.map((Function1 & Serializable)x$24 -> x$24.blockHash().flip()))).map((Function1 & Serializable)x$25 -> (Vector)x$25.sortBy((Function1 & Serializable)x$26 -> BoxesRunTime.boxToInteger((int)x$26.height()), (Ordering)Ordering.Int$.MODULE$), this.executionContext);
            Map messagesByBlockHash = (Map)messages.groupBy((Function1 & Serializable)x$27 -> x$27.blockHash().flip()).map((Function1 & Serializable)x0$1 -> {
                Vector messages;
                DoubleSha256DigestBE blockHash;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    blockHash = (DoubleSha256DigestBE)tuple2._1();
                    messages = (Vector)tuple2._2();
                    if (messages.size() > 1) {
                        throw new NonLocalReturnControl(object, (Object)Future$.MODULE$.failed((Throwable)new DuplicateFilters("Attempt to process duplicate filters")));
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2 tuple22 = new Tuple2((Object)blockHash, messages.head());
                return tuple22;
            });
            future = filterHeadersF.map((Function1 & Serializable)filterHeaders -> {
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(30).append("processFilters: filterHeaders=").append(filterHeaders).toString());
                BoxedUnit x$30 = BoxedUnit.UNIT;
                Predef$.MODULE$.require(filterHeaders.size() == messages.size(), (Function0 & Serializable)() -> new StringBuilder(62).append("Filter batch size does not match filter header batch size ").append(messages.size()).append(" != ").append(filterHeaders.size()).toString());
                BoxedUnit x$31 = BoxedUnit.UNIT;
                return new Tuple3(filterHeaders, (Object)x$30, (Object)x$31);
            }, this.executionContext).flatMap((Function1 & Serializable)x$34 -> {
                Tuple3 tuple3 = x$34;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                Vector filterHeaders = (Vector)tuple3._1();
                Future future = FutureUtil$.MODULE$.makeAsync((Function0 & Serializable)() -> (Vector)filterHeaders.map((Function1 & Serializable)filterHeader -> this.findFilterDbFromMessage((CompactFilterHeaderDb)filterHeader, (Map<DoubleSha256DigestBE, CompactFilterMessage>)messagesByBlockHash)), $this.executionContext).flatMap((Function1 & Serializable)compactFilterDbs -> this.filterDAO().createAll((Vector<CompactFilterDb>)compactFilterDbs).flatMap((Function1 & Serializable)x$33 -> {
                    Vector vector = x$33;
                    Future future = ((ChainCallbacks)this.chainConfig().callBacks()).executeOnCompactFilterConnectedCallbacks((Vector<CompactFilterDb>)compactFilterDbs, $this.executionContext).map(arg_0 -> ChainHandler.$anonfun$processFilters$15(this, compactFilterDbs, arg_0), $this.executionContext);
                    return future;
                }, $this.executionContext), $this.executionContext);
                return future;
            }, this.executionContext);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                future = (Future)ex.value();
            }
            throw ex;
        }
        return future;
    }

    public Future<BoxedUnit> verifyFilterHeaders(Vector<CompactFilterHeaderDb> filterHeaders) {
        Map byHash = (Map)filterHeaders.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(acc, fh) -> (Map)acc.updated((Object)fh.hashBE(), fh));
        Function1 & Serializable verify = (Function1 & Serializable)x$35 -> this.checkFilterHeader((Map<DoubleSha256DigestBE, CompactFilterHeaderDb>)byHash, (CompactFilterHeaderDb)x$35);
        return FutureUtil$.MODULE$.sequentially(filterHeaders, (Function1)verify, this.executionContext).map((Function1 & Serializable)x$36 -> {
            ChainHandler.$anonfun$verifyFilterHeaders$3(x$36);
            return BoxedUnit.UNIT;
        }, this.executionContext);
    }

    private Future<BoxedUnit> checkFilterHeader(Map<DoubleSha256DigestBE, CompactFilterHeaderDb> filtersByHash, CompactFilterHeaderDb filterHeader) {
        Future future;
        DoubleSha256DigestBE doubleSha256DigestBE = filterHeader.hashBE();
        DoubleSha256DigestBE doubleSha256DigestBE2 = filterHeader.previousFilterHeaderBE();
        if (!(doubleSha256DigestBE != null ? !doubleSha256DigestBE.equals(doubleSha256DigestBE2) : doubleSha256DigestBE2 != null)) {
            future = Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(42).append("Filter header cannot reference to itself: ").append(filterHeader).toString()));
        } else if (filterHeader.height() == 0) {
            future = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                DoubleSha256DigestBE doubleSha256DigestBE = filterHeader.previousFilterHeaderBE();
                DoubleSha256DigestBE doubleSha256DigestBE2 = DoubleSha256DigestBE$.MODULE$.empty();
                Predef$.MODULE$.require(!(doubleSha256DigestBE != null ? !doubleSha256DigestBE.equals(doubleSha256DigestBE2) : doubleSha256DigestBE2 != null), (Function0 & Serializable)() -> new StringBuilder(65).append("Previous filter header hash for the genesis block must be empty: ").append(filterHeader).toString());
            }, this.executionContext);
        } else {
            DoubleSha256DigestBE doubleSha256DigestBE3 = filterHeader.previousFilterHeaderBE();
            DoubleSha256DigestBE doubleSha256DigestBE4 = DoubleSha256DigestBE$.MODULE$.empty();
            if (!(doubleSha256DigestBE3 != null ? !doubleSha256DigestBE3.equals(doubleSha256DigestBE4) : doubleSha256DigestBE4 != null)) {
                future = Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(67).append("Previous filter header hash for a regular block must not be empty: ").append(filterHeader).toString()));
            } else {
                Future future2;
                Option option = filtersByHash.get((Object)filterHeader.previousFilterHeaderBE());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    CompactFilterHeaderDb prevHeader = (CompactFilterHeaderDb)some.value();
                    future2 = FutureUtil$.MODULE$.makeAsync((Function0)(JFunction0.mcV.sp & Serializable)() -> ChainHandler.checkHeight$1(filterHeader, prevHeader), this.executionContext);
                } else if (None$.MODULE$.equals(option)) {
                    Future<Option<CompactFilterHeaderDb>> filterHashFOpt = this.filterHeaderDAO().findByHash(filterHeader.previousFilterHeaderBE());
                    future2 = filterHashFOpt.map((Function1 & Serializable)x0$1 -> {
                        ChainHandler.$anonfun$checkFilterHeader$5(filterHeader, x0$1);
                        return BoxedUnit.UNIT;
                    }, this.executionContext);
                } else {
                    throw new MatchError((Object)option);
                }
                future = future2;
            }
        }
        return future;
    }

    private CompactFilterDb findFilterDbFromMessage(CompactFilterHeaderDb filterHeader, Map<DoubleSha256DigestBE, CompactFilterMessage> messagesByBlockHash) {
        CompactFilterDb filter;
        CompactFilterMessage message;
        Option option = messagesByBlockHash.get((Object)filterHeader.blockHashBE());
        if (option instanceof Some) {
            DoubleSha256DigestBE filterHashBE;
            Some some = (Some)option;
            message = (CompactFilterMessage)some.value();
            DoubleSha256DigestBE doubleSha256DigestBE = filterHashBE = CryptoUtil$.MODULE$.doubleSHA256(message.filterBytes()).flip();
            DoubleSha256DigestBE doubleSha256DigestBE2 = filterHeader.filterHashBE();
            if (doubleSha256DigestBE == null ? doubleSha256DigestBE2 != null : !doubleSha256DigestBE.equals(doubleSha256DigestBE2)) {
                String errMsg = new StringBuilder(0).append(new StringBuilder(52).append("Filter hash does not match filter header hash: ").append(filterHashBE).append(" != ").append(filterHeader.filterHashBE()).append("\n").toString()).append(new StringBuilder(33).append("filter=").append(message.filterBytes().toHex()).append("\nblock hash=").append(message.blockHash()).append("\nfilterHeader=").append(filterHeader).toString()).toString();
                this.logger().warn((Function0 & Serializable)() -> errMsg);
                throw new UnknownFilterHash(errMsg);
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new UnknownBlockHash(new StringBuilder(19).append("Unknown block hash ").append(filterHeader.blockHashBE()).toString());
            }
            throw new MatchError((Object)option);
        }
        CompactFilterDb compactFilterDb = filter = CompactFilterDbHelper$.MODULE$.fromFilterBytes(message.filterBytes(), filterHeader.blockHashBE(), filterHeader.height());
        return compactFilterDb;
    }

    public Future<ChainApi> processCheckpoints(Vector<DoubleSha256DigestBE> checkpoints, DoubleSha256DigestBE blockHash) {
        Future blockHeadersF = Future$.MODULE$.traverse((IterableOnce)checkpoints.indices().toVector(), (Function1 & Serializable)i -> ChainHandler.$anonfun$processCheckpoints$1(this, BoxesRunTime.unboxToInt((Object)i)), BuildFrom$.MODULE$.buildFromIterableOps(), this.executionContext).map((Function1 & Serializable)headers -> (Vector)headers.map((Function1 & Serializable)x$37 -> (BlockHeaderDb)x$37.head()), this.executionContext);
        return blockHeadersF.map((Function1 & Serializable)blockHeaders -> {
            Vector checkpointsWithBlocks = (Vector)checkpoints.zip((IterableOnce)blockHeaders);
            Map updatedCheckpoints = (Map)checkpointsWithBlocks.foldLeft(this.blockFilterCheckpoints(), (Function2 & Serializable)(res, pair) -> {
                Tuple2 tuple2 = pair;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DoubleSha256DigestBE filterHeaderHash = (DoubleSha256DigestBE)tuple2._1();
                BlockHeaderDb blockHeader = (BlockHeaderDb)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)filterHeaderHash, (Object)blockHeader);
                Tuple2 tuple23 = tuple22;
                DoubleSha256DigestBE filterHeaderHash2 = (DoubleSha256DigestBE)tuple23._1();
                BlockHeaderDb blockHeader2 = (BlockHeaderDb)tuple23._2();
                return (Map)res.updated((Object)blockHeader2.hashBE(), (Object)filterHeaderHash2);
            });
            return ChainHandler$.MODULE$.apply(this.blockHeaderDAO(), this.filterHeaderDAO(), this.filterDAO(), this.stateDAO(), (Map<DoubleSha256DigestBE, DoubleSha256DigestBE>)updatedCheckpoints, $this.executionContext, this.chainConfig());
        }, this.executionContext);
    }

    public Future<Option<CompactFilterDb>> getFilter(DoubleSha256DigestBE blockHash) {
        return this.filterDAO().findByBlockHash(blockHash);
    }

    public Future<Vector<BlockHeaderDb>> getHeadersAtHeight(int height) {
        return this.blockHeaderDAO().getAtHeight(height);
    }

    public Future<Object> getFilterHeaderCount() {
        this.logger().debug((Function0 & Serializable)() -> "Querying for filter header count");
        return this.filterHeaderDAO().getBestFilterHeaderHeight().map((Function1)(JFunction1.mcII.sp & Serializable)height -> {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(35).append("getFilterHeaderCount result: count=").append(height).toString());
            return height;
        }, this.executionContext);
    }

    public Future<Vector<CompactFilterHeaderDb>> getFilterHeadersAtHeight(int height) {
        return this.filterHeaderDAO().getAtHeight(height);
    }

    public Future<Option<CompactFilterHeaderDb>> getBestFilterHeaderWithChains(Vector<Blockchain> blockchains) {
        Future<Option<CompactFilterHeaderDb>> future;
        Option bestChainOpt = blockchains.maxByOption((Function1 & Serializable)x$39 -> x$39.tip().chainWork(), (Ordering)Ordering.BigInt$.MODULE$);
        Option option = bestChainOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            Blockchain bestChain = (Blockchain)some.value();
            future = this.filterHeaderDAO().getBestFilterHeaderForHeaders(bestChain.toVector());
        } else if (None$.MODULE$.equals(option)) {
            future = Future$.MODULE$.successful((Object)None$.MODULE$);
        } else {
            throw new MatchError((Object)option);
        }
        Future<Option<CompactFilterHeaderDb>> bestFilterHeadersInChain = future;
        return bestFilterHeadersInChain.flatMap((Function1 & Serializable)filterHeaderOpt -> (filterHeaderOpt.isEmpty() ? this.bestFilterHeaderSearch() : Future$.MODULE$.successful(filterHeaderOpt)).map((Function1 & Serializable)result -> result, $this.executionContext), this.executionContext);
    }

    public Future<Option<CompactFilterHeaderDb>> getBestFilterHeader() {
        Future<Vector<Blockchain>> blockchainsF = this.blockHeaderDAO().getBlockchains(this.executionContext);
        return blockchainsF.flatMap((Function1 & Serializable)blockchains -> this.getBestFilterHeaderWithChains((Vector<Blockchain>)blockchains).map((Function1 & Serializable)filterHeaderOpt -> filterHeaderOpt, $this.executionContext), this.executionContext);
    }

    public Future<Option<CompactFilterDb>> getBestFilter() {
        return this.filterDAO().getBestFilter();
    }

    /*
     * WARNING - void declaration
     */
    private Future<Option<CompactFilterHeaderDb>> bestFilterHeaderSearch() {
        void var3_3;
        Future<Option<CompactFilterHeaderDb>> bestFilterHeaderOptF = this.filterHeaderDAO().getBestFilterHeader();
        Future blockchainOptF = bestFilterHeaderOptF.flatMap((Function1 & Serializable)bestFilterHeaderOpt -> {
            Future<Vector<Blockchain>> future;
            Option option = bestFilterHeaderOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                CompactFilterHeaderDb bestFilterHeader = (CompactFilterHeaderDb)some.value();
                future = this.blockHeaderDAO().getBlockchainsBetweenHeights(bestFilterHeader.height() - this.chainConfig().chain().difficultyChangeInterval(), bestFilterHeader.height() + this.chainConfig().chain().difficultyChangeInterval(), $this.executionContext);
            } else if (None$.MODULE$.equals(option)) {
                future = Future$.MODULE$.successful((Object)scala.package$.MODULE$.Vector().empty());
            } else {
                throw new MatchError((Object)option);
            }
            return future.map((Function1 & Serializable)blockchains -> blockchains.isEmpty() ? None$.MODULE$ : blockchains.maxByOption((Function1 & Serializable)x$40 -> x$40.tip().chainWork(), (Ordering)Ordering.BigInt$.MODULE$), $this.executionContext);
        }, this.executionContext);
        Future filterHeadersOptF = blockchainOptF.map((Function1 & Serializable)blockchainOpt -> {
            Option bestHeadersForChainFOpt = blockchainOpt.map((Function1 & Serializable)b -> this.filterHeaderDAO().getBestFilterHeaderForHeaders(b.toVector()));
            return new Tuple2(blockchainOpt, (Object)bestHeadersForChainFOpt);
        }, this.executionContext).flatMap((Function1 & Serializable)x$41 -> {
            Future future;
            Tuple2 tuple2 = x$41;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Option bestHeadersForChainFOpt = (Option)tuple2._2();
            Option option = bestHeadersForChainFOpt;
            if (option instanceof Some) {
                Future f;
                Some some = (Some)option;
                future = f = (Future)some.value();
                return future.map((Function1 & Serializable)bestHeadersForChain -> bestHeadersForChain, $this.executionContext);
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                future = Future$.MODULE$.successful((Object)None$.MODULE$);
            }
            return future.map((Function1 & Serializable)bestHeadersForChain -> bestHeadersForChain, $this.executionContext);
        }, this.executionContext);
        return var3_3;
    }

    public Future<Option<CompactFilterHeaderDb>> getFilterHeader(DoubleSha256DigestBE blockHash) {
        return this.filterHeaderDAO().findByBlockHash(blockHash);
    }

    public Future<Object> getFilterCount() {
        this.logger().debug((Function0 & Serializable)() -> "Querying for filter count");
        return this.filterDAO().getBestFilterHeight().map((Function1)(JFunction1.mcII.sp & Serializable)height -> {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(29).append("getFilterCount result: count=").append(height).toString());
            return height;
        }, this.executionContext);
    }

    public Future<Vector<CompactFilterDb>> getFiltersAtHeight(int height) {
        return this.filterDAO().getAtHeight(height);
    }

    public Future<Object> getHeightByBlockStamp(BlockStamp blockStamp) {
        Future future;
        BlockStamp blockStamp2 = blockStamp;
        if (blockStamp2 instanceof BlockStamp.BlockHeight) {
            BlockStamp.BlockHeight blockHeight = (BlockStamp.BlockHeight)blockStamp2;
            future = Future$.MODULE$.successful((Object)BoxesRunTime.boxToInteger((int)blockHeight.height()));
        } else if (blockStamp2 instanceof BlockStamp.BlockHash) {
            BlockStamp.BlockHash blockHash = (BlockStamp.BlockHash)blockStamp2;
            future = this.getHeader(blockHash.hash()).map((Function1 & Serializable)header -> BoxesRunTime.boxToInteger((int)ChainHandler.$anonfun$getHeightByBlockStamp$1(blockHash, header)), this.executionContext);
        } else if (blockStamp2 instanceof BlockStamp.BlockTime) {
            BlockStamp.BlockTime blockTime = (BlockStamp.BlockTime)blockStamp2;
            future = Future$.MODULE$.failed((Throwable)new RuntimeException(new StringBuilder(17).append("Not implemented: ").append(blockTime).toString()));
        } else {
            throw new MatchError((Object)blockStamp2);
        }
        return future;
    }

    public Future<Object> epochSecondToBlockHeight(long time) {
        return this.blockHeaderDAO().findClosestToTime(UInt32$.MODULE$.apply(time)).map((Function1 & Serializable)x$43 -> BoxesRunTime.boxToInteger((int)x$43.height()), this.executionContext);
    }

    public Future<Option<Object>> getBlockHeight(DoubleSha256DigestBE blockHash) {
        return this.getHeader(blockHash).map((Function1 & Serializable)x$44 -> x$44.map((Function1 & Serializable)x$45 -> BoxesRunTime.boxToInteger((int)x$45.height())), this.executionContext);
    }

    public Future<Option<Object>> getNumberOfConfirmations(DoubleSha256DigestBE blockHash) {
        return this.getBlockHeight(blockHash).flatMap((Function1 & Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                future = FutureUtil$.MODULE$.none();
            } else if (option instanceof Some) {
                Some some = (Some)option;
                int blockHeight = BoxesRunTime.unboxToInt((Object)some.value());
                future = this.blockHeaderDAO().getBestChainTips().map((Function1 & Serializable)tips -> {
                    Vector getNAncestorsFs = (Vector)tips.map((Function1 & Serializable)tip -> this.blockHeaderDAO().getNAncestors(tip.hashBE(), tip.height() - blockHeight));
                    return new Tuple2(tips, (Object)getNAncestorsFs);
                }, $this.executionContext).flatMap((Function1 & Serializable)x$46 -> {
                    Tuple2 tuple2 = x$46;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Vector getNAncestorsFs = (Vector)tuple2._2();
                    Future future = Future$.MODULE$.sequence((IterableOnce)getNAncestorsFs, BuildFrom$.MODULE$.buildFromIterableOps(), $this.executionContext).map((Function1 & Serializable)ancestorChains -> {
                        Vector confs = (Vector)ancestorChains.flatMap((Function1 & Serializable)chain -> {
                            DoubleSha256DigestBE doubleSha256DigestBE = ((BlockHeaderDb)chain.last()).hashBE();
                            DoubleSha256DigestBE doubleSha256DigestBE2 = blockHash;
                            return !(doubleSha256DigestBE != null ? !doubleSha256DigestBE.equals(doubleSha256DigestBE2) : doubleSha256DigestBE2 != null) ? new Some((Object)BoxesRunTime.boxToInteger((int)(((BlockHeaderDb)chain.head()).height() - blockHeight + 1))) : None$.MODULE$;
                        });
                        return confs.nonEmpty() ? new Some(confs.max((Ordering)Ordering.Int$.MODULE$)) : None$.MODULE$;
                    }, $this.executionContext);
                    return future;
                }, $this.executionContext);
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, this.executionContext);
    }

    public Future<Vector<ChainQueryApi.FilterResponse>> getFiltersBetweenHeights(int startHeight, int endHeight) {
        return this.filterDAO().getBetweenHeights(startHeight, endHeight).map((Function1 & Serializable)dbos -> (Vector)dbos.map((Function1 & Serializable)dbo -> new ChainQueryApi.FilterResponse(dbo.golombFilter(), dbo.blockHashBE(), dbo.height())), this.executionContext);
    }

    public Future<Vector<BlockHeaderDb>> getHeadersBetween(BlockHeaderDb from, BlockHeaderDb to) {
        this.logger().info((Function0 & Serializable)() -> new StringBuilder(25).append("Finding headers from=").append(from).append(" to=").append(to).toString());
        return this.loop$1(Future$.MODULE$.successful((Object)to), scala.package$.MODULE$.Vector().empty(), from);
    }

    public Future<Object> isMissingChainWork() {
        return this.blockHeaderDAO().getBetweenHeights(0, 100).map((Function1 & Serializable)first100 -> {
            boolean first100MissingWork = first100.nonEmpty() && first100.exists((Function1 & Serializable)x$48 -> BoxesRunTime.boxToBoolean((boolean)ChainHandler.$anonfun$isMissingChainWork$2(x$48)));
            return new Tuple2(first100, (Object)BoxesRunTime.boxToBoolean((boolean)first100MissingWork));
        }, this.executionContext).flatMap((Function1 & Serializable)x$51 -> {
            Tuple2 tuple2 = x$51;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            boolean first100MissingWork = tuple2._2$mcZ$sp();
            Future future = (first100MissingWork ? Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true)) : this.blockHeaderDAO().maxHeight().flatMap((Function1 & Serializable)height -> ChainHandler.$anonfun$isMissingChainWork$4(this, BoxesRunTime.unboxToInt((Object)height)), $this.executionContext)).map((Function1 & Serializable)isMissingWork -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)isMissingWork)), $this.executionContext);
            return future;
        }, this.executionContext);
    }

    private Vector<BlockHeaderDb> calcChainWork(Vector<BlockHeaderDb> remainingHeaders, Vector<BlockHeaderDb> accum, BlockHeaderDb lastHeaderWithWorkInDb) {
        while (!remainingHeaders.isEmpty()) {
            BigInt newChainWork;
            BigInt bigInt;
            BlockHeaderDb header = (BlockHeaderDb)remainingHeaders.head();
            Option option = accum.lastOption().map((Function1 & Serializable)x$52 -> x$52.chainWork());
            if (option instanceof Some) {
                BigInt prevWork;
                Some some = (Some)option;
                bigInt = prevWork = (BigInt)some.value();
            } else if (None$.MODULE$.equals(option)) {
                bigInt = lastHeaderWithWorkInDb.chainWork();
            } else {
                throw new MatchError((Object)option);
            }
            BigInt currentChainWork = bigInt;
            BigInt x$1 = newChainWork = currentChainWork.$plus(Pow$.MODULE$.getBlockProof(header.blockHeader()));
            int x$2 = header.copy$default$1();
            DoubleSha256DigestBE x$3 = header.copy$default$2();
            Int32 x$4 = header.copy$default$3();
            DoubleSha256DigestBE x$5 = header.copy$default$4();
            DoubleSha256DigestBE x$6 = header.copy$default$5();
            UInt32 x$7 = header.copy$default$6();
            UInt32 x$8 = header.copy$default$7();
            UInt32 x$9 = header.copy$default$8();
            String x$10 = header.copy$default$9();
            BlockHeaderDb newHeader = header.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$1);
            accum = (Vector)accum.$colon$plus((Object)newHeader);
            remainingHeaders = remainingHeaders.tail();
        }
        return accum;
    }

    private Future<Vector<Blockchain>> getBatchForRecalc(int startHeight, int maxHeight, int batchSize) {
        int batchEndHeight = Math.min(maxHeight, startHeight + batchSize - 1);
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(18).append("Fetching from=").append(startHeight).append(" to=").append(batchEndHeight).toString());
        Future<Vector<Blockchain>> headersToCalcF = this.blockHeaderDAO().getBlockchainsBetweenHeights(startHeight, batchEndHeight, this.executionContext);
        return headersToCalcF;
    }

    private Future<Vector<Blockchain>> batchAndGetBlockchains(int batchSize, int batchStartHeight, int maxHeight, int numBatches) {
        IntRef counter = IntRef.create((int)batchStartHeight);
        Range range = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numBatches);
        Vector batchesNested = range.map((Function1 & Serializable)x$53 -> ChainHandler.$anonfun$batchAndGetBlockchains$1(this, counter, maxHeight, batchSize, BoxesRunTime.unboxToInt((Object)x$53))).toVector();
        return Future$.MODULE$.sequence((IterableOnce)batchesNested, BuildFrom$.MODULE$.buildFromIterableOps(), this.executionContext).map((Function1 & Serializable)x$54 -> (Vector)x$54.flatten(Predef$.MODULE$.$conforms()), this.executionContext);
    }

    private Future<Vector<BlockHeaderDb>> runRecalculateChainWork(int maxHeight, BlockHeaderDb lastHeader) {
        Future future;
        int currentHeight = lastHeader.height();
        int numBatches = 1;
        int batchSize = this.chainConfig().appConfig().chain().difficultyChangeInterval() / numBatches;
        if (currentHeight >= maxHeight) {
            future = Future$.MODULE$.successful((Object)scala.package$.MODULE$.Vector().empty());
        } else {
            int batchStartHeight = currentHeight + 1;
            Future<Vector<Blockchain>> headersToCalcF = this.batchAndGetBlockchains(batchSize, batchStartHeight, maxHeight, numBatches);
            future = headersToCalcF.map((Function1 & Serializable)headersToCalc -> {
                Option x$60 = headersToCalc.headOption().map((Function1 & Serializable)h -> {
                    ChainHandler.$anonfun$runRecalculateChainWork$2(this, maxHeight, h);
                    return BoxedUnit.UNIT;
                });
                Vector headersWithWork = (Vector)headersToCalc.flatMap((Function1 & Serializable)chain -> this.calcChainWork((Vector<BlockHeaderDb>)((Vector)chain.headers().sortBy((Function1 & Serializable)x$55 -> BoxesRunTime.boxToInteger((int)x$55.height()), (Ordering)Ordering.Int$.MODULE$)), (Vector<BlockHeaderDb>)scala.package$.MODULE$.Vector().empty(), lastHeader));
                this.logger().trace((Function0 & Serializable)() -> new StringBuilder(33).append("Upserting from height=").append(headersWithWork.headOption().map((Function1 & Serializable)x$56 -> BoxesRunTime.boxToInteger((int)x$56.height()))).append(" to height=").append(headersWithWork.lastOption().map((Function1 & Serializable)x$57 -> BoxesRunTime.boxToInteger((int)x$57.height()))).toString());
                BoxedUnit x$61 = BoxedUnit.UNIT;
                return new Tuple4(headersToCalc, (Object)x$60, (Object)headersWithWork, (Object)x$61);
            }, this.executionContext).flatMap((Function1 & Serializable)x$65 -> {
                Tuple4 tuple4 = x$65;
                if (tuple4 == null) {
                    throw new MatchError((Object)tuple4);
                }
                Vector headersWithWork = (Vector)tuple4._3();
                Future future = FutureUtil$.MODULE$.batchExecute(headersWithWork, (Function1 & Serializable)ts -> this.blockHeaderDAO().upsertAll((Vector)ts), (Object)scala.package$.MODULE$.Vector().empty(), batchSize, $this.executionContext).map((Function1 & Serializable)x$62 -> {
                    this.logger().trace((Function0 & Serializable)() -> new StringBuilder(38).append("Done upserting from height=").append(headersWithWork.headOption().map((Function1 & Serializable)x$58 -> BoxesRunTime.boxToInteger((int)x$58.height()))).append(" to height=").append(headersWithWork.lastOption().map((Function1 & Serializable)x$59 -> BoxesRunTime.boxToInteger((int)x$59.height()))).toString());
                    BoxedUnit x$63 = BoxedUnit.UNIT;
                    return new Tuple2(x$62, (Object)x$63);
                }, $this.executionContext).flatMap((Function1 & Serializable)x$64 -> {
                    Tuple2 tuple2 = x$64;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Future future = this.runRecalculateChainWork(maxHeight, (BlockHeaderDb)headersWithWork.last()).map((Function1 & Serializable)next -> next, $this.executionContext);
                    return future;
                }, $this.executionContext);
                return future;
            }, this.executionContext);
        }
        return future;
    }

    public Future<ChainHandler> recalculateChainWork() {
        this.logger().info((Function0 & Serializable)() -> "Calculating chain work for previous blocks");
        Future<Object> maxHeightF = this.blockHeaderDAO().maxHeight();
        Future<Object> startHeightF = this.blockHeaderDAO().getLowestNoWorkHeight();
        Future startF = startHeightF.flatMap((Function1 & Serializable)startHeight -> ChainHandler.$anonfun$recalculateChainWork$2(this, BoxesRunTime.unboxToInt((Object)startHeight)), this.executionContext);
        Future resultF = maxHeightF.flatMap((Function1 & Serializable)maxHeight -> startF.flatMap((Function1 & Serializable)start -> $this.runRecalculateChainWork(maxHeight, (BlockHeaderDb)start.head()).map((Function1 & Serializable)x$67 -> {
            Vector vector = x$67;
            $this.logger().info((Function0 & Serializable)() -> "Finished calculating chain work");
            ChainHandler chainHandler = ChainHandler$.MODULE$.apply($this.blockHeaderDAO(), $this.filterHeaderDAO(), $this.filterDAO(), $this.stateDAO(), $this.blockFilterCheckpoints(), $this.executionContext, $this.chainConfig());
            return chainHandler;
        }, $this.executionContext), this.executionContext), this.executionContext);
        resultF.failed().foreach((Function1 & Serializable)err -> {
            ChainHandler.$anonfun$recalculateChainWork$11(this, err);
            return BoxedUnit.UNIT;
        }, this.executionContext);
        return resultF;
    }

    private Future<BlockHeaderDb> calculateChainWorkGenesisBlock(BlockHeaderDb genesisHeader) {
        BigInt expectedWork;
        BigInt x$1 = expectedWork = Pow$.MODULE$.getBlockProof(genesisHeader.blockHeader());
        int x$2 = genesisHeader.copy$default$1();
        DoubleSha256DigestBE x$3 = genesisHeader.copy$default$2();
        Int32 x$4 = genesisHeader.copy$default$3();
        DoubleSha256DigestBE x$5 = genesisHeader.copy$default$4();
        DoubleSha256DigestBE x$6 = genesisHeader.copy$default$5();
        UInt32 x$7 = genesisHeader.copy$default$6();
        UInt32 x$8 = genesisHeader.copy$default$7();
        UInt32 x$9 = genesisHeader.copy$default$8();
        String x$10 = genesisHeader.copy$default$9();
        BlockHeaderDb genesisWithWork = genesisHeader.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$1);
        return this.blockHeaderDAO().update(genesisWithWork);
    }

    public ChainHandler copyWith(BlockHeaderDAO blockHeaderDAO, CompactFilterHeaderDAO filterHeaderDAO, CompactFilterDAO filterDAO, ChainStateDescriptorDAO stateDAO, Map<DoubleSha256DigestBE, DoubleSha256DigestBE> blockFilterCheckpoints) {
        return new ChainHandler(blockHeaderDAO, filterHeaderDAO, filterDAO, stateDAO, blockFilterCheckpoints, this.chainConfig(), this.executionContext);
    }

    public BlockHeaderDAO copyWith$default$1() {
        return this.blockHeaderDAO();
    }

    public CompactFilterHeaderDAO copyWith$default$2() {
        return this.filterHeaderDAO();
    }

    public CompactFilterDAO copyWith$default$3() {
        return this.filterDAO();
    }

    public ChainStateDescriptorDAO copyWith$default$4() {
        return this.stateDAO();
    }

    public Map<DoubleSha256DigestBE, DoubleSha256DigestBE> copyWith$default$5() {
        return this.blockFilterCheckpoints();
    }

    public Future<ChainHandlerCached> toChainHandlerCached() {
        return ChainHandler$.MODULE$.toChainHandlerCached(this, this.executionContext);
    }

    public Future<Object> getMedianTimePast() {
        int nMedianTimeSpan = 11;
        Vector top11 = this.getNTopHeaders$1(nMedianTimeSpan, (Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Future[]{this.getBestBlockHeader().map((Function1 & Serializable)x -> Option$.MODULE$.apply(x), this.executionContext)})));
        return Future$.MODULE$.sequence((IterableOnce)top11, BuildFrom$.MODULE$.buildFromIterableOps(), this.executionContext).map((Function1 & Serializable)x$68 -> (Vector)x$68.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Option<BlockHeaderDb>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Some) {
                    Some some = (Some)A1;
                    BlockHeaderDb header = (BlockHeaderDb)some.value();
                    object = BoxesRunTime.boxToLong((long)header.time().toLong());
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Option<BlockHeaderDb> x1) {
                Option<BlockHeaderDb> option = x1;
                boolean bl = option instanceof Some;
                return bl;
            }
        }), this.executionContext).map((Function1 & Serializable)times -> BoxesRunTime.boxToLong((long)ChainHandler.$anonfun$getMedianTimePast$4(times)), this.executionContext);
    }

    public Future<Object> isSyncing() {
        return this.stateDAO().isSyncing();
    }

    public Future<Object> isIBD() {
        return this.stateDAO().getIsIBD().map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ChainHandler.$anonfun$isIBD$1(x0$1)), this.executionContext);
    }

    public Future<ChainApi> setSyncing(boolean value) {
        Future<Object> isSyncingF = this.stateDAO().isSyncing();
        return isSyncingF.flatMap((Function1 & Serializable)isSyncing -> ChainHandler.$anonfun$setSyncing$1(this, value, BoxesRunTime.unboxToBoolean((Object)isSyncing)), this.executionContext);
    }

    public Future<ChainApi> setIBD(boolean value) {
        Future<Option<IsInitialBlockDownload>> isIBDF = this.stateDAO().getIsIBD();
        return isIBDF.flatMap((Function1 & Serializable)isIBDOpt -> {
            Future future;
            if (isIBDOpt.isDefined() && ((IsInitialBlockDownload)isIBDOpt.get()).isIBDRunning() == value) {
                future = Future$.MODULE$.unit();
            } else if (isIBDOpt.isDefined() && !((IsInitialBlockDownload)isIBDOpt.get()).isIBDRunning() && value) {
                this.logger().warn((Function0 & Serializable)() -> "Can only do IBD once, cannot set flag to true when database flag is false.");
                future = Future$.MODULE$.unit();
            } else {
                future = this.stateDAO().updateIsIbd(value);
            }
            return future.map((Function1 & Serializable)x$70 -> {
                Object object = x$70;
                ChainHandler chainHandler = this;
                return chainHandler;
            }, $this.executionContext);
        }, this.executionContext);
    }

    private Future<BoxedUnit> updateSyncingAndExecuteCallback(boolean value) {
        return this.stateDAO().updateSyncing(value).flatMap((Function1 & Serializable)changed -> ChainHandler.$anonfun$updateSyncingAndExecuteCallback$1(this, value, BoxesRunTime.unboxToBoolean((Object)changed)), this.executionContext);
    }

    public static final /* synthetic */ boolean $anonfun$processHeadersWithChains$3(BlockHeader h$1, BlockHeaderDb x$7) {
        DoubleSha256DigestBE doubleSha256DigestBE = x$7.hashBE();
        DoubleSha256DigestBE doubleSha256DigestBE2 = h$1.hashBE();
        return !(doubleSha256DigestBE != null ? !doubleSha256DigestBE.equals(doubleSha256DigestBE2) : doubleSha256DigestBE2 != null);
    }

    public static final /* synthetic */ void $anonfun$processHeadersWithChains$8(ChainHandler $this, Vector headers$1, Blockchain c) {
        $this.logger().info((Function0 & Serializable)() -> new StringBuilder(46).append("Processed headers from height=").append(c.height() - headers$1.length()).append(" to ").append(c.height()).append(". Best hash=").append(c.tip().hashBE().hex()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$findNextHeader$2(BlockHeaderDb prevBlockHeader$1, BlockHeaderDb x$12) {
        DoubleSha256DigestBE doubleSha256DigestBE = x$12.previousBlockHashBE();
        DoubleSha256DigestBE doubleSha256DigestBE2 = prevBlockHeader$1.hashBE();
        return !(doubleSha256DigestBE != null ? !doubleSha256DigestBE.equals(doubleSha256DigestBE2) : doubleSha256DigestBE2 != null);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Option $anonfun$findNextHeader$3(ChainHandler $this, int startHeight$1, int batchSize$3, Option prevBlockHeaderOpt$1, Vector chains) {
        block5: {
            block7: {
                block8: {
                    block6: {
                        block4: {
                            nextBlockHeaderOpt = $this.getBestChainAtHeight(startHeight$1, batchSize$3, (Vector<Blockchain>)chains);
                            var8_6 = new Tuple2(nextBlockHeaderOpt, (Object)prevBlockHeaderOpt$1);
                            if (var8_6 == null) break block4;
                            var9_7 = (Option)var8_6._1();
                            var10_8 = (Option)var8_6._2();
                            if (!(var9_7 instanceof Some)) break block4;
                            var11_9 = (Some)var9_7;
                            next = (FilterSyncMarker)var11_9.value();
                            if (!(var10_8 instanceof Some)) break block4;
                            var13_11 = (Some)var10_8;
                            prev = (BlockHeaderDb)var13_11.value();
                            v0 = next.stopBlockHash();
                            var15_13 = prev.hash();
                            var5_14 = !(v0 != null ? v0.equals(var15_13) == false : var15_13 != null) ? None$.MODULE$ : nextBlockHeaderOpt;
                            break block5;
                        }
                        if (var8_6 == null) break block6;
                        var16_15 = (Option)var8_6._1();
                        var17_16 = (Option)var8_6._2();
                        if (!(var16_15 instanceof Some) || !None$.MODULE$.equals(var17_16)) break block6;
                        var6_17 = true;
                        break block7;
                    }
                    if (var8_6 == null) break block8;
                    var18_18 = (Option)var8_6._1();
                    var19_19 = (Option)var8_6._2();
                    if (!None$.MODULE$.equals(var18_18) || !(var19_19 instanceof Some)) break block8;
                    var6_17 = true;
                    break block7;
                }
                if (var8_6 == null) ** GOTO lbl-1000
                var20_20 = (Option)var8_6._1();
                var21_21 = (Option)var8_6._2();
                if (None$.MODULE$.equals(var20_20) && None$.MODULE$.equals(var21_21)) {
                    var6_17 = true;
                } else lbl-1000:
                // 2 sources

                {
                    var6_17 = false;
                }
            }
            if (var6_17) {
                var5_14 = nextBlockHeaderOpt;
            } else {
                throw new MatchError((Object)var8_6);
            }
        }
        return var5_14;
    }

    public static final /* synthetic */ boolean $anonfun$getBestChainAtHeight$3(int targetHeight$1, BlockHeaderDb x$14) {
        return x$14.height() == targetHeight$1;
    }

    public static final /* synthetic */ CompactFilterHeaderDb $anonfun$processFilterHeaders$4(Vector blockHeaders$1, Vector filterHeaders$1, int i) {
        BlockHeaderDb blockHeader = (BlockHeaderDb)blockHeaders$1.apply(i);
        FilterHeader filterHeader = (FilterHeader)filterHeaders$1.apply(i);
        return CompactFilterHeaderDbHelper$.MODULE$.fromFilterHeader(filterHeader, blockHeader.hashBE(), blockHeader.height());
    }

    public static final /* synthetic */ String $anonfun$processFilterHeaders$11(CompactFilterHeaderDb minHeight$1, CompactFilterHeaderDb maxHeight$1) {
        return new StringBuilder(72).append("Processed filters headers from height=").append(minHeight$1.height()).append(" to ").append(maxHeight$1.height()).append(". Best filterheader.blockHash=").append(maxHeight$1.blockHashBE().hex()).toString();
    }

    public static final /* synthetic */ String $anonfun$processFilterHeaders$12() {
        return "Was unable to process any filters headers";
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ ChainApi $anonfun$processFilterHeaders$8(ChainHandler $this, Vector filterHeadersToCreate$1, BoxedUnit x$21) {
        var5_3 = x$21;
        minHeightOpt = filterHeadersToCreate$1.minByOption((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$processFilterHeaders$9$adapted(org.bitcoins.core.api.chain.db.CompactFilterHeaderDb ), (Lorg/bitcoins/core/api/chain/db/CompactFilterHeaderDb;)Ljava/lang/Object;)(), (Ordering)Ordering.Int$.MODULE$);
        var8_6 = new Tuple2((Object)minHeightOpt, (Object)(maxHeightOpt = filterHeadersToCreate$1.maxByOption((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$processFilterHeaders$10$adapted(org.bitcoins.core.api.chain.db.CompactFilterHeaderDb ), (Lorg/bitcoins/core/api/chain/db/CompactFilterHeaderDb;)Ljava/lang/Object;)(), (Ordering)Ordering.Int$.MODULE$)));
        if (var8_6 == null) ** GOTO lbl-1000
        var9_7 = (Option)var8_6._1();
        var10_8 = (Option)var8_6._2();
        if (!(var9_7 instanceof Some)) ** GOTO lbl-1000
        var11_9 = (Some)var9_7;
        minHeight = (CompactFilterHeaderDb)var11_9.value();
        if (var10_8 instanceof Some) {
            var13_11 = (Some)var10_8;
            maxHeight = (CompactFilterHeaderDb)var13_11.value();
            $this.logger().info((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$processFilterHeaders$11(org.bitcoins.core.api.chain.db.CompactFilterHeaderDb org.bitcoins.core.api.chain.db.CompactFilterHeaderDb ), ()Ljava/lang/String;)((CompactFilterHeaderDb)minHeight, (CompactFilterHeaderDb)maxHeight));
            var4_13 = $this;
        } else if (var8_6 != null) {
            $this.logger().warn((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$processFilterHeaders$12(), ()Ljava/lang/String;)());
            var4_13 = $this;
        } else {
            throw new MatchError((Object)var8_6);
        }
        var3_14 = var4_13;
        return var3_14;
    }

    public static final /* synthetic */ String $anonfun$processFilters$18(CompactFilterDb minHeight$2, CompactFilterDb maxHeight$2) {
        return new StringBuilder(58).append("Processed filters from height=").append(minHeight$2.height()).append(" to ").append(maxHeight$2.height()).append(". Best filter.blockHash=").append(maxHeight$2.blockHashBE().hex()).toString();
    }

    public static final /* synthetic */ String $anonfun$processFilters$19() {
        return "Was unable to process any filters";
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ ChainApi $anonfun$processFilters$15(ChainHandler $this, Vector compactFilterDbs$1, BoxedUnit x$32) {
        var5_3 = x$32;
        minHeightOpt = compactFilterDbs$1.minByOption((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$processFilters$16$adapted(org.bitcoins.core.api.chain.db.CompactFilterDb ), (Lorg/bitcoins/core/api/chain/db/CompactFilterDb;)Ljava/lang/Object;)(), (Ordering)Ordering.Int$.MODULE$);
        var8_6 = new Tuple2((Object)minHeightOpt, (Object)(maxHeightOpt = compactFilterDbs$1.maxByOption((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$processFilters$17$adapted(org.bitcoins.core.api.chain.db.CompactFilterDb ), (Lorg/bitcoins/core/api/chain/db/CompactFilterDb;)Ljava/lang/Object;)(), (Ordering)Ordering.Int$.MODULE$)));
        if (var8_6 == null) ** GOTO lbl-1000
        var9_7 = (Option)var8_6._1();
        var10_8 = (Option)var8_6._2();
        if (!(var9_7 instanceof Some)) ** GOTO lbl-1000
        var11_9 = (Some)var9_7;
        minHeight = (CompactFilterDb)var11_9.value();
        if (var10_8 instanceof Some) {
            var13_11 = (Some)var10_8;
            maxHeight = (CompactFilterDb)var13_11.value();
            $this.logger().info((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$processFilters$18(org.bitcoins.core.api.chain.db.CompactFilterDb org.bitcoins.core.api.chain.db.CompactFilterDb ), ()Ljava/lang/String;)((CompactFilterDb)minHeight, (CompactFilterDb)maxHeight));
            var4_13 = $this;
        } else if (var8_6 != null) {
            $this.logger().warn((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$processFilters$19(), ()Ljava/lang/String;)());
            var4_13 = $this;
        } else {
            throw new MatchError((Object)var8_6);
        }
        var3_14 = var4_13;
        return var3_14;
    }

    public static final /* synthetic */ void $anonfun$verifyFilterHeaders$3(Vector x$36) {
    }

    private static final void checkHeight$1(CompactFilterHeaderDb filterHeader, CompactFilterHeaderDb prevHeader) {
        Predef$.MODULE$.require(prevHeader.height() == filterHeader.height() - 1, (Function0 & Serializable)() -> new StringBuilder(48).append("Unexpected previous filter header's height: ").append(prevHeader.height()).append(" != ").append(filterHeader.height() - 1).toString());
    }

    public static final /* synthetic */ void $anonfun$checkFilterHeader$5(CompactFilterHeaderDb filterHeader$2, Option x0$1) {
        Option option = x0$1;
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException(new StringBuilder(39).append("Previous filter header does not exist: ").append(filterHeader$2).toString());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        CompactFilterHeaderDb prevHeader = (CompactFilterHeaderDb)some.value();
        ChainHandler.checkHeight$1(filterHeader$2, prevHeader);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Future $anonfun$processCheckpoints$1(ChainHandler $this, int i) {
        return $this.blockHeaderDAO().getAtHeight(i * 1000);
    }

    public static final /* synthetic */ int $anonfun$getHeightByBlockStamp$1(BlockStamp.BlockHash x3$1, Option header) {
        return BoxesRunTime.unboxToInt((Object)header.map((Function1 & Serializable)x$42 -> BoxesRunTime.boxToInteger((int)x$42.height())).getOrElse((Function0 & Serializable)() -> {
            throw new UnknownBlockHash(new StringBuilder(19).append("Unknown block hash ").append(x3$1.hash()).toString());
        }));
    }

    private final Future loop$1(Future currentF, Vector accum, BlockHeaderDb from$1) {
        return currentF.flatMap((Function1 & Serializable)current -> {
            Future future;
            DoubleSha256DigestBE doubleSha256DigestBE = current.hashBE();
            DoubleSha256DigestBE doubleSha256DigestBE2 = from$1.hashBE();
            if (!(doubleSha256DigestBE != null ? !doubleSha256DigestBE.equals(doubleSha256DigestBE2) : doubleSha256DigestBE2 != null)) {
                BlockHeaderDb blockHeaderDb = current;
                future = Future$.MODULE$.successful(accum.$plus$colon((Object)blockHeaderDb));
            } else {
                Future<Option<BlockHeaderDb>> nextOptF = this.getHeader(current.previousBlockHashBE());
                Future nextF = nextOptF.map((Function1 & Serializable)x$47 -> (BlockHeaderDb)x$47.getOrElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.error(new StringBuilder(22).append("Could not find header=").append(current.previousBlockHashBE()).toString())), $this.executionContext);
                BlockHeaderDb blockHeaderDb = current;
                future = this.loop$1(nextF, (Vector)accum.$plus$colon((Object)blockHeaderDb), from$1);
            }
            return future;
        }, this.executionContext);
    }

    public static final /* synthetic */ boolean $anonfun$isMissingChainWork$2(BlockHeaderDb x$48) {
        BigInt bigInt = x$48.chainWork();
        BigInt bigInt2 = scala.package$.MODULE$.BigInt().apply(0);
        return !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$isMissingChainWork$6(BlockHeaderDb x$49) {
        BigInt bigInt = x$49.chainWork();
        BigInt bigInt2 = scala.package$.MODULE$.BigInt().apply(0);
        return !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$isMissingChainWork$7(Tuple2 x$50) {
        boolean last100MissingWork;
        Tuple2 tuple2 = x$50;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean bl = last100MissingWork = tuple2._2$mcZ$sp();
        return bl;
    }

    public static final /* synthetic */ Future $anonfun$isMissingChainWork$4(ChainHandler $this, int height) {
        return $this.blockHeaderDAO().getBetweenHeights(height - 100, height).map((Function1 & Serializable)last100 -> {
            boolean last100MissingWork = last100.nonEmpty() && last100.exists((Function1 & Serializable)x$49 -> BoxesRunTime.boxToBoolean((boolean)ChainHandler.$anonfun$isMissingChainWork$6(x$49)));
            return new Tuple2(last100, (Object)BoxesRunTime.boxToBoolean((boolean)last100MissingWork));
        }, $this.executionContext).map((Function1 & Serializable)x$50 -> BoxesRunTime.boxToBoolean((boolean)ChainHandler.$anonfun$isMissingChainWork$7(x$50)), $this.executionContext);
    }

    public static final /* synthetic */ Future $anonfun$batchAndGetBlockchains$1(ChainHandler $this, IntRef counter$1, int maxHeight$3, int batchSize$4, int x$53) {
        Future<Vector<Blockchain>> f = counter$1.elem <= maxHeight$3 ? $this.getBatchForRecalc(counter$1.elem, maxHeight$3, batchSize$4) : Future$.MODULE$.successful((Object)scala.package$.MODULE$.Vector().empty());
        counter$1.elem += batchSize$4;
        return f;
    }

    public static final /* synthetic */ void $anonfun$runRecalculateChainWork$2(ChainHandler $this, int maxHeight$4, Blockchain h) {
        $this.logger().info((Function0 & Serializable)() -> new StringBuilder(55).append("Recalculating chain work... current height: ").append(h.height()).append(" maxHeight=").append(maxHeight$4).toString());
    }

    public static final /* synthetic */ Future $anonfun$recalculateChainWork$2(ChainHandler $this, int startHeight) {
        Future future;
        if (startHeight == 0) {
            Future<Vector<BlockHeaderDb>> genesisHeaderF = $this.blockHeaderDAO().getAtHeight(0);
            future = genesisHeaderF.flatMap((Function1 & Serializable)h -> {
                Predef$.MODULE$.require(h.length() == 1, (Function0 & Serializable)() -> "Should only have one genesis header!");
                return $this.calculateChainWorkGenesisBlock((BlockHeaderDb)h.head()).map((Function1 & Serializable)x$66 -> (Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BlockHeaderDb[]{x$66})), $this.executionContext);
            }, $this.executionContext);
        } else {
            future = $this.blockHeaderDAO().getAtHeight(startHeight - 1);
        }
        return future.map((Function1 & Serializable)headers -> headers, $this.executionContext);
    }

    public static final /* synthetic */ void $anonfun$recalculateChainWork$11(ChainHandler $this, Throwable err) {
        $this.logger().error((Function0 & Serializable)() -> "Failed to recalculate chain work", (Function0 & Serializable)() -> err);
    }

    private final Vector getNTopHeaders$1(int n, Vector acc) {
        while (n != 1) {
            Future prev = ((Future)acc.last()).flatMap((Function1 & Serializable)x0$1 -> {
                Future<Option<BlockHeaderDb>> future;
                Option option = x0$1;
                if (None$.MODULE$.equals(option)) {
                    future = Future$.MODULE$.successful((Object)None$.MODULE$);
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    BlockHeaderDb last = (BlockHeaderDb)some.value();
                    future = this.getHeader(last.previousBlockHashBE());
                } else {
                    throw new MatchError((Object)option);
                }
                return future;
            }, this.executionContext);
            acc = (Vector)acc.$colon$plus((Object)prev);
            --n;
        }
        return acc;
    }

    public static final /* synthetic */ long $anonfun$getMedianTimePast$4(Vector times) {
        return BoxesRunTime.unboxToLong((Object)((SeqOps)times.sorted((Ordering)Ordering.Long$.MODULE$)).apply(times.size() / 2));
    }

    public static final /* synthetic */ boolean $anonfun$isIBD$1(Option x0$1) {
        boolean bl;
        Option option = x0$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            IsInitialBlockDownload ibd = (IsInitialBlockDownload)some.value();
            bl = ibd.isIBDRunning();
        } else if (None$.MODULE$.equals(option)) {
            bl = true;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public static final /* synthetic */ Future $anonfun$setSyncing$1(ChainHandler $this, boolean value$1, boolean isSyncing) {
        return (isSyncing == value$1 ? Future$.MODULE$.unit() : $this.updateSyncingAndExecuteCallback(value$1)).map((Function1 & Serializable)x$69 -> {
            BoxedUnit boxedUnit = x$69;
            ChainHandler chainHandler = $this;
            return chainHandler;
        }, $this.executionContext);
    }

    public static final /* synthetic */ void $anonfun$updateSyncingAndExecuteCallback$2(BoxedUnit x$71) {
        BoxedUnit boxedUnit = x$71;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Future $anonfun$updateSyncingAndExecuteCallback$1(ChainHandler $this, boolean value$3, boolean changed) {
        return (changed && ((ChainCallbacks)$this.chainConfig().callBacks()).onSyncFlagChanged().nonEmpty() ? ((ChainCallbacks)$this.chainConfig().callBacks()).executeOnSyncFlagChanged(value$3, $this.executionContext) : Future$.MODULE$.unit()).map((Function1 & Serializable)x$71 -> {
            ChainHandler.$anonfun$updateSyncingAndExecuteCallback$2(x$71);
            return BoxedUnit.UNIT;
        }, $this.executionContext);
    }

    public ChainHandler(BlockHeaderDAO blockHeaderDAO, CompactFilterHeaderDAO filterHeaderDAO, CompactFilterDAO filterDAO, ChainStateDescriptorDAO stateDAO, Map<DoubleSha256DigestBE, DoubleSha256DigestBE> blockFilterCheckpoints, ChainAppConfig chainConfig, ExecutionContext executionContext) {
        this.blockHeaderDAO = blockHeaderDAO;
        this.filterHeaderDAO = filterHeaderDAO;
        this.filterDAO = filterDAO;
        this.stateDAO = stateDAO;
        this.blockFilterCheckpoints = blockFilterCheckpoints;
        this.chainConfig = chainConfig;
        this.executionContext = executionContext;
        ChainQueryApi.$init$((ChainQueryApi)this);
        ChainApi.$init$((ChainApi)this);
        Logging.$init$((Logging)this);
    }

    public static final /* synthetic */ Object $anonfun$processFilterHeaders$9$adapted(CompactFilterHeaderDb x$19) {
        return BoxesRunTime.boxToInteger((int)x$19.height());
    }

    public static final /* synthetic */ Object $anonfun$processFilterHeaders$10$adapted(CompactFilterHeaderDb x$20) {
        return BoxesRunTime.boxToInteger((int)x$20.height());
    }

    public static final /* synthetic */ Object $anonfun$processFilters$16$adapted(CompactFilterDb x$28) {
        return BoxesRunTime.boxToInteger((int)x$28.height());
    }

    public static final /* synthetic */ Object $anonfun$processFilters$17$adapted(CompactFilterDb x$29) {
        return BoxesRunTime.boxToInteger((int)x$29.height());
    }
}

