/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.chain.blockchain.sync;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.bitcoins.chain.ChainVerificationLogger;
import org.bitcoins.chain.blockchain.ChainHandler;
import org.bitcoins.core.api.chain.ChainApi;
import org.bitcoins.core.api.chain.db.BlockHeaderDb;
import org.bitcoins.core.protocol.blockchain.BlockHeader;
import org.bitcoins.crypto.DoubleSha256DigestBE;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005a4Qa\u0002\u0005\u0002\u0002MAQA\b\u0001\u0005\u0002}AQ!\u0003\u0001\u0005\u0002\tBQa\u0016\u0001\u0005\na;Q\u0001\u001e\u0005\t\u0002U4Qa\u0002\u0005\t\u0002YDQAH\u0003\u0005\u0002]\u0014\u0011b\u00115bS:\u001c\u0016P\\2\u000b\u0005%Q\u0011\u0001B:z]\u000eT!a\u0003\u0007\u0002\u0015\tdwnY6dQ\u0006LgN\u0003\u0002\u000e\u001d\u0005)1\r[1j]*\u0011q\u0002E\u0001\tE&$8m\\5og*\t\u0011#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001)i\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0007CA\u000e\u001d\u001b\u0005a\u0011BA\u000f\r\u0005]\u0019\u0005.Y5o-\u0016\u0014\u0018NZ5dCRLwN\u001c'pO\u001e,'/\u0001\u0004=S:LGO\u0010\u000b\u0002AA\u0011\u0011\u0005A\u0007\u0002\u0011Q!1\u0005\u000f R)\t!3\u0007E\u0002&Q)j\u0011A\n\u0006\u0003OY\t!bY8oGV\u0014(/\u001a8u\u0013\tIcE\u0001\u0004GkR,(/\u001a\t\u0003WEj\u0011\u0001\f\u0006\u0003\u001b5R!AL\u0018\u0002\u0007\u0005\u0004\u0018N\u0003\u00021\u001d\u0005!1m\u001c:f\u0013\t\u0011DF\u0001\u0005DQ\u0006Lg.\u00119j\u0011\u0015!$\u0001q\u00016\u0003\t)7\r\u0005\u0002&m%\u0011qG\n\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDQ!\u000f\u0002A\u0002i\nAb\u00195bS:D\u0015M\u001c3mKJ\u0004\"a\u000f\u001f\u000e\u0003)I!!\u0010\u0006\u0003\u0019\rC\u0017-\u001b8IC:$G.\u001a:\t\u000b}\u0012\u0001\u0019\u0001!\u0002%\u001d,GO\u00117pG.DU-\u00193fe\u001a+hn\u0019\t\u0005+\u0005\u001b\u0015*\u0003\u0002C-\tIa)\u001e8di&|g.\r\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\r:\taa\u0019:zaR|\u0017B\u0001%F\u0005Q!u.\u001e2mKNC\u0017MM\u001b7\t&<Wm\u001d;C\u000bB\u0019Q\u0005\u000b&\u0011\u0005-{U\"\u0001'\u000b\u0005-i%B\u0001(0\u0003!\u0001(o\u001c;pG>d\u0017B\u0001)M\u0005-\u0011En\\2l\u0011\u0016\fG-\u001a:\t\u000bI\u0013\u0001\u0019A*\u0002)\u001d,GOQ3ti\ncwnY6ICNDg)\u001e8d!\r)BKV\u0005\u0003+Z\u0011\u0011BR;oGRLwN\u001c\u0019\u0011\u0007\u0015B3)\u0001\u0005ts:\u001cG+\u001b9t)\u0015I6,X9t)\t!#\fC\u00035\u0007\u0001\u000fQ\u0007C\u0003]\u0007\u0001\u0007!&\u0001\u0005dQ\u0006Lg.\u00119j\u0011\u0015q6\u00011\u0001`\u0003\u0011!\u0018\u000e]:\u0011\u0007\u0001D7N\u0004\u0002bM:\u0011!-Z\u0007\u0002G*\u0011AME\u0001\u0007yI|w\u000e\u001e \n\u0003]I!a\u001a\f\u0002\u000fA\f7m[1hK&\u0011\u0011N\u001b\u0002\u0007-\u0016\u001cGo\u001c:\u000b\u0005\u001d4\u0002C\u00017p\u001b\u0005i'B\u00018-\u0003\t!'-\u0003\u0002q[\ni!\t\\8dW\"+\u0017\rZ3s\t\nDQA]\u0002A\u0002\r\u000bQBY3ti\ncwnY6ICND\u0007\"B \u0004\u0001\u0004\u0001\u0015!C\"iC&t7+\u001f8d!\t\tSa\u0005\u0002\u0006AQ\tQ\u000f")
public abstract class ChainSync
implements ChainVerificationLogger {
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ChainSync chainSync = this;
        synchronized (chainSync) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public Future<ChainApi> sync(ChainHandler chainHandler, Function1<DoubleSha256DigestBE, Future<BlockHeader>> getBlockHeaderFunc, Function0<Future<DoubleSha256DigestBE>> getBestBlockHashFunc, ExecutionContext ec) {
        Future<Vector<BlockHeaderDb>> currentTipsF = chainHandler.blockHeaderDAO().getBestChainTips();
        Future bestBlockHashF = (Future)getBestBlockHashFunc.apply();
        Future updatedChainApi = bestBlockHashF.flatMap((Function1 & Serializable)bestBlockHash -> currentTipsF.flatMap((Function1 & Serializable)tips -> this.syncTips(chainHandler, (Vector<BlockHeaderDb>)tips, (DoubleSha256DigestBE)bestBlockHash, getBlockHeaderFunc, ec), ec), ec);
        return updatedChainApi;
    }

    private Future<ChainApi> syncTips(ChainApi chainApi, Vector<BlockHeaderDb> tips, DoubleSha256DigestBE bestBlockHash, Function1<DoubleSha256DigestBE, Future<BlockHeader>> getBlockHeaderFunc, ExecutionContext ec) {
        Predef$.MODULE$.require(tips.nonEmpty(), (Function0 & Serializable)() -> "Cannot sync without the genesis block");
        Vector tipsBH = (Vector)tips.map((Function1 & Serializable)x$1 -> x$1.blockHeader());
        Future bestHeaderF = (Future)getBlockHeaderFunc.apply((Object)bestBlockHash);
        bestHeaderF.map((Function1 & Serializable)bestHeader -> {
            ChainSync.$anonfun$syncTips$5(this, tips, bestHeader);
            return BoxedUnit.UNIT;
        }, ec);
        Future hasBlockHashF2 = chainApi.getHeader(bestBlockHash);
        return hasBlockHashF2.flatMap((Function1 & Serializable)hasBlockHashF -> {
            Future future;
            if (hasBlockHashF.isDefined()) {
                future = Future$.MODULE$.successful((Object)chainApi);
            } else {
                Future headersToSyncF = this.loop$1(bestHeaderF, package$.MODULE$.Vector().empty(), tipsBH, getBlockHeaderFunc, ec);
                future = headersToSyncF.flatMap((Function1 & Serializable)headers -> {
                    this.logger().info((Function0 & Serializable)() -> new StringBuilder(49).append("Attempting to sync ").append(headers.length()).append(" blockheader to our chainstate").toString());
                    return chainApi.processHeaders(headers);
                }, ec);
            }
            return future;
        }, ec);
    }

    private final Future loop$1(Future lastHeaderF, Vector accum, Vector tipsBH$1, Function1 getBlockHeaderFunc$2, ExecutionContext ec$2) {
        return lastHeaderF.flatMap((Function1 & Serializable)lastHeader -> {
            Future future;
            if (tipsBH$1.contains(lastHeader)) {
                future = Future$.MODULE$.successful((Object)accum);
            } else {
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(12).append("Last header=").append(lastHeader.hashBE().hex()).toString());
                Future newLastHeaderF = (Future)getBlockHeaderFunc$2.apply((Object)lastHeader.previousBlockHashBE());
                BlockHeader blockHeader = lastHeader;
                future = this.loop$1(newLastHeaderF, (Vector)accum.$plus$colon((Object)blockHeader), tipsBH$1, getBlockHeaderFunc$2, ec$2);
            }
            return future;
        }, ec$2);
    }

    public static final /* synthetic */ void $anonfun$syncTips$5(ChainSync $this, Vector tips$1, BlockHeader bestHeader) {
        $this.logger().info((Function0 & Serializable)() -> new StringBuilder(39).append("Best tip from third party=").append(bestHeader.hashBE().hex()).append(" currentTips=").append(tips$1.map((Function1 & Serializable)x$2 -> x$2.hashBE().hex())).toString());
    }

    public ChainSync() {
        Logging.$init$((Logging)this);
    }
}

