/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.chain.pow;

import java.io.Serializable;
import java.math.BigInteger;
import org.bitcoins.chain.blockchain.Blockchain;
import org.bitcoins.chain.config.ChainAppConfig;
import org.bitcoins.core.api.chain.db.BlockHeaderDb;
import org.bitcoins.core.number.Number;
import org.bitcoins.core.number.UInt32;
import org.bitcoins.core.protocol.blockchain.BitcoinChainParams;
import org.bitcoins.core.protocol.blockchain.BlockHeader;
import org.bitcoins.core.protocol.blockchain.ChainParams;
import org.bitcoins.core.protocol.blockchain.MainNetChainParams$;
import org.bitcoins.core.protocol.blockchain.RegTestNetChainParams$;
import org.bitcoins.core.protocol.blockchain.SigNetChainParams;
import org.bitcoins.core.protocol.blockchain.TestNetChainParams$;
import org.bitcoins.core.util.NumberUtil$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005!4Q\u0001C\u0005\u0002\"IAQ!\u0007\u0001\u0005\u0002iAQ!\b\u0001\u0005\u0002yAQa\u0010\u0001\u0005\u0002\u0001CQa\u0015\u0001\u0005\u0002Q;QaZ\u0005\t\u0002\u00194Q\u0001C\u0005\t\u0002\u0011DQ!\u0007\u0004\u0005\u0002\u0015\u00141\u0001U8x\u0015\tQ1\"A\u0002q_^T!\u0001D\u0007\u0002\u000b\rD\u0017-\u001b8\u000b\u00059y\u0011\u0001\u00032ji\u000e|\u0017N\\:\u000b\u0003A\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\n\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t\u0011\"\u0001\fhKRtU\r^<pe.<vN]6SKF,\u0018N]3e)\ryr&\u000f\u000b\u0003A!\u0002\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\r9,XNY3s\u0015\t)S\"\u0001\u0003d_J,\u0017BA\u0014#\u0005\u0019)\u0016J\u001c;4e!)\u0011F\u0001a\u0002U\u000511m\u001c8gS\u001e\u0004\"aK\u0017\u000e\u00031R!!K\u0006\n\u00059b#AD\"iC&t\u0017\t\u001d9D_:4\u0017n\u001a\u0005\u0006a\t\u0001\r!M\u0001\u0010]\u0016<\bk\u001c;f]RL\u0017\r\u001c+jaB\u0011!gN\u0007\u0002g)\u0011A'N\u0001\u000bE2|7m[2iC&t'B\u0001\u001c%\u0003!\u0001(o\u001c;pG>d\u0017B\u0001\u001d4\u0005-\u0011En\\2l\u0011\u0016\fG-\u001a:\t\u000bQ\u0012\u0001\u0019\u0001\u001e\u0011\u0005mjT\"\u0001\u001f\u000b\u0005QZ\u0011B\u0001 =\u0005)\u0011En\\2lG\"\f\u0017N\\\u0001\u001aG\u0006d7-\u001e7bi\u0016tU\r\u001f;X_J\\'+Z9vSJ,G\r\u0006\u0003!\u00032s\u0005\"\u0002\"\u0004\u0001\u0004\u0019\u0015AC2veJ,g\u000e\u001e+jaB\u0011AIS\u0007\u0002\u000b*\u0011aiR\u0001\u0003I\nT!\u0001\u0004%\u000b\u0005%#\u0013aA1qS&\u00111*\u0012\u0002\u000e\u00052|7m\u001b%fC\u0012,'\u000f\u00122\t\u000b5\u001b\u0001\u0019A\"\u0002\u0015\u0019L'o\u001d;CY>\u001c7\u000eC\u0003P\u0007\u0001\u0007\u0001+A\u0006dQ\u0006Lg\u000eU1sC6\u001c\bC\u0001\u001aR\u0013\t\u00116GA\u0006DQ\u0006Lg\u000eU1sC6\u001c\u0018!D4fi\ncwnY6Qe>|g\r\u0006\u0002VCB\u0011aK\u0018\b\u0003/rs!\u0001W.\u000e\u0003eS!AW\t\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0012BA/\u0016\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u00181\u0003\r\tKw-\u00138u\u0015\tiV\u0003C\u0003c\t\u0001\u0007\u0011'\u0001\u0004iK\u0006$WM]\u0015\u0003\u0001\u0019\u0019\"AB\u000e\u0015\u0003\u0019\u0004\"\u0001\b\u0004\u0002\u0007A{w\u000f")
public abstract class Pow {
    public UInt32 getNetworkWorkRequired(BlockHeader newPotentialTip, Blockchain blockchain, ChainAppConfig config) {
        UInt32 uInt32;
        BitcoinChainParams chainParams = config.chain();
        BlockHeaderDb tip = blockchain.tip();
        int currentHeight = tip.height();
        if ((currentHeight + 1) % chainParams.difficultyChangeInterval() != 0) {
            if (chainParams.allowMinDifficultyBlocks()) {
                if (newPotentialTip.time().toLong() > tip.blockHeader().time().toLong() + chainParams.powTargetSpacing().toSeconds() * 2L) {
                    uInt32 = chainParams.compressedPowLimit();
                } else {
                    UInt32 uInt322;
                    Option<BlockHeaderDb> nonMinDiffF = blockchain.find((Function1<BlockHeaderDb, Object>)(Function1 & Serializable)h -> BoxesRunTime.boxToBoolean((boolean)Pow.$anonfun$getNetworkWorkRequired$1(chainParams, h)));
                    Option<BlockHeaderDb> option = nonMinDiffF;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        BlockHeaderDb bh = (BlockHeaderDb)some.value();
                        uInt322 = bh.nBits();
                    } else if (None$.MODULE$.equals(option)) {
                        BitcoinChainParams bitcoinChainParams = config.chain();
                        if (!RegTestNetChainParams$.MODULE$.equals(bitcoinChainParams)) {
                            boolean bl = TestNetChainParams$.MODULE$.equals(bitcoinChainParams) ? true : (MainNetChainParams$.MODULE$.equals(bitcoinChainParams) ? true : bitcoinChainParams instanceof SigNetChainParams);
                            if (bl) {
                                throw new RuntimeException(new StringBuilder(71).append("Could not find non mindifficulty block in chain of size=").append(blockchain.length()).append("! hash=").append(tip.hashBE().hex()).append(" height=").append(currentHeight).toString());
                            }
                            throw new MatchError((Object)bitcoinChainParams);
                        }
                        UInt32 uInt323 = RegTestNetChainParams$.MODULE$.compressedPowLimit();
                        uInt322 = uInt323;
                    } else {
                        throw new MatchError(option);
                    }
                    uInt32 = uInt322;
                }
            } else {
                uInt32 = tip.blockHeader().nBits();
            }
        } else {
            Option<BlockHeaderDb> firstBlockAtIntervalOpt;
            int firstHeight = currentHeight - (chainParams.difficultyChangeInterval() - 1);
            Predef$.MODULE$.require(firstHeight >= 0, (Function0 & Serializable)() -> new StringBuilder(47).append("We must have our first height be positive, got=").append(firstHeight).toString());
            Option<BlockHeaderDb> option = firstBlockAtIntervalOpt = blockchain.findAtHeight(firstHeight);
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new RuntimeException(new StringBuilder(82).append("Could not find block at height=").append(firstHeight).append(" out of ").append(blockchain.length()).append(" headers to calculate pow difficulty change").toString());
                }
                throw new MatchError(option);
            }
            Some some = (Some)option;
            BlockHeaderDb firstBlockAtInterval = (BlockHeaderDb)some.value();
            UInt32 uInt324 = this.calculateNextWorkRequired(tip, firstBlockAtInterval, (ChainParams)chainParams);
            uInt32 = uInt324;
        }
        UInt32 powLimit = uInt32;
        return powLimit;
    }

    public UInt32 calculateNextWorkRequired(BlockHeaderDb currentTip, BlockHeaderDb firstBlock, ChainParams chainParams) {
        UInt32 uInt32;
        if (chainParams.noRetargeting()) {
            uInt32 = currentTip.nBits();
        } else {
            UInt32 newTarget;
            long timespanSeconds;
            long actualTimespan = currentTip.time().$minus((Number)firstBlock.time()).toLong();
            if (actualTimespan < (timespanSeconds = chainParams.powTargetTimeSpan().toSeconds()) / 4L) {
                actualTimespan = timespanSeconds / 4L;
            }
            if (actualTimespan > timespanSeconds * 4L) {
                actualTimespan = timespanSeconds * 4L;
            }
            BigInteger powLimit = chainParams.powLimit();
            BigInt bnNew = NumberUtil$.MODULE$.targetExpansion(currentTip.nBits()).difficulty();
            bnNew = bnNew.$times(BigInt$.MODULE$.long2bigInt(actualTimespan));
            if ((bnNew = bnNew.$div(BigInt$.MODULE$.long2bigInt(timespanSeconds))).$greater((Object)BigInt$.MODULE$.javaBigInteger2bigInt(powLimit))) {
                bnNew = BigInt$.MODULE$.javaBigInteger2bigInt(powLimit);
            }
            uInt32 = newTarget = NumberUtil$.MODULE$.targetCompression(bnNew, false);
        }
        return uInt32;
    }

    public BigInt getBlockProof(BlockHeader header) {
        BlockHeader.TargetDifficultyHelper target = NumberUtil$.MODULE$.targetExpansion(header.nBits());
        return target.isNegative() || target.isOverflow() ? package$.MODULE$.BigInt().apply(0) : package$.MODULE$.BigInt().apply(1).$less$less(256).$div(target.difficulty().$plus(package$.MODULE$.BigInt().apply(1)));
    }

    public static final /* synthetic */ boolean $anonfun$getNetworkWorkRequired$1(BitcoinChainParams chainParams$1, BlockHeaderDb h) {
        UInt32 uInt32 = h.nBits();
        UInt32 uInt322 = chainParams$1.compressedPowLimit();
        return (uInt32 != null ? !uInt32.equals(uInt322) : uInt322 != null) || h.height() % chainParams$1.difficultyChangeInterval() == 0;
    }
}

