/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.chain.validation;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.bitcoins.chain.ChainVerificationLogger;
import org.bitcoins.chain.blockchain.Blockchain;
import org.bitcoins.chain.config.ChainAppConfig;
import org.bitcoins.chain.pow.Pow$;
import org.bitcoins.chain.validation.TipUpdateResult;
import org.bitcoins.core.api.chain.db.BlockHeaderDb;
import org.bitcoins.core.api.chain.db.BlockHeaderDbHelper$;
import org.bitcoins.core.number.UInt32;
import org.bitcoins.core.protocol.blockchain.BlockHeader;
import org.bitcoins.core.util.NumberUtil$;
import org.bitcoins.crypto.DoubleSha256DigestBE;
import org.slf4j.Marker;
import scala.Function0;
import scala.MatchError;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000514Q!\u0003\u0006\u0002\"MAQA\b\u0001\u0005\u0002}AQA\t\u0001\u0005\u0002\rBQA\u0011\u0001\u0005\n\rCQ\u0001\u0016\u0001\u0005\u0002UCQa\u0017\u0001\u0005\nq;Qa\u001b\u0006\t\u0002)4Q!\u0003\u0006\t\u0002!DQAH\u0004\u0005\u0002%\u0014Q\u0002V5q-\u0006d\u0017\u000eZ1uS>t'BA\u0006\r\u0003)1\u0018\r\\5eCRLwN\u001c\u0006\u0003\u001b9\tQa\u00195bS:T!a\u0004\t\u0002\u0011\tLGoY8j]NT\u0011!E\u0001\u0004_J<7\u0001A\n\u0004\u0001QQ\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u001c95\tA\"\u0003\u0002\u001e\u0019\t92\t[1j]Z+'/\u001b4jG\u0006$\u0018n\u001c8M_\u001e<WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"!\t\u0001\u000e\u0003)\t1b\u00195fG.tUm\u001e+jaR\u0019A\u0005\r\u001f\u0015\u0005\u0015B\u0003CA\u0011'\u0013\t9#BA\bUSB,\u0006\u000fZ1uKJ+7/\u001e7u\u0011\u0015I#\u0001q\u0001+\u0003\u0011\u0019wN\u001c4\u0011\u0005-rS\"\u0001\u0017\u000b\u00055b\u0011AB2p]\u001aLw-\u0003\u00020Y\tq1\t[1j]\u0006\u0003\boQ8oM&<\u0007\"B\u0019\u0003\u0001\u0004\u0011\u0014a\u00048foB{G/\u001a8uS\u0006dG+\u001b9\u0011\u0005MRT\"\u0001\u001b\u000b\u0005U2\u0014A\u00032m_\u000e\\7\r[1j]*\u0011q\u0007O\u0001\taJ|Go\\2pY*\u0011\u0011HD\u0001\u0005G>\u0014X-\u0003\u0002<i\tY!\t\\8dW\"+\u0017\rZ3s\u0011\u0015)$\u00011\u0001>!\tq\u0004)D\u0001@\u0015\t)D\"\u0003\u0002B\u007f\tQ!\t\\8dW\u000eD\u0017-\u001b8\u0002\u00191|w\rV5q%\u0016\u001cX\u000f\u001c;\u0015\u0007\u0011;\u0015\n\u0005\u0002\u0016\u000b&\u0011aI\u0006\u0002\u0005+:LG\u000fC\u0003I\u0007\u0001\u0007Q%\u0001\td_:tWm\u0019;USB\u0014Vm];mi\")!j\u0001a\u0001\u0017\u0006Q1-\u001e:sK:$H+\u001b9\u0011\u00051\u0013V\"A'\u000b\u00059{\u0015A\u00013c\u0015\ti\u0001K\u0003\u0002Rq\u0005\u0019\u0011\r]5\n\u0005Mk%!\u0004\"m_\u000e\\\u0007*Z1eKJ$%-\u0001\u0006jg\n\u000bGMT8oG\u0016$\"AV-\u0011\u0005U9\u0016B\u0001-\u0017\u0005\u001d\u0011un\u001c7fC:DQA\u0017\u0003A\u0002I\na\u0001[3bI\u0016\u0014\u0018\u0001C5t\u0005\u0006$\u0007k\\<\u0015\u0007u+g\r\u0006\u0002_IB\u0011qLY\u0007\u0002A*\u0011\u0011\rO\u0001\u0007]Vl'-\u001a:\n\u0005\r\u0004'AB+J]R\u001c$\u0007C\u0003.\u000b\u0001\u0007!\u0006C\u00032\u000b\u0001\u0007!\u0007C\u00036\u000b\u0001\u0007Q(\u000b\u0002\u0001\u000fM\u0011q\u0001\t\u000b\u0002UB\u0011\u0011eB\u0001\u000e)&\u0004h+\u00197jI\u0006$\u0018n\u001c8")
public abstract class TipValidation
implements ChainVerificationLogger {
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TipValidation tipValidation = this;
        synchronized (tipValidation) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public TipUpdateResult checkNewTip(BlockHeader newPotentialTip, Blockchain blockchain, ChainAppConfig conf) {
        TipUpdateResult tipUpdateResult;
        BlockHeader header = newPotentialTip;
        BlockHeaderDb currentTip = blockchain.tip();
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(62).append("Checking header=").append(header.hashBE().hex()).append(" to try to connect to currentTip=").append(currentTip.hashBE().hex()).append(" with height=").append(currentTip.height()).toString());
        UInt32 expectedWork = this.isBadPow(newPotentialTip, blockchain, conf);
        DoubleSha256DigestBE doubleSha256DigestBE = header.previousBlockHashBE();
        DoubleSha256DigestBE doubleSha256DigestBE2 = currentTip.hashBE();
        if (doubleSha256DigestBE == null ? doubleSha256DigestBE2 != null : !doubleSha256DigestBE.equals(doubleSha256DigestBE2)) {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(39).append("Failed to connect tip=").append(header.hashBE().hex()).append(" to current chain").toString());
            tipUpdateResult = new TipUpdateResult.BadPreviousBlockHash(newPotentialTip);
        } else {
            UInt32 uInt32 = header.nBits();
            UInt32 uInt322 = expectedWork;
            if (uInt32 == null ? uInt322 != null : !uInt32.equals(uInt322)) {
                tipUpdateResult = new TipUpdateResult.BadPOW(newPotentialTip);
            } else if (this.isBadNonce(newPotentialTip)) {
                tipUpdateResult = new TipUpdateResult.BadNonce(newPotentialTip);
            } else {
                BlockHeaderDb headerDb = BlockHeaderDbHelper$.MODULE$.fromBlockHeader(currentTip.height() + 1, currentTip.chainWork().$plus(Pow$.MODULE$.getBlockProof(newPotentialTip)), newPotentialTip);
                tipUpdateResult = new TipUpdateResult.Success(headerDb);
            }
        }
        TipUpdateResult.Failure connectTipResult = tipUpdateResult;
        this.logTipResult(connectTipResult, currentTip);
        return connectTipResult;
    }

    private void logTipResult(TipUpdateResult connectTipResult, BlockHeaderDb currentTip) {
        TipUpdateResult tipUpdateResult = connectTipResult;
        if (tipUpdateResult instanceof TipUpdateResult.Success) {
            TipUpdateResult.Success success = (TipUpdateResult.Success)tipUpdateResult;
            BlockHeaderDb tipDb = success.headerDb();
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(59).append("Successfully connected ").append(tipDb.hashBE().hex()).append(" with height=").append(tipDb.height()).append(" to block=").append(currentTip.hashBE().hex()).append(" with height=").append(currentTip.height()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (tipUpdateResult instanceof TipUpdateResult.Failure) {
            TipUpdateResult.Failure failure = (TipUpdateResult.Failure)tipUpdateResult;
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(44).append("Failed to connect ").append(failure.header().hashBE().hex()).append(" to ").append(currentTip.hashBE().hex()).append(" with height=").append(currentTip.height()).append(", reason=").append(failure).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)tipUpdateResult);
        }
    }

    public boolean isBadNonce(BlockHeader header) {
        BigInt headerWork = package$.MODULE$.BigInt().apply(1, header.hashBE().bytes().toArray());
        return headerWork.$less$eq((Object)BigInt$.MODULE$.int2bigInt(0)) || NumberUtil$.MODULE$.isNBitsOverflow(header.nBits()) ? true : headerWork.$greater((Object)header.difficulty());
    }

    private UInt32 isBadPow(BlockHeader newPotentialTip, Blockchain blockchain, ChainAppConfig config) {
        return Pow$.MODULE$.getNetworkWorkRequired(newPotentialTip, blockchain, config);
    }

    public TipValidation() {
        Logging.$init$((Logging)this);
    }
}

