/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.crypto;

import java.io.Serializable;
import org.bitcoins.crypto.CryptoUtil$;
import org.bitcoins.crypto.CurveCoordinate$;
import org.bitcoins.crypto.DERSignatureUtil$;
import org.bitcoins.crypto.DLEQUtil$;
import org.bitcoins.crypto.ECAdaptorSignature;
import org.bitcoins.crypto.ECAdaptorSignature$;
import org.bitcoins.crypto.ECDigitalSignature;
import org.bitcoins.crypto.ECDigitalSignature$;
import org.bitcoins.crypto.ECPrivateKey;
import org.bitcoins.crypto.ECPublicKey;
import org.bitcoins.crypto.FieldElement;
import org.bitcoins.crypto.FieldElement$;
import org.bitcoins.crypto.FiniteFieldMember;
import org.bitcoins.crypto.SecpPoint;
import org.bitcoins.crypto.SecpPointFinite;
import org.bitcoins.crypto.SecpPointInfinity$;
import org.bitcoins.crypto.Sha256Digest;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.package$;
import scodec.bits.ByteVector;

public final class AdaptorUtil$ {
    public static final AdaptorUtil$ MODULE$ = new AdaptorUtil$();

    public FieldElement adaptorNonce(ByteVector message, ECPrivateKey privKey, ECPublicKey adaptorPoint, String algoName, ByteVector auxRand) {
        Sha256Digest sha256Digest;
        ByteVector randHash = CryptoUtil$.MODULE$.sha256ECDSAAdaptorAux(auxRand).bytes();
        ByteVector maskedKey = randHash.xor(privKey.bytes());
        ByteVector bytesToHash = maskedKey.$plus$plus(adaptorPoint.bytes()).$plus$plus(message);
        String string = algoName;
        if ("DLEQ".equals(string)) {
            sha256Digest = CryptoUtil$.MODULE$.sha256DLEQ(bytesToHash);
        } else if ("ECDSAadaptor/non".equals(string)) {
            sha256Digest = CryptoUtil$.MODULE$.sha256ECDSAAdaptorNonce(bytesToHash);
        } else if (string != null) {
            sha256Digest = CryptoUtil$.MODULE$.taggedSha256(bytesToHash, algoName);
        } else {
            throw new MatchError((Object)string);
        }
        Sha256Digest nonceHash = sha256Digest;
        return (FieldElement)FieldElement$.MODULE$.apply(nonceHash.bytes());
    }

    private FieldElement adaptorSignHelper(ByteVector dataToSign, FieldElement k, ECPublicKey r, ECPrivateKey privateKey) {
        SecpPoint secpPoint = CryptoUtil$.MODULE$.decodePoint(r);
        if (SecpPointInfinity$.MODULE$.equals(secpPoint)) {
            throw new IllegalArgumentException(new StringBuilder(19).append("Invalid point, got=").append(SecpPointInfinity$.MODULE$).toString());
        }
        if (secpPoint instanceof SecpPointFinite) {
            SecpPointFinite secpPointFinite = (SecpPointFinite)secpPoint;
            FieldElement rx = (FieldElement)FieldElement$.MODULE$.apply(secpPointFinite.x().toBigInteger());
            FieldElement x = privateKey.fieldElement();
            FieldElement m = (FieldElement)FieldElement$.MODULE$.apply(dataToSign);
            FieldElement kInv = (FieldElement)k.inverse();
            return rx.multiply(x).add(m).multiply(kInv);
        }
        throw new MatchError((Object)secpPoint);
    }

    public ECAdaptorSignature adaptorSign(ECPrivateKey privateKey, ECPublicKey adaptorPoint, ByteVector dataToSign, ByteVector auxRand) {
        FieldElement k = this.adaptorNonce(dataToSign, privateKey, adaptorPoint, "ECDSAadaptor/non", auxRand);
        if (k.isZero()) {
            throw new RuntimeException("Nonce cannot be zero.");
        }
        ECPublicKey untweakedNonce = k.getPublicKey();
        ECPublicKey tweakedNonce = adaptorPoint.multiply(k);
        Tuple2<FieldElement, FieldElement> tuple2 = DLEQUtil$.MODULE$.dleqProve(k, adaptorPoint, auxRand);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        FieldElement proofE = (FieldElement)tuple2._1();
        FieldElement proofS = (FieldElement)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)proofE, (Object)proofS);
        FieldElement proofE2 = (FieldElement)tuple22._1();
        FieldElement proofS2 = (FieldElement)tuple22._2();
        FieldElement adaptedSig = this.adaptorSignHelper(dataToSign, k, tweakedNonce, privateKey);
        return ECAdaptorSignature$.MODULE$.apply(tweakedNonce, untweakedNonce, adaptedSig, proofE2, proofS2);
    }

    private FieldElement adaptorVerifyHelper(FieldElement rx, FieldElement s, ECPublicKey pubKey, ByteVector msg) {
        FieldElement m = (FieldElement)FieldElement$.MODULE$.apply(msg);
        ECPublicKey untweakedPoint = m.getPublicKey().add(pubKey.multiply(rx)).multiply((FieldElement)s.inverse());
        return (FieldElement)FieldElement$.MODULE$.apply(untweakedPoint.bytes().tail());
    }

    public boolean adaptorVerify(ECAdaptorSignature adaptorSig, ECPublicKey pubKey, ByteVector data, ECPublicKey adaptor) {
        boolean validProof = DLEQUtil$.MODULE$.dleqVerify(adaptorSig.dleqProofS(), adaptorSig.dleqProofE(), adaptorSig.untweakedNonce(), adaptor, adaptorSig.tweakedNonce());
        if (validProof) {
            FieldElement untweakedRx;
            FieldElement tweakedNoncex = (FieldElement)FieldElement$.MODULE$.apply(((FiniteFieldMember)CurveCoordinate$.MODULE$.apply(adaptorSig.tweakedNonce().bytes().tail())).toBigInteger());
            FieldElement untweakedNoncex = (FieldElement)FieldElement$.MODULE$.apply(adaptorSig.untweakedNonce().bytes().tail());
            if (tweakedNoncex.isZero() || untweakedNoncex.isZero()) {
                return false;
            }
            FieldElement fieldElement = untweakedRx = this.adaptorVerifyHelper(tweakedNoncex, adaptorSig.adaptedS(), pubKey, data);
            FieldElement fieldElement2 = untweakedNoncex;
            return !(fieldElement != null ? !((Object)fieldElement).equals(fieldElement2) : fieldElement2 != null);
        }
        return false;
    }

    public ECDigitalSignature adaptorComplete(ECPrivateKey adaptorSecret, ECAdaptorSignature adaptorSig) {
        FieldElement rx = (FieldElement)FieldElement$.MODULE$.apply(adaptorSig.tweakedNonce().bytes().tail());
        FieldElement correctedS = adaptorSig.adaptedS().multInv(adaptorSecret.fieldElement());
        ECDigitalSignature sig = ECDigitalSignature$.MODULE$.fromRS(package$.MODULE$.BigInt().apply(rx.toBigInteger()), package$.MODULE$.BigInt().apply(correctedS.toBigInteger()));
        return DERSignatureUtil$.MODULE$.lowS(sig);
    }

    public ECPrivateKey extractAdaptorSecret(ECDigitalSignature sig, ECAdaptorSignature adaptorSig, ECPublicKey adaptor) {
        ByteVector byteVector = adaptorSig.tweakedNonce().bytes().tail();
        ByteVector byteVector2 = sig.rBytes();
        Predef$.MODULE$.require(!(byteVector != null ? !byteVector.equals(byteVector2) : byteVector2 != null), (Function0 & Serializable)() -> "Adaptor signature must be related to signature");
        FieldElement secretOrNeg = (FieldElement)adaptorSig.adaptedS().multInv(FieldElement$.MODULE$.apply(sig.s()));
        ByteVector byteVector3 = secretOrNeg.getPublicKey().bytes().tail();
        ByteVector byteVector4 = adaptor.bytes().tail();
        Predef$.MODULE$.require(!(byteVector3 != null ? !byteVector3.equals(byteVector4) : byteVector4 != null), (Function0 & Serializable)() -> new StringBuilder(24).append("Invalid inputs: ").append(sig).append(", ").append(adaptorSig).append(", and ").append(adaptor).toString());
        ECPublicKey eCPublicKey = secretOrNeg.getPublicKey();
        ECPublicKey eCPublicKey2 = adaptor;
        if (!(eCPublicKey != null ? !((Object)eCPublicKey).equals(eCPublicKey2) : eCPublicKey2 != null)) {
            return secretOrNeg.toPrivateKey();
        }
        return ((FieldElement)secretOrNeg.negate()).toPrivateKey();
    }

    private AdaptorUtil$() {
    }
}

