/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.crypto;

import java.io.Serializable;
import java.security.Key;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import org.bitcoins.crypto.AesDecryptionException;
import org.bitcoins.crypto.AesEncryptedData;
import org.bitcoins.crypto.AesException$BadPasswordException$;
import org.bitcoins.crypto.AesIV$;
import org.bitcoins.crypto.AesKey;
import scala.Function0;
import scala.MatchError;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class AesCrypt$ {
    public static final AesCrypt$ MODULE$ = new AesCrypt$();
    private static final String aesCipherType = "AES/CFB/NoPadding";

    private String aesCipherType() {
        return aesCipherType;
    }

    private Cipher getCipher() {
        Cipher cipher = Cipher.getInstance(this.aesCipherType());
        return cipher;
    }

    private Cipher decryptionCipher(AesKey secret, ByteVector initializationVector) {
        Cipher cipher = this.getCipher();
        cipher.init(2, (Key)secret.toSecretKey(), new IvParameterSpec(initializationVector.toArray()));
        return cipher;
    }

    public Either<AesDecryptionException, ByteVector> decrypt(AesEncryptedData encrypted, AesKey key) {
        Cipher cipher = this.decryptionCipher(key, encrypted.iv());
        Try decryptionAttempt = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            byte[] plainText = cipher.doFinal(encrypted.cipherText().toArray());
            return ByteVector$.MODULE$.apply(plainText);
        });
        boolean bl = false;
        Failure failure = null;
        Try try_ = decryptionAttempt;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            ByteVector bytes = (ByteVector)success.value();
            return new Right((Object)bytes);
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof BadPaddingException) {
                return new Left((Object)AesException$BadPasswordException$.MODULE$);
            }
        }
        if (bl) {
            Throwable exception = failure.exception();
            throw exception;
        }
        throw new MatchError((Object)try_);
    }

    private Cipher encryptionCipher(AesKey secret, ByteVector iv) {
        Cipher cipher = this.getCipher();
        cipher.init(1, (Key)secret.toSecretKey(), new IvParameterSpec(iv.toArray()));
        return cipher;
    }

    public AesEncryptedData encryptWithIV(ByteVector plainText, ByteVector iv, AesKey key) {
        Cipher cipher = this.encryptionCipher(key, iv);
        byte[] cipherText = cipher.doFinal(plainText.toArray());
        AesEncryptedData encrypted = new AesEncryptedData(ByteVector$.MODULE$.apply(cipherText), iv);
        return encrypted;
    }

    public AesEncryptedData encrypt(ByteVector plainText, AesKey key) {
        ByteVector iv = AesIV$.MODULE$.random();
        return this.encryptWithIV(plainText, iv, key);
    }

    private AesCrypt$() {
    }
}

