/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.crypto;

import java.io.Serializable;
import java.math.BigInteger;
import org.bitcoins.crypto.BouncyCastleCryptoParams$;
import org.bitcoins.crypto.DERSignatureUtil$;
import org.bitcoins.crypto.ECDigitalSignature;
import org.bitcoins.crypto.ECDigitalSignature$;
import org.bitcoins.crypto.ECPrivateKey;
import org.bitcoins.crypto.ECPrivateKeyBytes;
import org.bitcoins.crypto.ECPublicKey;
import org.bitcoins.crypto.ECPublicKey$;
import org.bitcoins.crypto.ECPublicKeyApi;
import org.bitcoins.crypto.EmptyDigitalSignature$;
import org.bitcoins.crypto.FieldElement;
import org.bitcoins.crypto.HMacDSAKCalculatorWithEntropy;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class BouncyCastleUtil$ {
    public static final BouncyCastleUtil$ MODULE$ = new BouncyCastleUtil$();
    private static final ECCurve curve = BouncyCastleCryptoParams$.MODULE$.curve().getCurve();
    private static final ECPoint G = BouncyCastleCryptoParams$.MODULE$.curve().getG();

    private ECCurve curve() {
        return curve;
    }

    private ECPoint G() {
        return G;
    }

    private BigInteger getBigInteger(ByteVector bytes) {
        return new BigInteger(1, bytes.toArray());
    }

    public ECPublicKey pubKeyTweakMul(ECPublicKey publicKey, ByteVector tweak) {
        ECPoint point = this.decodePoint(publicKey).multiply(this.getBigInteger(tweak));
        return this.decodePubKey(point, publicKey.isCompressed());
    }

    public ECPoint decodePoint(ByteVector bytes) {
        return this.curve().decodePoint(bytes.toArray());
    }

    public ECPoint decodePoint(ECPublicKey pubKey) {
        return this.decodePoint(pubKey.decompressedBytes());
    }

    public ECPublicKey decodePubKey(ECPoint point, boolean isCompressed) {
        byte[] bytes = point.getEncoded(isCompressed);
        return ECPublicKey$.MODULE$.fromBytes(ByteVector$.MODULE$.apply(bytes));
    }

    public boolean decodePubKey$default$2() {
        return true;
    }

    public ECPublicKey pubKeyTweakMul(ECPublicKey pubKey, FieldElement tweak) {
        ECPoint tweakedPoint = this.decodePoint(pubKey).multiply(tweak.toBigInteger());
        return this.decodePubKey(tweakedPoint, pubKey.isCompressed());
    }

    public ECPublicKey decompressPublicKey(ECPublicKey publicKey) {
        if (publicKey.isCompressed()) {
            ECPoint point = this.decodePoint(publicKey.bytes());
            ByteVector decompressedBytes = ((ByteVector)ByteVector$.MODULE$.fromHex("04", ByteVector$.MODULE$.fromHex$default$2()).get()).$plus$plus(ByteVector$.MODULE$.apply(point.getXCoord().getEncoded())).$plus$plus(ByteVector$.MODULE$.apply(point.getYCoord().getEncoded()));
            return (ECPublicKey)ECPublicKey$.MODULE$.apply(decompressedBytes);
        }
        return publicKey;
    }

    public ECPublicKey computePublicKey(ECPrivateKeyBytes privateKey) {
        BigInteger priv = this.getBigInteger(privateKey.bytes());
        ECPoint point = this.G().multiply(priv);
        ByteVector pubBytes = ByteVector$.MODULE$.apply(point.getEncoded(privateKey.isCompressed()));
        return (ECPublicKey)ECPublicKey$.MODULE$.apply(pubBytes);
    }

    public ECPublicKey publicKeyConvert(ECPublicKey key, boolean compressed) {
        if (key.isCompressed() == compressed) {
            return key;
        }
        ECPoint point = this.decodePoint(key);
        ByteVector pubBytes = ByteVector$.MODULE$.apply(point.getEncoded(compressed));
        return (ECPublicKey)ECPublicKey$.MODULE$.apply(pubBytes);
    }

    public ECDigitalSignature sign(ByteVector dataToSign, ECPrivateKey privateKey) {
        ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
        ECPrivateKeyParameters privKey = new ECPrivateKeyParameters(this.getBigInteger(privateKey.bytes()), BouncyCastleCryptoParams$.MODULE$.curve());
        signer.init(true, (CipherParameters)privKey);
        BigInteger[] components = signer.generateSignature(dataToSign.toArray());
        Tuple2 tuple2 = new Tuple2((Object)components[0], (Object)components[1]);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BigInteger r = (BigInteger)tuple2._1();
        BigInteger s = (BigInteger)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)r, (Object)s);
        BigInteger r2 = (BigInteger)tuple22._1();
        BigInteger s2 = (BigInteger)tuple22._2();
        ECDigitalSignature signature = ECDigitalSignature$.MODULE$.apply(BigInt$.MODULE$.javaBigInteger2bigInt(r2), BigInt$.MODULE$.javaBigInteger2bigInt(s2));
        ECDigitalSignature signatureLowS = DERSignatureUtil$.MODULE$.lowS(signature);
        Predef$.MODULE$.require(signatureLowS.isDEREncoded(), (Function0 & Serializable)() -> new StringBuilder(73).append("We must create DER encoded signatures when signing a piece of data, got: ").append(signatureLowS).toString());
        return signatureLowS;
    }

    public ECDigitalSignature signWithEntropy(ByteVector dataToSign, ECPrivateKey privateKey, ByteVector entropy) {
        ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculatorWithEntropy((Digest)new SHA256Digest(), entropy));
        ECPrivateKeyParameters privKey = new ECPrivateKeyParameters(this.getBigInteger(privateKey.bytes()), BouncyCastleCryptoParams$.MODULE$.curve());
        signer.init(true, (CipherParameters)privKey);
        BigInteger[] components = signer.generateSignature(dataToSign.toArray());
        Tuple2 tuple2 = new Tuple2((Object)components[0], (Object)components[1]);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BigInteger r = (BigInteger)tuple2._1();
        BigInteger s = (BigInteger)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)r, (Object)s);
        BigInteger r2 = (BigInteger)tuple22._1();
        BigInteger s2 = (BigInteger)tuple22._2();
        ECDigitalSignature signature = ECDigitalSignature$.MODULE$.apply(BigInt$.MODULE$.javaBigInteger2bigInt(r2), BigInt$.MODULE$.javaBigInteger2bigInt(s2));
        ECDigitalSignature signatureLowS = DERSignatureUtil$.MODULE$.lowS(signature);
        Predef$.MODULE$.require(signatureLowS.isDEREncoded(), (Function0 & Serializable)() -> new StringBuilder(73).append("We must create DER encoded signatures when signing a piece of data, got: ").append(signatureLowS).toString());
        return signatureLowS;
    }

    public boolean verifyDigitalSignature(ByteVector data, ECPublicKeyApi publicKey, ECDigitalSignature signature) {
        Try resultTry = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            ECPublicKeyParameters publicKeyParams = new ECPublicKeyParameters(MODULE$.decodePoint(publicKey.bytes()), BouncyCastleCryptoParams$.MODULE$.curve());
            ECDSASigner signer = new ECDSASigner();
            signer.init(false, (CipherParameters)publicKeyParams);
            ECDigitalSignature eCDigitalSignature = signature;
            if (((Object)EmptyDigitalSignature$.MODULE$).equals(eCDigitalSignature)) {
                return signer.verifySignature(data.toArray(), BigInteger.valueOf(0L), BigInteger.valueOf(0L));
            }
            if (eCDigitalSignature != null) {
                Tuple2<BigInt, BigInt> tuple2 = signature.decodeSignature();
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                BigInt r = (BigInt)tuple2._1();
                BigInt s = (BigInt)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)r, (Object)s);
                BigInt r2 = (BigInt)tuple22._1();
                BigInt s2 = (BigInt)tuple22._2();
                return signer.verifySignature(data.toArray(), r2.bigInteger(), s2.bigInteger());
            }
            throw new MatchError((Object)eCDigitalSignature);
        });
        return BoxesRunTime.unboxToBoolean((Object)resultTry.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    private BouncyCastleUtil$() {
    }
}

