/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.crypto;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.text.Normalizer;
import org.bitcoins.crypto.BouncyCastleCryptoParams$;
import org.bitcoins.crypto.BouncyCastleUtil$;
import org.bitcoins.crypto.CryptoContext;
import org.bitcoins.crypto.CryptoContext$BouncyCastle$;
import org.bitcoins.crypto.CryptoParams$;
import org.bitcoins.crypto.CryptoRuntime;
import org.bitcoins.crypto.ECDigitalSignature;
import org.bitcoins.crypto.ECPrivateKey;
import org.bitcoins.crypto.ECPrivateKey$;
import org.bitcoins.crypto.ECPrivateKeyBytes;
import org.bitcoins.crypto.ECPublicKey;
import org.bitcoins.crypto.ECPublicKey$;
import org.bitcoins.crypto.ECPublicKeyApi;
import org.bitcoins.crypto.FieldElement;
import org.bitcoins.crypto.PBKDF2$;
import org.bitcoins.crypto.RipeMd160Digest;
import org.bitcoins.crypto.RipeMd160Digest$;
import org.bitcoins.crypto.SecpPoint;
import org.bitcoins.crypto.SecpPoint$;
import org.bitcoins.crypto.SecpPointInfinity$;
import org.bitcoins.crypto.Sha1Digest;
import org.bitcoins.crypto.Sha1Digest$;
import org.bitcoins.crypto.Sha256Digest;
import org.bitcoins.crypto.Sha256Digest$;
import org.bitcoins.crypto.Sha256Hash160Digest;
import org.bitcoins.crypto.Sha256Hash160Digest$;
import org.bitcoins.crypto.Sha3_256Digest;
import org.bitcoins.crypto.Sha3_256Digest$;
import org.bitcoins.crypto.SipHashKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.macs.SipHash;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.WNafUtil;
import org.bouncycastle.util.BigIntegers;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

@ScalaSignature(bytes="\u0006\u0005\tuaaB\u0010!!\u0003\r\ta\n\u0005\u0006e\u0001!\ta\r\u0005\to\u0001A)\u0019!C\u0005q!9\u0011\t\u0001b\u0001\n\u0003\u0012\u0005\"\u0002$\u0001\t\u0003:\u0005\"B&\u0001\t\u0003a\u0005\"B1\u0001\t\u0003\u0012\u0007\"\u0002<\u0001\t\u0003:\b\"\u0002?\u0001\t\u0003j\bbBA\u0001\u0001\u0011\u0005\u00131\u0001\u0005\b\u0003\u001f\u0001A\u0011IA\t\u0011\u001d\tY\u0002\u0001C!\u0003;Aq!a\n\u0001\t\u0003\nI\u0003C\u0004\u00024\u0001!\t%!\u000e\t\u000f\u0005E\u0003\u0001\"\u0011\u0002T!9\u0011Q\f\u0001\u0005B\u0005}\u0003bBA6\u0001\u0011\u0005\u0013Q\u000e\u0005\b\u0003k\u0002A\u0011IA<\u0011\u001d\t\t\t\u0001C!\u0003\u0007Cq!a$\u0001\t\u0003\n\t\nC\u0004\u0002\u0016\u0002!\t%!)\t\u000f\u0005\u0015\u0006\u0001\"\u0011\u0002(\"9\u0011Q\u0017\u0001\u0005B\u0005]\u0006bBAa\u0001\u0011\u0005\u00111\u0019\u0005\b\u0003\u001b\u0004A\u0011IAh\u0011\u001d\t\u0019\u000f\u0001C!\u0003KDq!a<\u0001\t\u0003\n\t\u0010C\u0004\u0003\n\u0001!\tEa\u0003\b\u000f\tE\u0001\u0005#\u0001\u0003\u0014\u00191q\u0004\tE\u0001\u0005+AqA!\u0007\u001e\t\u0003\u0011YBA\rC_Vt7-_2bgRdWm\u0011:zaR|'+\u001e8uS6,'BA\u0011#\u0003\u0019\u0019'/\u001f9u_*\u00111\u0005J\u0001\tE&$8m\\5og*\tQ%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001Q9\u0002\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u0012a!\u00118z%\u00164\u0007CA\u00181\u001b\u0005\u0001\u0013BA\u0019!\u00055\u0019%/\u001f9u_J+h\u000e^5nK\u00061A%\u001b8ji\u0012\"\u0012\u0001\u000e\t\u0003SUJ!A\u000e\u0016\u0003\tUs\u0017\u000e^\u0001\rg\u0016\u001cWO]3SC:$w.\\\u000b\u0002sA\u0011!hP\u0007\u0002w)\u0011A(P\u0001\tg\u0016\u001cWO]5us*\ta(\u0001\u0003kCZ\f\u0017B\u0001!<\u00051\u0019VmY;sKJ\u000bg\u000eZ8n\u00035\u0019'/\u001f9u_\u000e{g\u000e^3yiV\t1\t\u0005\u00020\t&\u0011Q\t\t\u0002\u000e\u0007JL\b\u000f^8D_:$X\r\u001f;\u0002\u001f\u0019\u0014Xm\u001d5Qe&4\u0018\r^3LKf,\u0012\u0001\u0013\t\u0003_%K!A\u0013\u0011\u0003\u0019\u0015\u001b\u0005K]5wCR,7*Z=\u0002\u0019I,7m\u001c<feB{\u0017N\u001c;\u0015\u00055S\u0006\u0003B\u0015O!BK!a\u0014\u0016\u0003\rQ+\b\u000f\\33!\t\t\u0006,D\u0001S\u0015\t\u0019F+\u0001\u0002fG*\u0011QKV\u0001\u0005[\u0006$\bN\u0003\u0002XI\u0005a!m\\;oGf\u001c\u0017m\u001d;mK&\u0011\u0011L\u0015\u0002\b\u000b\u000e\u0003v.\u001b8u\u0011\u0015YV\u00011\u0001]\u0003\u0005A\bCA/`\u001b\u0005q&BA+>\u0013\t\u0001gL\u0001\u0006CS\u001eLe\u000e^3hKJ\f\u0001C]3d_Z,'\u000fU;cY&\u001c7*Z=\u0015\u0007\r<G\u000e\u0005\u0003*\u001d\u0012$\u0007CA\u0018f\u0013\t1\u0007EA\u0006F\u0007B+(\r\\5d\u0017\u0016L\b\"\u00025\u0007\u0001\u0004I\u0017!C:jO:\fG/\u001e:f!\ty#.\u0003\u0002lA\t\u0011Ri\u0011#jO&$\u0018\r\\*jO:\fG/\u001e:f\u0011\u0015ig\u00011\u0001o\u0003\u001diWm]:bO\u0016\u0004\"a\u001c;\u000e\u0003AT!!\u001d:\u0002\t\tLGo\u001d\u0006\u0002g\u000611oY8eK\u000eL!!\u001e9\u0003\u0015\tKH/\u001a,fGR|'/A\u0004i[\u0006\u001cW'\r\u001a\u0015\u00079D(\u0010C\u0003z\u000f\u0001\u0007a.A\u0002lKfDQa_\u0004A\u00029\fA\u0001Z1uC\u00069\u0001.\\1deU2Dc\u00018\u007f\u007f\")\u0011\u0010\u0003a\u0001]\")1\u0010\u0003a\u0001]\u0006I!/\u001b9f\u001b\u0012\fd\u0007\r\u000b\u0005\u0003\u000b\tY\u0001E\u00020\u0003\u000fI1!!\u0003!\u0005=\u0011\u0016\u000e]3NIF2\u0004\u0007R5hKN$\bBBA\u0007\u0013\u0001\u0007a.A\u0003csR,7/\u0001\u0004tQ\u0006\u0014TG\u000e\u000b\u0005\u0003'\tI\u0002E\u00020\u0003+I1!a\u0006!\u00051\u0019\u0006.\u0019\u001a6m\u0011Kw-Z:u\u0011\u0019\tiA\u0003a\u0001]\u0006A1\u000f[14?J*d\u0007\u0006\u0003\u0002 \u0005\u0015\u0002cA\u0018\u0002\"%\u0019\u00111\u0005\u0011\u0003\u001dMC\u0017mM03kY\"\u0015nZ3ti\"1\u0011QB\u0006A\u00029\fAa\u001d5bcQ!\u00111FA\u0019!\ry\u0013QF\u0005\u0004\u0003_\u0001#AC*iCF\"\u0015nZ3ti\"1\u0011Q\u0002\u0007A\u00029\f\u0011B\\8s[\u0006d\u0017N_3\u0015\t\u0005]\u0012Q\n\t\u0005\u0003s\t9E\u0004\u0003\u0002<\u0005\r\u0003cAA\u001fU5\u0011\u0011q\b\u0006\u0004\u0003\u00032\u0013A\u0002\u001fs_>$h(C\u0002\u0002F)\na\u0001\u0015:fI\u00164\u0017\u0002BA%\u0003\u0017\u0012aa\u0015;sS:<'bAA#U!9\u0011qJ\u0007A\u0002\u0005]\u0012aA:ue\u0006i1\u000f[13kYB\u0015m\u001d52mA\"B!!\u0016\u0002\\A\u0019q&a\u0016\n\u0007\u0005e\u0003EA\nTQ\u0006\u0014TG\u000e%bg\"\fd\u0007\r#jO\u0016\u001cH\u000f\u0003\u0004\u0002\u000e9\u0001\rA\\\u0001\fi>\u0004VO\u00197jG.+\u0017\u0010F\u0002e\u0003CBq!a\u0019\u0010\u0001\u0004\t)'\u0001\u0006qe&4\u0018\r^3LKf\u00042aLA4\u0013\r\tI\u0007\t\u0002\u0012\u000b\u000e\u0003&/\u001b<bi\u0016\\U-\u001f\"zi\u0016\u001c\u0018\u0001B:jO:$R![A8\u0003cBa!a\u0019\u0011\u0001\u0004A\u0005BBA:!\u0001\u0007a.\u0001\u0006eCR\fGk\\*jO:\fqb]5h]^KG\u000f[#oiJ|\u0007/\u001f\u000b\bS\u0006e\u00141PA?\u0011\u0019\t\u0019'\u0005a\u0001\u0011\"1\u0011QB\tA\u00029Da!a \u0012\u0001\u0004q\u0017aB3oiJ|\u0007/_\u0001\rg\u0016\u001c7*Z=WKJLg-\u001f\u000b\u0005\u0003\u000b\u000bY\tE\u0002*\u0003\u000fK1!!#+\u0005\u001d\u0011un\u001c7fC:Da!!$\u0013\u0001\u0004q\u0017a\u00049sSZ\fG/Z&fs\nKH/Z:\u0002\rY,'/\u001b4z)!\t))a%\u0002\u001e\u0006}\u0005bBAK'\u0001\u0007\u0011qS\u0001\naV\u0014G.[2LKf\u00042aLAM\u0013\r\tY\n\t\u0002\u000f\u000b\u000e\u0003VO\u00197jG.+\u00170\u00119j\u0011\u0015Y8\u00031\u0001o\u0011\u0015A7\u00031\u0001j)\r!\u00171\u0015\u0005\b\u0003G\"\u0002\u0019AA3\u00035!x/Z1l\u001bVdG/\u001b9msR)A-!+\u0002,\"1\u0011QS\u000bA\u0002\u0011Dq!!,\u0016\u0001\u0004\ty+A\u0003uo\u0016\f7\u000eE\u00020\u0003cK1!a-!\u000511\u0015.\u001a7e\u000b2,W.\u001a8u\u0003\r\tG\r\u001a\u000b\u0006I\u0006e\u0016Q\u0018\u0005\u0007\u0003w3\u0002\u0019\u00013\u0002\u0007A\\\u0017\u0007\u0003\u0004\u0002@Z\u0001\r\u0001Z\u0001\u0004a.\u0014\u0014A\u00049vE.+\u0017\u0010V<fC.\fE\r\u001a\u000b\u0006I\u0006\u0015\u0017\u0011\u001a\u0005\u0007\u0003\u000f<\u0002\u0019\u00013\u0002\rA,(m[3z\u0011\u0019\tYm\u0006a\u0001\u0011\u00069\u0001O]5wW\u0016L\u0018aB:ja\"\u000b7\u000f\u001b\u000b\u0007\u0003#\f9.a7\u0011\u0007%\n\u0019.C\u0002\u0002V*\u0012A\u0001T8oO\"1\u0011\u0011\u001c\rA\u00029\fA!\u001b;f[\"1\u0011\u0010\u0007a\u0001\u0003;\u00042aLAp\u0013\r\t\t\u000f\t\u0002\u000b'&\u0004\b*Y:i\u0017\u0016L\u0018a\u00033fG>$W\rU8j]R$B!a:\u0002nB\u0019q&!;\n\u0007\u0005-\bEA\u0005TK\u000e\u0004\bk\\5oi\"1\u0011QB\rA\u00029\f\u0001\u0003\u001d2lI\u001a\u0014t+\u001b;i'\"\fW'\r\u001a\u0015\u00139\f\u00190a>\u0002|\n\u0015\u0001BBA{5\u0001\u0007a.\u0001\u0003qCN\u001c\bBBA}5\u0001\u0007a.\u0001\u0003tC2$\bbBA\u007f5\u0001\u0007\u0011q`\u0001\u000fSR,'/\u0019;j_:\u001cu.\u001e8u!\rI#\u0011A\u0005\u0004\u0005\u0007Q#aA%oi\"9!q\u0001\u000eA\u0002\u0005}\u0018\u0001\u00053fe&4X\rZ&fs2+gn\u001a;i\u0003-\u0011\u0018M\u001c3p[\nKH/Z:\u0015\u00079\u0014i\u0001C\u0004\u0003\u0010m\u0001\r!a@\u0002\u00039\f\u0011DQ8v]\u000eL8-Y:uY\u0016\u001c%/\u001f9u_J+h\u000e^5nKB\u0011q&H\n\u0005;!\u00129\u0002\u0005\u00020\u0001\u00051A(\u001b8jiz\"\"Aa\u0005")
public interface BouncycastleCryptoRuntime
extends CryptoRuntime {
    public void org$bitcoins$crypto$BouncycastleCryptoRuntime$_setter_$cryptoContext_$eq(CryptoContext var1);

    public static /* synthetic */ SecureRandom org$bitcoins$crypto$BouncycastleCryptoRuntime$$secureRandom$(BouncycastleCryptoRuntime $this) {
        return $this.org$bitcoins$crypto$BouncycastleCryptoRuntime$$secureRandom();
    }

    default public SecureRandom org$bitcoins$crypto$BouncycastleCryptoRuntime$$secureRandom() {
        return new SecureRandom();
    }

    @Override
    public CryptoContext cryptoContext();

    public static /* synthetic */ ECPrivateKey freshPrivateKey$(BouncycastleCryptoRuntime $this) {
        return $this.freshPrivateKey();
    }

    @Override
    default public ECPrivateKey freshPrivateKey() {
        BigInteger n = CryptoParams$.MODULE$.getN();
        int bitLength = n.bitLength();
        int minWeight = bitLength >>> 2;
        BigInteger priv = BigInteger.ZERO;
        boolean foundNum = false;
        while (!foundNum) {
            priv = BigIntegers.createRandomBigInteger((int)bitLength, (SecureRandom)this.org$bitcoins$crypto$BouncycastleCryptoRuntime$$secureRandom());
            if (priv.compareTo(BigInteger.ONE) < 0 || priv.compareTo(n) >= 0 || WNafUtil.getNafWeight((BigInteger)priv) < minWeight) continue;
            foundNum = true;
        }
        ByteVector bytes = ByteVector$.MODULE$.apply(priv.toByteArray());
        return ECPrivateKey$.MODULE$.fromBytes(bytes.padLeft(33L));
    }

    public static /* synthetic */ Tuple2 recoverPoint$(BouncycastleCryptoRuntime $this, BigInteger x) {
        return $this.recoverPoint(x);
    }

    default public Tuple2<ECPoint, ECPoint> recoverPoint(BigInteger x) {
        ByteVector byteVector;
        ByteVector bytes = ByteVector$.MODULE$.apply(x.toByteArray());
        if (bytes.length() < 32L) {
            byteVector = bytes.padLeft(32L);
        } else if (bytes.length() == 32L) {
            byteVector = bytes;
        } else if (bytes.length() == 33L && bytes.head() == (byte)0) {
            byteVector = bytes.tail();
        } else {
            throw new IllegalArgumentException(new StringBuilder(56).append("Field element cannot have more than 32 bytes, got ").append(bytes).append(" from ").append(x).toString());
        }
        ByteVector bytes32 = byteVector;
        byte by = (byte)2;
        byte by2 = (byte)3;
        return new Tuple2((Object)BouncyCastleUtil$.MODULE$.decodePoint((ECPublicKey)ECPublicKey$.MODULE$.apply(bytes32.$plus$colon(by))), (Object)BouncyCastleUtil$.MODULE$.decodePoint((ECPublicKey)ECPublicKey$.MODULE$.apply(bytes32.$plus$colon(by2))));
    }

    public static /* synthetic */ Tuple2 recoverPublicKey$(BouncycastleCryptoRuntime $this, ECDigitalSignature signature, ByteVector message) {
        return $this.recoverPublicKey(signature, message);
    }

    @Override
    default public Tuple2<ECPublicKey, ECPublicKey> recoverPublicKey(ECDigitalSignature signature, ByteVector message) {
        ECDomainParameters curve = BouncyCastleCryptoParams$.MODULE$.curve();
        Tuple2 tuple2 = new Tuple2((Object)signature.r().bigInteger(), (Object)signature.s().bigInteger());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BigInteger r = (BigInteger)tuple2._1();
        BigInteger s = (BigInteger)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)r, (Object)s);
        BigInteger r2 = (BigInteger)tuple22._1();
        BigInteger s2 = (BigInteger)tuple22._2();
        BigInteger m = new BigInteger(1, message.toArray());
        Tuple2<ECPoint, ECPoint> tuple23 = this.recoverPoint(r2);
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        ECPoint p1 = (ECPoint)tuple23._1();
        ECPoint p2 = (ECPoint)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)p1, (Object)p2);
        ECPoint p12 = (ECPoint)tuple24._1();
        ECPoint p22 = (ECPoint)tuple24._2();
        ECPoint Q1 = p12.multiply(s2).subtract(curve.getG().multiply(m)).multiply(r2.modInverse(curve.getN()));
        ECPoint Q2 = p22.multiply(s2).subtract(curve.getG().multiply(m)).multiply(r2.modInverse(curve.getN()));
        ECPublicKey pub1 = BouncyCastleUtil$.MODULE$.decodePubKey(Q1, BouncyCastleUtil$.MODULE$.decodePubKey$default$2());
        ECPublicKey pub2 = BouncyCastleUtil$.MODULE$.decodePubKey(Q2, BouncyCastleUtil$.MODULE$.decodePubKey$default$2());
        return new Tuple2((Object)pub1, (Object)pub2);
    }

    public static /* synthetic */ ByteVector hmac512$(BouncycastleCryptoRuntime $this, ByteVector key, ByteVector data) {
        return $this.hmac512(key, data);
    }

    @Override
    default public ByteVector hmac512(ByteVector key, ByteVector data) {
        HMac hmac512 = new HMac((Digest)new SHA512Digest());
        hmac512.init((CipherParameters)new KeyParameter(key.toArray()));
        hmac512.update(data.toArray(), 0, BoxesRunTime.unboxToInt((Object)data.intSize().get()));
        byte[] output = new byte[64];
        hmac512.doFinal(output, 0);
        return ByteVector$.MODULE$.apply(output);
    }

    public static /* synthetic */ ByteVector hmac256$(BouncycastleCryptoRuntime $this, ByteVector key, ByteVector data) {
        return $this.hmac256(key, data);
    }

    @Override
    default public ByteVector hmac256(ByteVector key, ByteVector data) {
        HMac mac = new HMac((Digest)new SHA256Digest());
        mac.init((CipherParameters)new KeyParameter(key.toArray()));
        mac.update(data.toArray(), 0, (int)data.length());
        byte[] output = new byte[32];
        mac.doFinal(output, 0);
        return ByteVector$.MODULE$.view(output);
    }

    public static /* synthetic */ RipeMd160Digest ripeMd160$(BouncycastleCryptoRuntime $this, ByteVector bytes) {
        return $this.ripeMd160(bytes);
    }

    @Override
    default public RipeMd160Digest ripeMd160(ByteVector bytes) {
        RIPEMD160Digest messageDigest = new RIPEMD160Digest();
        byte[] raw = bytes.toArray();
        messageDigest.update(raw, 0, raw.length);
        byte[] out = (byte[])Array$.MODULE$.fill(messageDigest.getDigestSize(), (Function0)(JFunction0.mcB.sp & Serializable)() -> 0, (ClassTag)ClassTag$.MODULE$.Byte());
        messageDigest.doFinal(out, 0);
        return (RipeMd160Digest)RipeMd160Digest$.MODULE$.apply(ByteVector$.MODULE$.apply(out));
    }

    public static /* synthetic */ Sha256Digest sha256$(BouncycastleCryptoRuntime $this, ByteVector bytes) {
        return $this.sha256(bytes);
    }

    @Override
    default public Sha256Digest sha256(ByteVector bytes) {
        byte[] hash = MessageDigest.getInstance("SHA-256").digest(bytes.toArray());
        return (Sha256Digest)Sha256Digest$.MODULE$.apply(ByteVector$.MODULE$.apply(hash));
    }

    public static /* synthetic */ Sha3_256Digest sha3_256$(BouncycastleCryptoRuntime $this, ByteVector bytes) {
        return $this.sha3_256(bytes);
    }

    @Override
    default public Sha3_256Digest sha3_256(ByteVector bytes) {
        byte[] hash = MessageDigest.getInstance("SHA3-256").digest(bytes.toArray());
        return (Sha3_256Digest)Sha3_256Digest$.MODULE$.apply(ByteVector$.MODULE$.apply(hash));
    }

    public static /* synthetic */ Sha1Digest sha1$(BouncycastleCryptoRuntime $this, ByteVector bytes) {
        return $this.sha1(bytes);
    }

    @Override
    default public Sha1Digest sha1(ByteVector bytes) {
        List hash = Predef$.MODULE$.wrapByteArray(MessageDigest.getInstance("SHA-1").digest(bytes.toArray())).toList();
        return (Sha1Digest)Sha1Digest$.MODULE$.apply(ByteVector$.MODULE$.apply((IterableOnce)hash));
    }

    public static /* synthetic */ String normalize$(BouncycastleCryptoRuntime $this, String str) {
        return $this.normalize(str);
    }

    @Override
    default public String normalize(String str) {
        return Normalizer.normalize(str, Normalizer.Form.NFC);
    }

    public static /* synthetic */ Sha256Hash160Digest sha256Hash160$(BouncycastleCryptoRuntime $this, ByteVector bytes) {
        return $this.sha256Hash160(bytes);
    }

    @Override
    default public Sha256Hash160Digest sha256Hash160(ByteVector bytes) {
        ByteVector hash = this.ripeMd160(this.sha256(bytes).bytes()).bytes();
        return (Sha256Hash160Digest)Sha256Hash160Digest$.MODULE$.apply(hash);
    }

    public static /* synthetic */ ECPublicKey toPublicKey$(BouncycastleCryptoRuntime $this, ECPrivateKeyBytes privateKey) {
        return $this.toPublicKey(privateKey);
    }

    @Override
    default public ECPublicKey toPublicKey(ECPrivateKeyBytes privateKey) {
        return BouncyCastleUtil$.MODULE$.computePublicKey(privateKey);
    }

    public static /* synthetic */ ECDigitalSignature sign$(BouncycastleCryptoRuntime $this, ECPrivateKey privateKey, ByteVector dataToSign) {
        return $this.sign(privateKey, dataToSign);
    }

    @Override
    default public ECDigitalSignature sign(ECPrivateKey privateKey, ByteVector dataToSign) {
        return BouncyCastleUtil$.MODULE$.sign(dataToSign, privateKey);
    }

    public static /* synthetic */ ECDigitalSignature signWithEntropy$(BouncycastleCryptoRuntime $this, ECPrivateKey privateKey, ByteVector bytes, ByteVector entropy) {
        return $this.signWithEntropy(privateKey, bytes, entropy);
    }

    @Override
    default public ECDigitalSignature signWithEntropy(ECPrivateKey privateKey, ByteVector bytes, ByteVector entropy) {
        return BouncyCastleUtil$.MODULE$.signWithEntropy(bytes, privateKey, entropy);
    }

    public static /* synthetic */ boolean secKeyVerify$(BouncycastleCryptoRuntime $this, ByteVector privateKeyBytes) {
        return $this.secKeyVerify(privateKeyBytes);
    }

    @Override
    default public boolean secKeyVerify(ByteVector privateKeyBytes) {
        BigInteger num = new BigInteger(1, privateKeyBytes.toArray());
        return BouncyCastleCryptoParams$.MODULE$.curve().getCurve().isValidFieldElement(num) && num.compareTo(BouncyCastleCryptoParams$.MODULE$.curve().getN()) < 0 && !BoxesRunTime.equalsNumNum((Number)num, (Number)BigInteger.ZERO);
    }

    public static /* synthetic */ boolean verify$(BouncycastleCryptoRuntime $this, ECPublicKeyApi publicKey, ByteVector data, ECDigitalSignature signature) {
        return $this.verify(publicKey, data, signature);
    }

    @Override
    default public boolean verify(ECPublicKeyApi publicKey, ByteVector data, ECDigitalSignature signature) {
        return BouncyCastleUtil$.MODULE$.verifyDigitalSignature(data, publicKey, signature);
    }

    public static /* synthetic */ ECPublicKey publicKey$(BouncycastleCryptoRuntime $this, ECPrivateKeyBytes privateKey) {
        return $this.publicKey(privateKey);
    }

    @Override
    default public ECPublicKey publicKey(ECPrivateKeyBytes privateKey) {
        return BouncyCastleUtil$.MODULE$.computePublicKey(privateKey);
    }

    public static /* synthetic */ ECPublicKey tweakMultiply$(BouncycastleCryptoRuntime $this, ECPublicKey publicKey, FieldElement tweak) {
        return $this.tweakMultiply(publicKey, tweak);
    }

    @Override
    default public ECPublicKey tweakMultiply(ECPublicKey publicKey, FieldElement tweak) {
        return BouncyCastleUtil$.MODULE$.pubKeyTweakMul(publicKey, tweak.bytes());
    }

    public static /* synthetic */ ECPublicKey add$(BouncycastleCryptoRuntime $this, ECPublicKey pk1, ECPublicKey pk2) {
        return $this.add(pk1, pk2);
    }

    @Override
    default public ECPublicKey add(ECPublicKey pk1, ECPublicKey pk2) {
        ECPoint p1 = BouncyCastleUtil$.MODULE$.decodePoint(pk1);
        ECPoint p2 = BouncyCastleUtil$.MODULE$.decodePoint(pk2);
        ECPoint sumPoint = p1.add(p2);
        return BouncyCastleUtil$.MODULE$.decodePubKey(sumPoint, BouncyCastleUtil$.MODULE$.decodePubKey$default$2());
    }

    public static /* synthetic */ ECPublicKey pubKeyTweakAdd$(BouncycastleCryptoRuntime $this, ECPublicKey pubkey, ECPrivateKey privkey) {
        return $this.pubKeyTweakAdd(pubkey, privkey);
    }

    @Override
    default public ECPublicKey pubKeyTweakAdd(ECPublicKey pubkey, ECPrivateKey privkey) {
        ECPublicKey tweak = privkey.publicKey();
        return pubkey.add(tweak);
    }

    public static /* synthetic */ long sipHash$(BouncycastleCryptoRuntime $this, ByteVector item, SipHashKey key) {
        return $this.sipHash(item, key);
    }

    @Override
    default public long sipHash(ByteVector item, SipHashKey key) {
        int sipHashCParam = 2;
        int sipHashDParam = 4;
        SipHash sh = new SipHash(sipHashCParam, sipHashDParam);
        KeyParameter keyParam = new KeyParameter(key.bytes().toArray());
        sh.init((CipherParameters)keyParam);
        int offset = 0;
        sh.update(item.toArray(), offset, (int)item.length());
        return sh.doFinal();
    }

    public static /* synthetic */ SecpPoint decodePoint$(BouncycastleCryptoRuntime $this, ByteVector bytes) {
        return $this.decodePoint(bytes);
    }

    @Override
    default public SecpPoint decodePoint(ByteVector bytes) {
        ECPoint decoded = BouncyCastleUtil$.MODULE$.decodePoint(bytes);
        if (decoded.isInfinity()) {
            return SecpPointInfinity$.MODULE$;
        }
        return SecpPoint$.MODULE$.apply(decoded.getRawXCoord().getEncoded(), decoded.getRawYCoord().getEncoded());
    }

    public static /* synthetic */ ByteVector pbkdf2WithSha512$(BouncycastleCryptoRuntime $this, ByteVector pass, ByteVector salt, int iterationCount, int derivedKeyLength) {
        return $this.pbkdf2WithSha512(pass, salt, iterationCount, derivedKeyLength);
    }

    @Override
    default public ByteVector pbkdf2WithSha512(ByteVector pass, ByteVector salt, int iterationCount, int derivedKeyLength) {
        byte[] bytes = PBKDF2$.MODULE$.withSha512(pass, salt, iterationCount, derivedKeyLength).getEncoded();
        return ByteVector$.MODULE$.apply(bytes);
    }

    public static /* synthetic */ ByteVector randomBytes$(BouncycastleCryptoRuntime $this, int n) {
        return $this.randomBytes(n);
    }

    @Override
    default public ByteVector randomBytes(int n) {
        byte[] array = new byte[n];
        this.org$bitcoins$crypto$BouncycastleCryptoRuntime$$secureRandom().nextBytes(array);
        return ByteVector$.MODULE$.apply(array);
    }

    public static void $init$(BouncycastleCryptoRuntime $this) {
        $this.org$bitcoins$crypto$BouncycastleCryptoRuntime$_setter_$cryptoContext_$eq(CryptoContext$BouncyCastle$.MODULE$);
    }
}

