/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.crypto;

import java.io.Serializable;
import org.bitcoins.crypto.CryptoParams$;
import org.bitcoins.crypto.DERSignatureUtil$;
import org.bitcoins.crypto.ECDigitalSignature;
import org.bitcoins.crypto.ECDigitalSignature$;
import org.bitcoins.crypto.EmptyDigitalSignature$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

@ScalaSignature(bytes="\u0006\u0005\u00114Qa\u0004\t\u0002\"]AQA\b\u0001\u0005\u0002}AQA\t\u0001\u0005\u0002\rBQA\t\u0001\u0005\u00021BQa\u000e\u0001\u0005\u0002aBQa\u000e\u0001\u0005\u0002%CQa\u0013\u0001\u0005\u00021CQa\u0013\u0001\u0005\u00029CQ\u0001\u0015\u0001\u0005\u0002ECQ\u0001\u0015\u0001\u0005\u0002MCQ!\u0016\u0001\u0005\u0002YCQ\u0001\u0017\u0001\u0005\u0002e;Qa\u0019\t\t\u0002\t4Qa\u0004\t\t\u0002\u0001DQAH\u0007\u0005\u0002\u0005\u0014\u0001\u0003R#S'&<g.\u0019;ve\u0016,F/\u001b7\u000b\u0005E\u0011\u0012AB2ssB$xN\u0003\u0002\u0014)\u0005A!-\u001b;d_&t7OC\u0001\u0016\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"!\t\u0001\u000e\u0003A\tA\"[:E\u000bJ+enY8eK\u0012$\"\u0001J\u0014\u0011\u0005e)\u0013B\u0001\u0014\u001b\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u000b\u0002A\u0002%\n\u0011b]5h]\u0006$XO]3\u0011\u0005\u0005R\u0013BA\u0016\u0011\u0005I)5\tR5hSR\fGnU5h]\u0006$XO]3\u0015\u0005\u0011j\u0003\"\u0002\u0018\u0004\u0001\u0004y\u0013!\u00022zi\u0016\u001c\bC\u0001\u00196\u001b\u0005\t$B\u0001\u001a4\u0003\u0011\u0011\u0017\u000e^:\u000b\u0003Q\naa]2pI\u0016\u001c\u0017B\u0001\u001c2\u0005)\u0011\u0015\u0010^3WK\u000e$xN]\u0001\u0010I\u0016\u001cw\u000eZ3TS\u001et\u0017\r^;sKR\u0011\u0011\b\u0013\t\u00053ibD(\u0003\u0002<5\t1A+\u001e9mKJ\u0002\"!P#\u000f\u0005y\u001aeBA C\u001b\u0005\u0001%BA!\u0017\u0003\u0019a$o\\8u}%\t1$\u0003\u0002E5\u00059\u0001/Y2lC\u001e,\u0017B\u0001$H\u0005\u0019\u0011\u0015nZ%oi*\u0011AI\u0007\u0005\u0006Q\u0011\u0001\r!\u000b\u000b\u0003s)CQAL\u0003A\u0002=\n\u0001$[:WC2LGmU5h]\u0006$XO]3F]\u000e|G-\u001b8h)\t!S\nC\u0003)\r\u0001\u0007\u0011\u0006\u0006\u0002%\u001f\")af\u0002a\u0001_\u00051\u0011n\u001d'poN#\"\u0001\n*\t\u000b!B\u0001\u0019A\u0015\u0015\u0005\u0011\"\u0006\"\u0002\u0015\n\u0001\u0004y\u0013\u0001\u00027poN#\"!K,\t\u000b!R\u0001\u0019A\u0015\u0002\u0017A\f'o]3E\u000bJc\u0015\r\u001f\u000b\u00035v\u00032!G.:\u0013\ta&D\u0001\u0004PaRLwN\u001c\u0005\u0006=.\u0001\raL\u0001\u0006S:\u0004X\u000f^\u0015\u0003\u00015\u0019\"!\u0004\u0011\u0015\u0003\t\u0004\"!I\u0007\u0002!\u0011+%kU5h]\u0006$XO]3Vi&d\u0007")
public abstract class DERSignatureUtil {
    public boolean isDEREncoded(ECDigitalSignature signature) {
        return this.isDEREncoded(signature.bytes());
    }

    public boolean isDEREncoded(ByteVector bytes) {
        if (bytes.nonEmpty() && bytes.size() < 9L) {
            return false;
        }
        if (bytes.nonEmpty()) {
            boolean firstByteIs0x30 = bytes.head() == 48;
            long signatureSize = bytes.apply(1L);
            boolean signatureLengthIsCorrect = signatureSize == bytes.slice(2L, bytes.size()).size();
            boolean thirdByteIs0x02 = bytes.apply(2L) == 2;
            byte rSize = bytes.apply(3L);
            int sOffset = rSize + 4;
            if (sOffset < 0 || (long)sOffset >= bytes.length()) {
                return false;
            }
            boolean second0x02Exists = bytes.apply((long)sOffset) == 2;
            return firstByteIs0x30 && signatureLengthIsCorrect && thirdByteIs0x02 && second0x02Exists;
        }
        return true;
    }

    public Tuple2<BigInt, BigInt> decodeSignature(ECDigitalSignature signature) {
        return this.decodeSignature(signature.bytes());
    }

    public Tuple2<BigInt, BigInt> decodeSignature(ByteVector bytes) {
        Some some;
        Tuple2 tuple2;
        Option<Tuple2<BigInt, BigInt>> option = DERSignatureUtil$.MODULE$.parseDERLax(bytes);
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            BigInt r = (BigInt)tuple2._1();
            BigInt s = (BigInt)tuple2._2();
            return new Tuple2((Object)r, (Object)s);
        }
        if (None$.MODULE$.equals(option)) {
            return new Tuple2((Object)BigInt$.MODULE$.int2bigInt(0), (Object)BigInt$.MODULE$.int2bigInt(0));
        }
        throw new MatchError(option);
    }

    public boolean isValidSignatureEncoding(ECDigitalSignature signature) {
        ECDigitalSignature eCDigitalSignature = signature;
        if (((Object)EmptyDigitalSignature$.MODULE$).equals(eCDigitalSignature)) {
            return true;
        }
        if (eCDigitalSignature != null) {
            ECDigitalSignature eCDigitalSignature2 = eCDigitalSignature;
            return this.isValidSignatureEncoding(eCDigitalSignature2.bytes());
        }
        throw new MatchError((Object)eCDigitalSignature);
    }

    public boolean isValidSignatureEncoding(ByteVector bytes) {
        if (bytes.size() == 0L) {
            return true;
        }
        if (bytes.size() < 9L) {
            return false;
        }
        if (bytes.size() > 73L) {
            return false;
        }
        if (bytes.head() != 48) {
            return false;
        }
        if ((long)bytes.apply(1L) != bytes.size() - 3L) {
            return false;
        }
        byte rSize = bytes.apply(3L);
        if ((long)(5 + rSize) >= bytes.size()) {
            return false;
        }
        byte sSize = bytes.apply((long)(5 + rSize));
        if ((long)(rSize + sSize + 7) != bytes.size()) {
            return false;
        }
        if (bytes.apply(2L) != 2) {
            return false;
        }
        if (rSize == 0) {
            return false;
        }
        if ((bytes.apply(4L) & 0x80) != 0) {
            return false;
        }
        if (rSize > 1 && bytes.apply(4L) == 0 && (bytes.apply(5L) & 0x80) == 0) {
            return false;
        }
        if (bytes.apply((long)(rSize + 4)) != 2) {
            return false;
        }
        if (sSize == 0) {
            return false;
        }
        if ((bytes.apply((long)(rSize + 6)) & 0x80) != 0) {
            return false;
        }
        return sSize <= 1 || bytes.apply((long)(rSize + 6)) != 0 || (bytes.apply((long)(rSize + 7)) & 0x80) != 0;
    }

    public boolean isLowS(ECDigitalSignature signature) {
        return this.isLowS(signature.bytes());
    }

    public boolean isLowS(ByteVector signature) {
        Try result = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            Tuple2<BigInt, BigInt> tuple2 = this.decodeSignature(signature);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            BigInt s = (BigInt)tuple2._2();
            BigInt s2 = s;
            return s2.bigInteger().compareTo(CryptoParams$.MODULE$.halfCurveOrder()) <= 0;
        });
        Try try_ = result;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            boolean bool = BoxesRunTime.unboxToBoolean((Object)success.value());
            return bool;
        }
        if (try_ instanceof Failure) {
            return false;
        }
        throw new MatchError((Object)try_);
    }

    public ECDigitalSignature lowS(ECDigitalSignature signature) {
        ECDigitalSignature sigLowS = this.isLowS(signature) ? signature : ECDigitalSignature$.MODULE$.apply(signature.r(), BigInt$.MODULE$.javaBigInteger2bigInt(CryptoParams$.MODULE$.getN().subtract(signature.s().bigInteger())));
        Predef$.MODULE$.require(DERSignatureUtil$.MODULE$.isLowS(sigLowS));
        return sigLowS;
    }

    public Option<Tuple2<BigInt, BigInt>> parseDERLax(ByteVector input) {
        BufferedIterator iterator = input.toIterable().iterator().buffered();
        return DERSignatureUtil.nextByteMustBe$1((byte)48, iterator).flatMap((Function1 & Serializable)x$6 -> {
            BoxedUnit boxedUnit = x$6;
            return DERSignatureUtil.nextOption$1(iterator).flatMap((Function1 & Serializable)totalLengthByteUnProcessed -> DERSignatureUtil.$anonfun$parseDERLax$14(iterator, BoxesRunTime.unboxToByte((Object)totalLengthByteUnProcessed)));
        });
    }

    private static final Option nextOption$1(BufferedIterator iterator$1) {
        if (iterator$1.hasNext()) {
            return new Some(iterator$1.next());
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ Option $anonfun$parseDERLax$1(byte requiredByte$1, byte nextByte) {
        if (nextByte == requiredByte$1) {
            return new Some((Object)BoxedUnit.UNIT);
        }
        return None$.MODULE$;
    }

    private static final Option nextByteMustBe$1(byte requiredByte, BufferedIterator iterator$1) {
        return DERSignatureUtil.nextOption$1(iterator$1).flatMap((Function1 & Serializable)nextByte -> DERSignatureUtil.$anonfun$parseDERLax$1(requiredByte, BoxesRunTime.unboxToByte((Object)nextByte)));
    }

    public static final /* synthetic */ Option $anonfun$parseDERLax$2(BufferedIterator iterator$1, Option x0$1, int x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)BoxesRunTime.boxToInteger((int)x1$1));
        if (tuple2 != null) {
            Option bytesOpt = (Option)tuple2._1();
            return bytesOpt.flatMap((Function1 & Serializable)bytesSoFar -> DERSignatureUtil.nextOption$1(iterator$1).map((Function1 & Serializable)object -> bytesSoFar.$colon$plus(BoxesRunTime.unboxToByte((Object)object))));
        }
        throw new MatchError((Object)tuple2);
    }

    private static final Option moveIterForward$1(int steps, BufferedIterator iterator$1) {
        return (Option)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), steps).foldLeft((Object)Option$.MODULE$.apply((Object)ByteVector$.MODULE$.empty()), (Function2 & Serializable)(x0$1, x1$1) -> DERSignatureUtil.$anonfun$parseDERLax$2(iterator$1, x0$1, BoxesRunTime.unboxToInt((Object)x1$1)));
    }

    public static final /* synthetic */ boolean $anonfun$parseDERLax$10(byte x$2) {
        return x$2 == (byte)0;
    }

    public static final /* synthetic */ Option $anonfun$parseDERLax$8(BufferedIterator iterator$1, int length) {
        return DERSignatureUtil.moveIterForward$1(length, iterator$1).map((Function1 & Serializable)numBytes -> {
            ByteVector numBytesWithoutLeadingZero = numBytes.dropWhile((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DERSignatureUtil.$anonfun$parseDERLax$10(BoxesRunTime.unboxToByte((Object)x$2))));
            return new Tuple2(numBytes, (Object)numBytesWithoutLeadingZero);
        }).flatMap((Function1 & Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 != null) {
                ByteVector numBytesWithoutLeadingZero = (ByteVector)tuple2._2();
                return (numBytesWithoutLeadingZero.length() <= 32L ? new Some((Object)package$.MODULE$.BigInt().apply(1, numBytesWithoutLeadingZero.toArray())) : None$.MODULE$).map((Function1 & Serializable)num -> num);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static final /* synthetic */ Option $anonfun$parseDERLax$6(BufferedIterator iterator$1, byte lengthByteUnProcessed) {
        Object object;
        if ((lengthByteUnProcessed & 0x80) != 0) {
            int lenByte;
            for (lenByte = lengthByteUnProcessed - 128; lenByte > 0 && iterator$1.hasNext() && BoxesRunTime.unboxToByte((Object)iterator$1.head()) == (byte)0; --lenByte) {
                iterator$1.next();
            }
            object = lenByte >= 4 ? None$.MODULE$ : DERSignatureUtil.moveIterForward$1(lenByte, iterator$1).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.toInt(false, x$1.toInt$default$2())));
        } else {
            object = new Some((Object)BoxesRunTime.boxToInteger((int)lengthByteUnProcessed));
        }
        return object.flatMap((Function1 & Serializable)length -> DERSignatureUtil.$anonfun$parseDERLax$8(iterator$1, BoxesRunTime.unboxToInt((Object)length)));
    }

    private static final Option processInteger$1(BufferedIterator iterator$1) {
        return DERSignatureUtil.nextByteMustBe$1((byte)2, iterator$1).flatMap((Function1 & Serializable)x$4 -> {
            BoxedUnit boxedUnit = x$4;
            return DERSignatureUtil.nextOption$1(iterator$1).flatMap((Function1 & Serializable)lengthByteUnProcessed -> DERSignatureUtil.$anonfun$parseDERLax$6(iterator$1, BoxesRunTime.unboxToByte((Object)lengthByteUnProcessed)));
        });
    }

    public static final /* synthetic */ Option $anonfun$parseDERLax$14(BufferedIterator iterator$1, byte totalLengthByteUnProcessed) {
        Some some;
        if ((totalLengthByteUnProcessed & 0x80) != 0) {
            int processedTotalLengthByte = totalLengthByteUnProcessed - 128;
            some = DERSignatureUtil.moveIterForward$1(processedTotalLengthByte, iterator$1);
        } else {
            some = new Some((Object)BoxedUnit.UNIT);
        }
        return some.flatMap((Function1 & Serializable)x$5 -> {
            Object object = x$5;
            return DERSignatureUtil.processInteger$1(iterator$1).flatMap((Function1 & Serializable)r -> DERSignatureUtil.processInteger$1(iterator$1).map((Function1 & Serializable)s -> new Tuple2(r, s)));
        });
    }
}

