/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.crypto;

import java.io.Serializable;
import org.bitcoins.crypto.AdaptorUtil$;
import org.bitcoins.crypto.CryptoUtil$;
import org.bitcoins.crypto.ECPublicKey;
import org.bitcoins.crypto.FieldElement;
import org.bitcoins.crypto.FieldElement$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scodec.bits.ByteVector;

public final class DLEQUtil$ {
    public static final DLEQUtil$ MODULE$ = new DLEQUtil$();

    public Tuple2<ECPublicKey, ECPublicKey> dleqPair(FieldElement fe, ECPublicKey adaptorPoint) {
        ECPublicKey point = fe.getPublicKey();
        ECPublicKey tweakedPoint = adaptorPoint.multiply(fe);
        return new Tuple2((Object)point, (Object)tweakedPoint);
    }

    public FieldElement dleqNonce(FieldElement fe, ECPublicKey adaptorPoint, ECPublicKey point, ECPublicKey tweakedPoint, ByteVector auxRand) {
        ByteVector hash = CryptoUtil$.MODULE$.sha256(point.bytes().$plus$plus(tweakedPoint.bytes())).bytes();
        return AdaptorUtil$.MODULE$.adaptorNonce(hash, fe.toPrivateKey(), adaptorPoint, "DLEQ", auxRand);
    }

    public ByteVector dleqChallengeHash(ECPublicKey adaptorPoint, ECPublicKey r1, ECPublicKey r2, ECPublicKey p1, ECPublicKey p2) {
        return CryptoUtil$.MODULE$.sha256DLEQ(p1.bytes().$plus$plus(adaptorPoint.bytes()).$plus$plus(p2.bytes()).$plus$plus(r1.bytes()).$plus$plus(r2.bytes())).bytes();
    }

    public Tuple2<FieldElement, FieldElement> dleqProve(FieldElement fe, ECPublicKey adaptorPoint, ByteVector auxRand) {
        Predef$.MODULE$.require(!fe.isZero(), (Function0 & Serializable)() -> "Input field element cannot be zero.");
        Tuple2<ECPublicKey, ECPublicKey> tuple2 = this.dleqPair(fe, adaptorPoint);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ECPublicKey p1 = (ECPublicKey)tuple2._1();
        ECPublicKey p2 = (ECPublicKey)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)p1, (Object)p2);
        ECPublicKey p12 = (ECPublicKey)tuple22._1();
        ECPublicKey p22 = (ECPublicKey)tuple22._2();
        FieldElement k = this.dleqNonce(fe, adaptorPoint, p12, p22, auxRand);
        if (k.isZero()) {
            throw new RuntimeException("Nonce cannot be zero.");
        }
        Tuple2<ECPublicKey, ECPublicKey> tuple23 = this.dleqPair(k, adaptorPoint);
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        ECPublicKey r1 = (ECPublicKey)tuple23._1();
        ECPublicKey r2 = (ECPublicKey)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)r1, (Object)r2);
        ECPublicKey r12 = (ECPublicKey)tuple24._1();
        ECPublicKey r22 = (ECPublicKey)tuple24._2();
        ByteVector challengeHash = this.dleqChallengeHash(adaptorPoint, r12, r22, p12, p22);
        FieldElement e = (FieldElement)FieldElement$.MODULE$.apply(challengeHash);
        FieldElement s = fe.multiply(e).add(k);
        return new Tuple2((Object)e, (Object)s);
    }

    public boolean dleqVerify(FieldElement s, FieldElement e, ECPublicKey p1, ECPublicKey adaptor, ECPublicKey p2) {
        ByteVector challengeHash;
        ECPublicKey r1 = p1.multiply((FieldElement)e.negate()).add(s.getPublicKey());
        ECPublicKey r2 = p2.multiply((FieldElement)e.negate()).add(adaptor.multiply(s));
        ByteVector byteVector = challengeHash = this.dleqChallengeHash(adaptor, r1, r2, p1, p2);
        ByteVector byteVector2 = e.bytes();
        return !(byteVector != null ? !byteVector.equals(byteVector2) : byteVector2 != null);
    }

    private DLEQUtil$() {
    }
}

