/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.crypto;

import java.io.Serializable;
import org.bitcoins.crypto.CryptoBytesUtil$;
import org.bitcoins.crypto.DummyECDigitalSignature$;
import org.bitcoins.crypto.ECDigitalSignature;
import org.bitcoins.crypto.EmptyDigitalSignature$;
import org.bitcoins.crypto.Factory;
import org.bitcoins.crypto.HashType;
import org.bitcoins.crypto.LowRDummyECDigitalSignature$;
import scala.Function0;
import scala.Predef$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class ECDigitalSignature$
extends Factory<ECDigitalSignature> {
    public static final ECDigitalSignature$ MODULE$ = new ECDigitalSignature$();
    private static final ECDigitalSignature minimalEncodedZeroSig = MODULE$.fromRS(BigInt$.MODULE$.int2bigInt(0), BigInt$.MODULE$.int2bigInt(0));

    @Override
    public ECDigitalSignature fromBytes(ByteVector bytes) {
        if (bytes.size() == 1L && bytes.head() == 0) {
            return EmptyDigitalSignature$.MODULE$;
        }
        if (bytes.size() == 0L) {
            return EmptyDigitalSignature$.MODULE$;
        }
        ByteVector byteVector = bytes;
        ByteVector byteVector2 = DummyECDigitalSignature$.MODULE$.bytes();
        if (!(byteVector != null ? !byteVector.equals(byteVector2) : byteVector2 != null)) {
            return DummyECDigitalSignature$.MODULE$;
        }
        ByteVector byteVector3 = bytes;
        ByteVector byteVector4 = LowRDummyECDigitalSignature$.MODULE$.bytes();
        if (!(byteVector3 != null ? !byteVector3.equals(byteVector4) : byteVector4 != null)) {
            return LowRDummyECDigitalSignature$.MODULE$;
        }
        return new ECDigitalSignature.ECDigitalSignatureImpl(bytes);
    }

    public ECDigitalSignature fromFrontOfBytes(ByteVector bytes) {
        ECDigitalSignature sigWithExtra = this.fromBytes(bytes);
        ECDigitalSignature sig = this.fromRS(sigWithExtra.r(), sigWithExtra.s());
        Predef$.MODULE$.require(bytes.startsWith(sig.bytes()), (Function0 & Serializable)() -> new StringBuilder(51).append("Received weirdly encoded signature at beginning of ").append(bytes).toString());
        return sig;
    }

    public ECDigitalSignature fromFrontOfBytesWithSigHash(ByteVector bytes) {
        ECDigitalSignature sigWithoutSigHash = this.fromFrontOfBytes(bytes);
        return (ECDigitalSignature)this.apply(sigWithoutSigHash.bytes().$colon$plus(bytes.drop(sigWithoutSigHash.byteSize()).head()));
    }

    public ECDigitalSignature apply(BigInt r, BigInt s) {
        return this.fromRS(r, s);
    }

    public ECDigitalSignature apply(BigInt r, BigInt s, HashType hashType) {
        return this.fromRS(r, s, hashType);
    }

    public ECDigitalSignature fromRS(BigInt r, BigInt s) {
        int rsSize = r.toByteArray().length + s.toByteArray().length;
        int totalSize = 4 + rsSize;
        ByteVector bytes = ByteVector$.MODULE$.apply(new byte[]{(byte)48, (byte)totalSize, (byte)2, (byte)r.toByteArray().length}).$plus$plus(ByteVector$.MODULE$.apply(r.toByteArray())).$plus$plus(ByteVector$.MODULE$.apply(new byte[]{(byte)2, (byte)s.toByteArray().length})).$plus$plus(ByteVector$.MODULE$.apply(s.toByteArray()));
        return this.fromBytes(bytes);
    }

    public ECDigitalSignature fromRS(BigInt r, BigInt s, HashType hashType) {
        return this.fromRS(r, s).appendHashType(hashType);
    }

    public ECDigitalSignature fromRS(ByteVector byteVector) {
        Predef$.MODULE$.require(byteVector.length() == 64L, (Function0 & Serializable)() -> new StringBuilder(69).append("Incorrect size for reading a ECDigital signature from a bytevec, got ").append(byteVector.length()).toString());
        BigInt r = package$.MODULE$.BigInt().apply(1, byteVector.take(32L).toArray());
        BigInt s = package$.MODULE$.BigInt().apply(1, byteVector.takeRight(32L).toArray());
        return this.fromRS(r, s);
    }

    public ECDigitalSignature fromRS(ByteVector byteVector, HashType hashType) {
        return this.fromRS(byteVector).appendHashType(hashType);
    }

    public ECDigitalSignature fromRS(String hex) {
        ByteVector bytes = CryptoBytesUtil$.MODULE$.decodeHex(hex);
        return this.fromRS(bytes);
    }

    public ECDigitalSignature fromRS(String hex, HashType hashType) {
        return this.fromRS(hex).appendHashType(hashType);
    }

    public ECDigitalSignature minimalEncodedZeroSig() {
        return minimalEncodedZeroSig;
    }

    private ECDigitalSignature$() {
    }
}

