/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.crypto;

import java.io.Serializable;
import org.bitcoins.crypto.CryptoBytesUtil$;
import org.bitcoins.crypto.CryptoOrdering$;
import org.bitcoins.crypto.CryptoUtil$;
import org.bitcoins.crypto.ECPrivateKey;
import org.bitcoins.crypto.Factory;
import org.bitcoins.crypto.FieldElement;
import org.bitcoins.crypto.SchnorrNonce;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.SeqOps;
import scala.collection.immutable.Vector;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scodec.bits.ByteVector;

public final class ECPrivateKey$
extends Factory<ECPrivateKey>
implements Serializable {
    public static final ECPrivateKey$ MODULE$ = new ECPrivateKey$();

    @Override
    public ECPrivateKey fromBytes(ByteVector bytes) {
        if (bytes.size() == 32L) {
            return new ECPrivateKey(bytes);
        }
        if (bytes.size() == 33L && bytes.head() == 0) {
            return new ECPrivateKey(bytes.slice(1L, 33L));
        }
        throw new IllegalArgumentException(new StringBuilder(57).append("Private keys must be 32 in size, got: ").append(CryptoBytesUtil$.MODULE$.encodeHex(bytes)).append(" which is of size: ").append(bytes.size()).toString());
    }

    public ECPrivateKey fromFieldElement(FieldElement fieldElement) {
        return fieldElement.toPrivateKey();
    }

    public ECPrivateKey apply() {
        return this.freshPrivateKey();
    }

    public ECPrivateKey freshPrivateKey() {
        return CryptoUtil$.MODULE$.freshPrivateKey();
    }

    public Vector<ECPrivateKey> generateNonceOrderedPrivKeys(int num) {
        Vector privKeys = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), num).map((Function1 & Serializable)x$2 -> ECPrivateKey$.MODULE$.freshPrivateKey()).toVector();
        Vector sortByNonce = (Vector)((SeqOps)privKeys.map((Function1 & Serializable)p -> new Tuple2(p, (Object)p.schnorrNonce()))).sortBy((Function1 & Serializable)x$3 -> (SchnorrNonce)x$3._2(), CryptoOrdering$.MODULE$.nonceOrdering());
        return (Vector)sortByNonce.map((Function1 & Serializable)x$4 -> (ECPrivateKey)x$4._1());
    }

    public Option<ByteVector> unapply(ECPrivateKey x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)x$0.bytes());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ECPrivateKey$.class);
    }

    private ECPrivateKey$() {
    }
}

