/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.crypto;

import java.math.BigInteger;
import org.bitcoins.crypto.Factory;
import org.bitcoins.crypto.FiniteFieldMember;
import scala.math.BigInt;
import scala.reflect.ScalaSignature;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

@ScalaSignature(bytes="\u0006\u0005\u0005\ra!B\t\u0013\u0003\u0003I\u0002\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u0011Y\u0002!\u0011!Q\u0001\n]BQA\u000f\u0001\u0005\u0002mBQa\u0010\u0001\u0007\u0002\u0001CQa\u0013\u0001\u0005B1CQA\u0014\u0001\u0005\u0002=CQA\u0014\u0001\u0005\u0002yCQ\u0001\u0019\u0001\u0005\u0002\u0005D\u0001\"\u001b\u0001\t\u0006\u0004%\tA\u001b\u0005\tW\u0002A)\u0019!C\u0001U\"AA\u000e\u0001EC\u0002\u0013\u0005!\u000eC\u0003n\u0001\u0011\u0005a\u000eC\u0003q\u0001\u0011\u0005\u0011\u000fC\u0003w\u0001\u0011\u0005q\u000fC\u0003{\u0001\u0011\u00051\u0010C\u0003\u007f\u0001\u0011\u0005qPA\tGS:LG/\u001a$jK2$wJ\u00196fGRT!a\u0005\u000b\u0002\r\r\u0014\u0018\u0010\u001d;p\u0015\t)b#\u0001\u0005cSR\u001cw.\u001b8t\u0015\u00059\u0012aA8sO\u000e\u0001QC\u0001\u000e\"'\t\u00011\u0004E\u0002\u001d;}i\u0011AE\u0005\u0003=I\u0011qAR1di>\u0014\u0018\u0010\u0005\u0002!C1\u0001A!\u0002\u0012\u0001\u0005\u0004\u0019#!\u0001$\u0012\u0005\u0011R\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#a\u0002(pi\"Lgn\u001a\t\u00049-z\u0012B\u0001\u0017\u0013\u0005E1\u0015N\\5uK\u001aKW\r\u001c3NK6\u0014WM]\u0001\u000bM&,G\u000eZ(sI\u0016\u0014\bCA\u00185\u001b\u0005\u0001$BA\u00193\u0003\u0011i\u0017\r\u001e5\u000b\u0003M\nAA[1wC&\u0011Q\u0007\r\u0002\u000b\u0005&<\u0017J\u001c;fO\u0016\u0014\u0018\u0001\u00032zi\u0016\u001c\u0016N_3\u0011\u0005\u0015B\u0014BA\u001d'\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007qjd\bE\u0002\u001d\u0001}AQ!L\u0002A\u00029BQAN\u0002A\u0002]\naCZ5fY\u0012lU-\u001c2fe\u000e{gn\u001d;sk\u000e$xN\u001d\u000b\u0003?\u0005CQA\u0011\u0003A\u0002\r\u000bQAY=uKN\u0004\"\u0001R%\u000e\u0003\u0015S!AR$\u0002\t\tLGo\u001d\u0006\u0002\u0011\u000611oY8eK\u000eL!AS#\u0003\u0015\tKH/\u001a,fGR|'/A\u0005ge>l')\u001f;fgR\u0011q$\u0014\u0005\u0006\u0005\u0016\u0001\raQ\u0001\u0006CB\u0004H.\u001f\u000b\u0003?ACQ!\u0015\u0004A\u0002I\u000b1A\\;n!\t\u00196L\u0004\u0002U3:\u0011Q\u000bW\u0007\u0002-*\u0011q\u000bG\u0001\u0007yI|w\u000e\u001e \n\u0003\u001dJ!A\u0017\u0014\u0002\u000fA\f7m[1hK&\u0011A,\u0018\u0002\u0007\u0005&<\u0017J\u001c;\u000b\u0005i3CCA\u0010`\u0011\u0015\tv\u00011\u0001/\u000351'o\\7CsR,\u0017I\u001d:bsR\u0011qD\u0019\u0005\u0006\u0005\"\u0001\ra\u0019\t\u0004K\u00114\u0017BA3'\u0005\u0015\t%O]1z!\t)s-\u0003\u0002iM\t!!)\u001f;f\u0003\u0011QXM]8\u0016\u0003}\t1a\u001c8f\u00035y'\u000fZ3s\u001b&tWo](oK\u0006iq-\u001a;CS\u001eLe\u000e^3hKJ$\"AL8\t\u000b\tc\u0001\u0019A\"\u0002\u0007\u0005$G\rF\u0002 eRDQa]\u0007A\u0002}\t1AZ32\u0011\u0015)X\u00021\u0001 \u0003\r1WMM\u0001\t[VdG/\u001b9msR\u0019q\u0004_=\t\u000bMt\u0001\u0019A\u0010\t\u000bUt\u0001\u0019A\u0010\u0002\r9,w-\u0019;f)\tyB\u0010C\u0003~\u001f\u0001\u0007q$\u0001\u0002gK\u0006q1m\\7qkR,\u0017J\u001c<feN,GcA\u0010\u0002\u0002!)Q\u0010\u0005a\u0001?\u0001")
public abstract class FiniteFieldObject<F extends FiniteFieldMember<F>>
extends Factory<F> {
    private F zero;
    private F one;
    private F orderMinusOne;
    private final BigInteger fieldOrder;
    private final int byteSize;
    private volatile byte bitmap$0;

    public abstract F fieldMemberConstructor(ByteVector var1);

    @Override
    public F fromBytes(ByteVector bytes) {
        if (bytes.length() < (long)this.byteSize) {
            return this.fieldMemberConstructor(bytes.padLeft((long)this.byteSize));
        }
        if (bytes.length() == (long)this.byteSize) {
            return this.fieldMemberConstructor(bytes);
        }
        if (bytes.length() == (long)(this.byteSize + 1) && bytes.head() == (byte)0) {
            return this.fieldMemberConstructor(bytes.tail());
        }
        throw new IllegalArgumentException(new StringBuilder(50).append("Field element cannot have more than 32 bytes, got ").append(bytes).toString());
    }

    public F apply(BigInt num) {
        return this.apply(num.underlying());
    }

    public F apply(BigInteger num) {
        return this.fromByteArray(num.mod(this.fieldOrder).toByteArray());
    }

    public F fromByteArray(byte[] bytes) {
        return (F)this.fromBytes(ByteVector$.MODULE$.apply(bytes));
    }

    private F zero$lzycompute() {
        FiniteFieldObject finiteFieldObject = this;
        synchronized (finiteFieldObject) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.zero = this.fromBytes(ByteVector$.MODULE$.empty());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.zero;
    }

    public F zero() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.zero$lzycompute();
        }
        return this.zero;
    }

    private F one$lzycompute() {
        FiniteFieldObject finiteFieldObject = this;
        synchronized (finiteFieldObject) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.one = this.fromBytes(ByteVector$.MODULE$.fromByte((byte)1));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.one;
    }

    public F one() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.one$lzycompute();
        }
        return this.one;
    }

    private F orderMinusOne$lzycompute() {
        FiniteFieldObject finiteFieldObject = this;
        synchronized (finiteFieldObject) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.orderMinusOne = this.apply(this.fieldOrder.subtract(BigInteger.ONE));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.orderMinusOne;
    }

    public F orderMinusOne() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.orderMinusOne$lzycompute();
        }
        return this.orderMinusOne;
    }

    public BigInteger getBigInteger(ByteVector bytes) {
        return new BigInteger(1, bytes.toArray());
    }

    public F add(F fe1, F fe2) {
        BigInteger num1 = ((FiniteFieldMember)fe1).toBigInteger();
        BigInteger num2 = ((FiniteFieldMember)fe2).toBigInteger();
        BigInteger sum = num1.add(num2).mod(this.fieldOrder);
        return this.apply(sum);
    }

    public F multiply(F fe1, F fe2) {
        BigInteger num1 = ((FiniteFieldMember)fe1).toBigInteger();
        BigInteger num2 = ((FiniteFieldMember)fe2).toBigInteger();
        BigInteger sum = num1.multiply(num2).mod(this.fieldOrder);
        return this.apply(sum);
    }

    public F negate(F fe) {
        BigInteger neg = this.fieldOrder.subtract(((FiniteFieldMember)fe).toBigInteger());
        return this.apply(neg);
    }

    public F computeInverse(F fe) {
        BigInteger inv = ((FiniteFieldMember)fe).toBigInteger().modInverse(this.fieldOrder);
        return this.apply(inv);
    }

    public FiniteFieldObject(BigInteger fieldOrder, int byteSize) {
        this.fieldOrder = fieldOrder;
        this.byteSize = byteSize;
    }
}

