/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.crypto;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bitcoins.crypto.BouncyCastleCryptoParams$;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scodec.bits.ByteVector;

@ScalaSignature(bytes="\u0006\u0005\u0005=a\u0001\u0002\u000b\u0016\u0001qA\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!)A\b\u0001C\u0001{!9!\t\u0001b\u0001\n\u0013\u0019\u0005B\u0002&\u0001A\u0003%A\tC\u0004L\u0001\t\u0007I\u0011\u0002'\t\rM\u0003\u0001\u0015!\u0003N\u0011\u001d!\u0006A1A\u0005\nUCaa\u0018\u0001!\u0002\u00131\u0006b\u00021\u0001\u0005\u0004%I!\u0016\u0005\u0007C\u0002\u0001\u000b\u0011\u0002,\t\u000f\t\u0004\u0001\u0019!C\u0005\u0007\"91\r\u0001a\u0001\n\u0013!\u0007B\u00026\u0001A\u0003&A\tC\u0003l\u0001\u0011\u0005C\u000eC\u0003q\u0001\u0011\u0005\u0013\u000fC\u0003q\u0001\u0011\u00053\u0010C\u0004\u0002\u0004\u0001!\t%!\u0002\t\u000f\u0005\u001d\u0001\u0001\"\u0003\u0002\n\ti\u0002*T1d\tN\u000b5jQ1mGVd\u0017\r^8s/&$\b.\u00128ue>\u0004\u0018P\u0003\u0002\u0017/\u000511M]=qi>T!\u0001G\r\u0002\u0011\tLGoY8j]NT\u0011AG\u0001\u0004_J<7\u0001A\n\u0004\u0001u)\u0003C\u0001\u0010$\u001b\u0005y\"B\u0001\u0011\"\u0003\u0011a\u0017M\\4\u000b\u0003\t\nAA[1wC&\u0011Ae\b\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u0019bS\"A\u0014\u000b\u0005!J\u0013aB:jO:,'o\u001d\u0006\u0003-)R!aK\r\u0002\u0019\t|WO\\2zG\u0006\u001cH\u000f\\3\n\u00055:#A\u0004#T\u0003.\u001b\u0015\r\\2vY\u0006$xN]\u0001\u0007I&<Wm\u001d;\u0011\u0005A\nT\"A\u0015\n\u0005IJ#A\u0002#jO\u0016\u001cH/A\u0004f]R\u0014x\u000e]=\u0011\u0005URT\"\u0001\u001c\u000b\u0005]B\u0014\u0001\u00022jiNT\u0011!O\u0001\u0007g\u000e|G-Z2\n\u0005m2$A\u0003\"zi\u00164Vm\u0019;pe\u00061A(\u001b8jiz\"2A\u0010!B!\ty\u0004!D\u0001\u0016\u0011\u0015q3\u00011\u00010\u0011\u0015\u00194\u00011\u00015\u0003\u0011QVIU(\u0016\u0003\u0011\u0003\"!\u0012%\u000e\u0003\u0019S!aR\u0011\u0002\t5\fG\u000f[\u0005\u0003\u0013\u001a\u0013!BQ5h\u0013:$XmZ3s\u0003\u0015QVIU(!\u0003\u0011AW*Y2\u0016\u00035\u0003\"AT)\u000e\u0003=S!\u0001U\u0015\u0002\t5\f7m]\u0005\u0003%>\u0013A\u0001S'bG\u0006)\u0001.T1dA\u0005\t1*F\u0001W!\r9&\fX\u0007\u00021*\t\u0011,A\u0003tG\u0006d\u0017-\u0003\u0002\\1\n)\u0011I\u001d:bsB\u0011q+X\u0005\u0003=b\u0013AAQ=uK\u0006\u00111\nI\u0001\u0002-\u0006\u0011a\u000bI\u0001\u0002]\u0006)an\u0018\u0013fcR\u0011Q\r\u001b\t\u0003/\u001aL!a\u001a-\u0003\tUs\u0017\u000e\u001e\u0005\bS6\t\t\u00111\u0001E\u0003\rAH%M\u0001\u0003]\u0002\nq\"[:EKR,'/\\5oSN$\u0018n\u0019\u000b\u0002[B\u0011qK\\\u0005\u0003_b\u0013qAQ8pY\u0016\fg.\u0001\u0003j]&$HcA3sg\")!\r\u0005a\u0001\t\")A\u000f\u0005a\u0001k\u00061!/\u00198e_6\u0004\"A^=\u000e\u0003]T!\u0001_\u0011\u0002\u0011M,7-\u001e:jifL!A_<\u0003\u0019M+7-\u001e:f%\u0006tGm\\7\u0015\t\u0015dXp \u0005\u0006EF\u0001\r\u0001\u0012\u0005\u0006}F\u0001\r\u0001R\u0001\u0002I\"1\u0011\u0011A\tA\u0002Y\u000bq!\\3tg\u0006<W-A\u0003oKb$8\nF\u0001E\u0003%\u0011\u0017\u000e^:U_&sG\u000fF\u0002E\u0003\u0017Aa!!\u0004\u0014\u0001\u00041\u0016!\u0001;")
public class HMacDSAKCalculatorWithEntropy
implements DSAKCalculator {
    private final ByteVector entropy;
    private final BigInteger ZERO;
    private final HMac hMac;
    private final byte[] K;
    private final byte[] V;
    private BigInteger n;

    private BigInteger ZERO() {
        return this.ZERO;
    }

    private HMac hMac() {
        return this.hMac;
    }

    private byte[] K() {
        return this.K;
    }

    private byte[] V() {
        return this.V;
    }

    private BigInteger n() {
        return this.n;
    }

    private void n_$eq(BigInteger x$1) {
        this.n = x$1;
    }

    public boolean isDeterministic() {
        return true;
    }

    public void init(BigInteger n, SecureRandom random) {
        throw new IllegalStateException("Operation not supported");
    }

    public void init(BigInteger n, BigInteger d, byte[] message) {
        this.n_$eq(n);
        Arrays.fill((byte[])this.V(), (byte)((byte)1));
        Arrays.fill((byte[])this.K(), (byte)((byte)0));
        byte[] x = new byte[(n.bitLength() + 7) / 8];
        byte[] dVal = BigIntegers.asUnsignedByteArray((BigInteger)d);
        System.arraycopy(dVal, 0, x, x.length - dVal.length, dVal.length);
        byte[] m = new byte[(n.bitLength() + 7) / 8];
        BigInteger mInt = this.bitsToInt(message);
        if (mInt.compareTo(n) >= 0) {
            mInt = mInt.subtract(n);
        }
        byte[] mVal = BigIntegers.asUnsignedByteArray((BigInteger)mInt);
        System.arraycopy(mVal, 0, m, m.length - mVal.length, mVal.length);
        this.hMac().init((CipherParameters)new KeyParameter(this.K()));
        this.hMac().update(this.V(), 0, this.V().length);
        this.hMac().update((byte)0);
        this.hMac().update(x, 0, x.length);
        this.hMac().update(m, 0, m.length);
        this.hMac().update(this.entropy.toArray(), 0, 32);
        this.hMac().doFinal(this.K(), 0);
        this.hMac().init((CipherParameters)new KeyParameter(this.K()));
        this.hMac().update(this.V(), 0, this.V().length);
        this.hMac().doFinal(this.V(), 0);
        this.hMac().update(this.V(), 0, this.V().length);
        this.hMac().update((byte)1);
        this.hMac().update(x, 0, x.length);
        this.hMac().update(m, 0, m.length);
        this.hMac().update(this.entropy.toArray(), 0, 32);
        this.hMac().doFinal(this.K(), 0);
        this.hMac().init((CipherParameters)new KeyParameter(this.K()));
        this.hMac().update(this.V(), 0, this.V().length);
        this.hMac().doFinal(this.V(), 0);
    }

    public BigInteger nextK() {
        byte[] t = new byte[(this.n().bitLength() + 7) / 8];
        while (true) {
            int len;
            for (int tOff = 0; tOff < t.length; tOff += len) {
                this.hMac().update(this.V(), 0, this.V().length);
                this.hMac().doFinal(this.V(), 0);
                len = Math.min(t.length - tOff, this.V().length);
                System.arraycopy(this.V(), 0, t, tOff, len);
            }
            BigInteger k = this.bitsToInt(t);
            if (k.compareTo(this.ZERO()) > 0 && k.compareTo(this.n()) < 0) {
                return k;
            }
            this.hMac().update(this.V(), 0, this.V().length);
            this.hMac().update((byte)0);
            this.hMac().doFinal(this.K(), 0);
            this.hMac().init((CipherParameters)new KeyParameter(this.K()));
            this.hMac().update(this.V(), 0, this.V().length);
            this.hMac().doFinal(this.V(), 0);
        }
    }

    private BigInteger bitsToInt(byte[] t) {
        BigInteger v;
        block0: {
            v = new BigInteger(1, t);
            if (t.length * 8 <= this.n().bitLength()) break block0;
            v = v.shiftRight(t.length * 8 - this.n().bitLength());
        }
        return v;
    }

    public HMacDSAKCalculatorWithEntropy(Digest digest, ByteVector entropy) {
        this.entropy = entropy;
        Predef$.MODULE$.require(entropy.length() == 32L, (Function0 & Serializable)() -> "Entropy must be 32 bytes");
        this.ZERO = BigInteger.valueOf(0L);
        this.hMac = new HMac(digest);
        this.K = new byte[this.hMac().getMacSize()];
        this.V = new byte[this.hMac().getMacSize()];
        this.n = BouncyCastleCryptoParams$.MODULE$.curve().getN();
    }
}

