/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoins.crypto;

import java.io.Serializable;
import org.bitcoins.crypto.ECDigitalSignature;
import org.bitcoins.crypto.Factory;
import org.bitcoins.crypto.HashType;
import org.bitcoins.crypto.SIGHASH_ALL;
import org.bitcoins.crypto.SIGHASH_ALL$;
import org.bitcoins.crypto.SIGHASH_ALL_ANYONECANPAY;
import org.bitcoins.crypto.SIGHASH_ANYONECANPAY;
import org.bitcoins.crypto.SIGHASH_DEFAULT$;
import org.bitcoins.crypto.SIGHASH_NONE;
import org.bitcoins.crypto.SIGHASH_NONE_ANYONECANPAY;
import org.bitcoins.crypto.SIGHASH_SINGLE;
import org.bitcoins.crypto.SIGHASH_SINGLE_ANYONECANPAY;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scodec.bits.ByteOrdering;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class HashType$
extends Factory<HashType> {
    public static final HashType$ MODULE$ = new HashType$();
    private static Seq<Product> hashTypes;
    private static Vector<Object> hashTypeBytes;
    private static final byte sigHashDefaultByte;
    private static final byte sigHashAllByte;
    private static final SIGHASH_DEFAULT$ sigHashDefault;
    private static final SIGHASH_ALL sigHashAll;
    private static final int sigHashAnyoneCanPayNum;
    private static final byte sigHashAnyoneCanPayByte;
    private static final SIGHASH_ANYONECANPAY sigHashAnyoneCanPay;
    private static final byte sigHashNoneByte;
    private static final SIGHASH_NONE sigHashNone;
    private static final byte sigHashSingleByte;
    private static final SIGHASH_SINGLE sigHashSingle;
    private static final byte sigHashAllAnyoneCanPayByte;
    private static final int sigHashAllAnyoneCanPayNum;
    private static final SIGHASH_ALL_ANYONECANPAY sigHashAllAnyoneCanPay;
    private static final byte sigHashNoneAnyoneCanPayByte;
    private static final int sigHashNoneAnyoneCanPayNum;
    private static final SIGHASH_NONE_ANYONECANPAY sigHashNoneAnyoneCanPay;
    private static final byte sigHashSingleAnyoneCanPayByte;
    private static final int sigHashSingleAnyoneCanPayNum;
    private static final SIGHASH_SINGLE_ANYONECANPAY sigHashSingleAnyoneCanPay;
    private static volatile byte bitmap$0;

    static {
        sigHashDefaultByte = (byte)0;
        sigHashAllByte = (byte)1;
        sigHashDefault = SIGHASH_DEFAULT$.MODULE$;
        sigHashAll = SIGHASH_ALL$.MODULE$.apply(MODULE$.sigHashAllByte());
        sigHashAnyoneCanPayNum = 128;
        sigHashAnyoneCanPayByte = (byte)128;
        sigHashAnyoneCanPay = new SIGHASH_ANYONECANPAY(MODULE$.sigHashAnyoneCanPayNum());
        sigHashNoneByte = (byte)2;
        sigHashNone = new SIGHASH_NONE(MODULE$.sigHashNoneByte());
        sigHashSingleByte = (byte)3;
        sigHashSingle = new SIGHASH_SINGLE(MODULE$.sigHashSingleByte());
        sigHashAllAnyoneCanPayByte = (byte)(MODULE$.sigHashAllByte() | MODULE$.sigHashAnyoneCanPayByte());
        sigHashAllAnyoneCanPayNum = MODULE$.sigHashAllByte() | MODULE$.sigHashAnyoneCanPayNum();
        sigHashAllAnyoneCanPay = new SIGHASH_ALL_ANYONECANPAY(MODULE$.sigHashAllAnyoneCanPayNum());
        sigHashNoneAnyoneCanPayByte = (byte)(MODULE$.sigHashNoneByte() | MODULE$.sigHashAnyoneCanPayByte());
        sigHashNoneAnyoneCanPayNum = MODULE$.sigHashNoneByte() | MODULE$.sigHashAnyoneCanPayNum();
        sigHashNoneAnyoneCanPay = new SIGHASH_NONE_ANYONECANPAY(MODULE$.sigHashNoneAnyoneCanPayNum());
        sigHashSingleAnyoneCanPayByte = (byte)(MODULE$.sigHashSingleByte() | MODULE$.sigHashAnyoneCanPayByte());
        sigHashSingleAnyoneCanPayNum = MODULE$.sigHashSingleByte() | MODULE$.sigHashAnyoneCanPayNum();
        sigHashSingleAnyoneCanPay = new SIGHASH_SINGLE_ANYONECANPAY(MODULE$.sigHashSingleAnyoneCanPayNum());
    }

    private int intFromBytes(ByteVector bytes) {
        Predef$.MODULE$.require(bytes.size() <= 4L, (Function0 & Serializable)() -> "We cannot have an Int32 be larger than 4 bytes");
        return bytes.toInt(false, (ByteOrdering)ByteOrdering.BigEndian$.MODULE$);
    }

    @Override
    public HashType fromBytes(ByteVector bytes) {
        int num = this.intFromBytes(bytes);
        return this.fromNumber(num);
    }

    public HashType fromByte(byte by) {
        return this.fromBytes(ByteVector$.MODULE$.fromByte(by));
    }

    public HashType fromNumber(int num) {
        if (this.isSigHashDefault(num)) {
            return SIGHASH_DEFAULT$.MODULE$;
        }
        if (this.isSigHashNone(num)) {
            if (this.isSigHashNoneAnyoneCanPay(num)) {
                return new SIGHASH_NONE_ANYONECANPAY(num);
            }
            return new SIGHASH_NONE(num);
        }
        if (this.isSigHashSingle(num)) {
            if (this.isSigHashAnyoneCanPay(num)) {
                return new SIGHASH_SINGLE_ANYONECANPAY(num);
            }
            return new SIGHASH_SINGLE(num);
        }
        if (this.isSigHashAnyoneCanPay(num)) {
            if (this.isSigHashAllAnyoneCanPay(num)) {
                return new SIGHASH_ALL_ANYONECANPAY(num);
            }
            Predef$.MODULE$.require(this.isOnlyAnyoneCanPay(num));
            return new SIGHASH_ANYONECANPAY(num);
        }
        return new SIGHASH_ALL(num);
    }

    public byte byte(HashType hashType) {
        HashType hashType2 = hashType;
        if (hashType2 instanceof SIGHASH_ALL) {
            return this.sigHashAllByte();
        }
        if (hashType2 != null) {
            HashType hashType3 = hashType2;
            return hashType3.byte();
        }
        throw new MatchError((Object)hashType2);
    }

    public boolean isSigHashDefault(int num) {
        return num == 0;
    }

    public boolean isSigHashAllOne(int num) {
        return (num & 0x1F) == 1;
    }

    public boolean isSigHashNone(int num) {
        return (num & 0x1F) == 2;
    }

    public boolean isSigHashSingle(int num) {
        return (num & 0x1F) == 3;
    }

    public boolean isSigHashAnyoneCanPay(int num) {
        return (num & 0x80) == 128;
    }

    public boolean isSigHashAllAnyoneCanPay(int num) {
        return this.isSigHashAllOne(num) && this.isSigHashAnyoneCanPay(num);
    }

    public boolean isSigHashNoneAnyoneCanPay(int num) {
        return this.isSigHashNone(num) && this.isSigHashAnyoneCanPay(num);
    }

    public boolean isSigHashSingleAnyoneCanPay(int num) {
        return this.isSigHashSingle(num) && this.isSigHashAnyoneCanPay(num);
    }

    public boolean isSigHashAll(int num) {
        return !this.isSigHashNone(num) && !this.isSigHashSingle(num) && !this.isSigHashAnyoneCanPay(num) && !this.isSigHashAllAnyoneCanPay(num) && !this.isSigHashSingleAnyoneCanPay(num) && !this.isSigHashNoneAnyoneCanPay(num) && !this.isSigHashDefault(num);
    }

    public boolean isOnlyAnyoneCanPay(int num) {
        return !this.isSigHashAllAnyoneCanPay(num) && !this.isSigHashNoneAnyoneCanPay(num) && !this.isSigHashSingleAnyoneCanPay(num);
    }

    public boolean isAnyoneCanPay(HashType hashType) {
        HashType hashType2 = hashType;
        if (hashType2 instanceof SIGHASH_ANYONECANPAY ? true : (hashType2 instanceof SIGHASH_ALL_ANYONECANPAY ? true : (hashType2 instanceof SIGHASH_SINGLE_ANYONECANPAY ? true : hashType2 instanceof SIGHASH_NONE_ANYONECANPAY))) {
            return true;
        }
        if (hashType2 instanceof SIGHASH_ALL ? true : (hashType2 instanceof SIGHASH_SINGLE ? true : (hashType2 instanceof SIGHASH_NONE ? true : SIGHASH_DEFAULT$.MODULE$.equals(hashType2)))) {
            return false;
        }
        throw new MatchError((Object)hashType2);
    }

    private Seq<Product> hashTypes$lzycompute() {
        HashType$ hashType$ = this;
        synchronized (hashType$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                hashTypes = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Product[]{this.sigHashAll(), this.sigHashNone(), this.sigHashSingle(), this.sigHashAnyoneCanPay(), this.sigHashNoneAnyoneCanPay(), this.sigHashAllAnyoneCanPay(), this.sigHashSingleAnyoneCanPay(), this.sigHashDefault()}));
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return hashTypes;
    }

    public Seq<Product> hashTypes() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.hashTypes$lzycompute();
        }
        return hashTypes;
    }

    private Vector<Object> hashTypeBytes$lzycompute() {
        HashType$ hashType$ = this;
        synchronized (hashType$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                hashTypeBytes = (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapByteArray(new byte[]{this.sigHashDefaultByte(), this.sigHashAllByte(), this.sigHashSingleByte(), this.sigHashNoneByte(), this.sigHashAnyoneCanPayByte(), this.sigHashNoneAnyoneCanPayByte(), this.sigHashSingleAnyoneCanPayByte(), this.sigHashAllAnyoneCanPayByte()}));
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return hashTypeBytes;
    }

    public Vector<Object> hashTypeBytes() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.hashTypeBytes$lzycompute();
        }
        return hashTypeBytes;
    }

    public HashType apply(int num) {
        return this.fromNumber(num);
    }

    public HashType apply(byte by) {
        return this.fromByte(by);
    }

    public byte sigHashDefaultByte() {
        return sigHashDefaultByte;
    }

    public byte sigHashAllByte() {
        return sigHashAllByte;
    }

    public SIGHASH_DEFAULT$ sigHashDefault() {
        return sigHashDefault;
    }

    public SIGHASH_ALL sigHashAll() {
        return sigHashAll;
    }

    public int sigHashAnyoneCanPayNum() {
        return sigHashAnyoneCanPayNum;
    }

    public byte sigHashAnyoneCanPayByte() {
        return sigHashAnyoneCanPayByte;
    }

    public SIGHASH_ANYONECANPAY sigHashAnyoneCanPay() {
        return sigHashAnyoneCanPay;
    }

    public byte sigHashNoneByte() {
        return sigHashNoneByte;
    }

    public SIGHASH_NONE sigHashNone() {
        return sigHashNone;
    }

    public byte sigHashSingleByte() {
        return sigHashSingleByte;
    }

    public SIGHASH_SINGLE sigHashSingle() {
        return sigHashSingle;
    }

    public byte sigHashAllAnyoneCanPayByte() {
        return sigHashAllAnyoneCanPayByte;
    }

    public int sigHashAllAnyoneCanPayNum() {
        return sigHashAllAnyoneCanPayNum;
    }

    public SIGHASH_ALL_ANYONECANPAY sigHashAllAnyoneCanPay() {
        return sigHashAllAnyoneCanPay;
    }

    public byte sigHashNoneAnyoneCanPayByte() {
        return sigHashNoneAnyoneCanPayByte;
    }

    public int sigHashNoneAnyoneCanPayNum() {
        return sigHashNoneAnyoneCanPayNum;
    }

    public SIGHASH_NONE_ANYONECANPAY sigHashNoneAnyoneCanPay() {
        return sigHashNoneAnyoneCanPay;
    }

    public byte sigHashSingleAnyoneCanPayByte() {
        return sigHashSingleAnyoneCanPayByte;
    }

    public int sigHashSingleAnyoneCanPayNum() {
        return sigHashSingleAnyoneCanPayNum;
    }

    public SIGHASH_SINGLE_ANYONECANPAY sigHashSingleAnyoneCanPay() {
        return sigHashSingleAnyoneCanPay;
    }

    public boolean isDefinedHashtypeSignature(ECDigitalSignature sig) {
        return sig.bytes().nonEmpty() && this.hashTypeBytes().contains((Object)BoxesRunTime.boxToByte((byte)sig.bytes().last()));
    }

    private HashType$() {
    }
}

